/**
 * Generated by Apache Royale Compiler from org/apache/royale/reflection/utils/getMembersWithQNameMatch.as
 * org.apache.royale.reflection.utils.getMembersWithQNameMatch
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.reflection.utils.getMembersWithQNameMatch');

goog.require('QName');
goog.require('org.apache.royale.reflection.MemberDefinitionBase');



/**
 *  A utility method to retrieve members with a name that matches via the matcher QName argument
 *  
 *  @asparam memberCollection the collection (an Array) of member definitions to check
 *  @asparam matcher a QName to check against definitions. An undefined uri represents any namespace, a '*' represents any local name.
 *  @asparam collate an optional array to collate into, if passed externally
 *  
 *  @asreturns an Array (the collate parameter if it was used, otherwise a new Array)
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  
 *  @royaleignorecoercion RegExp
 * @export
 * @param {Array} memberCollection
 * @param {QName=} matcher
 * @param {Array=} collate
 * @return {Array}
 */
org.apache.royale.reflection.utils.getMembersWithQNameMatch = function(memberCollection, matcher, collate) {
  matcher = typeof matcher !== 'undefined' ? matcher : null;
  collate = typeof collate !== 'undefined' ? collate : null;
  var /** @type {Array} */ ret = collate ? collate : [];
  if (matcher == null) {
    matcher = new QName('*');
  }
  if (memberCollection) {
    var foreachiter0_target = memberCollection;
    for (var foreachiter0 in foreachiter0_target) 
    {
    var item = foreachiter0_target[foreachiter0];
    {
      if (!matcher.uri) {
        if (matcher.uri == '') {
          if (item.uri == '') {
            if (matcher.localName == '*' || matcher.localName == item.name)
              ret.push(item);
          }
        } else {
          if (matcher.localName == '*' || matcher.localName == item.name)
            ret.push(item);
        }
      } else {
        if (matcher.uri == item.uri) {
          if (matcher.localName == '*' || matcher.localName == item.name)
            ret.push(item);
        }
      }
    }}
    
  }
  return ret;
}