/**
 * Generated by Apache Royale Compiler from org/apache/royale/reflection/getAliasByClass.as
 * org.apache.royale.reflection.getAliasByClass
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.reflection.getAliasByClass');



/**
 * Retrieves a an alias for a class, based on an alias mapping, previously registered with
 * registerClassAlias, or possibly using [RemoteClass(alias='someAlias')] metadata
 *
 * @asparam classObject the class to retrieve the alias for
 * @asreturn the most recently mapped alias, if found otherwise null
 * @export
 * @param {Object} classObject
 * @return {string}
 */
org.apache.royale.reflection.getAliasByClass = function(classObject) {
  var /** @type {string} */ ret;
  if (classObject == null)
    throw new TypeError("Parameter classObject must be non-null.");
  
  var /** @type {*} */ info = classObject.prototype.ROYALE_CLASS_INFO;
  if (info) {
    ret = org.apache.royale.utils.Language.string(info.alias);
    if (ret == '')
      ret = null;
  }
  else
    ret = null;
  return ret;
}