/**
 * Generated by Apache Royale Compiler from org\apache\royale\reflection\getClassByAlias.as
 * org.apache.royale.reflection.getClassByAlias
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.reflection.getClassByAlias');

goog.require('org.apache.royale.reflection.TypeDefinition');



/**
 * Retrieves a class based on an alias mapping, previously registered with
 * registerClassAlias, or possibly using [RemoteClass(alias='someAlias')] metadata
 *
 * @asparam aliasName the alias name to use to look up the class definition
 * @asreturn the class definition that has been mapped to by the registered
 *         alias, or null if no alias mapping exists.
 * @export
 * @param {string} aliasName
 * @return {Object}
 */
org.apache.royale.reflection.getClassByAlias = function(aliasName) {
  
  if (aliasName == null)
    throw new TypeError("Parameter aliasName must be non-null.");
  if (aliasName.length == 0)
    throw new TypeError("Parameter aliasName must be non-empty string.");
  try {
    var /** @type {Object} */ klazz = org.apache.royale.reflection.TypeDefinition.getClassByAlias(aliasName);
  } catch (e) {
    throw new ReferenceError("Class " + aliasName + " could not be found.");
  }
  return klazz;
}