/**
 * Generated by Apache Royale Compiler from org/apache/royale/utils/Language.as
 * org.apache.royale.utils.Language
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.utils.Language');
goog.provide('org.apache.royale.utils.Language.VectorSupport');
goog.require('org.apache.royale.utils.Language');



/**
 * @constructor
 */
org.apache.royale.utils.Language = function() {
};


/**
 * @private
 * @type {Array}
 */
org.apache.royale.utils.Language.sortNames;


/**
 * @private
 * @type {Array}
 */
org.apache.royale.utils.Language.sortNamesOne = [];


/**
 * @private
 * @type {number}
 */
org.apache.royale.utils.Language.muler;


org.apache.royale.utils.Language.get__zeroStr = function() {
  var value = String.fromCharCode(0);
  Object.defineProperty(org.apache.royale.utils.Language, 'zeroStr', { value: value, writable: true });
  return value;
};
org.apache.royale.utils.Language.set__zeroStr = function(value) {
  Object.defineProperty(org.apache.royale.utils.Language, 'zeroStr', { value: value, writable: true });
};
/**
 * @private
 * @type {string}
 */
org.apache.royale.utils.Language.zeroStr;

Object.defineProperties(org.apache.royale.utils.Language, /** @lends {org.apache.royale.utils.Language} */ {
/**
 * @private
 * @type {string}
 */
zeroStr: {
  get: org.apache.royale.utils.Language.get__zeroStr,
  set: org.apache.royale.utils.Language.set__zeroStr,
  configurable: true}});


/**
 * as()
 *
 * @asparam leftOperand The lefthand operand of the
 * binary as operator in AS3.
 * @asparam rightOperand The righthand operand of the
 * binary operator in AS3.
 * @asparam coercion The cast is a coercion,
 * throw exception if it fails.
 * @asreturn Returns the lefthand operand if it is of the
 * type of the righthand operand, otherwise null.
 * @param {Object} leftOperand
 * @param {Object} rightOperand
 * @param {*} coercion
 * @return {Object}
 */
org.apache.royale.utils.Language.as = function(leftOperand, rightOperand, coercion) {
  
/**
 * @const
 * @type {boolean}
 */
var itIs = org.apache.royale.utils.Language.is(leftOperand, rightOperand);
  if (!itIs && !!coercion) {
    if (rightOperand.constructor === org.apache.royale.utils.Language._synthType) {
      return rightOperand['coerce'](leftOperand);
    } else if ([Boolean, Number, String].indexOf(rightOperand) != -1) {
      return rightOperand(leftOperand);
    } else if (Object === rightOperand) {
      return rightOperand(leftOperand).valueOf();
    }
    if (leftOperand == null) {
      return null;
    }
    
/**
 * @const
 * @type {string}
 */
var leftType = '' + (leftOperand.ROYALE_CLASS_INFO ? leftOperand.ROYALE_CLASS_INFO.names[0].qName : String(leftOperand));
    
/**
 * @const
 * @type {string}
 */
var rightType = '' + (rightOperand.prototype && rightOperand.prototype.ROYALE_CLASS_INFO ? rightOperand.prototype.ROYALE_CLASS_INFO.names[0].qName : String(rightOperand));
    throw new TypeError('Error #1034: Type Coercion failed: cannot convert ' + leftType + ' to ' + rightType);
  }
  return itIs ? leftOperand : null;
};


/**
 * int()
 *
 * @asparam value The value to be cast.
 * @asreturn {number}
 * @param {number} value
 * @return {number}
 */
org.apache.royale.utils.Language._int = function(value) {
  return value >> 0;
};


/**
 * string()
 * @asparam value The value to be cast.
 * @asreturn {string}
 * @param {*} value
 * @return {string}
 */
org.apache.royale.utils.Language.string = function(value) {
  if (value == null) {
    return null;
  }
  return "" + value;
};


/**
 * is()
 *
 * @asparam leftOperand The lefthand operand of the
 * binary as operator in AS3.
 * @asparam rightOperand The righthand operand of the
 * binary operator in AS3.
 * @asreturn {boolean}
 * @param {Object} leftOperand
 * @param {Object} rightOperand
 * @return {boolean}
 */
org.apache.royale.utils.Language.is = function(leftOperand, rightOperand) {
  var /** @type {Object} */ superClass;
  if (leftOperand == null || rightOperand == null)
    return false;
  if (rightOperand === Array) {
    return (Array.isArray(leftOperand) && !(org.apache.royale.utils.Language.SYNTH_TAG_FIELD in leftOperand));
  }
  if (leftOperand instanceof rightOperand)
    return true;
  if (rightOperand === Object)
    return true;
  var /** @type {string} */ theType = typeof(leftOperand);
  if (theType === 'string')
    return rightOperand === String;
  if (theType === 'number') {
    if (rightOperand === Number)
      return true;
  }
  if (theType === 'boolean')
    return rightOperand === Boolean;
  if (rightOperand.constructor === org.apache.royale.utils.Language._synthType)
    return !!(rightOperand['checkIs'](leftOperand));
  if (leftOperand.ROYALE_CLASS_INFO === undefined)
    return false;
  if (leftOperand.ROYALE_CLASS_INFO.interfaces) {
    if (org.apache.royale.utils.Language.checkInterfaces(leftOperand, rightOperand)) {
      return true;
    }
  }
  superClass = leftOperand.constructor.superClass_;
  if (superClass) {
    while (superClass && superClass.ROYALE_CLASS_INFO) {
      if (superClass.ROYALE_CLASS_INFO.interfaces) {
        if (org.apache.royale.utils.Language.checkInterfaces(superClass, rightOperand)) {
          return true;
        }
      }
      superClass = superClass.constructor.superClass_;
    }
  }
  return false;
};


/**
 * Helper function for is()
 * @private
 * @param {*} leftOperand
 * @param {*} rightOperand
 * @return {boolean}
 */
org.apache.royale.utils.Language.checkInterfaces = function(leftOperand, rightOperand) {
  var /** @type {number} */ i = 0, /** @type {Array} */ interfaces;
  //var /** @type {number} */ i = 0, /** @type {Array} */ interfaces;
  interfaces = leftOperand.ROYALE_CLASS_INFO.interfaces;
  for (i = (interfaces.length - 1) >> 0; i > -1; i--) {
    if (interfaces[i] === rightOperand) {
      return true;
    }
    if (interfaces[i].prototype.ROYALE_CLASS_INFO.interfaces) {
      var /** @type {boolean} */ isit = org.apache.royale.utils.Language.checkInterfaces(interfaces[i].prototype, rightOperand);
      if (isit)
        return true;
    }
  }
  return false;
};


/**
 * @royaledebug
 * @param {...} rest
 */
org.apache.royale.utils.Language.trace = function(rest) {
  rest = rest;if(!goog.DEBUG)return;
  rest = Array.prototype.slice.call(arguments, 0);
  var /** @type {*} */ theConsole;
  theConsole = goog.global["console"];
  if (theConsole === undefined) {
    if (typeof(window) !== "undefined") {
      theConsole = window.console;
    } else if (typeof(console) !== "undefined") {
      theConsole = console;
    }
  }
  try {
    if (theConsole && theConsole.log) {
      theConsole.log.apply(theConsole, rest);
    }
  } catch (e) {
  }
};


/**
 * uint()
 *
 * @asparam value The value to be cast.
 * @asreturn {number}
 * @param {number} value
 * @return {number}
 */
org.apache.royale.utils.Language.uint = function(value) {
  return value >>> 0;
};


/**
 * caches closures and returns the one closure
 *
 * @asparam fn The method on the instance.
 * @asparam object The instance.
 * @asparam boundMethodName The name to use to cache the closure.
 * @asreturn The closure.
 *
 * @royaleignorecoercion Function
 * @param {Function} fn
 * @param {Object} object
 * @param {string} boundMethodName
 * @return {Function}
 */
org.apache.royale.utils.Language.closure = function(fn, object, boundMethodName) {
  if (object.hasOwnProperty(boundMethodName)) {
    return  /** @type {Function} */ (object[boundMethodName]);
  }
  var /** @type {Function} */ boundMethod = goog.bind(fn, object);
  Object.defineProperty(object, boundMethodName, {value:boundMethod});
  return boundMethod;
};


/**
 * @asparam arr
 * @asparam names
 * @asparam opt
 *
 * @royaleignorecoercion Function
 * @param {Array} arr
 * @param {...} args
 */
org.apache.royale.utils.Language.sort = function(arr, args) {
  args = Array.prototype.slice.call(arguments, 1);
  var /** @type {Function} */ compareFunction = null;
  var /** @type {number} */ opt = 0;
  if (args.length == 1) {
    if (typeof(args[0]) === "function")
      compareFunction =  /** @type {Function} */ (args[0]);
    else
      opt = (args[0]) >> 0;
  } else if (args.length == 2) {
    compareFunction =  /** @type {Function} */ (args[0]);
    opt = (args[1]) >> 0;
  }
  org.apache.royale.utils.Language.muler = (2 & opt) > 0 ? -1 : 1;
  if (compareFunction)
    arr.sort(compareFunction); else if (opt & 16) {
    arr.sort(org.apache.royale.utils.Language.compareAsNumber);
  } else if (opt & 1) {
    arr.sort(org.apache.royale.utils.Language.compareAsStringCaseinsensitive);
  } else {
    arr.sort(org.apache.royale.utils.Language.compareAsString);
  }
};


/**
 * @private
 * @param {Object} a
 * @param {Object} b
 * @return {number}
 */
org.apache.royale.utils.Language.compareAsStringCaseinsensitive = function(a, b) {
  var /** @type {number} */ v = ((a || org.apache.royale.utils.Language.zeroStr).toString().toLowerCase().localeCompare((b || org.apache.royale.utils.Language.zeroStr).toString().toLowerCase())) >> 0;
  if (v != 0) {
    return (v * org.apache.royale.utils.Language.muler) >> 0;
  }
  return 0;
};


/**
 * @private
 * @param {Object} a
 * @param {Object} b
 * @return {number}
 */
org.apache.royale.utils.Language.compareAsString = function(a, b) {
  var /** @type {number} */ v = ((a || org.apache.royale.utils.Language.zeroStr).toString().localeCompare((b || org.apache.royale.utils.Language.zeroStr).toString())) >> 0;
  if (v != 0) {
    return (v * org.apache.royale.utils.Language.muler) >> 0;
  }
  return 0;
};


/**
 * @private
 * @param {Object} a
 * @param {Object} b
 * @return {number}
 */
org.apache.royale.utils.Language.compareAsNumber = function(a, b) {
  if (a > b) {
    return (org.apache.royale.utils.Language.muler) >> 0;
  } else if (a < b) {
    return (-org.apache.royale.utils.Language.muler) >> 0;
  }
  return 0;
};


/**
 * @asparam arr
 * @asparam names
 * @asparam opt
 * @royaleignorecoercion Array
 * @param {Array} arr
 * @param {Object} names
 * @param {Object=} opt
 * @return {Array}
 */
org.apache.royale.utils.Language.sortOn = function(arr, names, opt) {
  opt = typeof opt !== 'undefined' ? opt : 0;
  if (org.apache.royale.utils.Language.is(names, Array)) {
    org.apache.royale.utils.Language.sortNames = names;
  } else {
    org.apache.royale.utils.Language.sortNamesOne[0] = names;
    org.apache.royale.utils.Language.sortNames = org.apache.royale.utils.Language.sortNamesOne;
  }
  if (org.apache.royale.utils.Language.is(opt, Array)) {
    var /** @type {number} */ opt2 = 0;
    var foreachiter0_target = opt;
    for (var foreachiter0 in foreachiter0_target) 
    {
    var o = foreachiter0_target[foreachiter0];
    {
      opt2 = opt2 | o;
    }}
    
  } else {
    opt2 = ((org.apache.royale.utils.Language._int(opt) == opt) ? org.apache.royale.utils.Language._int(opt) : 0) >> 0;
  }
  org.apache.royale.utils.Language.muler = (2 & opt2) > 0 ? -1 : 1;
  var /** @type {Array} */ orig;
  if (opt2 & 8) {
    orig = arr.slice();
  }
  if (opt2 & 16) {
    arr.sort(org.apache.royale.utils.Language.compareNumber);
  } else if (opt2 & 1) {
    arr.sort(org.apache.royale.utils.Language.compareStringCaseinsensitive);
  } else {
    arr.sort(org.apache.royale.utils.Language.compareString);
  }
  if (opt2 & 8) {
    var /** @type {Array} */ retArr = [];
    var /** @type {number} */ n = (arr.length) >> 0;
    for (var /** @type {number} */ i = 0; i < n; i++) {
      var /** @type {Object} */ item = orig[i];
      retArr.push(arr.indexOf(item));
    }
    return retArr;
  }
  return arr;
};


/**
 * @private
 * @param {Object} a
 * @param {Object} b
 * @return {number}
 */
org.apache.royale.utils.Language.compareStringCaseinsensitive = function(a, b) {
  var foreachiter1_target = org.apache.royale.utils.Language.sortNames;
  for (var foreachiter1 in foreachiter1_target) 
  {
  var n = foreachiter1_target[foreachiter1];
  {
    var /** @type {number} */ v = ((a[n] || org.apache.royale.utils.Language.zeroStr).toString().toLowerCase().localeCompare((b[n] || org.apache.royale.utils.Language.zeroStr).toString().toLowerCase())) >> 0;
    if (v != 0) {
      return (v * org.apache.royale.utils.Language.muler) >> 0;
    }
  }}
  
  return 0;
};


/**
 * @private
 * @param {Object} a
 * @param {Object} b
 * @return {number}
 */
org.apache.royale.utils.Language.compareString = function(a, b) {
  var foreachiter2_target = org.apache.royale.utils.Language.sortNames;
  for (var foreachiter2 in foreachiter2_target) 
  {
  var n = foreachiter2_target[foreachiter2];
  {
    var /** @type {number} */ v = ((a[n] || org.apache.royale.utils.Language.zeroStr).toString().localeCompare((b[n] || org.apache.royale.utils.Language.zeroStr).toString())) >> 0;
    if (v != 0) {
      return (v * org.apache.royale.utils.Language.muler) >> 0;
    }
  }}
  
  return 0;
};


/**
 * @private
 * @param {Object} a
 * @param {Object} b
 * @return {number}
 */
org.apache.royale.utils.Language.compareNumber = function(a, b) {
  var foreachiter3_target = org.apache.royale.utils.Language.sortNames;
  for (var foreachiter3 in foreachiter3_target) 
  {
  var n = foreachiter3_target[foreachiter3];
  {
    if (a[n] > b[n]) {
      return (org.apache.royale.utils.Language.muler) >> 0;
    } else if (a[n] < b[n]) {
      return (-org.apache.royale.utils.Language.muler) >> 0;
    }
  }}
  
  return 0;
};


/**
 * no export (allow dead code elimination if never used):
 * @param {*} val
 * @return {*}
 */
org.apache.royale.utils.Language.resolveUncertain = function(val) {
  if (val) {
    var /** @type {Object} */ c = val.constructor;
    if (c == String || c == Number || c == Boolean || c.constructor == org.apache.royale.utils.Language._synthType)
      val = val.valueOf();
  }
  return val;
};


/**
 * @private
 * @type {Object}
 */
org.apache.royale.utils.Language._synthType;


/**
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.utils.Language.SYNTH_TAG_FIELD = goog.DEBUG ? '_synthType' : '_s';


/**
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.utils.Language.CHECK_INDEX = goog.DEBUG ? 'chkIdx' : '_ci';


/**
 * @param {Object} def
 * @return {boolean}
 */
org.apache.royale.utils.Language.isSynthType = function(def) {
  return !!((org.apache.royale.utils.Language._synthType && def && def.constructor == org.apache.royale.utils.Language._synthType));
};


/**
 * Intended primarily for compiler-generated use only
 * Low level class factory for synthetic types (native AS3 top-level classes that are final and do not have corresponding classes in javascript).
 * Supports very light integration for emulation of related language level features, for construction, type-checking and coercion
 * by default: supports int, uint and Class
 * This Language method is only included in release build if it is used anywhere
 * Supports a 'plugin' style addition of extra types beyond the basic defaults
 *
 * @royalesuppressresolveuncertain true, _synthType
 * @royalesuppresscompleximplicitcoercion true
 *
 * @param {string} typeName
 * @param {*} newDefinition
 * @return {Object}
 */
org.apache.royale.utils.Language.synthType = function(typeName, newDefinition) {
  if (!org.apache.royale.utils.Language._synthType) {
    var /** @type {*} */ rtFunc = Function;
    org.apache.royale.utils.Language._synthType = rtFunc('return ' + 'function(b,c,d,e,n){var f=function(){var t=this;var a=Array.prototype.slice.call(arguments);a.push(t);t.type=f.type;t.value=f.construct.apply(t,a);return f.noWrap?t.value:t};f.type=b;f.toString=function(){return b};f.construct=c;f.checkIs=d;f.coerce=e;f.noWrap=!!n;var p=f.prototype;p.valueOf=function(){return this.value};p.constructor=f;f.constructor=arguments.callee;return f}')();
    Object.defineProperties(org.apache.royale.utils.Language._synthType, {'_types':{value:{}}});
  }
  var /** @type {Object} */ typeStore = org.apache.royale.utils.Language._synthType['_types'];
  if (newDefinition) {
    typeStore[typeName] = new org.apache.royale.utils.Language._synthType(typeName, newDefinition['construct'], newDefinition['checkIs'], newDefinition['coerce'], newDefinition['noWrap']);
  }
  var /** @type {Object} */ snythTypeInst = typeStore[typeName];
  if (!snythTypeInst) {
    switch (typeName) {
      case 'int':
        snythTypeInst = typeStore['int'] = new org.apache.royale.utils.Language._synthType('int', org.apache.royale.utils.Language._int, function(v) {
          return v >> 0 === v.valueOf();
        }, org.apache.royale.utils.Language._int);
        break;
      case 'uint':
        snythTypeInst = typeStore['uint'] = new org.apache.royale.utils.Language._synthType('uint', org.apache.royale.utils.Language.uint, function(v) {
          return v >>> 0 === v.valueOf();
        }, org.apache.royale.utils.Language.uint);
        break;
      case 'Class':
        
/**
 * @const
 * @type {RegExp}
 */
var excludeName = /^name$|^name,|,name$|,name(?=,)/;
        
/**
 * @const
 * @type {string}
 */
var isFunc = Object.getOwnPropertyNames(function() {
        }).join().replace(excludeName, '');
        
/**
 * @const
 * @type {Function}
 */
var classCheck = function(v) {
          return !!(typeof(v) == 'function' && v.prototype && v.prototype['constructor'] == v && (v.prototype.ROYALE_CLASS_INFO || v.constructor == org.apache.royale.utils.Language._synthType || v == Boolean || Object.getOwnPropertyNames(v).join().replace(excludeName, '') != isFunc));
        };
        snythTypeInst = typeStore['Class'] = new org.apache.royale.utils.Language._synthType('Class', function() {
          throw new TypeError('Error #1115: Class is not a constructor.');
        }, classCheck, function(v) {
          if (v != null && !classCheck(v))
            throw new TypeError('Error #1034: Type Coercion failed: cannot convert "' + org.apache.royale.utils.Language.string(v) + '" to Class.');
          return v ? v : null;
        });
        break;
      default:
        throw new TypeError('unknown synthetic type:' + typeName);
        break;
    }
  }
  return snythTypeInst;
};


/**
 * Intended primarily for compiler-generated use only
 * Adds Vector support via synthType
 * Acts like a class Factory for Vector subclasses as synthTypes, which provides correct type-checking behaviour
 * Uses cached lookups and 'plugin' style addition of synthTypes for each distinct requested Vector subclass type
 *
 * @royaleignorecoercion Array
 * @royalesuppresscompleximplicitcoercion true
 *
 * @param {string} elementType
 * @return {Object}
 */
org.apache.royale.utils.Language.synthVector = function(elementType) {
  var /** @type {string} */ typeName = 'Vector';
  if (elementType !== null)
    typeName += '.<' + elementType + '>';
  
/**
 * @const
 * @type {Function}
 */
var synth = org.apache.royale.utils.Language.synthType;
  if (!org.apache.royale.utils.Language._synthType || !org.apache.royale.utils.Language._synthType['_types'][typeName]) {
    var /** @type {Object} */ type = synth(typeName, {'construct':function(size, fixed, instance) {
      
/**
 * @const
 * @type {Array}
 */
var a = arguments;
      var /** @type {number} */ l = a.length;
      instance = a[--l];
      fixed = !!(l == 2 ? a[--l] : false);
      size = (l == 1 ? a[0] : 0) >> 0;
      instance['type'] = typeName;
      instance[org.apache.royale.utils.Language.VectorSupport.FIXED_LEN] = fixed ? size : -1;
      return org.apache.royale.utils.Language.VectorSupport.arrayVector([], size, elementType, fixed, instance);
    }, 'checkIs':function(v) {
      return org.apache.royale.utils.Language.VectorSupport.checkIsVector(v, typeName);
    }, 'coerce':function(source) {
      if (source && Array.isArray(source)) {
        var /** @type {Array} */ arr = org.apache.royale.utils.Language.as(source, Array);
        return org.apache.royale.utils.Language.VectorSupport.checkIsVector(arr, typeName) ? arr : org.apache.royale.utils.Language.VectorSupport.arrayVector(arr.slice(), (arr.length) >> 0, elementType, false, null, false);
      }
      throw new TypeError('Error #1034: Type Coercion failed: cannot convert ' + source + ' to ' + typeName);
    }, 'noWrap':true});
    org.apache.royale.utils.Language.VectorSupport.langSynthType = org.apache.royale.utils.Language._synthType;
    org.apache.royale.utils.Language.VectorSupport.vectorElementCoercion(elementType, type, false);
    org.apache.royale.utils.Language.VectorSupport.vectorElementDefault(elementType, type);
    type.prototype = Object.create(type.prototype);
    
/**
 * @const
 * @type {Object}
 */
var baseVectorOverrides = org.apache.royale.utils.Language.VectorSupport.getBaseOverrides();
    
/**
 * @const
 * @type {Object}
 */
var localOverrides = {'length':{'get':baseVectorOverrides.get_len, 'set':baseVectorOverrides.set_len}, 'toString':{value:baseVectorOverrides.toString}, 'map':{value:baseVectorOverrides.map}, 'splice':{value:baseVectorOverrides.splice}, 'slice':{value:baseVectorOverrides.slice}, 'concat':{value:baseVectorOverrides.concat}, 'filter':{value:baseVectorOverrides.filter}, 'insertAt':{value:baseVectorOverrides.uncheckedInsertAt}, 'removeAt':{value:baseVectorOverrides.uncheckedRemoveAt}, 'constructor':{value:type}};
    localOverrides[org.apache.royale.utils.Language.CHECK_INDEX] = {value:baseVectorOverrides[org.apache.royale.utils.Language.CHECK_INDEX]};
    localOverrides[org.apache.royale.utils.Language.VectorSupport.ELEMENT_TYPE] = {value:elementType};
    localOverrides['type'] = {value:typeName};
    localOverrides[org.apache.royale.utils.Language.VectorSupport.COERCE_ELEMENT] = {value:type[org.apache.royale.utils.Language.VectorSupport.COERCE_ELEMENT], configurable:true};
    localOverrides[org.apache.royale.utils.Language.VectorSupport.DEFAULT_VALUE] = {value:type[org.apache.royale.utils.Language.VectorSupport.DEFAULT_VALUE]};
    Object.defineProperties(type.prototype, localOverrides);
  }
  return org.apache.royale.utils.Language._synthType['_types'][typeName];
};


/**
 * A light wrapper around a Vector constructor call that has an untyped return type
 * (because the resulting type is unknown at compile time)
 * This could be used to create and return a default Vector instance
 *
 * @royaleignorecoercion Array
 * no export (allow dead code elimination if never used):
 * @param {number=} size
 * @param {string=} baseType
 * @param {boolean=} fixed
 * @return {*}
 */
org.apache.royale.utils.Language.Vector = function(size, baseType, fixed) {
  size = typeof size !== 'undefined' ? size : 0;
  baseType = typeof baseType !== 'undefined' ? baseType : null;
  fixed = typeof fixed !== 'undefined' ? fixed : false;
  var /** @type {Object} */ vectorClass = org.apache.royale.utils.Language.synthVector(baseType);
  return new vectorClass(size, fixed);
};


/**
 * Support for legacy vectorEmulationClass=Array approach.
 *
 * no export (allow dead code elimination if never used):
 * @param {number=} size
 * @param {string=} baseType
 * @return {Array}
 */
org.apache.royale.utils.Language.arrayAsVector = function(size, baseType) {
  size = typeof size !== 'undefined' ? size : 0;
  baseType = typeof baseType !== 'undefined' ? baseType : null;
  var /** @type {Array} */ arr = [];
  var /** @type {Object} */ defValue = null;
  if (baseType == "int" || baseType == "uint" || baseType == "Number") {
    defValue = 0;
  } else if (baseType == "String") {
    defValue = "";
  } else if (baseType == "Boolean") {
    defValue = false;
  }
  for (var /** @type {number} */ i = 0; i < size; i++)
    arr.push(defValue);
  return arr;
};


/**
 * @constructor
 */
org.apache.royale.utils.Language.VectorSupport = function() {
};


/**
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.utils.Language.VectorSupport.fixedRangeError = 'Error #1126: Cannot change the length of a fixed Vector';


/**
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.utils.Language.VectorSupport.nonConstructorError = 'Error #1007: Instantiation attempted on a non-constructor.';


/**
 * @nocollapse
 * @type {Object}
 */
org.apache.royale.utils.Language.VectorSupport.langSynthType;


/**
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.utils.Language.VectorSupport.COERCE_ELEMENT = goog.DEBUG ? 'coerceElement' : 'cE';


/**
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.utils.Language.VectorSupport.DEFAULT_VALUE = goog.DEBUG ? 'defaultValue' : 'dV';


/**
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.utils.Language.VectorSupport.ELEMENT_TYPE = goog.DEBUG ? 'elementType' : 'eT';


/**
 * @nocollapse
 * @const
 * @type {string}
 */
org.apache.royale.utils.Language.VectorSupport.FIXED_LEN = goog.DEBUG ? 'fixedLen' : 'fL';


/**
 * @private
 * @param {number} index
 * @param {number} limit
 * @return {string}
 */
org.apache.royale.utils.Language.VectorSupport.indexRangerError = function(index, limit) {
  return 'Error #1125: The index ' + index + ' is out of range ' + limit;
};


/**
 * internal use only: v should be an Array.
 * @param {Object} v
 * @param {string} typeName
 * @return {boolean}
 */
org.apache.royale.utils.Language.VectorSupport.checkIsVector = function(v, typeName) {
  
/**
 * @const
 * @type {boolean}
 */
var base = !!(v && org.apache.royale.utils.Language.SYNTH_TAG_FIELD in v);
  var /** @type {boolean} */ ret = base && v[org.apache.royale.utils.Language.SYNTH_TAG_FIELD] instanceof org.apache.royale.utils.Language.VectorSupport.langSynthType['_types'][typeName];
  if (!ret && base && typeName == "Vector.<*>") {
    
/**
 * @const
 * @type {string}
 */
var elementType = org.apache.royale.utils.Language.string(v[org.apache.royale.utils.Language.SYNTH_TAG_FIELD][org.apache.royale.utils.Language.VectorSupport.ELEMENT_TYPE]);
    ret = elementType != 'int' && elementType != 'uint' && elementType != 'Number';
  }
  return ret;
};


/**
 * @param {string} elementType
 * @param {Object} synthVectorClass
 * @return {Object}
 */
org.apache.royale.utils.Language.VectorSupport.vectorElementDefault = function(elementType, synthVectorClass) {
  if (synthVectorClass[org.apache.royale.utils.Language.VectorSupport.DEFAULT_VALUE] !== undefined)
    return synthVectorClass[org.apache.royale.utils.Language.VectorSupport.DEFAULT_VALUE];
  
/**
 * @const
 * @type {Object}
 */
var standardDefaults = {'int':0, 'uint':0, 'Number':0, 'String':'', 'Boolean':false};
  var /** @type {Object} */ defaultVal = null;
  if (elementType in standardDefaults) {
    defaultVal = standardDefaults[elementType];
  }
  synthVectorClass[org.apache.royale.utils.Language.VectorSupport.DEFAULT_VALUE] = defaultVal;
  return defaultVal;
};


/**
 *
 * @royaleignorecoercion Function
 * @royalesuppresscompleximplicitcoercion true
 * @param {string} elementType
 * @param {Object} synthVectorClass
 * @param {boolean} deferred
 * @return {Function}
 */
org.apache.royale.utils.Language.VectorSupport.vectorElementCoercion = function(elementType, synthVectorClass, deferred) {
  if (synthVectorClass[org.apache.royale.utils.Language.VectorSupport.COERCE_ELEMENT])
    return  /** @type {Function} */ (synthVectorClass[org.apache.royale.utils.Language.VectorSupport.COERCE_ELEMENT]);
  
/**
 * @const
 * @type {Function}
 */
var identity = function(v) {
    return v === undefined ? null : v;
  };
  
/**
 * @const
 * @type {Object}
 */
var standardCoercions = {'int':org.apache.royale.utils.Language._int, 'uint':org.apache.royale.utils.Language.uint, 'Number':Number, 'String':org.apache.royale.utils.Language.string, 'Boolean':Boolean, "*":identity, "Object":identity};
  var /** @type {Function} */ coercion;
  if (elementType == 'Class') {
    coercion = org.apache.royale.utils.Language.synthType('Class', null)['coerce'];
  }
  else
    coercion =  /** @type {Function} */ (standardCoercions[elementType]);
  if (coercion == null) {
    if (elementType.indexOf('Vector.<') == 0) {
      coercion = function(v) {
        if (!(v === null || org.apache.royale.utils.Language.synthVector(elementType.slice(8, -1))['checkIs'](v))) {
          throw new TypeError('Error #1034: Type Coercion failed: cannot convert ' + v + ' to ' + elementType);
        }
        else
          return v;
      };
    } else {
      var /** @type {boolean} */ defer = false;
      var /** @type {Array} */ parts = elementType.split('.');
      var /** @type {number} */ n = (parts.length) >> 0;
      var /** @type {Object} */ o = goog.global;
      for (var /** @type {number} */ i = 0; i < n; i++) {
        o = o && o[parts[i]];
        if (!o) {
          if (deferred)
            throw new TypeError('missing dependency ' + elementType);
          defer = true;
          break;
        }
      }
      if (defer) {
        coercion = null;
      }
      else
        coercion = function(v) {
          return org.apache.royale.utils.Language.as(v, o, true);
        };
    }
  }
  synthVectorClass[org.apache.royale.utils.Language.VectorSupport.COERCE_ELEMENT] = coercion;
  if (deferred) {
    Object.defineProperty(synthVectorClass.prototype, org.apache.royale.utils.Language.VectorSupport.COERCE_ELEMENT, {value:coercion});
  }
  return coercion;
};


/**
 * internal use only. arr should be an Array
 * @royaleignorecoercion Array
 * @royaleignorecoercion Function
 * @private
 * @param {Object} arr
 * @param {number} size
 * @param {Object} tag
 * @return {Error}
 */
org.apache.royale.utils.Language.VectorSupport.coerceElements = function(arr, size, tag) {
  var /** @type {Function} */ coercion =  /** @type {Function} */ (tag[org.apache.royale.utils.Language.VectorSupport.COERCE_ELEMENT]);
  if (coercion == null) {
    coercion = org.apache.royale.utils.Language.VectorSupport.vectorElementCoercion(org.apache.royale.utils.Language.string(tag[org.apache.royale.utils.Language.VectorSupport.ELEMENT_TYPE]), tag.constructor, true);
  }
  var /** @type {Error} */ err;
  for (var /** @type {number} */ i = 0; i < size; i++) {
    var /** @type {*} */ original = arr[i];
    if (original === undefined)
      original = null;
    try {
      arr[i] = coercion(original);
    } catch (e) {
      
/**
 * @const
 * @type {Object}
 */
var defValue = tag[org.apache.royale.utils.Language.VectorSupport.DEFAULT_VALUE];
      org.apache.royale.utils.Language.VectorSupport.array_fill(arr, defValue, (i) >>> 0);
      err = e;
      break;
    }
  }
  return err;
};


/**
 * @royaleignorecoercion Function
 * @param {Array} arr
 * @param {number} size
 * @param {string} basetype
 * @param {boolean} fixed
 * @param {Object} tag
 * @param {boolean=} construct
 * @return {Array}
 */
org.apache.royale.utils.Language.VectorSupport.arrayVector = function(arr, size, basetype, fixed, tag, construct) {
  construct = typeof construct !== 'undefined' ? construct : true;
  size = size >>> 0;
  if (basetype == null) {
    throw new TypeError(org.apache.royale.utils.Language.VectorSupport.nonConstructorError);
  }
  org.apache.royale.utils.Language.VectorSupport.tagVectorArray(arr, basetype, fixed, tag);
  if (!tag)
    tag = arr[org.apache.royale.utils.Language.SYNTH_TAG_FIELD];
  if (size) {
    if (construct) {
      arr.length = size;
      
/**
 * @const
 * @type {Object}
 */
var defValue = tag[org.apache.royale.utils.Language.VectorSupport.DEFAULT_VALUE];
      org.apache.royale.utils.Language.VectorSupport.array_fill(arr, defValue, 0);
    } else {
      
/**
 * @const
 * @type {Error}
 */
var err = org.apache.royale.utils.Language.VectorSupport.coerceElements(arr, (size) >>> 0, tag);
      if (err)
        throw new ((err.constructor))(err.message);
    }
  }
  return arr;
};


/**
 * @royalesuppressclosure
 * @royalesuppresscompleximplicitcoercion true
 * @param {Array} array
 * @param {string} elementType
 * @param {boolean} fixed
 * @param {Object} inst
 * @return {Array}
 */
org.apache.royale.utils.Language.VectorSupport.tagVectorArray = function(array, elementType, fixed, inst) {
  
/**
 * @const
 * @type {string}
 */
var vectorType = 'Vector.<' + elementType + '>';
  
/**
 * @const
 * @type {Object}
 */
var synthVectorClass = inst ? inst.constructor : org.apache.royale.utils.Language.VectorSupport.langSynthType['_types'][vectorType];
  if (!inst)
    inst = new synthVectorClass()[org.apache.royale.utils.Language.SYNTH_TAG_FIELD];
  inst.value = array;
  
/**
 * @const
 * @type {Function}
 */
var blend = Object.assign || function(target, source) {
    for (var /** @type {string} */ field in source) {
      target[field] = source[field];
    }
    return target;
  };
  
/**
 * @const
 * @type {Object}
 */
var props = {'fixed':{'get':function() {
    return inst[org.apache.royale.utils.Language.VectorSupport.FIXED_LEN] > -1;
  }, 'set':function(v) {
    if (inst[org.apache.royale.utils.Language.VectorSupport.FIXED_LEN] > -1 != v) {
      inst[org.apache.royale.utils.Language.VectorSupport.FIXED_LEN] = (v ? array.length : -1);
      Object.defineProperties(array, org.apache.royale.utils.Language.VectorSupport.getMutationTypeSafetyOverrides(v));
    }
  }}, 'splice':{value:inst.splice}, 'slice':{value:inst.slice}, 'concat':{value:inst.concat}, 'map':{value:inst.map}, 'filter':{value:inst.filter}, 'toString':{value:inst.toString}, 'constructor':{value:inst.constructor}};
  props[org.apache.royale.utils.Language.CHECK_INDEX] = {value:inst[org.apache.royale.utils.Language.CHECK_INDEX]};
  props[org.apache.royale.utils.Language.SYNTH_TAG_FIELD] = {value:inst};
  blend(props, org.apache.royale.utils.Language.VectorSupport.getMutationTypeSafetyOverrides(fixed));
  Object.defineProperties(array, props);
  return array;
};


/**
 * Fills the array from a start point (defaults to zero) to its end with the specified value
 * @private
 * @param {Array} arr
 * @param {Object} value
 * @param {number} start
 * @return {Array}
 */
org.apache.royale.utils.Language.VectorSupport.array_fill = function(arr, value, start) {
  if (arr['fill']) {
    return arr['fill'](value, start);
  } else {
    var /** @type {number} */ i = start >>> 0;
    
/**
 * @const
 * @type {number}
 */
var l = (arr.length) >>> 0;
    while (i < l) {
      arr[i] = value;
      i++;
    }
  }
  return arr;
};


/**
 * @private
 * @type {org.apache.royale.utils.Language.VectorSupport}
 */
org.apache.royale.utils.Language.VectorSupport._instance;


/**
 * @private
 * @type {Object}
 */
org.apache.royale.utils.Language.VectorSupport._baseObject;


/**
 
 * prevent closure generation for the method references:
 * @royalesuppressclosure
 * @return {Object}
 */
org.apache.royale.utils.Language.VectorSupport.getBaseOverrides = function() {
  if (org.apache.royale.utils.Language.VectorSupport._baseObject)
    return org.apache.royale.utils.Language.VectorSupport._baseObject;
  org.apache.royale.utils.Language.VectorSupport._instance = new org.apache.royale.utils.Language.VectorSupport();
  org.apache.royale.utils.Language.VectorSupport._baseObject = {};
  var /** @type {org.apache.royale.utils.Language.VectorSupport} */ inst = org.apache.royale.utils.Language.VectorSupport._instance;
  org.apache.royale.utils.Language.VectorSupport._baseObject.toString = inst.toString;
  org.apache.royale.utils.Language.VectorSupport._baseObject.map = inst.map;
  org.apache.royale.utils.Language.VectorSupport._baseObject.splice = inst.splice;
  org.apache.royale.utils.Language.VectorSupport._baseObject.slice = inst.slice;
  org.apache.royale.utils.Language.VectorSupport._baseObject.concat = inst.concat;
  org.apache.royale.utils.Language.VectorSupport._baseObject.filter = inst.filter;
  org.apache.royale.utils.Language.VectorSupport._baseObject.uncheckedInsertAt = inst.uncheckedInsertAt;
  org.apache.royale.utils.Language.VectorSupport._baseObject.uncheckedRemoveAt = inst.uncheckedRemoveAt;
  org.apache.royale.utils.Language.VectorSupport._baseObject.get_len = inst.get_len;
  org.apache.royale.utils.Language.VectorSupport._baseObject.set_len = inst.set_len;
  org.apache.royale.utils.Language.VectorSupport._baseObject[org.apache.royale.utils.Language.CHECK_INDEX] = inst.chkIdx;
  return org.apache.royale.utils.Language.VectorSupport._baseObject;
};


/**
 * @private
 * @type {Object}
 */
org.apache.royale.utils.Language.VectorSupport._nonFixedTypeSafetyOverrides;


/**
 * @private
 * @type {Object}
 */
org.apache.royale.utils.Language.VectorSupport._fixedTypeSafetyOverrides;


/**
 * @royalesuppressclosure
 * @param {boolean} fixed
 * @return {Object}
 */
org.apache.royale.utils.Language.VectorSupport.getMutationTypeSafetyOverrides = function(fixed) {
  if (org.apache.royale.utils.Language.VectorSupport._nonFixedTypeSafetyOverrides)
    return fixed ? org.apache.royale.utils.Language.VectorSupport._fixedTypeSafetyOverrides : org.apache.royale.utils.Language.VectorSupport._nonFixedTypeSafetyOverrides;
  var /** @type {org.apache.royale.utils.Language.VectorSupport} */ inst = org.apache.royale.utils.Language.VectorSupport._instance;
  org.apache.royale.utils.Language.VectorSupport._nonFixedTypeSafetyOverrides = {'pop':{value:Array.prototype.pop, configurable:true}, 'push':{value:inst.push, configurable:true}, 'shift':{value:Array.prototype.shift, configurable:true}, 'unshift':{value:inst.unshift, configurable:true}, 'insertAt':{value:inst.insertAt, configurable:true}, 'removeAt':{value:inst.removeAt, configurable:true}};
  
/**
 * @const
 * @type {Object}
 */
var error = {value:inst.throwRangeError, configurable:true};
  org.apache.royale.utils.Language.VectorSupport._fixedTypeSafetyOverrides = {'pop':error, 'push':error, 'shift':error, 'unshift':error, 'insertAt':error, 'removeAt':error};
  return fixed ? org.apache.royale.utils.Language.VectorSupport._fixedTypeSafetyOverrides : org.apache.royale.utils.Language.VectorSupport._nonFixedTypeSafetyOverrides;
};


/**
 * @return {string}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.toString = function() {
  return Array.prototype.map.call(this, String).toString();
};


/**
 * @royaleignorecoercion Array
 * @param {Function} callback
 * @return {*}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.map = function(callback) {
  var self = this;
  var /** @type {Object} */ inst = this[org.apache.royale.utils.Language.SYNTH_TAG_FIELD];
  return org.apache.royale.utils.Language.VectorSupport.tagVectorArray(Array.prototype.map.call(this, function(item, index, source) {
    return inst[org.apache.royale.utils.Language.VectorSupport.COERCE_ELEMENT](callback(item, index, source));
  }), org.apache.royale.utils.Language.string(inst[org.apache.royale.utils.Language.VectorSupport.ELEMENT_TYPE]), false, null);
};


/**
 * @royaleignorecoercion Array
 * @return {*}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.splice = function() {
  var /** @type {Array} */ a = Array.prototype.slice.call(arguments);
  var /** @type {Object} */ inst = this[org.apache.royale.utils.Language.SYNTH_TAG_FIELD];
  var /** @type {Array} */ ret = Array.prototype.splice.apply(this, a);
  if (inst[org.apache.royale.utils.Language.VectorSupport.FIXED_LEN] > -1)
    inst[org.apache.royale.utils.Language.VectorSupport.FIXED_LEN] = this['length'];
  return org.apache.royale.utils.Language.VectorSupport.tagVectorArray(ret, org.apache.royale.utils.Language.string(inst[org.apache.royale.utils.Language.VectorSupport.ELEMENT_TYPE]), false, null);
};


/**
 * @royaleignorecoercion Array
 * @return {*}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.slice = function() {
  var /** @type {Array} */ a = Array.prototype.slice.call(arguments);
  var /** @type {Object} */ inst = this[org.apache.royale.utils.Language.SYNTH_TAG_FIELD];
  var /** @type {Array} */ ret = Array.prototype.slice.apply(this, a);
  return org.apache.royale.utils.Language.VectorSupport.tagVectorArray(ret, org.apache.royale.utils.Language.string(inst[org.apache.royale.utils.Language.VectorSupport.ELEMENT_TYPE]), false, null);
};


/**
 * @royaleignorecoercion Array
 * @return {*}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.filter = function() {
  var /** @type {Array} */ a = Array.prototype.slice.call(arguments);
  var /** @type {Object} */ inst = this[org.apache.royale.utils.Language.SYNTH_TAG_FIELD];
  var /** @type {Array} */ ret = Array.prototype.filter.apply(this, a);
  return org.apache.royale.utils.Language.VectorSupport.tagVectorArray(ret, org.apache.royale.utils.Language.string(inst[org.apache.royale.utils.Language.VectorSupport.ELEMENT_TYPE]), false, null);
};


/**
 * @royaleignorecoercion Array
 * @royaleignorecoercion String
 * @return {*}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.concat = function() {
  var /** @type {Array} */ a = Array.prototype.slice.call(arguments);
  var /** @type {Object} */ inst = this[org.apache.royale.utils.Language.SYNTH_TAG_FIELD];
  var /** @type {number} */ l = (a.length) >>> 0;
  for (var /** @type {number} */ i = 0; i < l; i++) {
    var /** @type {Array} */ contender = a[i];
    if (!org.apache.royale.utils.Language.VectorSupport.checkIsVector(contender, inst['type'])) {
      throw new TypeError('Error #1034: Type Coercion failed: cannot convert ' + contender[org.apache.royale.utils.Language.SYNTH_TAG_FIELD]['type'] + ' to ' + inst['type']);
    }
  }
  var /** @type {Array} */ ret = Array.prototype.concat.apply(this, a);
  return org.apache.royale.utils.Language.VectorSupport.tagVectorArray(ret, org.apache.royale.utils.Language.string(inst[org.apache.royale.utils.Language.VectorSupport.ELEMENT_TYPE]), false, null);
};


/**
 * @param {number} index
 * @param {*} item
 * @return {*}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.uncheckedInsertAt = function(index, item) {
  return Array.prototype.splice.call(this, index, 0, item);
};


/**
 * @param {number} index
 * @return {*}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.uncheckedRemoveAt = function(index) {
  return Array.prototype.splice.call(this, index, 1)[0];
};


/**
 * @return {number}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.get_len = function() {
  return Number(this['value'].length);
};


/**
 * @royaleignorecoercion Array
 * @param {number} value
 */
org.apache.royale.utils.Language.VectorSupport.prototype.set_len = function(value) {
  if (this[org.apache.royale.utils.Language.VectorSupport.FIXED_LEN] != -1) {
    throw new RangeError(org.apache.royale.utils.Language.VectorSupport.fixedRangeError);
  } else {
    var /** @type {number} */ oldLen = Number(this['value'].length);
    this['value'].length = value;
    if (oldLen < value) {
      org.apache.royale.utils.Language.VectorSupport.array_fill(this['value'], this[org.apache.royale.utils.Language.VectorSupport.DEFAULT_VALUE], (oldLen) >>> 0);
    }
  }
};


/**
 * @royaleignorecoercion Array
 * @param {*} v
 * @return {*}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.push = function(v) {
  var /** @type {Array} */ a = Array.prototype.slice.call(arguments);
  
/**
 * @const
 * @type {Error}
 */
var err = org.apache.royale.utils.Language.VectorSupport.coerceElements(a, (a.length) >>> 0, this[org.apache.royale.utils.Language.SYNTH_TAG_FIELD]);
  var /** @type {number} */ len = (Array.prototype.push.apply(this, a)) >>> 0;
  if (err)
    throw new ((err.constructor))(err.message);
  return len;
};


/**
 * @royaleignorecoercion Array
 * @param {*} v
 * @return {*}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.unshift = function(v) {
  var /** @type {Array} */ a = Array.prototype.slice.call(arguments);
  
/**
 * @const
 * @type {Error}
 */
var err = org.apache.royale.utils.Language.VectorSupport.coerceElements(a, (a.length) >>> 0, this[org.apache.royale.utils.Language.SYNTH_TAG_FIELD]);
  var /** @type {number} */ len = (Array.prototype.unshift.apply(this, a)) >>> 0;
  if (err)
    throw new ((err.constructor))(err.message);
  return len;
};


/**
 * @param {number} index
 * @param {*} item
 */
org.apache.royale.utils.Language.VectorSupport.prototype.insertAt = function(index, item) {
  this[org.apache.royale.utils.Language.SYNTH_TAG_FIELD]['insertAt'].call(this, index, item);
};


/**
 * @param {number} index
 * @return {Object}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.removeAt = function(index) {
  
/**
 * @const
 * @type {number}
 */
var idx = (index < 0 ? Math.max(this['length'] + index, 0) : index) >> 0;
  if (idx >= this['length'])
    throw new RangeError(org.apache.royale.utils.Language.VectorSupport.indexRangerError(index, (this['length']) >>> 0));
  return this[org.apache.royale.utils.Language.SYNTH_TAG_FIELD]['removeAt'].call(this, idx);
};


/**
 */
org.apache.royale.utils.Language.VectorSupport.prototype.throwRangeError = function() {
  throw new RangeError(org.apache.royale.utils.Language.VectorSupport.fixedRangeError);
};


/**
 * @param {number} index
 * @return {number}
 */
org.apache.royale.utils.Language.VectorSupport.prototype.chkIdx = function(index) {
  var /** @type {number} */ limit = Number(this[org.apache.royale.utils.Language.SYNTH_TAG_FIELD][org.apache.royale.utils.Language.VectorSupport.FIXED_LEN]);
  var /** @type {boolean} */ fail = index >>> 0 !== index;
  fail = fail || ((limit == -1) ? (index > (limit = Number(this['length']))) : (index >= limit));
  if (fail) {
    throw new RangeError(org.apache.royale.utils.Language.VectorSupport.indexRangerError(index, (limit) >>> 0));
  }
  return index;
};