/**
 * Generated by Apache Royale Compiler from org/apache/royale/graphics/SolidColor.as
 * org.apache.royale.graphics.SolidColor
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.graphics.SolidColor');

goog.require('org.apache.royale.graphics.IGraphicShape');
goog.require('org.apache.royale.utils.CSSUtils');
goog.require('org.apache.royale.graphics.IFill');



/**
 *  Constructor.
 *
 *  @asparam color Specifies the color.
 *  The default value is 0x000000 (black).
 *
 *  @asparam alpha Specifies the level of transparency.
 *  Valid values range from 0.0 (completely transparent)
 *  to 1.0 (completely opaque).
 *  The default value is 1.0.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Royale 1.0.0
 * @constructor
 * @implements {org.apache.royale.graphics.IFill}
 * @param {number=} color
 * @param {number=} alpha
 */
org.apache.royale.graphics.SolidColor = function(color, alpha) {
  color = typeof color !== 'undefined' ? color : 0x000000;
  alpha = typeof alpha !== 'undefined' ? alpha : 1.0;
  ;
  this.color = color;
  this.alpha = alpha;
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.graphics.SolidColor', org.apache.royale.graphics.SolidColor);


/**
 * @private
 * @type {number}
 */
org.apache.royale.graphics.SolidColor.prototype.org_apache_royale_graphics_SolidColor__alpha = 1.0;


/**
 * @private
 * @type {number}
 */
org.apache.royale.graphics.SolidColor.prototype.org_apache_royale_graphics_SolidColor__color = 0x0;


/**
 * addFillAttrib()
 *
 * @asparam value The IGraphicShape object on which the fill must be added.
 * @asreturn {string}
 * @export
 * @param {org.apache.royale.graphics.IGraphicShape} value
 * @return {string}
 */
org.apache.royale.graphics.SolidColor.prototype.addFillAttrib = function(value) {
  return 'fill:' + org.apache.royale.utils.CSSUtils.attributeFromColor(this.color) + ';fill-opacity:' + this.alpha;
};


org.apache.royale.graphics.SolidColor.prototype.get__alpha = function() {
  return this.org_apache_royale_graphics_SolidColor__alpha;
};


org.apache.royale.graphics.SolidColor.prototype.set__alpha = function(value) {
  var /** @type {number} */ oldValue = this.org_apache_royale_graphics_SolidColor__alpha;
  if (value != oldValue) {
    this.org_apache_royale_graphics_SolidColor__alpha = value;
  }
};


org.apache.royale.graphics.SolidColor.prototype.get__color = function() {
  return this.org_apache_royale_graphics_SolidColor__color;
};


org.apache.royale.graphics.SolidColor.prototype.set__color = function(value) {
  if (value < 0 || value > 0xffffff)
    throw new Error("Color values must be between 0 and 0xFFFFFF");
  var /** @type {number} */ oldValue = this.org_apache_royale_graphics_SolidColor__color;
  if (value != oldValue) {
    this.org_apache_royale_graphics_SolidColor__color = value;
  }
};


Object.defineProperties(org.apache.royale.graphics.SolidColor.prototype, /** @lends {org.apache.royale.graphics.SolidColor.prototype} */ {
/**
  * @export
  * @type {number} */
alpha: {
get: org.apache.royale.graphics.SolidColor.prototype.get__alpha,
set: org.apache.royale.graphics.SolidColor.prototype.set__alpha},
/**
  * @export
  * @type {number} */
color: {
get: org.apache.royale.graphics.SolidColor.prototype.get__color,
set: org.apache.royale.graphics.SolidColor.prototype.set__color}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.graphics.SolidColor.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'SolidColor', qName: 'org.apache.royale.graphics.SolidColor', kind: 'class' }], interfaces: [org.apache.royale.graphics.IFill] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.graphics.SolidColor.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'alpha': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.graphics.SolidColor'},
        'color': { type: 'uint', access: 'readwrite', declaredBy: 'org.apache.royale.graphics.SolidColor'}
      };
    },
    methods: function () {
      return {
        'SolidColor': { type: '', declaredBy: 'org.apache.royale.graphics.SolidColor', parameters: function () { return [ 'uint', true ,'Number', true ]; }},
        'addFillAttrib': { type: 'String', declaredBy: 'org.apache.royale.graphics.SolidColor', parameters: function () { return [ 'org.apache.royale.graphics.IGraphicShape', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.graphics.SolidColor.prototype.ROYALE_COMPILE_FLAGS = 10;