/**
 * Generated by Apache Royale Compiler from org/apache/royale/display/Graphics.as
 * org.apache.royale.display.Graphics
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.display.Graphics');
goog.provide('org.apache.royale.display.Graphics.setNoFill');

goog.require('org.apache.royale.display.BitmapData');
goog.require('org.apache.royale.display.CapsStyle');
goog.require('org.apache.royale.display.GraphicsBitmapFill');
goog.require('org.apache.royale.display.GraphicsGradientFill');
goog.require('org.apache.royale.display.GraphicsSolidFill');
goog.require('org.apache.royale.display.GraphicsStroke');
goog.require('org.apache.royale.display.IGraphicsFill');
goog.require('org.apache.royale.display.IGraphicsTarget');
goog.require('org.apache.royale.display.JointStyle');
goog.require('org.apache.royale.display.js.JSRuntimeGraphicsStore');
goog.require('org.apache.royale.display.js.createGraphicsSVG');
goog.require('org.apache.royale.geom.Matrix');
goog.require('org.apache.royale.utils.Language');



/**
 * @constructor
 * @param {org.apache.royale.display.IGraphicsTarget} target
 */
org.apache.royale.display.Graphics = function(target) {
  
  this.org_apache_royale_display_Graphics_currentStroke = new org.apache.royale.display.GraphicsStroke();
  this.org_apache_royale_display_Graphics_STROKE_SOLID_FILL = new org.apache.royale.display.GraphicsSolidFill();
  this.org_apache_royale_display_Graphics_STROKE_GRADIENT_FILL = new org.apache.royale.display.GraphicsGradientFill();
  this.org_apache_royale_display_Graphics_STROKE_BITMAP_FILL = new org.apache.royale.display.GraphicsBitmapFill();
  this.org_apache_royale_display_Graphics_SOLID_FILL = new org.apache.royale.display.GraphicsSolidFill();
  this.org_apache_royale_display_Graphics_GRADIENT_FILL = new org.apache.royale.display.GraphicsGradientFill();
  this.org_apache_royale_display_Graphics_BITMAP_FILL = new org.apache.royale.display.GraphicsBitmapFill();
  ;
  if (!org.apache.royale.display.Graphics.unlocked)
    throw new Error('Constructor call not permitted, use static getInstanceFor method');
  this.org_apache_royale_display_Graphics_graphicsTarget = target;
  org.apache.royale.display.Graphics._instIdx++;
};


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.display.Graphics.unlocked;


/**
 * @private
 * @type {WeakMap}
 */
org.apache.royale.display.Graphics.instanceMap;


/**
 * @param {org.apache.royale.display.IGraphicsTarget} target
 * @return {org.apache.royale.display.Graphics}
 */
org.apache.royale.display.Graphics.getInstanceFor = function(target) {
  if (!target)
    return null;
  var /** @type {org.apache.royale.display.Graphics} */ graphicsInst;
  if (!org.apache.royale.display.Graphics.instanceMap) {
    org.apache.royale.display.Graphics.instanceMap = new WeakMap();
  } else {
    graphicsInst = org.apache.royale.display.Graphics.instanceMap.get(target);
  }
  if (!graphicsInst) {
    org.apache.royale.display.Graphics.unlocked = true;
    org.apache.royale.display.Graphics.instanceMap.set(target, (graphicsInst = new org.apache.royale.display.Graphics(target)));
    org.apache.royale.display.Graphics.unlocked = false;
  }
  
  return graphicsInst;
};


/**
 * This provides explicit support for reflection if needed. Otherwise this class can be assumed to be unreflectable by normal means (across targets)
 * @asparam instance - the instance of the Graphics class to be reflected against
 * @asreturn an object that is reflectable via string method names which map to runtime method references
 *
 * @param {org.apache.royale.display.Graphics} instance
 * @return {Object}
 */
org.apache.royale.display.Graphics.getReflectionMap = function(instance) {
  
  if (!instance)
    return null;
  return {'clear':org.apache.royale.utils.Language.closure(instance.clear, instance, 'clear'), 'beginFill':org.apache.royale.utils.Language.closure(instance.beginFill, instance, 'beginFill'), 'endFill':org.apache.royale.utils.Language.closure(instance.endFill, instance, 'endFill'), 'beginGradientFill':org.apache.royale.utils.Language.closure(instance.beginGradientFill, instance, 'beginGradientFill'), 'beginBitmapFill':org.apache.royale.utils.Language.closure(instance.beginBitmapFill, instance, 'beginBitmapFill'), 'lineGradientStyle':org.apache.royale.utils.Language.closure(instance.lineGradientStyle, instance, 'lineGradientStyle'), 'lineBitmapStyle':org.apache.royale.utils.Language.closure(instance.lineBitmapStyle, instance, 'lineBitmapStyle'), 'lineStyle':org.apache.royale.utils.Language.closure(instance.lineStyle, instance, 'lineStyle'), 'moveTo':org.apache.royale.utils.Language.closure(instance.moveTo, instance, 'moveTo'), 'lineTo':org.apache.royale.utils.Language.closure(instance.lineTo, instance, 'lineTo'), 'curveTo':org.apache.royale.utils.Language.closure(instance.curveTo, instance, 'curveTo'), 'cubicCurveTo':org.apache.royale.utils.Language.closure(instance.cubicCurveTo, instance, 'cubicCurveTo'), 'drawEllipse':org.apache.royale.utils.Language.closure(instance.drawEllipse, instance, 'drawEllipse'), 'drawRoundRect':org.apache.royale.utils.Language.closure(instance.drawRoundRect, instance, 'drawRoundRect'), 'drawRoundRectComplex':org.apache.royale.utils.Language.closure(instance.drawRoundRectComplex, instance, 'drawRoundRectComplex'), 'drawRect':org.apache.royale.utils.Language.closure(instance.drawRect, instance, 'drawRect'), 'drawCircle':org.apache.royale.utils.Language.closure(instance.drawCircle, instance, 'drawCircle')};
};


/**
 * @private
 * @type {org.apache.royale.display.IGraphicsTarget}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_graphicsTarget;


/**
 * @royaleignorecoercion HTMLElement
 */
org.apache.royale.display.Graphics.prototype.clear = function() {
  
  var /** @type {SVGElement} */ svg = this.org_apache_royale_display_Graphics_graphicsTarget.graphicsRenderTarget;
  while (svg.firstChild) {
    svg.removeChild(svg.firstChild);
  }
  this.org_apache_royale_display_Graphics__defs = null;
  this.org_apache_royale_display_Graphics_defsIdx = 0;
  this.org_apache_royale_display_Graphics_currentFill = null;
  this.org_apache_royale_display_Graphics_currentStroke = new org.apache.royale.display.GraphicsStroke();
  this.org_apache_royale_display_Graphics__pathData = null;
  this.org_apache_royale_display_Graphics__currentPath = null;
  this.org_apache_royale_display_Graphics__currentStrokePath = null;
  this.org_apache_royale_display_Graphics__strokePathData = null;
  this.org_apache_royale_display_Graphics__nonZeroFill = false;
  this.org_apache_royale_display_Graphics__lastPoint = this.org_apache_royale_display_Graphics__lastStartPoint = null;
  this.org_apache_royale_display_Graphics__moveTo = null;
  this.org_apache_royale_display_Graphics__strokeMove = false;
};


/**
 * @private
 * @type {number}
 */
org.apache.royale.display.Graphics._instIdx = 0;


/**
 * @private
 * @type {number}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_defsIdx = 0;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics__nonZeroFill;


/**
 * @private
 * @type {SVGDefsElement}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics__defs;


/**
 * @private
 * @type {Attr}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics__pathData;


/**
 * @private
 * @return {Attr}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_getPathData = function() {
  if (!this.org_apache_royale_display_Graphics__pathData) {
    this.org_apache_royale_display_Graphics_getCurrentPath();
  }
  return this.org_apache_royale_display_Graphics__pathData;
};


/**
 * @private
 * @type {org.apache.royale.display.IGraphicsFill}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_currentFill;


/**
 * @private
 * @type {org.apache.royale.display.GraphicsStroke}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_currentStroke;


/**
 * @private
 * @type {SVGPathElement}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics__currentPath;


/**
 * @private
 * @type {SVGPathElement}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics__currentStrokePath;


/**
 * @royaleignorecoercion SVGPathElement
 * @royaleignorecoercion SVGElement
 * @private
 * @return {SVGPathElement}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_getCurrentPath = function() {
  if (!this.org_apache_royale_display_Graphics__currentPath) {
    this.org_apache_royale_display_Graphics__currentPath = org.apache.royale.display.js.createGraphicsSVG('path');
    this.org_apache_royale_display_Graphics__currentStrokePath = this.org_apache_royale_display_Graphics__currentPath;
    this.org_apache_royale_display_Graphics__currentPath.setAttributeNS(null, 'd', '');
    this.org_apache_royale_display_Graphics__pathData = this.org_apache_royale_display_Graphics__currentPath.getAttributeNodeNS(null, 'd');
    if (this.org_apache_royale_display_Graphics_currentFill) {
      this.org_apache_royale_display_Graphics_currentFill.apply(this, this.org_apache_royale_display_Graphics__currentPath);
      if (!this.org_apache_royale_display_Graphics__nonZeroFill) {
        this.org_apache_royale_display_Graphics__currentPath.setAttributeNS(null, 'fill-rule', 'evenodd');
      } else {
        this.org_apache_royale_display_Graphics__nonZeroFill = false;
      }
    }
    else
      org.apache.royale.display.Graphics.setNoFill(this.org_apache_royale_display_Graphics__currentPath);
    this.org_apache_royale_display_Graphics_svg.appendChild(this.org_apache_royale_display_Graphics__currentPath);
    this.org_apache_royale_display_Graphics_currentStroke.apply(this, this.org_apache_royale_display_Graphics__currentPath);
  }
  return this.org_apache_royale_display_Graphics__currentPath;
};


/**
 * @private
 * @type {Attr}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics__strokePathData;


/**
 * @private
 * @type {string}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics__lastStartPoint;


/**
 * @private
 * @type {string}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics__moveTo;


/**
 * @private
 * @type {string}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics__lastPoint;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics__strokeMove;


/**
 * @private
 * @param {string} value
 * @param {string} lastPoint
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_appendPathData = function(value, lastPoint) {
  this.org_apache_royale_display_Graphics__lastPoint = lastPoint;
  if (this.org_apache_royale_display_Graphics__moveTo) {
    value = this.org_apache_royale_display_Graphics__moveTo + value;
    this.org_apache_royale_display_Graphics__moveTo = null;
  } else if (!this.org_apache_royale_display_Graphics__pathData && value.charAt(0) !== 'M') {
    value = 'M0 0' + value;
  }
  this.org_apache_royale_display_Graphics_getPathData().value += value;
  if (this.org_apache_royale_display_Graphics__currentStrokePath !== this.org_apache_royale_display_Graphics__currentPath) {
    if (this.org_apache_royale_display_Graphics__strokeMove && value.charAt(0) === 'M') {
      this.org_apache_royale_display_Graphics__strokePathData.value = value;
    } else {
      this.org_apache_royale_display_Graphics__strokePathData.value += value;
    }
    this.org_apache_royale_display_Graphics__strokeMove = false;
  }
};


/**
 * support for linestyle changes that occur 'during' a path
 * also supports special cases where filters are used to support certain effects in svg
 *
 * @royaleignorecoercion SVGPathElement
 * @param {boolean} fromPaint
 * @return {SVGPathElement}
 */
org.apache.royale.display.Graphics.prototype.spawnStroke = function(fromPaint) {
  if (!this.org_apache_royale_display_Graphics__strokePathData) {
    if (this.org_apache_royale_display_Graphics_getCurrentPath().getAttributeNS(null, 'stroke') !== 'none') {
      this.org_apache_royale_display_Graphics__currentStrokePath = org.apache.royale.display.js.createGraphicsSVG('path');
      this.org_apache_royale_display_Graphics__currentStrokePath.setAttributeNS(null, 'd', this.org_apache_royale_display_Graphics_getPathData().value);
      this.org_apache_royale_display_Graphics__currentStrokePath.setAttributeNS(null, 'fill', 'none');
      this.org_apache_royale_display_Graphics_currentStroke.apply(this, this.org_apache_royale_display_Graphics__currentStrokePath);
      this.org_apache_royale_display_Graphics_getCurrentPath().setAttributeNS(null, 'stroke', 'none');
      this.org_apache_royale_display_Graphics_svg.appendChild(this.org_apache_royale_display_Graphics__currentStrokePath);
      if (fromPaint) {
        this.org_apache_royale_display_Graphics__strokePathData = this.org_apache_royale_display_Graphics__currentStrokePath.getAttributeNodeNS(null, 'd');
        return this.org_apache_royale_display_Graphics__currentStrokePath;
      }
    }
  }
  this.org_apache_royale_display_Graphics__currentStrokePath = org.apache.royale.display.js.createGraphicsSVG('path');
  this.org_apache_royale_display_Graphics__strokeMove = true;
  this.org_apache_royale_display_Graphics__currentStrokePath.setAttributeNS(null, 'd', 'M' + this.org_apache_royale_display_Graphics__lastPoint);
  this.org_apache_royale_display_Graphics__currentStrokePath.setAttributeNS(null, 'fill', 'none');
  this.org_apache_royale_display_Graphics__strokePathData = this.org_apache_royale_display_Graphics__currentStrokePath.getAttributeNodeNS(null, 'd');
  this.org_apache_royale_display_Graphics_svg.appendChild(this.org_apache_royale_display_Graphics__currentStrokePath);
  this.org_apache_royale_display_Graphics__lastPoint = null;
  return this.org_apache_royale_display_Graphics__currentStrokePath;
};


/**
 * @private
 * @const
 * @type {org.apache.royale.display.GraphicsSolidFill}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_STROKE_SOLID_FILL;


/**
 * @private
 * @const
 * @type {org.apache.royale.display.GraphicsGradientFill}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_STROKE_GRADIENT_FILL;


/**
 * @private
 * @const
 * @type {org.apache.royale.display.GraphicsBitmapFill}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_STROKE_BITMAP_FILL;


/**
 * @private
 * @const
 * @type {org.apache.royale.display.GraphicsSolidFill}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_SOLID_FILL;


/**
 * @private
 * @const
 * @type {org.apache.royale.display.GraphicsGradientFill}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_GRADIENT_FILL;


/**
 * @private
 * @const
 * @type {org.apache.royale.display.GraphicsBitmapFill}
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_BITMAP_FILL;


/**
 *
 * @royaleignorecoercion SVGPatternElement
 * @royaleignorecoercion SVGUseElement
 * @param {org.apache.royale.display.BitmapData} bitmapData
 * @param {boolean} smooth
 * @return {SVGPatternElement}
 */
org.apache.royale.display.Graphics.prototype.makeBitmapPaint = function(bitmapData, smooth) {
  var /** @type {SVGPatternElement} */ patternElement = org.apache.royale.display.js.createGraphicsSVG('pattern', false);
  patternElement.setAttributeNS(null, 'patternUnits', 'userSpaceOnUse');
  var /** @type {SVGUseElement} */ imageUse = org.apache.royale.display.js.createGraphicsSVG('use', false);
  var /** @type {string} */ id = bitmapData.getID();
  if (!this.org_apache_royale_display_Graphics_defs.hasAttribute('xmlns:xlink')) {
    this.org_apache_royale_display_Graphics_defs.setAttribute('xmlns:xlink', 'http://www.w3.org/1999/xlink');
  }
  imageUse.setAttributeNS("http://www.w3.org/1999/xlink", "href", '#impl-' + id);
  if (!smooth) {
    imageUse.setAttributeNS(null, 'style', 'image-rendering: optimizeSpeed; image-rendering: pixelated;');
  }
  patternElement.appendChild(imageUse);
  this.org_apache_royale_display_Graphics_defs.appendChild(patternElement);
  patternElement.setAttribute('id', 'royale-bitmapfill-' + org.apache.royale.display.Graphics._instIdx + '-' + this.org_apache_royale_display_Graphics_defsIdx);
  this.org_apache_royale_display_Graphics_defsIdx++;
  return patternElement;
};


/**
 *
 * @royaleignorecoercion SVGGradientElement
 * @param {string} elementType
 * @return {SVGGradientElement}
 */
org.apache.royale.display.Graphics.prototype.makeGradient = function(elementType) {
  var /** @type {SVGGradientElement} */ gradientElement = org.apache.royale.display.js.createGraphicsSVG(elementType, false);
  gradientElement.setAttributeNS(null, 'gradientUnits', 'userSpaceOnUse');
  this.org_apache_royale_display_Graphics_defs.appendChild(gradientElement);
  gradientElement.setAttribute('id', 'royale-gradient-' + org.apache.royale.display.Graphics._instIdx + '-' + this.org_apache_royale_display_Graphics_defsIdx);
  this.org_apache_royale_display_Graphics_defsIdx++;
  return gradientElement;
};


/**
 * @royaleignorecoercion SVGStopElement
 * @return {SVGStopElement}
 */
org.apache.royale.display.Graphics.prototype.makeGradientStop = function() {
  var /** @type {SVGStopElement} */ stopElement = org.apache.royale.display.js.createGraphicsSVG('stop', false);
  return stopElement;
};


/**
 * @private
 * @type {SVGFilterElement}
 */
org.apache.royale.display.Graphics._linearRGBfilter;


/**
 * This is used to allow emulation of 'linearRGB' interpolationMethod in gradients
 * @royaleignorecoercion SVGFilterElement
 * @royaleignorecoercion SVGElement
 * @return {string}
 */
org.apache.royale.display.Graphics.prototype.getLinearRGBfilter = function() {
  var self = this;
  var /** @type {string} */ id = 'royale-linearRGB-filter';
  if (org.apache.royale.display.Graphics._linearRGBfilter) {
    return 'url(#' + id + ')';
  }
  var /** @type {SVGFilterElement} */ filter = org.apache.royale.display.js.createGraphicsSVG('filter', false);
  filter.setAttribute('id', id);
  filter.setAttributeNS(null, 'filterUnits', 'objectBoundingBox');
  var /** @type {Array} */ arr = ['R', 'G', 'B', 'A'];
  arr = arr.map(function(col) {
    return '<feFunc' + col + ' type="gamma" amplitude="1" exponent="0.454545454545" offset="0"/>';
  });
  filter.innerHTML = '<feComponentTransfer color-interpolation-filters="sRGB">' + arr.join('') + '</feComponentTransfer>';
  org.apache.royale.display.Graphics._linearRGBfilter = filter;
  org.apache.royale.display.js.JSRuntimeGraphicsStore.getInstance().addGraphicsImpl(filter);
  return 'url(#' + id + ')';
};


/**
 * @param {number} color
 * @param {number=} alpha
 */
org.apache.royale.display.Graphics.prototype.beginFill = function(color, alpha) {
  alpha = typeof alpha !== 'undefined' ? alpha : 1.0;
  
  if (this.org_apache_royale_display_Graphics__currentPath)
    this.org_apache_royale_display_Graphics_endCurrentPath();
  this.org_apache_royale_display_Graphics_SOLID_FILL.color = color;
  this.org_apache_royale_display_Graphics_SOLID_FILL.alpha = alpha;
  this.org_apache_royale_display_Graphics_currentFill = this.org_apache_royale_display_Graphics_SOLID_FILL;
};


/**
 */
org.apache.royale.display.Graphics.prototype.endFill = function() {
  
  this.org_apache_royale_display_Graphics_endCurrentPath();
};


/**
 * @param {string} type
 * @param {Array} colors
 * @param {Array} alphas
 * @param {Array} ratios
 * @param {org.apache.royale.geom.Matrix=} matrix
 * @param {string=} spreadMethod
 * @param {string=} interpolationMethod
 * @param {number=} focalPointRatio
 */
org.apache.royale.display.Graphics.prototype.beginGradientFill = function(type, colors, alphas, ratios, matrix, spreadMethod, interpolationMethod, focalPointRatio) {
  matrix = typeof matrix !== 'undefined' ? matrix : null;
  spreadMethod = typeof spreadMethod !== 'undefined' ? spreadMethod : 'pad';
  interpolationMethod = typeof interpolationMethod !== 'undefined' ? interpolationMethod : 'rgb';
  focalPointRatio = typeof focalPointRatio !== 'undefined' ? focalPointRatio : 0;
  
  if (this.org_apache_royale_display_Graphics__currentPath)
    this.org_apache_royale_display_Graphics_endCurrentPath();
  if (colors == null || !colors.length) {
    this.org_apache_royale_display_Graphics_currentFill = null;
    return;
  }
  if (type !== 'linear' && type !== 'radial')
    throw new Error('Error #2008: Parameter type must be one of the accepted values.');
  var /** @type {org.apache.royale.display.GraphicsGradientFill} */ gradientFill = this.org_apache_royale_display_Graphics_GRADIENT_FILL;
  gradientFill.type = type;
  gradientFill.colors = colors ? colors.slice() : null;
  gradientFill.alphas = alphas ? alphas.slice() : null;
  gradientFill.ratios = ratios ? ratios.slice() : null;
  gradientFill.matrix = matrix ? matrix.clone() : null;
  gradientFill.spreadMethod = spreadMethod;
  gradientFill.interpolationMethod = interpolationMethod;
  gradientFill.focalPointRatio = focalPointRatio;
  this.org_apache_royale_display_Graphics_currentFill = gradientFill;
};


/**
 * @param {org.apache.royale.display.BitmapData} bitmap
 * @param {org.apache.royale.geom.Matrix=} matrix
 * @param {boolean=} repeat
 * @param {boolean=} smooth
 */
org.apache.royale.display.Graphics.prototype.beginBitmapFill = function(bitmap, matrix, repeat, smooth) {
  matrix = typeof matrix !== 'undefined' ? matrix : null;
  repeat = typeof repeat !== 'undefined' ? repeat : true;
  smooth = typeof smooth !== 'undefined' ? smooth : false;
  
  if (this.org_apache_royale_display_Graphics__currentPath)
    this.org_apache_royale_display_Graphics_endCurrentPath();
  if (bitmap == null) {
    throw new TypeError('Error #2007: Parameter bitmap must be non-null.');
  }
  var /** @type {org.apache.royale.display.GraphicsBitmapFill} */ bitmapFill = this.org_apache_royale_display_Graphics_BITMAP_FILL;
  bitmapFill.bitmapData = bitmap;
  bitmapFill.matrix = matrix ? matrix.clone() : null;
  bitmapFill.repeat = repeat;
  bitmapFill.smooth = smooth;
  this.org_apache_royale_display_Graphics_currentFill = bitmapFill;
};


/**
 * @param {org.apache.royale.display.BitmapData} bitmap
 * @param {org.apache.royale.geom.Matrix=} matrix
 * @param {boolean=} repeat
 * @param {boolean=} smooth
 */
org.apache.royale.display.Graphics.prototype.lineBitmapStyle = function(bitmap, matrix, repeat, smooth) {
  matrix = typeof matrix !== 'undefined' ? matrix : null;
  repeat = typeof repeat !== 'undefined' ? repeat : true;
  smooth = typeof smooth !== 'undefined' ? smooth : false;
  
  if (bitmap == null) {
    throw new TypeError('Error #2007: Parameter bitmap must be non-null.');
  }
  var /** @type {org.apache.royale.display.GraphicsBitmapFill} */ bitmapFill = this.org_apache_royale_display_Graphics_STROKE_BITMAP_FILL;
  bitmapFill.bitmapData = bitmap;
  bitmapFill.matrix = matrix ? matrix.clone() : null;
  bitmapFill.repeat = repeat;
  bitmapFill.smooth = smooth;
  this.org_apache_royale_display_Graphics_currentStroke.fill = bitmapFill;
  if (this.org_apache_royale_display_Graphics__currentStrokePath) {
    this.org_apache_royale_display_Graphics_currentStroke.apply(this, this.org_apache_royale_display_Graphics__currentStrokePath);
  }
};


/**
 * @param {string} type
 * @param {Array} colors
 * @param {Array} alphas
 * @param {Array} ratios
 * @param {org.apache.royale.geom.Matrix=} matrix
 * @param {string=} spreadMethod
 * @param {string=} interpolationMethod
 * @param {number=} focalPointRatio
 */
org.apache.royale.display.Graphics.prototype.lineGradientStyle = function(type, colors, alphas, ratios, matrix, spreadMethod, interpolationMethod, focalPointRatio) {
  matrix = typeof matrix !== 'undefined' ? matrix : null;
  spreadMethod = typeof spreadMethod !== 'undefined' ? spreadMethod : "pad";
  interpolationMethod = typeof interpolationMethod !== 'undefined' ? interpolationMethod : "rgb";
  focalPointRatio = typeof focalPointRatio !== 'undefined' ? focalPointRatio : 0;
  
  if (colors == null || !colors.length) {
    this.org_apache_royale_display_Graphics_currentStroke.thickness = NaN;
    return;
  }
  if (type !== 'linear' && type !== 'radial')
    throw new Error('Error #2008: Parameter type must be one of the accepted values.');
  var /** @type {org.apache.royale.display.GraphicsGradientFill} */ gradientFill = this.org_apache_royale_display_Graphics_STROKE_GRADIENT_FILL;
  gradientFill.type = type;
  gradientFill.colors = colors ? colors.slice() : null;
  gradientFill.alphas = alphas ? alphas.slice() : null;
  gradientFill.ratios = ratios ? ratios.slice() : null;
  gradientFill.matrix = matrix ? matrix.clone() : null;
  gradientFill.spreadMethod = spreadMethod;
  gradientFill.interpolationMethod = interpolationMethod;
  gradientFill.focalPointRatio = focalPointRatio;
  this.org_apache_royale_display_Graphics_currentStroke.fill = gradientFill;
  if (this.org_apache_royale_display_Graphics__currentStrokePath) {
    this.org_apache_royale_display_Graphics_currentStroke.apply(this, this.org_apache_royale_display_Graphics__currentStrokePath);
  }
};


/**
 * @param {number=} thickness
 * @param {number=} color
 * @param {number=} alpha
 * @param {boolean=} pixelHinting
 * @param {string=} scaleMode
 * @param {string=} caps
 * @param {string=} joints
 * @param {number=} miterLimit
 */
org.apache.royale.display.Graphics.prototype.lineStyle = function(thickness, color, alpha, pixelHinting, scaleMode, caps, joints, miterLimit) {
  thickness = typeof thickness !== 'undefined' ? thickness : NaN;
  color = typeof color !== 'undefined' ? color : 0;
  alpha = typeof alpha !== 'undefined' ? alpha : 1.0;
  pixelHinting = typeof pixelHinting !== 'undefined' ? pixelHinting : false;
  scaleMode = typeof scaleMode !== 'undefined' ? scaleMode : 'normal';
  caps = typeof caps !== 'undefined' ? caps : null;
  joints = typeof joints !== 'undefined' ? joints : null;
  miterLimit = typeof miterLimit !== 'undefined' ? miterLimit : 3;
  
  var /** @type {boolean} */ checkForSpawn = !!(this.org_apache_royale_display_Graphics__currentPath);
  var /** @type {org.apache.royale.display.GraphicsStroke} */ strokeBase = this.org_apache_royale_display_Graphics_currentStroke;
  caps = caps ? caps : org.apache.royale.display.CapsStyle.ROUND;
  joints = joints ? joints : org.apache.royale.display.JointStyle.ROUND;
  if (checkForSpawn && this.org_apache_royale_display_Graphics__lastPoint) {
    if (strokeBase.thickness !== thickness || strokeBase.fill !== this.org_apache_royale_display_Graphics_STROKE_SOLID_FILL || color !== this.org_apache_royale_display_Graphics_STROKE_SOLID_FILL.color || alpha !== this.org_apache_royale_display_Graphics_STROKE_SOLID_FILL.alpha || strokeBase.scaleMode !== scaleMode || strokeBase.caps !== caps || strokeBase.joints !== joints || strokeBase.miterLimit !== miterLimit) {
      this.spawnStroke(false);
    }
  }
  this.org_apache_royale_display_Graphics_STROKE_SOLID_FILL.color = color;
  this.org_apache_royale_display_Graphics_STROKE_SOLID_FILL.alpha = alpha;
  strokeBase.thickness = thickness;
  strokeBase.fill = this.org_apache_royale_display_Graphics_STROKE_SOLID_FILL;
  strokeBase.pixelHinting = pixelHinting;
  strokeBase.scaleMode = scaleMode;
  strokeBase.caps = caps ? caps : org.apache.royale.display.CapsStyle.ROUND;
  strokeBase.joints = joints;
  strokeBase.miterLimit = miterLimit;
  if (this.org_apache_royale_display_Graphics__currentStrokePath) {
    strokeBase.apply(this, this.org_apache_royale_display_Graphics__currentStrokePath);
  }
};


/**
 * @private
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics_endCurrentPath = function() {
  if (!isNaN(this.org_apache_royale_display_Graphics_currentStroke.thickness)) {
    if (this.org_apache_royale_display_Graphics__pathData && this.org_apache_royale_display_Graphics__pathData.value) {
      var /** @type {string} */ lastChar = this.org_apache_royale_display_Graphics__pathData.value.substr(this.org_apache_royale_display_Graphics__pathData.value.length - 1);
      if (lastChar.toUpperCase() != 'Z') {
        this.org_apache_royale_display_Graphics__pathData.value += 'Z';
      }
      if (this.org_apache_royale_display_Graphics__currentStrokePath !== this.org_apache_royale_display_Graphics__currentPath) {
        this.org_apache_royale_display_Graphics__strokePathData.value += 'L' + this.org_apache_royale_display_Graphics__lastStartPoint;
      }
    }
  }
  this.org_apache_royale_display_Graphics__currentPath = null;
  this.org_apache_royale_display_Graphics__currentStrokePath = null;
  this.org_apache_royale_display_Graphics__pathData = null;
  this.org_apache_royale_display_Graphics__strokePathData = null;
  this.org_apache_royale_display_Graphics__lastStartPoint = null;
  this.org_apache_royale_display_Graphics__lastPoint = null;
  this.org_apache_royale_display_Graphics_currentFill = null;
};


/**
 * @param {number} x
 * @param {number} y
 */
org.apache.royale.display.Graphics.prototype.moveTo = function(x, y) {
  
  var /** @type {string} */ lp = x + ' ' + y;
  this.org_apache_royale_display_Graphics__lastStartPoint = lp;
  this.org_apache_royale_display_Graphics__moveTo = 'M' + lp;
};


/**
 * @param {number} x
 * @param {number} y
 */
org.apache.royale.display.Graphics.prototype.lineTo = function(x, y) {
  
  var /** @type {string} */ lp = x + ' ' + y;
  if (!this.org_apache_royale_display_Graphics__lastStartPoint)
    this.org_apache_royale_display_Graphics__lastStartPoint = '0 0';
  this.org_apache_royale_display_Graphics_appendPathData('L' + lp, lp);
};


/**
 * @param {number} controlX
 * @param {number} controlY
 * @param {number} anchorX
 * @param {number} anchorY
 */
org.apache.royale.display.Graphics.prototype.curveTo = function(controlX, controlY, anchorX, anchorY) {
  
  var /** @type {string} */ lp = anchorX + ' ' + anchorY;
  if (!this.org_apache_royale_display_Graphics__lastStartPoint)
    this.org_apache_royale_display_Graphics__lastStartPoint = '0 0';
  this.org_apache_royale_display_Graphics_appendPathData('Q' + controlX + ' ' + controlY + ' ' + lp, lp);
};


/**
 * @param {number} controlX1
 * @param {number} controlY1
 * @param {number} controlX2
 * @param {number} controlY2
 * @param {number} anchorX
 * @param {number} anchorY
 */
org.apache.royale.display.Graphics.prototype.cubicCurveTo = function(controlX1, controlY1, controlX2, controlY2, anchorX, anchorY) {
  
  var /** @type {string} */ lp = anchorX + ' ' + anchorY;
  if (!this.org_apache_royale_display_Graphics__lastStartPoint)
    this.org_apache_royale_display_Graphics__lastStartPoint = '0 0';
  this.org_apache_royale_display_Graphics_appendPathData('C' + controlX1 + ' ' + controlY1 + ' ' + controlX2 + ' ' + controlY2 + ' ' + lp, lp);
};


/**
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 */
org.apache.royale.display.Graphics.prototype.drawEllipse = function(x, y, width, height) {
  
  if (isNaN(width) || isNaN(height)) {
    throw new Error('Error #2004: One of the parameters is invalid.');
  }
  if (isNaN(y))
    y = 0;
  if (isNaN(x))
    x = 0;
  var /** @type {string} */ d;
  var /** @type {number} */ rx = width / 2;
  var /** @type {number} */ ry = height / 2;
  var /** @type {string} */ centerY = ' ' + (y + ry);
  var /** @type {string} */ startPoint = (x + width) + centerY;
  if (rx == 0 || ry == 0) {
    if (rx == 0) {
      d = 'M' + x + ' ' + (y + height);
    } else {
      d = 'M' + startPoint;
    }
    if (rx || ry) {
      if (rx)
        d += 'L' + x + centerY + 'Z'; else {
        d += 'L' + x + ' ' + y + 'Z';
      }
    }
  } else {
    var /** @type {string} */ arcTo = 'A' + rx + ' ' + ry + ' 0 0 0 ';
    d = 'M' + startPoint + arcTo + x + centerY + arcTo + startPoint;
  }
  this.org_apache_royale_display_Graphics__lastStartPoint = null;
  this.org_apache_royale_display_Graphics_appendPathData(d, startPoint);
};


/**
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {number} ellipseWidth
 * @param {number=} ellipseHeight
 */
org.apache.royale.display.Graphics.prototype.drawRoundRect = function(x, y, width, height, ellipseWidth, ellipseHeight) {
  ellipseHeight = typeof ellipseHeight !== 'undefined' ? ellipseHeight : NaN;
  
  if (isNaN(width) || isNaN(height) || isNaN(ellipseWidth)) {
    throw new Error('Error #2004: One of the parameters is invalid.');
  }
  if (isNaN(y))
    y = 0;
  if (isNaN(x))
    x = 0;
  var /** @type {number} */ rX = Math.min(ellipseWidth / 2, width / 2);
  if (isNaN(ellipseHeight)) {
    ellipseHeight = ellipseWidth;
  }
  var /** @type {number} */ rY = Math.min(ellipseHeight / 2, height / 2);
  if (rX == 0 || rY == 0) {
    this.org_apache_royale_display_Graphics__drawRect(x, y, width, height);
    return;
  }
  var /** @type {number} */ xw = x + width;
  var /** @type {number} */ yh = y + height;
  var /** @type {string} */ sweep = rX * rY < 0 ? '0 ' : '1 ';
  var /** @type {string} */ arcBase = 'A' + rX + ' ' + rY + ' 0 0 ' + sweep;
  var /** @type {string} */ startPoint = xw + ' ' + (yh - rY);
  var /** @type {string} */ d = 'M' + startPoint + arcBase + (xw - rX) + ' ' + yh + 'L' + (x + rX) + ' ' + yh + arcBase + x + ' ' + (yh - rY) + 'L' + x + ' ' + (y + rY) + arcBase + (x + rX) + ' ' + y + 'L' + (xw - rX) + ' ' + y + arcBase + xw + ' ' + (y + rY) + 'Z';
  this.org_apache_royale_display_Graphics__lastStartPoint = null;
  this.org_apache_royale_display_Graphics_appendPathData(d, startPoint);
};


/**
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 * @param {number} topLeftRadius
 * @param {number} topRightRadius
 * @param {number} bottomLeftRadius
 * @param {number} bottomRightRadius
 */
org.apache.royale.display.Graphics.prototype.drawRoundRectComplex = function(x, y, width, height, topLeftRadius, topRightRadius, bottomLeftRadius, bottomRightRadius) {
  
  if (isNaN(width) || isNaN(height) || isNaN(topLeftRadius) || isNaN(topRightRadius) || isNaN(bottomLeftRadius) || isNaN(bottomRightRadius)) {
    throw new Error('Error #2004: One of the parameters is invalid.');
  }
  if (isNaN(y))
    y = 0;
  if (isNaN(x))
    x = 0;
  var /** @type {string} */ d;
  var /** @type {boolean} */ rectOnly = (height > 0 && width > 0) && (topLeftRadius == 0 && topRightRadius == 0 && bottomLeftRadius == 0 && bottomRightRadius == 0);
  if (!rectOnly) {
    rectOnly = (width == 0 || height == 0) && (topLeftRadius >= 0 && topRightRadius >= 0 && bottomLeftRadius >= 0 && bottomRightRadius >= 0);
  }
  if (rectOnly) {
    this.org_apache_royale_display_Graphics__drawRect(x, y, width, height);
    return;
  }
  var /** @type {number} */ xw = x + width;
  var /** @type {number} */ yh = y + height;
  var /** @type {number} */ maxSize = width < height ? width / 2 : height / 2;
  if (topRightRadius + bottomRightRadius > height) {
    topRightRadius = bottomRightRadius = maxSize;
  }
  if (height < width) {
    if (topLeftRadius + bottomLeftRadius > height)
      topLeftRadius = bottomLeftRadius = maxSize;
    if (topRightRadius + bottomRightRadius > height)
      topRightRadius = bottomRightRadius = maxSize;
  } else {
    if (topLeftRadius + topRightRadius > width)
      topLeftRadius = topRightRadius = maxSize;
    if (bottomLeftRadius + bottomRightRadius > width)
      bottomLeftRadius = bottomRightRadius = maxSize;
  }
  var /** @type {string} */ startPoint = xw + ' ' + (yh - bottomRightRadius);
  if (bottomRightRadius) {
    d = 'M' + startPoint + 'A' + bottomRightRadius + ' ' + bottomRightRadius + ' 0 0 1 ' + (xw - bottomRightRadius) + ' ' + yh;
  } else {
    d = 'M' + startPoint;
  }
  if (bottomLeftRadius) {
    d += 'L' + (x + bottomLeftRadius) + ' ' + yh + 'A' + bottomLeftRadius + ' ' + bottomLeftRadius + ' 0 0 1 ' + x + ' ' + (yh - bottomLeftRadius);
  } else {
    d += 'L' + x + ' ' + yh;
  }
  if (topLeftRadius) {
    d += 'L' + x + ' ' + (y + topLeftRadius) + 'A' + topLeftRadius + ' ' + topLeftRadius + ' 0 0 1 ' + (x + topLeftRadius) + ' ' + y;
  } else {
    d += 'L' + x + ' ' + y;
  }
  if (topRightRadius) {
    d += 'L' + (xw - topRightRadius) + ' ' + y + 'A' + topRightRadius + ' ' + topRightRadius + ' 0 0 1 ' + xw + ' ' + (y + topRightRadius) + 'Z';
  } else {
    d += 'L' + xw + ' ' + y + 'Z';
  }
  this.org_apache_royale_display_Graphics_appendPathData(d, startPoint);
};


/**
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 */
org.apache.royale.display.Graphics.prototype.drawRect = function(x, y, width, height) {
  
  if (isNaN(width) || isNaN(height)) {
    throw new Error('Error #2004: One of the parameters is invalid.');
  }
  if (isNaN(x))
    x = 0;
  if (isNaN(y))
    y = 0;
  var /** @type {boolean} */ w = !!width;
  var /** @type {boolean} */ h = !!height;
  var /** @type {string} */ startPoint = x + ' ' + y;
  var /** @type {string} */ d = 'M' + startPoint;
  if (w)
    d += 'h' + width;
  if (h)
    d += 'v' + height;
  if (w)
    d += 'h' + -width;
  if (w || h)
    d += 'Z';
  this.org_apache_royale_display_Graphics__lastStartPoint = null;
  this.org_apache_royale_display_Graphics_appendPathData(d, startPoint);
};


/**
 * @private
 * @param {number} x
 * @param {number} y
 * @param {number} width
 * @param {number} height
 */
org.apache.royale.display.Graphics.prototype.org_apache_royale_display_Graphics__drawRect = function(x, y, width, height) {
  if (isNaN(width) || isNaN(height)) {
    throw new Error('Error #2004: One of the parameters is invalid.');
  }
  if (isNaN(x))
    x = 0;
  if (isNaN(y))
    y = 0;
  var /** @type {boolean} */ w = !!width;
  var /** @type {boolean} */ h = !!height;
  var /** @type {string} */ startPoint = (x + width) + ' ' + (y + height);
  var /** @type {string} */ d = 'M' + startPoint;
  if (w)
    d += 'h' + -width;
  if (h)
    d += 'v' + -height;
  if (w)
    d += 'h' + width;
  if (w || h)
    d += 'Z';
  this.org_apache_royale_display_Graphics_appendPathData(d, startPoint);
};


/**
 * @param {number} x
 * @param {number} y
 * @param {number} radius
 */
org.apache.royale.display.Graphics.prototype.drawCircle = function(x, y, radius) {
  
  if (isNaN(radius)) {
    throw new Error('Error #2004: One of the parameters is invalid.');
  }
  if (isNaN(x))
    x = radius;
  if (isNaN(y))
    y = radius;
  var /** @type {string} */ startPoint;
  var /** @type {string} */ d;
  if (radius) {
    var /** @type {string} */ arcBase = 'A' + radius + ' ' + radius + ' 0 0 0 ';
    var /** @type {string} */ yS = ' ' + y;
    startPoint = (x + radius) + yS;
    d = 'M' + startPoint + arcBase + (x - radius) + yS + arcBase + startPoint;
  } else {
    startPoint = x + ' ' + y;
    d = 'M' + startPoint;
  }
  this.org_apache_royale_display_Graphics__lastStartPoint = null;
  this.org_apache_royale_display_Graphics_appendPathData(d, startPoint);
};


org.apache.royale.display.Graphics.prototype.get__org_apache_royale_display_Graphics_svg = function() {
  return this.org_apache_royale_display_Graphics_graphicsTarget.graphicsRenderTarget;
};


org.apache.royale.display.Graphics.prototype.get__org_apache_royale_display_Graphics_defs = function() {
  if (!this.org_apache_royale_display_Graphics__defs) {
    this.org_apache_royale_display_Graphics__defs = org.apache.royale.display.js.createGraphicsSVG('defs', false);
    var /** @type {SVGElement} */ svgNode = this.org_apache_royale_display_Graphics_svg;
    if (svgNode.childNodes.length) {
      svgNode.insertBefore(this.org_apache_royale_display_Graphics__defs, svgNode.childNodes[0]);
    }
    else
      svgNode.appendChild(this.org_apache_royale_display_Graphics__defs);
  }
  return this.org_apache_royale_display_Graphics__defs;
};


Object.defineProperties(org.apache.royale.display.Graphics.prototype, /** @lends {org.apache.royale.display.Graphics.prototype} */ {
/**
  * @type {SVGElement} */
org_apache_royale_display_Graphics_svg: {
get: org.apache.royale.display.Graphics.prototype.get__org_apache_royale_display_Graphics_svg},
/**
  * @type {SVGDefsElement} */
org_apache_royale_display_Graphics_defs: {
get: org.apache.royale.display.Graphics.prototype.get__org_apache_royale_display_Graphics_defs}}
);


/**
 * @export
 * @param {SVGPathElement} element
 */
org.apache.royale.display.Graphics.setNoFill = function(element) {
  element.setAttributeNS(null, 'fill', 'none');
}