/**
 * Generated by Apache Royale Compiler from org/apache/royale/display/BitmapData.as
 * org.apache.royale.display.BitmapData
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.display.BitmapData');

goog.require('org.apache.royale.display.JPEGEncoderOptions');
goog.require('org.apache.royale.display.PNGEncoderOptions');
goog.require('org.apache.royale.display.js.JSRuntimeGraphicsStore');
goog.require('org.apache.royale.display.js.nonNullParamError');
goog.require('org.apache.royale.geom.Rectangle');
goog.require('org.apache.royale.utils.BinaryData');
goog.require('org.apache.royale.utils.Language');



/**
 *
 * @asparam width
 * @asparam height
 * @asparam transparent
 * @asparam fillColor
 *
 * @royaleignorecoercion HTMLCanvasElement
 * @royaleignorecoercion CanvasRenderingContext2D
 * @constructor
 * @param {number} width
 * @param {number} height
 * @param {boolean=} transparent
 * @param {number=} fillColor
 */
org.apache.royale.display.BitmapData = function(width, height, transparent, fillColor) {
  transparent = typeof transparent !== 'undefined' ? transparent : true;
  fillColor = typeof fillColor !== 'undefined' ? fillColor : 0xffffffff;
  if ((width < 0 || width > 8191) || (height < 0 || height > 8191) || (width * height > 16777215))
    throw new Error('width and/or height exceed the maximum dimensions');
  this.org_apache_royale_display_BitmapData__transparent = transparent;
  if (width && height) {
    this.org_apache_royale_display_BitmapData__canvas = document.createElement('canvas');
    this.org_apache_royale_display_BitmapData__canvas.width = this.org_apache_royale_display_BitmapData__width = width;
    this.org_apache_royale_display_BitmapData__canvas.height = this.org_apache_royale_display_BitmapData__height = height;
    this.org_apache_royale_display_BitmapData__id = 'royale-bitmapdata-' + org.apache.royale.display.BitmapData._instIdx++;
    this.org_apache_royale_display_BitmapData__canvas.setAttributeNS(null, 'id', this.org_apache_royale_display_BitmapData__id);
    this.org_apache_royale_display_BitmapData__ctx = this.org_apache_royale_display_BitmapData__canvas.getContext('2d');
    if (fillColor || !transparent) {
      this.org_apache_royale_display_BitmapData__ctx.fillStyle = this.org_apache_royale_display_BitmapData_convertColorValToStyle(fillColor);
      this.org_apache_royale_display_BitmapData__ctx.fillRect(0, 0, width, height);
    }
    this.org_apache_royale_display_BitmapData__svgTarget = org.apache.royale.display.js.JSRuntimeGraphicsStore.getInstance().addBitmapDataImpl(this.org_apache_royale_display_BitmapData__canvas);
    requestAnimationFrame(org.apache.royale.utils.Language.closure(this.org_apache_royale_display_BitmapData_onRenderUpdate, this, 'org_apache_royale_display_BitmapData_onRenderUpdate'));
  }
  else
    throw new Error('ArgumentError: Error #2015: Invalid BitmapData.');
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.display.BitmapData', org.apache.royale.display.BitmapData);


/**
 * @private
 * @type {HTMLCanvasElement}
 */
org.apache.royale.display.BitmapData.prototype.org_apache_royale_display_BitmapData__canvas;


/**
 * @private
 * @type {CanvasRenderingContext2D}
 */
org.apache.royale.display.BitmapData.prototype.org_apache_royale_display_BitmapData__ctx;


/**
 * @private
 * @type {ImageData}
 */
org.apache.royale.display.BitmapData.prototype.org_apache_royale_display_BitmapData__lockedData;


/**
 * @private
 * @type {number}
 */
org.apache.royale.display.BitmapData._instIdx = 0;


/**
 * @private
 * @type {string}
 */
org.apache.royale.display.BitmapData.prototype.org_apache_royale_display_BitmapData__id;


/**
 * @export
 * @return {string}
 */
org.apache.royale.display.BitmapData.prototype.getID = function() {
  return this.org_apache_royale_display_BitmapData__id;
};


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.display.BitmapData.prototype.org_apache_royale_display_BitmapData__dirty = true;


/**
 * @private
 * @type {SVGImageElement}
 */
org.apache.royale.display.BitmapData.prototype.org_apache_royale_display_BitmapData__svgTarget;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.display.BitmapData._checked;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.display.BitmapData._safariDT;


/**
 *
 * @royaleignorecoercion SVGElement
 * @private
 * @param {number} timeStamp
 */
org.apache.royale.display.BitmapData.prototype.org_apache_royale_display_BitmapData_onRenderUpdate = function(timeStamp) {
  if (this.org_apache_royale_display_BitmapData__canvas && this.org_apache_royale_display_BitmapData__svgTarget) {
    var /** @type {string} */ img_dataurl = this.org_apache_royale_display_BitmapData__canvas.toDataURL("image/png");
    this.org_apache_royale_display_BitmapData__svgTarget.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", img_dataurl);
    if (this.org_apache_royale_display_BitmapData_isSafariDesktop) {
      var /** @type {SVGElement} */ parentNode = this.org_apache_royale_display_BitmapData__svgTarget.parentNode;
      parentNode.appendChild(parentNode.removeChild(this.org_apache_royale_display_BitmapData__svgTarget));
    }
  }
  this.org_apache_royale_display_BitmapData__dirty = false;
};


/**
 * @private
 * @param {number} val
 * @return {string}
 */
org.apache.royale.display.BitmapData.prototype.org_apache_royale_display_BitmapData_convertColorValToStyle = function(val) {
  if (this.org_apache_royale_display_BitmapData__transparent) {
    if (val < 0x01000000)
      return 'rgba(0,0,0,0)';
    else
      return 'rgba(' + ((val & 0xff0000) >> 16) + ',' + ((val & 0xff00) >> 8) + ',' + (val & 0xff) + ',' + (((val & 0xff000000) >>> 24) / 255) + ')';
  } else {
    val = (val & 0xffffff) >>> 0;
    return 'rgb(' + ((val & 0xff0000) >> 16) + ',' + ((val & 0xff00) >> 8) + ',' + (val & 0xff) + ')';
  }
};


/**
 * @private
 * @type {number}
 */
org.apache.royale.display.BitmapData.prototype.org_apache_royale_display_BitmapData__width = 0;


/**
 * @private
 * @type {number}
 */
org.apache.royale.display.BitmapData.prototype.org_apache_royale_display_BitmapData__height = 0;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.display.BitmapData.prototype.org_apache_royale_display_BitmapData__transparent;


/**
 * Compresses this BitmapData object using the selected compressor algorithm and returns a new ByteArray object.
 * @asparam rect
 * @asparam compressor
 * @asparam byteArray
 * @asreturn
 * @export
 * @param {org.apache.royale.geom.Rectangle} rect
 * @param {Object} compressor
 * @param {org.apache.royale.utils.BinaryData=} byteArray
 * @return {org.apache.royale.utils.BinaryData}
 */
org.apache.royale.display.BitmapData.prototype.encode = function(rect, compressor, byteArray) {
  byteArray = typeof byteArray !== 'undefined' ? byteArray : null;
  if (!this.org_apache_royale_display_BitmapData__canvas)
    throw new Error('ArgumentError: Error #2015: Invalid BitmapData');
  if (!rect)
    throw new TypeError(org.apache.royale.display.js.nonNullParamError('rect'));
  if (!compressor)
    throw new TypeError(org.apache.royale.display.js.nonNullParamError('compressor'));
  var /** @type {boolean} */ wasLocked = !!(this.org_apache_royale_display_BitmapData__lockedData);
  if (wasLocked)
    this.unlock();
  var /** @type {string} */ dataString;
  switch (compressor.constructor) {
    case org.apache.royale.display.JPEGEncoderOptions:
      var /** @type {number} */ q = org.apache.royale.utils.Language.as(compressor, org.apache.royale.display.JPEGEncoderOptions, true).quality;
      if (q > 100)
        throw new RangeError('Error #2006: The supplied index is out of bounds.');
      dataString = this.org_apache_royale_display_BitmapData__canvas.toDataURL('image/jpeg', q / 100);
      break;
    case org.apache.royale.display.PNGEncoderOptions:
      dataString = this.org_apache_royale_display_BitmapData__canvas.toDataURL();
      break;
    default:
      throw new Error('ArgumentError: Error #2004: One of the parameters is invalid.');
      break;
  }
  
/**
 * @const
 * @type {string}
 */
var decodedData = org.apache.royale.utils.Language.string(window['atob'](dataString));
  
/**
 * @const
 * @type {number}
 */
var l = (decodedData.length) >>> 0;
  var /** @type {Uint8Array} */ bytes = new Uint8Array(l);
  for (var /** @type {number} */ i = 0; i < l; i++) {
    bytes[i] = decodedData.charCodeAt(i);
  }
  var /** @type {org.apache.royale.utils.BinaryData} */ output = new org.apache.royale.utils.BinaryData(bytes.buffer);
  if (byteArray) {
    byteArray.writeBinaryData(output);
  }
  if (wasLocked)
    this.lock();
  return output;
};


/**
 * Sets a single pixel of a BitmapData object.
 * @asparam x
 * @asparam y
 * @asparam color
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} color
 */
org.apache.royale.display.BitmapData.prototype.setPixel = function(x, y, color) {
  this.setPixel32(x, y, (0xff000000 | color) >>> 0);
};


/**
 * Sets the color and alpha transparency values of a single pixel of a BitmapData object.
 * @asparam x
 * @asparam y
 * @asparam color
 * @export
 * @param {number} x
 * @param {number} y
 * @param {number} color
 */
org.apache.royale.display.BitmapData.prototype.setPixel32 = function(x, y, color) {
  var /** @type {number} */ alpha = 0;
  if (!this.org_apache_royale_display_BitmapData__canvas)
    throw new Error('ArgumentError: Error #2015: Invalid BitmapData');
  var /** @type {ImageData} */ pixel;
  //var /** @type {number} */ alpha = 0;
  var /** @type {number} */ idx = 0;
  if (this.org_apache_royale_display_BitmapData__transparent) {
    if (this.org_apache_royale_display_BitmapData__lockedData) {
      idx = ((this.org_apache_royale_display_BitmapData__width * 4) * y + x * 4) >>> 0;
      pixel = this.org_apache_royale_display_BitmapData__lockedData;
    } else {
      pixel = this.org_apache_royale_display_BitmapData__ctx.getImageData(x, y, 1, 1);
    }
    alpha = (pixel.data[idx + 3]) >>> 0;
    if (alpha == 0)
      color = 0;
    else
      alpha = ((color >> 24) & 0xff) >>> 0;
  } else {
    alpha = 0xff;
    pixel = this.org_apache_royale_display_BitmapData__ctx.createImageData(1, 1);
  }
  pixel.data[idx++] = (color >> 16) & 0xff;
  pixel.data[idx++] = (color >> 8) & 0xff;
  pixel.data[idx++] = (color & 0xff);
  pixel.data[idx] = alpha;
  if (!this.org_apache_royale_display_BitmapData__lockedData) {
    this.org_apache_royale_display_BitmapData__ctx.putImageData(pixel, x, y);
    if (!this.org_apache_royale_display_BitmapData__dirty) {
      this.org_apache_royale_display_BitmapData__dirty = true;
      requestAnimationFrame(org.apache.royale.utils.Language.closure(this.org_apache_royale_display_BitmapData_onRenderUpdate, this, 'org_apache_royale_display_BitmapData_onRenderUpdate'));
    }
  }
};


/**
 * @export
 */
org.apache.royale.display.BitmapData.prototype.lock = function() {
  if (!this.org_apache_royale_display_BitmapData__canvas)
    throw new Error('ArgumentError: Error #2015: Invalid BitmapData');
  if (!this.org_apache_royale_display_BitmapData__lockedData) {
    this.org_apache_royale_display_BitmapData__lockedData = this.org_apache_royale_display_BitmapData__ctx.getImageData(0, 0, this.org_apache_royale_display_BitmapData__width, this.org_apache_royale_display_BitmapData__height);
  }
};


/**
 * @export
 */
org.apache.royale.display.BitmapData.prototype.unlock = function() {
  if (!this.org_apache_royale_display_BitmapData__canvas)
    throw new Error('ArgumentError: Error #2015: Invalid BitmapData');
  if (this.org_apache_royale_display_BitmapData__lockedData) {
    this.org_apache_royale_display_BitmapData__ctx.putImageData(this.org_apache_royale_display_BitmapData__lockedData, 0, 0);
    this.org_apache_royale_display_BitmapData__lockedData = null;
    if (!this.org_apache_royale_display_BitmapData__dirty) {
      this.org_apache_royale_display_BitmapData__dirty = true;
      requestAnimationFrame(org.apache.royale.utils.Language.closure(this.org_apache_royale_display_BitmapData_onRenderUpdate, this, 'org_apache_royale_display_BitmapData_onRenderUpdate'));
    }
  }
};


/**
 * @export
 * @param {number} x
 * @param {number} y
 * @return {number}
 */
org.apache.royale.display.BitmapData.prototype.getPixel = function(x, y) {
  return (0xffffff & this.getPixel32(x, y)) >>> 0;
};


/**
 * @export
 * @param {number} x
 * @param {number} y
 * @return {number}
 */
org.apache.royale.display.BitmapData.prototype.getPixel32 = function(x, y) {
  var /** @type {number} */ alpha = 0;
  if (!this.org_apache_royale_display_BitmapData__canvas)
    throw new Error('ArgumentError: Error #2015: Invalid BitmapData');
  var /** @type {ImageData} */ pixel;
  //var /** @type {number} */ alpha = 0;
  var /** @type {number} */ idx = 0;
  if (this.org_apache_royale_display_BitmapData__transparent) {
    if (this.org_apache_royale_display_BitmapData__lockedData) {
      idx = ((this.org_apache_royale_display_BitmapData__width * 4) * y + x * 4) >>> 0;
      pixel = this.org_apache_royale_display_BitmapData__lockedData;
    } else {
      pixel = this.org_apache_royale_display_BitmapData__ctx.getImageData(x, y, 1, 1);
    }
    alpha = (pixel.data[3]) >>> 0;
  } else {
    alpha = 0xff;
    pixel = this.org_apache_royale_display_BitmapData__ctx.getImageData(x, y, 1, 1);
  }
  return ((alpha << 24) | (pixel.data[idx++] << 16) | (pixel.data[idx++] << 8) | pixel.data[idx]) >>> 0;
};


/**
 * @export
 * @return {org.apache.royale.display.BitmapData}
 */
org.apache.royale.display.BitmapData.prototype.clone = function() {
  if (!this.org_apache_royale_display_BitmapData__canvas)
    throw new Error('ArgumentError: Error #2015: Invalid BitmapData');
  var /** @type {org.apache.royale.display.BitmapData} */ c = new org.apache.royale.display.BitmapData(this.org_apache_royale_display_BitmapData__width, this.org_apache_royale_display_BitmapData__height, true, 0);
  c.org_apache_royale_display_BitmapData__transparent = this.org_apache_royale_display_BitmapData__transparent;
  c.org_apache_royale_display_BitmapData__ctx.putImageData(this.org_apache_royale_display_BitmapData__ctx.getImageData(0, 0, this.org_apache_royale_display_BitmapData__width, this.org_apache_royale_display_BitmapData__height), 0, 0);
  return c;
};


/**
 *  Fills a rectangular area of pixels with a specified ARGB color
 * @asparam rect
 * @asparam color
 * @export
 * @param {org.apache.royale.geom.Rectangle} rect
 * @param {number} color
 */
org.apache.royale.display.BitmapData.prototype.fillRect = function(rect, color) {
  if (!rect)
    throw new TypeError('TypeError: Error #2007: Parameter rect must be non-null');
  if (!this.org_apache_royale_display_BitmapData__canvas)
    throw new Error('ArgumentError: Error #2015: Invalid BitmapData');
  if (this.org_apache_royale_display_BitmapData__lockedData) {
    var /** @type {Uint32Array} */ wideData = new Uint32Array(this.org_apache_royale_display_BitmapData__lockedData.data.buffer);
    if (!this.org_apache_royale_display_BitmapData__transparent)
      color = (0xff000000 & color) >>> 0;
    color = ((((color << 8) >>> 0) | color >>> 24) >>> 0) >>> 0;
    
/**
 * @const
 * @type {number}
 */
var yEnd = (rect.bottom) >>> 0;
    
/**
 * @const
 * @type {number}
 */
var xStart = (rect.x) >>> 0;
    
/**
 * @const
 * @type {number}
 */
var xEnd = (rect.right) >>> 0;
    for (var /** @type {number} */ y = (rect.y) >>> 0; y < yEnd; y++) {
      var /** @type {number} */ yOffset = (this.org_apache_royale_display_BitmapData__width * y) >>> 0;
      for (var /** @type {number} */ x = xStart; x < xEnd; x++) {
        var /** @type {number} */ idx = (yOffset + x) >>> 0;
        wideData[idx] = color;
      }
    }
  } else {
    this.org_apache_royale_display_BitmapData__ctx.fillStyle = this.org_apache_royale_display_BitmapData_convertColorValToStyle(color);
    this.org_apache_royale_display_BitmapData__ctx.fillRect(rect.x, rect.y, rect.width, rect.height);
    if (!this.org_apache_royale_display_BitmapData__dirty) {
      this.org_apache_royale_display_BitmapData__dirty = true;
      requestAnimationFrame(org.apache.royale.utils.Language.closure(this.org_apache_royale_display_BitmapData_onRenderUpdate, this, 'org_apache_royale_display_BitmapData_onRenderUpdate'));
    }
  }
};


/**
 * @export
 */
org.apache.royale.display.BitmapData.prototype.dispose = function() {
  if (this.org_apache_royale_display_BitmapData__canvas) {
    this.org_apache_royale_display_BitmapData__ctx = null;
    org.apache.royale.display.js.JSRuntimeGraphicsStore.getInstance().removeBitmapDataImpl(this.org_apache_royale_display_BitmapData__canvas, this.org_apache_royale_display_BitmapData__svgTarget);
    this.org_apache_royale_display_BitmapData__canvas = null;
    this.org_apache_royale_display_BitmapData__svgTarget = null;
    this.org_apache_royale_display_BitmapData__lockedData = null;
  }
};


org.apache.royale.display.BitmapData.prototype.get__org_apache_royale_display_BitmapData_isSafariDesktop = function() {
  if (org.apache.royale.display.BitmapData._checked)
    return org.apache.royale.display.BitmapData._safariDT;
  var /** @type {boolean} */ isSafariDT;
  if (window['safari']) {
    var /** @type {string} */ ua = org.apache.royale.utils.Language.string(window['navigator']['userAgent']);
    if (ua.search(/version\/[\d\.]/i) > -1) {
      isSafariDT = ua.search(/iPad|iPhone|iPod/) == -1;
    }
  }
  org.apache.royale.display.BitmapData._safariDT = isSafariDT;
  org.apache.royale.display.BitmapData._checked = true;
  console.log('safari Desktop?', isSafariDT);
  return isSafariDT;
};


org.apache.royale.display.BitmapData.prototype.get__width = function() {
  if (!this.org_apache_royale_display_BitmapData__canvas)
    throw new Error('ArgumentError: Error #2015: Invalid BitmapData');
  return this.org_apache_royale_display_BitmapData__width;
};


org.apache.royale.display.BitmapData.prototype.get__height = function() {
  if (!this.org_apache_royale_display_BitmapData__canvas)
    throw new Error('ArgumentError: Error #2015: Invalid BitmapData');
  return this.org_apache_royale_display_BitmapData__height;
};


org.apache.royale.display.BitmapData.prototype.get__transparent = function() {
  if (!this.org_apache_royale_display_BitmapData__canvas)
    throw new Error('ArgumentError: Error #2015: Invalid BitmapData');
  return this.org_apache_royale_display_BitmapData__transparent;
};


org.apache.royale.display.BitmapData.prototype.get__rect = function() {
  if (!this.org_apache_royale_display_BitmapData__canvas)
    throw new Error('ArgumentError: Error #2015: Invalid BitmapData');
  return new org.apache.royale.geom.Rectangle(0, 0, this.org_apache_royale_display_BitmapData__width, this.org_apache_royale_display_BitmapData__height);
};


Object.defineProperties(org.apache.royale.display.BitmapData.prototype, /** @lends {org.apache.royale.display.BitmapData.prototype} */ {
/**
  * @type {boolean} */
org_apache_royale_display_BitmapData_isSafariDesktop: {
get: org.apache.royale.display.BitmapData.prototype.get__org_apache_royale_display_BitmapData_isSafariDesktop},
/**
  * @export
  * @type {number} */
width: {
get: org.apache.royale.display.BitmapData.prototype.get__width},
/**
  * @export
  * @type {number} */
height: {
get: org.apache.royale.display.BitmapData.prototype.get__height},
/**
  * @export
  * @type {boolean} */
transparent: {
get: org.apache.royale.display.BitmapData.prototype.get__transparent},
/**
  * @export
  * @type {org.apache.royale.geom.Rectangle} */
rect: {
get: org.apache.royale.display.BitmapData.prototype.get__rect}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.display.BitmapData.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'BitmapData', qName: 'org.apache.royale.display.BitmapData', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.display.BitmapData.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'width': { type: 'uint', access: 'readonly', declaredBy: 'org.apache.royale.display.BitmapData'},
        'height': { type: 'uint', access: 'readonly', declaredBy: 'org.apache.royale.display.BitmapData'},
        'transparent': { type: 'Boolean', access: 'readonly', declaredBy: 'org.apache.royale.display.BitmapData'},
        'rect': { type: 'org.apache.royale.geom.Rectangle', access: 'readonly', declaredBy: 'org.apache.royale.display.BitmapData'}
      };
    },
    methods: function () {
      return {
        'BitmapData': { type: '', declaredBy: 'org.apache.royale.display.BitmapData', parameters: function () { return [ 'uint', false ,'uint', false ,'Boolean', true ,'uint', true ]; }},
        'encode': { type: 'org.apache.royale.utils.BinaryData', declaredBy: 'org.apache.royale.display.BitmapData', parameters: function () { return [ 'org.apache.royale.geom.Rectangle', false ,'Object', false ,'org.apache.royale.utils.BinaryData', true ]; }},
        'setPixel': { type: 'void', declaredBy: 'org.apache.royale.display.BitmapData', parameters: function () { return [ 'int', false ,'int', false ,'uint', false ]; }},
        'setPixel32': { type: 'void', declaredBy: 'org.apache.royale.display.BitmapData', parameters: function () { return [ 'int', false ,'int', false ,'uint', false ]; }},
        'lock': { type: 'void', declaredBy: 'org.apache.royale.display.BitmapData'},
        'unlock': { type: 'void', declaredBy: 'org.apache.royale.display.BitmapData'},
        'getPixel': { type: 'uint', declaredBy: 'org.apache.royale.display.BitmapData', parameters: function () { return [ 'int', false ,'int', false ]; }},
        'getPixel32': { type: 'uint', declaredBy: 'org.apache.royale.display.BitmapData', parameters: function () { return [ 'int', false ,'int', false ]; }},
        'clone': { type: 'org.apache.royale.display.BitmapData', declaredBy: 'org.apache.royale.display.BitmapData'},
        'fillRect': { type: 'void', declaredBy: 'org.apache.royale.display.BitmapData', parameters: function () { return [ 'org.apache.royale.geom.Rectangle', false ,'uint', false ]; }},
        'dispose': { type: 'void', declaredBy: 'org.apache.royale.display.BitmapData'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.display.BitmapData.prototype.ROYALE_COMPILE_FLAGS = 10;