/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/SingleSelectionDropTargetBead.as
 * org.apache.royale.html.beads.SingleSelectionDropTargetBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.SingleSelectionDropTargetBead');

goog.require('org.apache.royale.collections.ArrayList');
goog.require('org.apache.royale.core.DropType');
goog.require('org.apache.royale.core.IDataProviderModel');
goog.require('org.apache.royale.core.IItemRenderer');
goog.require('org.apache.royale.core.ISelectionModel');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.events.DragEvent');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.geom.Point');
goog.require('org.apache.royale.html.beads.IDrawingLayerBead');
goog.require('org.apache.royale.html.beads.SingleSelectionDropIndicatorBead');
goog.require('org.apache.royale.html.beads.controllers.DropMouseController');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.core.IBead}
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead = function() {
  org.apache.royale.html.beads.SingleSelectionDropTargetBead.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.SingleSelectionDropTargetBead, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.SingleSelectionDropTargetBead', org.apache.royale.html.beads.SingleSelectionDropTargetBead);


/**
 * @private
 * @type {org.apache.royale.html.beads.controllers.DropMouseController}
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype._dropController;


/**
 * @private
 * @type {org.apache.royale.html.beads.SingleSelectionDropIndicatorBead}
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype._dropIndicatorBead;


/**
 * @private
 * @type {org.apache.royale.core.UIBase}
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype._dropIndicator;


/**
 * @private
 * @type {Object}
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.lastItemVisited;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.indicatorVisible = false;


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype._strand;


/**
 * @private
 * @type {string}
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype._dropDirection = "horizontal";


/**
 * @protected
 * @type {org.apache.royale.core.UIBase}
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype._indicatorParent;


/**
 * @asprivate
 * @protected
 * @param {Object} ir
 * @param {number} width
 * @param {number} height
 * @return {org.apache.royale.core.UIBase}
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.getDropIndicator = function(ir, width, height) {
  if (this._dropIndicatorBead == null) {
    this._dropIndicatorBead = org.apache.royale.utils.Language.as(this._strand.getBeadByType(org.apache.royale.html.beads.SingleSelectionDropIndicatorBead), org.apache.royale.html.beads.SingleSelectionDropIndicatorBead);
    if (this._dropIndicatorBead == null)
      return null;
  }
  this._dropIndicator = this._dropIndicatorBead.getDropIndicator(ir, width, height);
  return this._dropIndicator;
};


/**
 * @asprivate
 * @private
 * @param {org.apache.royale.events.DragEvent} event
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.handleDragEnter = function(event) {
  var /** @type {org.apache.royale.events.Event} */ newEvent = new org.apache.royale.events.Event("enter", false, true);
  this.dispatchEvent(newEvent);
  if (newEvent.defaultPrevented)
    return;
  var /** @type {org.apache.royale.geom.Point} */ pt0;
  var /** @type {org.apache.royale.geom.Point} */ pt1;
  var /** @type {org.apache.royale.geom.Point} */ pt2;
  this._dropController.acceptDragDrop(org.apache.royale.utils.Language.as(event.relatedObject, org.apache.royale.core.IUIBase), org.apache.royale.core.DropType.COPY);
  var /** @type {Object} */ startHere = event.relatedObject;
  while (!org.apache.royale.utils.Language.is(startHere, org.apache.royale.core.IItemRenderer) && startHere != null) {
    startHere = startHere.parent;
  }
  if (org.apache.royale.utils.Language.is(startHere, org.apache.royale.core.IItemRenderer)) {
    var /** @type {org.apache.royale.core.IItemRenderer} */ ir = org.apache.royale.utils.Language.as(startHere, org.apache.royale.core.IItemRenderer);
    this.lastItemVisited = ir;
  }
  if (this.lastItemVisited && !this.indicatorVisible && this.indicatorParent) {
    var /** @type {org.apache.royale.core.UIBase} */ di = this.getDropIndicator(this.lastItemVisited, (this.dropDirection == "horizontal") ? this.indicatorParent.width : 4, (this.dropDirection == "horizontal") ? 4 : this.indicatorParent.height);
    this.indicatorVisible = true;
    this.displayDropIndicator(org.apache.royale.utils.Language.as(this.lastItemVisited, org.apache.royale.core.IUIBase));
    if (this.indicatorParent != null) {
      this.indicatorParent.addElement(di);
    }
  }
};


/**
 * @asprivate
 * @private
 * @param {org.apache.royale.events.DragEvent} event
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.handleDragExit = function(event) {
  this.dispatchEvent(new org.apache.royale.events.Event("exit", false, true));
  if (this.indicatorVisible) {
    if (this.indicatorParent != null) {
      this.indicatorParent.removeElement(this._dropIndicator);
    }
    this.indicatorVisible = false;
  }
};


/**
 * @asprivate
 * @private
 * @param {org.apache.royale.events.DragEvent} event
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.handleDragOver = function(event) {
  var /** @type {org.apache.royale.events.Event} */ newEvent = new org.apache.royale.events.Event("over", false, true);
  this.dispatchEvent(newEvent);
  if (event.defaultPrevented) {
    return;
  }
  var /** @type {Object} */ startHere = event.relatedObject;
  while (!org.apache.royale.utils.Language.is(startHere, org.apache.royale.core.IItemRenderer) && startHere != null) {
    startHere = startHere.parent;
  }
  if (org.apache.royale.utils.Language.is(startHere, org.apache.royale.core.IItemRenderer) && this._dropIndicator != null && this.indicatorParent) {
    this.displayDropIndicator(org.apache.royale.utils.Language.as(startHere, org.apache.royale.core.IUIBase));
    this.lastItemVisited = startHere;
  } else if (this.lastItemVisited && this._dropIndicator != null && this.indicatorParent) {
    var /** @type {org.apache.royale.core.UIBase} */ lastItem = org.apache.royale.utils.Language.as(this.lastItemVisited, org.apache.royale.core.UIBase);
    this.displayDropIndicator(org.apache.royale.utils.Language.as(this.lastItemVisited, org.apache.royale.core.IUIBase));
  }
};


/**
 * @asprivate
 * @private
 * @param {org.apache.royale.events.DragEvent} event
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.handleDragDrop = function(event) {
  this.handleDragExit(event);
  var /** @type {org.apache.royale.events.Event} */ newEvent = new org.apache.royale.events.Event("drop", false, true);
  this.dispatchEvent(newEvent);
  if (newEvent.defaultPrevented) {
    return;
  }
  var /** @type {number} */ targetIndex = -1;
  var /** @type {org.apache.royale.core.UIBase} */ itemRendererParent;
  var /** @type {Object} */ startHere = event.relatedObject;
  while (!org.apache.royale.utils.Language.is(startHere, org.apache.royale.core.IItemRenderer) && startHere != null) {
    startHere = startHere.parent;
  }
  if (org.apache.royale.utils.Language.is(startHere, org.apache.royale.core.IItemRenderer)) {
    var /** @type {org.apache.royale.core.IItemRenderer} */ ir = org.apache.royale.utils.Language.as(startHere, org.apache.royale.core.IItemRenderer);
    itemRendererParent = org.apache.royale.utils.Language.as(ir.itemRendererParent, org.apache.royale.core.UIBase);
    targetIndex = itemRendererParent.getElementIndex(ir);
  } else if (startHere != null) {
    itemRendererParent = org.apache.royale.utils.Language.as(startHere.itemRendererParent, org.apache.royale.core.UIBase);
  }
  var /** @type {org.apache.royale.geom.Point} */ downPoint = new org.apache.royale.geom.Point(event.clientX, event.clientY);
  if (org.apache.royale.events.DragEvent.dragInitiator) {
    org.apache.royale.events.DragEvent.dragInitiator.acceptingDrop(this._strand, "object");
  }
  var /** @type {Object} */ dragSource = org.apache.royale.events.DragEvent.dragSource;
  var /** @type {number} */ sourceIndex = 0;
  var /** @type {org.apache.royale.core.IDataProviderModel} */ dataProviderModel = org.apache.royale.utils.Language.as(this._strand.getBeadByType(org.apache.royale.core.IDataProviderModel), org.apache.royale.core.IDataProviderModel);
  if (org.apache.royale.utils.Language.is(dataProviderModel.dataProvider, Array)) {
    var /** @type {Array} */ dataArray = org.apache.royale.utils.Language.as(dataProviderModel.dataProvider, Array);
    if (targetIndex == -1) {
      dataArray.push(dragSource);
    } else {
      dataArray.splice(targetIndex, 0, dragSource);
    }
    var /** @type {Array} */ newArray = dataArray.slice();
    dataProviderModel.dataProvider = newArray;
  } else if (org.apache.royale.utils.Language.is(dataProviderModel.dataProvider, org.apache.royale.collections.ArrayList)) {
    var /** @type {org.apache.royale.collections.ArrayList} */ dataList = org.apache.royale.utils.Language.as(dataProviderModel.dataProvider, org.apache.royale.collections.ArrayList);
    if (targetIndex == -1) {
      dataList.addItem(dragSource);
    } else {
      dataList.addItemAt(dragSource, targetIndex);
    }
  }
  if (org.apache.royale.events.DragEvent.dragInitiator) {
    org.apache.royale.events.DragEvent.dragInitiator.acceptedDrop(this._strand, "object");
  }
  if (org.apache.royale.utils.Language.is(dataProviderModel, org.apache.royale.core.ISelectionModel)) {
    org.apache.royale.utils.Language.as(dataProviderModel, org.apache.royale.core.ISelectionModel).selectedIndex = targetIndex;
  }
  org.apache.royale.utils.Language.as(this._strand, org.apache.royale.events.IEventDispatcher, true).dispatchEvent(new org.apache.royale.events.Event("dragDropAccepted"));
  this.dispatchEvent(new org.apache.royale.events.Event("complete"));
};


/**
 * @private
 * @param {org.apache.royale.core.IUIBase} item
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.displayDropIndicator = function(item) {
  if (this.dropDirection == "horizontal") {
    this._dropIndicator.x = 0;
    this._dropIndicator.y = item.y;
  } else {
    this._dropIndicator.x = item.x;
    this._dropIndicator.y = 0;
  }
};


org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.set__strand = function(value) {
  this._strand = value;
  this._dropController = new org.apache.royale.html.beads.controllers.DropMouseController();
  this._strand.addBead(this._dropController);
  org.apache.royale.utils.Language.as(this._dropController, org.apache.royale.events.IEventDispatcher, true).addEventListener(org.apache.royale.events.DragEvent.DRAG_ENTER, org.apache.royale.utils.Language.closure(this.handleDragEnter, this, 'handleDragEnter'));
  org.apache.royale.utils.Language.as(this._dropController, org.apache.royale.events.IEventDispatcher, true).addEventListener(org.apache.royale.events.DragEvent.DRAG_EXIT, org.apache.royale.utils.Language.closure(this.handleDragExit, this, 'handleDragExit'));
  org.apache.royale.utils.Language.as(this._dropController, org.apache.royale.events.IEventDispatcher, true).addEventListener(org.apache.royale.events.DragEvent.DRAG_OVER, org.apache.royale.utils.Language.closure(this.handleDragOver, this, 'handleDragOver'));
  org.apache.royale.utils.Language.as(this._dropController, org.apache.royale.events.IEventDispatcher, true).addEventListener(org.apache.royale.events.DragEvent.DRAG_DROP, org.apache.royale.utils.Language.closure(this.handleDragDrop, this, 'handleDragDrop'));
};


org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.get__dropDirection = function() {
  return this._dropDirection;
};


org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.set__dropDirection = function(value) {
  this._dropDirection = value;
};


org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.get__indicatorParent = function() {
  if (this._indicatorParent == null) {
    var /** @type {org.apache.royale.html.beads.IDrawingLayerBead} */ layerBead = org.apache.royale.utils.Language.as(this._strand.getBeadByType(org.apache.royale.html.beads.IDrawingLayerBead), org.apache.royale.html.beads.IDrawingLayerBead);
    if (layerBead != null) {
      this._indicatorParent = layerBead.layer;
    }
  }
  return this._indicatorParent;
};


Object.defineProperties(org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype, /** @lends {org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.set__strand},
/**
  * @export
  * @type {string} */
dropDirection: {
get: org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.get__dropDirection,
set: org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.set__dropDirection},
/**
  * @export
  * @type {org.apache.royale.core.UIBase} */
indicatorParent: {
get: org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.get__indicatorParent}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'SingleSelectionDropTargetBead', qName: 'org.apache.royale.html.beads.SingleSelectionDropTargetBead', kind: 'class' }], interfaces: [org.apache.royale.core.IBead] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.SingleSelectionDropTargetBead.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.SingleSelectionDropTargetBead'},
        'dropDirection': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.html.beads.SingleSelectionDropTargetBead'}
      };
    },
    methods: function () {
      return {
        'SingleSelectionDropTargetBead': { type: '', declaredBy: 'org.apache.royale.html.beads.SingleSelectionDropTargetBead'}
      };
    },
    metadata: function () { return [  ]; }
  };
};