/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/SingleSelectionDragImageBead.as
 * org.apache.royale.html.beads.SingleSelectionDragImageBead
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.SingleSelectionDragImageBead');

goog.require('org.apache.royale.core.IChild');
goog.require('org.apache.royale.core.IItemRenderer');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.Lookalike');
goog.require('org.apache.royale.events.DragEvent');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.html.beads.controllers.DragMouseController');
goog.require('org.apache.royale.utils.getParentOrSelfByType');
goog.require('org.apache.royale.core.IBead');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.core.IBead}
 */
org.apache.royale.html.beads.SingleSelectionDragImageBead = function() {
  org.apache.royale.html.beads.SingleSelectionDragImageBead.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.SingleSelectionDragImageBead, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.SingleSelectionDragImageBead', org.apache.royale.html.beads.SingleSelectionDragImageBead);


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.SingleSelectionDragImageBead.prototype._strand;


/**
 * Creates an example/temporary component to be dragged and returns it.
 *
 * @asparam ir IItemRenderer The itemRenderer to be used as a template.
 * @asreturn UIBase The "dragImage" to use.
 *
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 * @protected
 * @param {org.apache.royale.core.IItemRenderer} ir
 * @return {org.apache.royale.core.UIBase}
 */
org.apache.royale.html.beads.SingleSelectionDragImageBead.prototype.createDragImage = function(ir) {
  var /** @type {org.apache.royale.core.UIBase} */ dragImage = new org.apache.royale.core.Lookalike(ir);
  dragImage.className = "DragImage";
  dragImage.width = org.apache.royale.utils.Language.as(ir, org.apache.royale.core.IUIBase).width;
  dragImage.height = org.apache.royale.utils.Language.as(ir, org.apache.royale.core.IUIBase).height;
  dragImage.element.style.position = 'absolute';
  dragImage.element.style.cursor = 'pointer';
  return dragImage;
};


/**
 * @asprivate
 *
 * @private
 * @param {org.apache.royale.events.DragEvent} event
 */
org.apache.royale.html.beads.SingleSelectionDragImageBead.prototype.handleDragStart = function(event) {
  org.apache.royale.utils.Language.trace("SingleSelectionDragImageBead received the DragStart via: " + event.target.toString());
  var /** @type {org.apache.royale.core.IItemRenderer} */ renderer = org.apache.royale.utils.Language.as(org.apache.royale.utils.getParentOrSelfByType(org.apache.royale.utils.Language.as(event.target, org.apache.royale.core.IChild), org.apache.royale.core.IItemRenderer), org.apache.royale.core.IItemRenderer);
  if (renderer) {
    org.apache.royale.html.beads.controllers.DragMouseController.dragImage = this.createDragImage(renderer);
  }
};


org.apache.royale.html.beads.SingleSelectionDragImageBead.prototype.set__strand = function(value) {
  this._strand = value;
  org.apache.royale.utils.Language.as(this._strand, org.apache.royale.events.IEventDispatcher, true).addEventListener(org.apache.royale.events.DragEvent.DRAG_START, org.apache.royale.utils.Language.closure(this.handleDragStart, this, 'handleDragStart'));
};


Object.defineProperties(org.apache.royale.html.beads.SingleSelectionDragImageBead.prototype, /** @lends {org.apache.royale.html.beads.SingleSelectionDragImageBead.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.SingleSelectionDragImageBead.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.SingleSelectionDragImageBead.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'SingleSelectionDragImageBead', qName: 'org.apache.royale.html.beads.SingleSelectionDragImageBead', kind: 'class' }], interfaces: [org.apache.royale.core.IBead] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.SingleSelectionDragImageBead.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.SingleSelectionDragImageBead'}
      };
    },
    methods: function () {
      return {
        'SingleSelectionDragImageBead': { type: '', declaredBy: 'org.apache.royale.html.beads.SingleSelectionDragImageBead'}
      };
    }
  };
};