/**
 * Generated by Apache Royale Compiler from org/apache/royale/collections/SortField.as
 * org.apache.royale.collections.SortField
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.collections.SortField');

goog.require('org.apache.royale.collections.CompareUtils');
goog.require('org.apache.royale.collections.SortFieldCompareTypes');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.collections.ISortField');
goog.require('org.apache.royale.utils.Language');



/**
 *  Constructor.
 *
 *  @asparam name The name of the property that this field uses for
 *              comparison.
 *              If the object is a simple type, pass <code>null</code>.
 *  @asparam caseInsensitive When sorting strings, tells the comparator
 *              whether to ignore the case of the values.
 *  @asparam descending Tells the comparator whether to arrange items in
 *              descending order.
 *  @asparam numeric Tells the comparator whether to compare sort items as
 *              numbers, instead of alphabetically.
 *  @asparam sortCompareType Gives an indication to SortField which of the
 *              default compare functions to use.
 *  @asparam customCompareFunction Use a custom function to compare the
 *              objects based on this SortField.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.collections.ISortField}
 * @param {string=} name
 * @param {boolean=} caseInsensitive
 * @param {boolean=} descending
 * @param {Object=} numeric
 * @param {string=} sortCompareType
 * @param {Function=} customCompareFunction
 */
org.apache.royale.collections.SortField = function(name, caseInsensitive, descending, numeric, sortCompareType, customCompareFunction) {
  name = typeof name !== 'undefined' ? name : null;
  caseInsensitive = typeof caseInsensitive !== 'undefined' ? caseInsensitive : false;
  descending = typeof descending !== 'undefined' ? descending : false;
  numeric = typeof numeric !== 'undefined' ? numeric : null;
  sortCompareType = typeof sortCompareType !== 'undefined' ? sortCompareType : null;
  customCompareFunction = typeof customCompareFunction !== 'undefined' ? customCompareFunction : null;
  org.apache.royale.collections.SortField.base(this, 'constructor');
  this.org_apache_royale_collections_SortField__name = name;
  this.org_apache_royale_collections_SortField__caseInsensitive = caseInsensitive;
  this.org_apache_royale_collections_SortField__descending = descending;
  this.org_apache_royale_collections_SortField__numeric = numeric;
  this.org_apache_royale_collections_SortField__sortCompareType = sortCompareType;
  if (customCompareFunction != null) {
    this.org_apache_royale_collections_SortField__compareFunction = customCompareFunction;
  } else if (this.updateSortCompareType() == false) {
    this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.stringCompare, this, 'stringCompare');
  }
};
goog.inherits(org.apache.royale.collections.SortField, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.collections.SortField', org.apache.royale.collections.SortField);


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.collections.SortField.prototype.org_apache_royale_collections_SortField__caseInsensitive;


/**
 * @private
 * @type {Function}
 */
org.apache.royale.collections.SortField.prototype.org_apache_royale_collections_SortField__compareFunction;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.collections.SortField.prototype.org_apache_royale_collections_SortField__descending;


/**
 * @private
 * @type {string}
 */
org.apache.royale.collections.SortField.prototype.org_apache_royale_collections_SortField__name;


/**
 * @private
 * @type {Object}
 */
org.apache.royale.collections.SortField.prototype.org_apache_royale_collections_SortField__numeric;


/**
 * @private
 * @type {string}
 */
org.apache.royale.collections.SortField.prototype.org_apache_royale_collections_SortField__sortCompareType = null;


/**
 * @private
 * @type {boolean}
 */
org.apache.royale.collections.SortField.prototype.org_apache_royale_collections_SortField__usingCustomCompareFunction;


/**
 *  @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} obj
 */
org.apache.royale.collections.SortField.prototype.initializeDefaultCompareFunction = function(obj) {
  if (!this.usingCustomCompareFunction) {
    if (this.org_apache_royale_collections_SortField__sortCompareType) {
      if (this.updateSortCompareType() == true) {
        return;
      }
    }
    if (this.org_apache_royale_collections_SortField__numeric == true)
      this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_SortField_numericCompare, this, 'org_apache_royale_collections_SortField_numericCompare');
    else if (this.org_apache_royale_collections_SortField__caseInsensitive || this.org_apache_royale_collections_SortField__numeric == false)
      this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.stringCompare, this, 'stringCompare'); else {
      var /** @type {Object} */ value;
      if (this.org_apache_royale_collections_SortField__name) {
        value = this.getSortFieldValue(obj);
      }
      if (value == null) {
        value = obj;
      }
      var /** @type {string} */ typ = typeof(value);
      switch (typ) {
        case "string":
          this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.stringCompare, this, 'stringCompare');
          break;
        case "object":
          if (org.apache.royale.utils.Language.is(value, Date)) {
            this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_SortField_dateCompare, this, 'org_apache_royale_collections_SortField_dateCompare');
          } else {
            this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.stringCompare, this, 'stringCompare');
            var /** @type {string} */ test;
            try {
              test = value.toString();
            } catch (error2) {
            }
            if (!test || test == "[object Object]") {
              this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_SortField_nullCompare, this, 'org_apache_royale_collections_SortField_nullCompare');
            }
          }
          break;
        case "xml":
          this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.xmlCompare, this, 'xmlCompare');
          break;
        case "boolean":
        
        case "number":
          this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_SortField_numericCompare, this, 'org_apache_royale_collections_SortField_numericCompare');
          break;
      }
    }
  }
};


/**
 *  @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 */
org.apache.royale.collections.SortField.prototype.reverse = function() {
  this.org_apache_royale_collections_SortField__descending = !this.org_apache_royale_collections_SortField__descending;
};


/**
 *  @inheritDoc
 *
 *  @langversion 3.0
 *  @playerversion Flash 11.8
 *  @playerversion AIR 3.8
 *  @productversion Flex 4.11
 * @export
 * @return {boolean}
 */
org.apache.royale.collections.SortField.prototype.updateSortCompareType = function() {
  if (!this.org_apache_royale_collections_SortField__sortCompareType) {
    return false;
  }
  switch (this.org_apache_royale_collections_SortField__sortCompareType) {
    case org.apache.royale.collections.SortFieldCompareTypes.DATE:
      this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_SortField_dateCompare, this, 'org_apache_royale_collections_SortField_dateCompare');
      return true;
    case org.apache.royale.collections.SortFieldCompareTypes.NULL:
      this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_SortField_nullCompare, this, 'org_apache_royale_collections_SortField_nullCompare');
      return true;
    case org.apache.royale.collections.SortFieldCompareTypes.NUMERIC:
      this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_SortField_numericCompare, this, 'org_apache_royale_collections_SortField_numericCompare');
      return true;
    case org.apache.royale.collections.SortFieldCompareTypes.STRING:
      this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.stringCompare, this, 'stringCompare');
      return true;
    case org.apache.royale.collections.SortFieldCompareTypes.XML:
      this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.xmlCompare, this, 'xmlCompare');
      return true;
  }
  return false;
};


/**
 * @export
 * @param {Object} object
 * @return {boolean}
 */
org.apache.royale.collections.SortField.prototype.objectHasSortField = function(object) {
  return this.getSortFieldValue(object) !== undefined;
};


/**
 * @protected
 * @param {Object} obj
 * @return {*}
 */
org.apache.royale.collections.SortField.prototype.getSortFieldValue = function(obj) {
  var /** @type {*} */ result = undefined;
  try {
    result = obj[this.org_apache_royale_collections_SortField__name];
  } catch (error) {
  }
  return result;
};


/**
 * @private
 * @param {Object} a
 * @param {Object} b
 * @return {number}
 */
org.apache.royale.collections.SortField.prototype.org_apache_royale_collections_SortField_nullCompare = function(a, b) {
  var /** @type {Object} */ left;
  var /** @type {Object} */ right;
  var /** @type {boolean} */ found = false;
  if (a == null && b == null) {
    return 0;
  }
  if (this.org_apache_royale_collections_SortField__name) {
    left = this.getSortFieldValue(a);
    right = this.getSortFieldValue(b);
  }
  if (left == null && right == null)
    return 0;
  if (left == null && !this.org_apache_royale_collections_SortField__name)
    left = a;
  if (right == null && !this.org_apache_royale_collections_SortField__name)
    right = b;
  var /** @type {string} */ typeLeft = typeof(left);
  var /** @type {string} */ typeRight = typeof(right);
  if (typeLeft == "string" || typeRight == "string") {
    found = true;
    this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.stringCompare, this, 'stringCompare');
  } else if (typeLeft == "object" || typeRight == "object") {
    if (org.apache.royale.utils.Language.is(left, Date) || org.apache.royale.utils.Language.is(right, Date)) {
      found = true;
      this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_SortField_dateCompare, this, 'org_apache_royale_collections_SortField_dateCompare');
    }
  } else if (typeLeft == "xml" || typeRight == "xml") {
    found = true;
    this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.xmlCompare, this, 'xmlCompare');
  } else if (typeLeft == "number" || typeRight == "number" || typeLeft == "boolean" || typeRight == "boolean") {
    found = true;
    this.org_apache_royale_collections_SortField__compareFunction = org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_SortField_numericCompare, this, 'org_apache_royale_collections_SortField_numericCompare');
  }
  if (found) {
    return (this.org_apache_royale_collections_SortField__compareFunction(left, right)) >> 0;
  } else {
    var /** @type {string} */ message = "noComparatorSortField";
    throw new Error(message);
  }
};


/**
 *  Pull the numbers from the objects and call the implementation.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @private
 * @param {Object} a
 * @param {Object} b
 * @return {number}
 */
org.apache.royale.collections.SortField.prototype.org_apache_royale_collections_SortField_numericCompare = function(a, b) {
  var /** @type {number} */ fa = this.org_apache_royale_collections_SortField__name == null ? Number(a) : Number(this.getSortFieldValue(a));
  var /** @type {number} */ fb = this.org_apache_royale_collections_SortField__name == null ? Number(b) : Number(this.getSortFieldValue(b));
  return org.apache.royale.collections.CompareUtils.numericCompare(fa, fb);
};


/**
 *  Pull the date objects from the values and compare them.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @private
 * @param {Object} a
 * @param {Object} b
 * @return {number}
 */
org.apache.royale.collections.SortField.prototype.org_apache_royale_collections_SortField_dateCompare = function(a, b) {
  var /** @type {Date} */ fa = this.org_apache_royale_collections_SortField__name == null ? org.apache.royale.utils.Language.as(a, Date) : org.apache.royale.utils.Language.as(this.getSortFieldValue(a), Date);
  var /** @type {Date} */ fb = this.org_apache_royale_collections_SortField__name == null ? org.apache.royale.utils.Language.as(b, Date) : org.apache.royale.utils.Language.as(this.getSortFieldValue(b), Date);
  return org.apache.royale.collections.CompareUtils.dateCompare(fa, fb);
};


/**
 *  Pull the strings from the objects and call the implementation.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @protected
 * @param {Object} a
 * @param {Object} b
 * @return {number}
 */
org.apache.royale.collections.SortField.prototype.stringCompare = function(a, b) {
  var /** @type {string} */ fa = this.org_apache_royale_collections_SortField__name == null ? String(a) : String(this.getSortFieldValue(a));
  var /** @type {string} */ fb = this.org_apache_royale_collections_SortField__name == null ? String(b) : String(this.getSortFieldValue(b));
  return org.apache.royale.collections.CompareUtils.stringCompare(fa, fb, this.org_apache_royale_collections_SortField__caseInsensitive);
};


/**
 *  Pull the values out fo the XML object, then compare
 *  using the string or numeric comparator depending
 *  on the numeric flag.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @protected
 * @param {Object} a
 * @param {Object} b
 * @return {number}
 */
org.apache.royale.collections.SortField.prototype.xmlCompare = function(a, b) {
  var /** @type {string} */ sa = org.apache.royale.utils.Language.string(this.org_apache_royale_collections_SortField__name == null ? a.toString() : this.getSortFieldValue(a).toString());
  var /** @type {string} */ sb = org.apache.royale.utils.Language.string(this.org_apache_royale_collections_SortField__name == null ? b.toString() : this.getSortFieldValue(b).toString());
  if (this.org_apache_royale_collections_SortField__numeric == true) {
    return org.apache.royale.collections.CompareUtils.numericCompare(parseFloat(sa), parseFloat(sb));
  } else {
    return org.apache.royale.collections.CompareUtils.stringCompare(sa, sb, this.org_apache_royale_collections_SortField__caseInsensitive);
  }
};


org.apache.royale.collections.SortField.prototype.get__arraySortOnOptions = function() {
  if (this.usingCustomCompareFunction || this.org_apache_royale_collections_SortField__name == null || this.org_apache_royale_collections_SortField__compareFunction == org.apache.royale.utils.Language.closure(this.xmlCompare, this, 'xmlCompare') || this.org_apache_royale_collections_SortField__compareFunction == org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_SortField_dateCompare, this, 'org_apache_royale_collections_SortField_dateCompare')) {
    return -1;
  }
  var /** @type {number} */ options = 0;
  if (this.org_apache_royale_collections_SortField__caseInsensitive)
    options |= (1) >> 0;
  if (this.org_apache_royale_collections_SortField__descending)
    options |= (2) >> 0;
  if (this.org_apache_royale_collections_SortField__numeric == true || this.org_apache_royale_collections_SortField__compareFunction == org.apache.royale.utils.Language.closure(this.org_apache_royale_collections_SortField_numericCompare, this, 'org_apache_royale_collections_SortField_numericCompare'))
    options |= (16) >> 0;
  return options;
};


org.apache.royale.collections.SortField.prototype.get__compareFunction = function() {
  return this.org_apache_royale_collections_SortField__compareFunction;
};


org.apache.royale.collections.SortField.prototype.get__descending = function() {
  return this.org_apache_royale_collections_SortField__descending;
};


org.apache.royale.collections.SortField.prototype.get__name = function() {
  return this.org_apache_royale_collections_SortField__name;
};


org.apache.royale.collections.SortField.prototype.get__numeric = function() {
  return this.org_apache_royale_collections_SortField__numeric;
};


org.apache.royale.collections.SortField.prototype.get__sortCompareType = function() {
  return this.org_apache_royale_collections_SortField__sortCompareType;
};


org.apache.royale.collections.SortField.prototype.get__usingCustomCompareFunction = function() {
  return this.org_apache_royale_collections_SortField__usingCustomCompareFunction;
};


Object.defineProperties(org.apache.royale.collections.SortField.prototype, /** @lends {org.apache.royale.collections.SortField.prototype} */ {
/**
  * @export
  * @type {number} */
arraySortOnOptions: {
get: org.apache.royale.collections.SortField.prototype.get__arraySortOnOptions},
/**
  * @export
  * @type {Function} */
compareFunction: {
get: org.apache.royale.collections.SortField.prototype.get__compareFunction},
/**
  * @export
  * @type {boolean} */
descending: {
get: org.apache.royale.collections.SortField.prototype.get__descending},
/**
  * @export
  * @type {string} */
name: {
get: org.apache.royale.collections.SortField.prototype.get__name},
/**
  * @export
  * @type {Object} */
numeric: {
get: org.apache.royale.collections.SortField.prototype.get__numeric},
/**
  * @export
  * @type {string} */
sortCompareType: {
get: org.apache.royale.collections.SortField.prototype.get__sortCompareType},
/**
  * @export
  * @type {boolean} */
usingCustomCompareFunction: {
get: org.apache.royale.collections.SortField.prototype.get__usingCustomCompareFunction}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.collections.SortField.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'SortField', qName: 'org.apache.royale.collections.SortField', kind: 'class' }], interfaces: [org.apache.royale.collections.ISortField] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.collections.SortField.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'arraySortOnOptions': { type: 'int', access: 'readonly', declaredBy: 'org.apache.royale.collections.SortField'},
        'compareFunction': { type: 'Function', access: 'readonly', declaredBy: 'org.apache.royale.collections.SortField'},
        'descending': { type: 'Boolean', access: 'readonly', declaredBy: 'org.apache.royale.collections.SortField'},
        'name': { type: 'String', access: 'readonly', declaredBy: 'org.apache.royale.collections.SortField'},
        'numeric': { type: 'Object', access: 'readonly', declaredBy: 'org.apache.royale.collections.SortField'},
        'sortCompareType': { type: 'String', access: 'readonly', declaredBy: 'org.apache.royale.collections.SortField', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'sortCompareTypeChanged' } ] } ]; }},
        'usingCustomCompareFunction': { type: 'Boolean', access: 'readonly', declaredBy: 'org.apache.royale.collections.SortField'}
      };
    },
    methods: function () {
      return {
        'SortField': { type: '', declaredBy: 'org.apache.royale.collections.SortField', parameters: function () { return [ 'String', true ,'Boolean', true ,'Boolean', true ,'Object', true ,'String', true ,'Function', true ]; }},
        'initializeDefaultCompareFunction': { type: 'void', declaredBy: 'org.apache.royale.collections.SortField', parameters: function () { return [ 'Object', false ]; }},
        'reverse': { type: 'void', declaredBy: 'org.apache.royale.collections.SortField'},
        'updateSortCompareType': { type: 'Boolean', declaredBy: 'org.apache.royale.collections.SortField'},
        'objectHasSortField': { type: 'Boolean', declaredBy: 'org.apache.royale.collections.SortField', parameters: function () { return [ 'Object', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.collections.SortField.prototype.ROYALE_COMPILE_FLAGS = 10;