/**
 * Generated by Apache Royale Compiler from org/apache/royale/collections/CompareUtils.as
 * org.apache.royale.collections.CompareUtils
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.collections.CompareUtils');

goog.require('org.apache.royale.collections.IArrayListView');
goog.require('org.apache.royale.collections.Sort');
goog.require('org.apache.royale.collections.SortField');



/**
 * @constructor
 */
org.apache.royale.collections.CompareUtils = function() {
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.collections.CompareUtils', org.apache.royale.collections.CompareUtils);


/**
 * Sort an <code>IArrayListView</code> collection
 *
 * @asparam collection     The Collection to sort
 * @asparam sortBy         The name of the field to sort
 * @asparam orderDesc        True ASC , false DESC
 * @asparam numericSort    If the sorting should be numeric or alphanumeric
 *
 * @asreturn the collection
 * @export
 * @param {org.apache.royale.collections.IArrayListView} collection
 * @param {string} sortBy
 * @param {boolean=} orderDesc
 * @param {boolean=} numericSort
 * @return {org.apache.royale.collections.IArrayListView}
 */
org.apache.royale.collections.CompareUtils.sort = function(collection, sortBy, orderDesc, numericSort) {
  orderDesc = typeof orderDesc !== 'undefined' ? orderDesc : false;
  numericSort = typeof numericSort !== 'undefined' ? numericSort : false;
  var /** @type {org.apache.royale.collections.SortField} */ sortField = new org.apache.royale.collections.SortField(sortBy, true, orderDesc, numericSort);
  var /** @type {org.apache.royale.collections.Sort} */ dataSort = new org.apache.royale.collections.Sort();
  dataSort.fields = [sortField];
  collection.sort = dataSort;
  collection.refresh();
  return collection;
};


/**
 *  Compares two numeric values.
 *
 *  @asparam a First number.
 *
 *  @asparam b Second number.
 *
 *  @asreturn 0 is both numbers are NaN.
 *  1 if only <code>a</code> is a NaN.
 *  -1 if only <code>b</code> is a NaN.
 *  -1 if <code>a</code> is less than <code>b</code>.
 *  1 if <code>a</code> is greater than <code>b</code>.
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {number} a
 * @param {number} b
 * @return {number}
 */
org.apache.royale.collections.CompareUtils.numericCompare = function(a, b) {
  if (isNaN(a) && isNaN(b))
    return 0;
  if (isNaN(a))
    return 1;
  if (isNaN(b))
    return -1;
  if (a < b)
    return -1;
  if (a > b)
    return 1;
  return 0;
};


/**
 *  Compares two String values.
 *
 *  @asparam a First String value.
 *
 *  @asparam b Second String value.
 *
 *  @asparam caseInsensitive Specifies to perform a case insensitive compare,
 *  <code>true</code>, or not, <code>false</code>.
 *
 *  @asreturn 0 is both Strings are null.
 *  1 if only <code>a</code> is null.
 *  -1 if only <code>b</code> is null.
 *  -1 if <code>a</code> precedes <code>b</code>.
 *  1 if <code>b</code> precedes <code>a</code>.
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {string} a
 * @param {string} b
 * @param {boolean=} caseInsensitive
 * @return {number}
 */
org.apache.royale.collections.CompareUtils.stringCompare = function(a, b, caseInsensitive) {
  caseInsensitive = typeof caseInsensitive !== 'undefined' ? caseInsensitive : false;
  if (a == null && b == null)
    return 0;
  if (a == null)
    return 1;
  if (b == null)
    return -1;
  if (caseInsensitive) {
    a = a.toLocaleLowerCase();
    b = b.toLocaleLowerCase();
  }
  var /** @type {number} */ result = (a.localeCompare(b)) >> 0;
  if (result < -1)
    result = -1;
  else if (result > 1)
    result = 1;
  return result;
};


/**
 *  Compares the two Date objects and returns an integer value
 *  indicating if the first Date object is before, equal to,
 *  or after the second item.
 *
 *  @asparam a Date object.
 *
 *  @asparam b Date object.
 *
 *  @asreturn 0 if <code>a</code> and <code>b</code> are equal
 *  (or both are <code>null</code>);
 *  -1 if <code>a</code> is before <code>b</code>
 *  (or <code>b</code> is <code>null</code>);
 *  1 if <code>a</code> is after <code>b</code>
 *  (or <code>a</code> is <code>null</code>);
 *  0 is both dates getTime's are NaN;
 *  1 if only <code>a</code> getTime is a NaN;
 *  -1 if only <code>b</code> getTime is a NaN.
 *
 *  @langversion 3.0
 *  @playerversion Flash 9
 *  @playerversion AIR 1.1
 *  @productversion Flex 3
 * @export
 * @param {Date} a
 * @param {Date} b
 * @return {number}
 */
org.apache.royale.collections.CompareUtils.dateCompare = function(a, b) {
  if (a == null && b == null)
    return 0;
  if (a == null)
    return 1;
  if (b == null)
    return -1;
  var /** @type {number} */ na = a.getTime();
  var /** @type {number} */ nb = b.getTime();
  if (na < nb)
    return -1;
  if (na > nb)
    return 1;
  if (isNaN(na) && isNaN(nb))
    return 0;
  if (isNaN(na))
    return 1;
  if (isNaN(nb))
    return -1;
  return 0;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.collections.CompareUtils.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'CompareUtils', qName: 'org.apache.royale.collections.CompareUtils', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.collections.CompareUtils.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    methods: function () {
      return {
        '|sort': { type: 'org.apache.royale.collections.IArrayListView', declaredBy: 'org.apache.royale.collections.CompareUtils', parameters: function () { return [ 'org.apache.royale.collections.IArrayListView', false ,'String', false ,'Boolean', true ,'Boolean', true ]; }},
        '|numericCompare': { type: 'int', declaredBy: 'org.apache.royale.collections.CompareUtils', parameters: function () { return [ 'Number', false ,'Number', false ]; }},
        '|stringCompare': { type: 'int', declaredBy: 'org.apache.royale.collections.CompareUtils', parameters: function () { return [ 'String', false ,'String', false ,'Boolean', true ]; }},
        '|dateCompare': { type: 'int', declaredBy: 'org.apache.royale.collections.CompareUtils', parameters: function () { return [ 'Date', false ,'Date', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.collections.CompareUtils.prototype.ROYALE_COMPILE_FLAGS = 10;