/**
 * Generated by Apache Royale Compiler from org\apache\royale\collections\FlattenedList.as
 * org.apache.royale.collections.FlattenedList
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.collections.FlattenedList');

goog.require('org.apache.royale.collections.ArrayList');
goog.require('org.apache.royale.collections.HierarchicalData');
goog.require('org.apache.royale.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @extends {org.apache.royale.collections.ArrayList}
 * @param {org.apache.royale.collections.HierarchicalData} hdata
 */
org.apache.royale.collections.FlattenedList = function(hdata) {
  org.apache.royale.collections.FlattenedList.base(this, 'constructor');
  this.hdata = hdata;
  this.openNodes = [];
  this.reset();
};
goog.inherits(org.apache.royale.collections.FlattenedList, org.apache.royale.collections.ArrayList);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.collections.FlattenedList', org.apache.royale.collections.FlattenedList);


/**
 * @export
 * @type {org.apache.royale.collections.HierarchicalData}
 */
org.apache.royale.collections.FlattenedList.prototype.hdata;


/**
 * @export
 * @type {Array}
 */
org.apache.royale.collections.FlattenedList.prototype.openNodes;


/**
 * Resets the list so that only the top root node is open.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 */
org.apache.royale.collections.FlattenedList.prototype.reset = function() {
  var /** @type {Array} */ arr = [];
  this.addChildren(this.hdata.getRoot(), arr);
  this.source = arr;
};


/**
 * @asprivate
 * @protected
 * @param {Object} node
 * @param {Array} arr
 */
org.apache.royale.collections.FlattenedList.prototype.addChildren = function(node, arr) {
  var /** @type {Array} */ children = org.apache.royale.utils.Language.as(this.hdata.getChildren(node), Array);
  var /** @type {number} */ n = children.length;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    arr.push(children[i]);
    if (this.isOpen(children[i])) {
      this.addChildren(children[i], arr);
    }
  }
};


/**
 * Returns true if the node has children nodes.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} node
 * @return {boolean}
 */
org.apache.royale.collections.FlattenedList.prototype.hasChildren = function(node) {
  return this.hdata.hasChildren(node);
};


/**
 * Returns true if the node is currently open.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} node
 * @return {boolean}
 */
org.apache.royale.collections.FlattenedList.prototype.isOpen = function(node) {
  return this.openNodes.indexOf(node) != -1;
};


/**
 * Opens the given node. The array data now contains more elements.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} node
 */
org.apache.royale.collections.FlattenedList.prototype.openNode = function(node) {
  if (this.hdata.hasChildren(node)) {
    this.openNodes.push(node);
    var /** @type {Array} */ arr = [];
    this.addChildren(node, arr);
    var /** @type {number} */ i = this.getItemIndex(node);
    while (arr.length) {
      this.addItemAt(arr.shift(), ++i);
    }
  }
  this.updateNode(node);
};


/**
 * Closes the given node. The array data now contains fewer elements.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} node
 */
org.apache.royale.collections.FlattenedList.prototype.closeNode = function(node) {
  var /** @type {number} */ i = this.openNodes.indexOf(node);
  if (i != -1) {
    if (this.hdata.hasChildren(node)) {
      var /** @type {Array} */ children = org.apache.royale.utils.Language.as(this.hdata.getChildren(node), Array);
      var /** @type {number} */ n = children.length;
      for (var /** @type {number} */ j = 0; j < n; j++) {
        this.closeNode(children[j]);
      }
    }
    this.openNodes.splice(i, 1);
    var /** @type {Array} */ arr = [];
    this.addChildren(node, arr);
    i = this.getItemIndex(node) + 1;
    while (arr.length) {
      this.removeItemAt(i);
      arr.shift();
    }
  }
  this.updateNode(node);
};


/**
 * Singles to the node that its state has changed and it should
 * update itself
 * @export
 * @param {Object} node
 */
org.apache.royale.collections.FlattenedList.prototype.updateNode = function(node) {
  this.itemUpdated(node);
};


/**
 * Returns the depth of the node with the root being zero.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} node
 * @return {number}
 */
org.apache.royale.collections.FlattenedList.prototype.getDepth = function(node) {
  var /** @type {number} */ depth = this.org_apache_royale_collections_FlattenedList_godeep(node, this.hdata.getRoot(), 0);
  return depth;
};


/**
 * @asprivate
 * @private
 * @param {Object} seeking
 * @param {Object} node
 * @param {number} depth
 * @return {number}
 */
org.apache.royale.collections.FlattenedList.prototype.org_apache_royale_collections_FlattenedList_godeep = function(seeking, node, depth) {
  if (seeking == node)
    return depth;
  if (this.hdata.hasChildren(node)) {
    var /** @type {Array} */ children = org.apache.royale.utils.Language.as(this.hdata.getChildren(node), Array);
    var /** @type {number} */ len = children.length;
    for (var /** @type {number} */ i = 0; i < len; i++) {
      var /** @type {number} */ newDepth = this.org_apache_royale_collections_FlattenedList_godeep(seeking, children[i], depth + 1);
      if (newDepth > 0)
        return newDepth;
    }
  }
  return -1;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.collections.FlattenedList.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'FlattenedList', qName: 'org.apache.royale.collections.FlattenedList', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.collections.FlattenedList.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {
      return {
        'hdata': { type: 'org.apache.royale.collections.HierarchicalData'},
        'openNodes': { type: 'Array'}
      };
    },
    accessors: function () {return {};},
    methods: function () {
      return {
        'FlattenedList': { type: '', declaredBy: 'org.apache.royale.collections.FlattenedList', parameters: function () { return [  { index: 1, type: 'org.apache.royale.collections.HierarchicalData', optional: false } ]; }},
        'reset': { type: 'void', declaredBy: 'org.apache.royale.collections.FlattenedList'},
        'hasChildren': { type: 'Boolean', declaredBy: 'org.apache.royale.collections.FlattenedList', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }},
        'isOpen': { type: 'Boolean', declaredBy: 'org.apache.royale.collections.FlattenedList', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }},
        'openNode': { type: 'void', declaredBy: 'org.apache.royale.collections.FlattenedList', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }},
        'closeNode': { type: 'void', declaredBy: 'org.apache.royale.collections.FlattenedList', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }},
        'updateNode': { type: 'void', declaredBy: 'org.apache.royale.collections.FlattenedList', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }},
        'getDepth': { type: 'int', declaredBy: 'org.apache.royale.collections.FlattenedList', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }}
      };
    }
  };
};