/**
 * Generated by Apache Royale Compiler from org\apache\royale\collections\CollectionUtils.as
 * org.apache.royale.collections.CollectionUtils
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.collections.CollectionUtils');

goog.require('org.apache.royale.collections.ICollectionView');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.4
 * @constructor
 */
org.apache.royale.collections.CollectionUtils = function() {
  ;
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.collections.CollectionUtils', org.apache.royale.collections.CollectionUtils);


/**
 * Search for an index in a collection of objects, given the key and the value
 *
 * @asparam collection The <code>ICollectionView</code> to inspect
 * @asparam key The <code>String</code> that will be use for search
 * @asparam value Any kind of object to perform the comparison
 *
 * @asreturn an <code>int</code> that represents the index of the object in the collection
 * 
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.4
 * @export
 * @param {org.apache.royale.collections.ICollectionView} collection
 * @param {string} key
 * @param {*} value
 * @return {number}
 */
org.apache.royale.collections.CollectionUtils.findIndex = function(collection, key, value) {
  var /** @type {number} */ index = -1;
  if (collection) {
    var /** @type {number} */ i = 0;
    var /** @type {number} */ n = collection.length;
    for (i = 0; i < n; i++) {
      if (collection.getItemAt(i)[key] == value) {
        index = i;
        break;
      }
    }
  }
  return index;
};


/**
 * Get a item in a given collection given a key and a value
 *
 * @asparam collection The <code>ICollectionView</code> to inspect
 * @asparam key The <code>String</code> that will be use for search
 * @asparam value Any kind of object to perform the comparison
 *
 * @asreturn The object if exists in the collection
 * 
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.4
 * @export
 * @param {org.apache.royale.collections.ICollectionView} collection
 * @param {string} key
 * @param {*} value
 * @return {*}
 */
org.apache.royale.collections.CollectionUtils.getItemByField = function(collection, key, value) {
  if (collection && key && (key != "") && value) {
    var /** @type {number} */ i = 0;
    var /** @type {number} */ n = collection.length;
    for (i = 0; i < n; i++) {
      if (collection.getItemAt(i)[key] == value || (isNaN(value) && isNaN(collection.getItemAt(i)[key]))) {
        return collection.getItemAt(i);
      }
    }
  }
  return null;
};


/**
 * Tries to find the object or the propertyId in a collection and returns the index if found.
 * The comparation is based on 'id'
 * Supports nulls in property object and returns -1
 * For use with List components in bindinds with "selectedIndex"
 * 
 * @asparam collection a <code>ICollectionView</code> dataprovider where we need to look for
 * @asparam obj an <code>Object</code> with a subproperty used for comparation
 * @asparam property the <code>String</code> name of the subproperty. This could be and Obejct with an id or directly a propertyId
 *
 * @asreturn the index if was found, -1 if the object is null or not found
 * 
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.4
 * @export
 * @param {org.apache.royale.collections.ICollectionView} collection
 * @param {Object} obj
 * @param {string} property
 * @return {number}
 */
org.apache.royale.collections.CollectionUtils.findSelectedIndex = function(collection, obj, property) {
  var /** @type {number} */ index = -1;
  if (obj && obj[property]) {
    if (obj[property].hasOwnProperty("id")) {
      index = org.apache.royale.collections.CollectionUtils.findIndex(collection, 'id', obj[property].id);
    } else {
      index = org.apache.royale.collections.CollectionUtils.findIndex(collection, 'id', obj[property]);
    }
  }
  return index;
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.collections.CollectionUtils.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'CollectionUtils', qName: 'org.apache.royale.collections.CollectionUtils', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.collections.CollectionUtils.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {return {};},
    methods: function () {
      return {
        'CollectionUtils': { type: '', declaredBy: 'org.apache.royale.collections.CollectionUtils'},
        '|findIndex': { type: 'int', declaredBy: 'org.apache.royale.collections.CollectionUtils', parameters: function () { return [  { index: 1, type: 'org.apache.royale.collections.ICollectionView', optional: false },{ index: 2, type: 'String', optional: false },{ index: 3, type: '*', optional: false } ]; }},
        '|getItemByField': { type: '*', declaredBy: 'org.apache.royale.collections.CollectionUtils', parameters: function () { return [  { index: 1, type: 'org.apache.royale.collections.ICollectionView', optional: false },{ index: 2, type: 'String', optional: false },{ index: 3, type: '*', optional: false } ]; }},
        '|findSelectedIndex': { type: 'Number', declaredBy: 'org.apache.royale.collections.CollectionUtils', parameters: function () { return [  { index: 1, type: 'org.apache.royale.collections.ICollectionView', optional: false },{ index: 2, type: 'Object', optional: false },{ index: 3, type: 'String', optional: false } ]; }}
      };
    }
  };
};