/**
 * Generated by Apache Royale Compiler from org\apache\royale\collections\ArrayList.as
 * org.apache.royale.collections.ArrayList
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.collections.ArrayList');

goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.events.CollectionEvent');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.EventDispatcher');
goog.require('org.apache.royale.collections.IArrayList');
goog.require('org.apache.royale.collections.ICollectionView');
goog.require('org.apache.royale.core.IBead');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @extends {org.apache.royale.events.EventDispatcher}
 * @implements {org.apache.royale.core.IBead}
 * @implements {org.apache.royale.collections.ICollectionView}
 * @implements {org.apache.royale.collections.IArrayList}
 * @param {Array=} initialSource
 */
org.apache.royale.collections.ArrayList = function(initialSource) {
  initialSource = typeof initialSource !== 'undefined' ? initialSource : null;
  org.apache.royale.collections.ArrayList.base(this, 'constructor');
  if (initialSource)
    this.org_apache_royale_collections_ArrayList__source = initialSource;
  else
    this.org_apache_royale_collections_ArrayList__source = [];
};
goog.inherits(org.apache.royale.collections.ArrayList, org.apache.royale.events.EventDispatcher);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.collections.ArrayList', org.apache.royale.collections.ArrayList);


/**
 * @private
 * @type {string}
 */
org.apache.royale.collections.ArrayList.prototype.org_apache_royale_collections_ArrayList__id;


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.collections.ArrayList.prototype.org_apache_royale_collections_ArrayList__strand;


/**
 * @private
 * @type {Array}
 */
org.apache.royale.collections.ArrayList.prototype.org_apache_royale_collections_ArrayList__source;


/**
 * Returns a copy of the source array.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @return {Array}
 */
org.apache.royale.collections.ArrayList.prototype.toArray = function() {
  return this.org_apache_royale_collections_ArrayList__source.concat();
};


/**
 *  Fetches an item from the collection
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.royale.collections.ArrayList.prototype.getItemAt = function(index) {
  return this.org_apache_royale_collections_ArrayList__source[index];
};


/**
 *  Fetches an item from the collection given an index.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} item
 * @return {number}
 */
org.apache.royale.collections.ArrayList.prototype.getItemIndex = function(item) {
  return this.org_apache_royale_collections_ArrayList__source.indexOf(item);
};


/**
 *  Adds an item to the end of the array.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} item
 */
org.apache.royale.collections.ArrayList.prototype.addItem = function(item) {
  this.addItemAt(item, this.length);
};


/**
 *  Inserts an item to a specific location within the array.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} item
 * @param {number} index
 */
org.apache.royale.collections.ArrayList.prototype.addItemAt = function(item, index) {
  
/**
 * @const
 * @type {number}
 */
var spliceUpperBound = this.length;
  if (index < spliceUpperBound && index > 0) {
    this.source.splice(index, 0, item);
  } else if (index == spliceUpperBound) {
    this.source.push(item);
  } else if (index == 0) {
    this.source.unshift(item);
  } else {
    return;
  }
  var /** @type {org.apache.royale.events.CollectionEvent} */ collectionEvent = new org.apache.royale.events.CollectionEvent(org.apache.royale.events.CollectionEvent.ITEM_ADDED);
  collectionEvent.item = item;
  collectionEvent.index = index;
  this.dispatchEvent(collectionEvent);
};


/**
 *  Replaces the item at the given index with a new item and
 *  returns the old item.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} item
 * @param {number} index
 * @return {Object}
 */
org.apache.royale.collections.ArrayList.prototype.setItemAt = function(item, index) {
  
/**
 * @const
 * @type {number}
 */
var spliceUpperBound = this.length;
  var /** @type {Object} */ oldItem;
  if (index >= 0 && index < spliceUpperBound) {
    oldItem = this.source[index];
    this.source[index] = item;
    var /** @type {org.apache.royale.events.CollectionEvent} */ collectionEvent = new org.apache.royale.events.CollectionEvent(org.apache.royale.events.CollectionEvent.ITEM_UPDATED);
    collectionEvent.item = item;
    collectionEvent.index = index;
    this.dispatchEvent(collectionEvent);
  } else {
  }
  return oldItem;
};


/**
 *  Removed an item from the array and returns it.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} item
 * @return {boolean}
 */
org.apache.royale.collections.ArrayList.prototype.removeItem = function(item) {
  var /** @type {number} */ index = this.getItemIndex(item);
  var /** @type {boolean} */ result = index >= 0;
  if (result) {
    this.removeItemAt(index);
  }
  return result;
};


/**
 *  Removes an item from a specific location within the array and
 *  returns it.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {number} index
 * @return {Object}
 */
org.apache.royale.collections.ArrayList.prototype.removeItemAt = function(index) {
  
/**
 * @const
 * @type {number}
 */
var spliceUpperBound = this.length - 1;
  var /** @type {Object} */ removed;
  if (index > 0 && index < spliceUpperBound) {
    removed = this.source.splice(index, 1)[0];
  } else if (index == spliceUpperBound) {
    removed = this.source.pop();
  } else if (index == 0) {
    removed = this.source.shift();
  } else {
    return null;
  }
  var /** @type {org.apache.royale.events.CollectionEvent} */ collectionEvent = new org.apache.royale.events.CollectionEvent(org.apache.royale.events.CollectionEvent.ITEM_REMOVED);
  collectionEvent.item = removed;
  collectionEvent.index = index;
  this.dispatchEvent(collectionEvent);
  return removed;
};


/**
 *  Removes all of the items from the array.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 */
org.apache.royale.collections.ArrayList.prototype.removeAll = function() {
  if (this.length > 0) {
    var /** @type {org.apache.royale.events.CollectionEvent} */ collectionEvent = new org.apache.royale.events.CollectionEvent(org.apache.royale.events.CollectionEvent.ALL_ITEMS_REMOVED);
    collectionEvent.items = this.source.splice(0, this.length);
    collectionEvent.index = -1;
    this.dispatchEvent(collectionEvent);
  }
};


/**
 *  Signals that an item in the array has been updated.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {Object} item
 */
org.apache.royale.collections.ArrayList.prototype.itemUpdated = function(item) {
  var /** @type {number} */ index = this.getItemIndex(item);
  if (index >= 0) {
    var /** @type {org.apache.royale.events.CollectionEvent} */ collectionEvent = new org.apache.royale.events.CollectionEvent(org.apache.royale.events.CollectionEvent.ITEM_UPDATED);
    collectionEvent.item = item;
    collectionEvent.index = index;
    this.dispatchEvent(collectionEvent);
  }
};


/**
 *  Signals that an item in the array has been updated.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @export
 * @param {number} index
 */
org.apache.royale.collections.ArrayList.prototype.itemUpdatedAt = function(index) {
  var /** @type {org.apache.royale.events.CollectionEvent} */ collectionEvent = new org.apache.royale.events.CollectionEvent(org.apache.royale.events.CollectionEvent.ITEM_UPDATED);
  collectionEvent.item = this.getItemAt(index);
  collectionEvent.index = index;
  this.dispatchEvent(collectionEvent);
};


org.apache.royale.collections.ArrayList.prototype.get__id = function() {
  return this.org_apache_royale_collections_ArrayList__id;
};


org.apache.royale.collections.ArrayList.prototype.set__id = function(value) {
  if (this.org_apache_royale_collections_ArrayList__id != value) {
    this.org_apache_royale_collections_ArrayList__id = value;
    this.dispatchEvent(new org.apache.royale.events.Event("idChanged"));
  }
};


org.apache.royale.collections.ArrayList.prototype.set__strand = function(value) {
  this.org_apache_royale_collections_ArrayList__strand = value;
  this.org_apache_royale_collections_ArrayList__source = new Array();
};


org.apache.royale.collections.ArrayList.prototype.get__source = function() {
  return this.org_apache_royale_collections_ArrayList__source;
};


org.apache.royale.collections.ArrayList.prototype.set__source = function(value) {
  if (this.org_apache_royale_collections_ArrayList__source != value) {
    if (value == null) {
      this.org_apache_royale_collections_ArrayList__source = [];
    } else {
      this.org_apache_royale_collections_ArrayList__source = value;
    }
    this.dispatchEvent(new org.apache.royale.events.CollectionEvent(org.apache.royale.events.CollectionEvent.COLLECTION_CHANGED));
  }
};


org.apache.royale.collections.ArrayList.prototype.get__length = function() {
  return this.org_apache_royale_collections_ArrayList__source ? this.org_apache_royale_collections_ArrayList__source.length : 0;
};


Object.defineProperties(org.apache.royale.collections.ArrayList.prototype, /** @lends {org.apache.royale.collections.ArrayList.prototype} */ {
/**
  * @export
  * @type {string} */
id: {
get: org.apache.royale.collections.ArrayList.prototype.get__id,
set: org.apache.royale.collections.ArrayList.prototype.set__id},
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.collections.ArrayList.prototype.set__strand},
/**
  * @export
  * @type {Array} */
source: {
get: org.apache.royale.collections.ArrayList.prototype.get__source,
set: org.apache.royale.collections.ArrayList.prototype.set__source},
/**
  * @export
  * @type {number} */
length: {
get: org.apache.royale.collections.ArrayList.prototype.get__length}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.collections.ArrayList.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'ArrayList', qName: 'org.apache.royale.collections.ArrayList', kind: 'class' }], interfaces: [org.apache.royale.core.IBead, org.apache.royale.collections.ICollectionView, org.apache.royale.collections.IArrayList] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.collections.ArrayList.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'id': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.collections.ArrayList'},
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.collections.ArrayList'},
        'source': { type: 'Array', access: 'readwrite', declaredBy: 'org.apache.royale.collections.ArrayList'},
        'length': { type: 'int', access: 'readonly', declaredBy: 'org.apache.royale.collections.ArrayList'}
      };
    },
    methods: function () {
      return {
        'ArrayList': { type: '', declaredBy: 'org.apache.royale.collections.ArrayList', parameters: function () { return [  { index: 1, type: 'Array', optional: true } ]; }},
        'toArray': { type: 'Array', declaredBy: 'org.apache.royale.collections.ArrayList'},
        'getItemAt': { type: 'Object', declaredBy: 'org.apache.royale.collections.ArrayList', parameters: function () { return [  { index: 1, type: 'int', optional: false } ]; }},
        'getItemIndex': { type: 'int', declaredBy: 'org.apache.royale.collections.ArrayList', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }},
        'addItem': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayList', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }},
        'addItemAt': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayList', parameters: function () { return [  { index: 1, type: 'Object', optional: false },{ index: 2, type: 'int', optional: false } ]; }},
        'setItemAt': { type: 'Object', declaredBy: 'org.apache.royale.collections.ArrayList', parameters: function () { return [  { index: 1, type: 'Object', optional: false },{ index: 2, type: 'int', optional: false } ]; }},
        'removeItem': { type: 'Boolean', declaredBy: 'org.apache.royale.collections.ArrayList', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }},
        'removeItemAt': { type: 'Object', declaredBy: 'org.apache.royale.collections.ArrayList', parameters: function () { return [  { index: 1, type: 'int', optional: false } ]; }},
        'removeAll': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayList'},
        'itemUpdated': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayList', parameters: function () { return [  { index: 1, type: 'Object', optional: false } ]; }},
        'itemUpdatedAt': { type: 'void', declaredBy: 'org.apache.royale.collections.ArrayList', parameters: function () { return [  { index: 1, type: 'int', optional: false } ]; }}
      };
    },
    metadata: function () { return [  ]; }
  };
};