/**
 * Generated by Apache Royale Compiler from org/apache/royale/svg/Circle.as
 * org.apache.royale.svg.Circle
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.svg.Circle');

goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.html.util.createSVG');
goog.require('org.apache.royale.svg.GraphicShape');
goog.require('org.apache.royale.graphics.ICircle');
goog.require('org.apache.royale.graphics.IDrawable');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.7
 * @constructor
 * @extends {org.apache.royale.svg.GraphicShape}
 * @implements {org.apache.royale.graphics.ICircle}
 * @implements {org.apache.royale.graphics.IDrawable}
 * @param {number=} cx
 * @param {number=} cy
 * @param {number=} r
 */
org.apache.royale.svg.Circle = function(cx, cy, r) {
  org.apache.royale.svg.Circle.base(this, 'constructor');
  cx = typeof cx !== 'undefined' ? cx : 0;
  cy = typeof cy !== 'undefined' ? cy : 0;
  r = typeof r !== 'undefined' ? r : 0;
  this.x = cx;
  this.y = cy;
  this.radius = r;
};
goog.inherits(org.apache.royale.svg.Circle, org.apache.royale.svg.GraphicShape);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.svg.Circle', org.apache.royale.svg.Circle);


/**
 * @private
 * @type {number}
 */
org.apache.royale.svg.Circle.prototype.org_apache_royale_svg_Circle__radius;


/**
 * @private
 * @type {org.apache.royale.core.WrappedHTMLElement}
 */
org.apache.royale.svg.Circle.prototype.org_apache_royale_svg_Circle__circle;


/**
 *  Draw the circle.
 *  @asparam cx The x location of the center of the circle
 *  @asparam cy The y location of the center of the circle.
 *  @asparam radius The radius of the circle.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 *  @royaleignorecoercion SVGCircleElement
 * @export
 * @param {number} cx
 * @param {number} cy
 * @param {number} radius
 */
org.apache.royale.svg.Circle.prototype.drawCircle = function(cx, cy, radius) {
  
  var /** @type {string} */ style = this.getStyleStr();
  if (this.org_apache_royale_svg_Circle__circle == null) {
    this.org_apache_royale_svg_Circle__circle = org.apache.royale.html.util.createSVG('circle');
    this.org_apache_royale_svg_Circle__circle.royale_wrapper = this;
    this.element.appendChild(this.org_apache_royale_svg_Circle__circle);
  }
  this.org_apache_royale_svg_Circle__circle.setAttribute('style', style);
  if (this.stroke) {
    this.org_apache_royale_svg_Circle__circle.setAttribute('cx', radius + this.stroke.weight);
    this.org_apache_royale_svg_Circle__circle.setAttribute('cy', radius + this.stroke.weight);
  } else {
    this.org_apache_royale_svg_Circle__circle.setAttribute('cx', radius);
    this.org_apache_royale_svg_Circle__circle.setAttribute('cy', radius);
  }
  this.org_apache_royale_svg_Circle__circle.setAttribute('r', radius);
  this.resize(this.x - radius, this.y - radius);
};


/**
 * @protected
 * @override
 */
org.apache.royale.svg.Circle.prototype.drawImpl = function() {
  this.drawCircle(0, 0, this.radius);
};


/**
 * @export
 */
org.apache.royale.svg.Circle.prototype.draw = function() {
  this.drawImpl();
};


org.apache.royale.svg.Circle.prototype.get__radius = function() {
  return this.org_apache_royale_svg_Circle__radius;
};


org.apache.royale.svg.Circle.prototype.set__radius = function(value) {
  this.org_apache_royale_svg_Circle__radius = value;
  this.updateView();
};


org.apache.royale.svg.Circle.prototype.get__width = function() {
  return this.org_apache_royale_svg_Circle__radius * 2;
};


org.apache.royale.svg.Circle.prototype.set__width = function(value) {
  this.radius = value / 2;
};


org.apache.royale.svg.Circle.prototype.get__height = function() {
  return this.org_apache_royale_svg_Circle__radius * 2;
};


org.apache.royale.svg.Circle.prototype.set__height = function(value) {
  this.radius = value / 2;
};


Object.defineProperties(org.apache.royale.svg.Circle.prototype, /** @lends {org.apache.royale.svg.Circle.prototype} */ {
/**
  * @export
  * @type {number} */
radius: {
get: org.apache.royale.svg.Circle.prototype.get__radius,
set: org.apache.royale.svg.Circle.prototype.set__radius},
/**
  * @export
  * @type {number} */
width: {
get: org.apache.royale.svg.Circle.prototype.get__width,
set: org.apache.royale.svg.Circle.prototype.set__width},
/**
  * @export
  * @type {number} */
height: {
get: org.apache.royale.svg.Circle.prototype.get__height,
set: org.apache.royale.svg.Circle.prototype.set__height}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.svg.Circle.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'Circle', qName: 'org.apache.royale.svg.Circle', kind: 'class' }], interfaces: [org.apache.royale.graphics.ICircle, org.apache.royale.graphics.IDrawable] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.svg.Circle.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'radius': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.svg.Circle'},
        'width': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.svg.Circle'},
        'height': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.svg.Circle'}
      };
    },
    methods: function () {
      return {
        'Circle': { type: '', declaredBy: 'org.apache.royale.svg.Circle', parameters: function () { return [ 'Number', true ,'Number', true ,'Number', true ]; }},
        'drawCircle': { type: 'void', declaredBy: 'org.apache.royale.svg.Circle', parameters: function () { return [ 'Number', false ,'Number', false ,'Number', false ]; }},
        'draw': { type: 'void', declaredBy: 'org.apache.royale.svg.Circle'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.svg.Circle.prototype.ROYALE_COMPILE_FLAGS = 10;