/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/controllers/ListMultiSelectionMouseController.as
 * org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController');

goog.require('org.apache.royale.core.IIndexedItemRenderer');
goog.require('org.apache.royale.core.IItemRendererOwnerView');
goog.require('org.apache.royale.core.IMultiSelectionModel');
goog.require('org.apache.royale.core.IRollOverModel');
goog.require('org.apache.royale.core.ISelectableItemRenderer');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.events.ItemAddedEvent');
goog.require('org.apache.royale.events.ItemRemovedEvent');
goog.require('org.apache.royale.events.MultiSelectionItemClickedEvent');
goog.require('org.apache.royale.html.beads.IListView');
goog.require('org.apache.royale.utils.getSelectionRenderBead');
goog.require('org.apache.royale.utils.sendEvent');
goog.require('org.apache.royale.core.IBeadController');
goog.require('org.apache.royale.utils.Language');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.7
 * @constructor
 * @implements {org.apache.royale.core.IBeadController}
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController = function() {
};


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController', org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController);


/**
 * @protected
 * @type {org.apache.royale.core.IMultiSelectionModel}
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.listModel;


/**
 * @protected
 * @type {org.apache.royale.html.beads.IListView}
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.listView;


/**
 * @protected
 * @type {org.apache.royale.core.IItemRendererOwnerView}
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.dataGroup;


/**
 * @private
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.org_apache_royale_html_beads_controllers_ListMultiSelectionMouseController__strand;


/**
 * @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @protected
 * @param {org.apache.royale.events.ItemAddedEvent} event
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.handleItemAdded = function(event) {
  event.item.addEventListener("itemClicked", org.apache.royale.utils.Language.closure(this.selectedHandler, this, 'selectedHandler'));
  event.item.addEventListener("itemRollOver", org.apache.royale.utils.Language.closure(this.rolloverHandler, this, 'rolloverHandler'));
  event.item.addEventListener("itemRollOut", org.apache.royale.utils.Language.closure(this.rolloutHandler, this, 'rolloutHandler'));
};


/**
 * @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @protected
 * @param {org.apache.royale.events.ItemRemovedEvent} event
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.handleItemRemoved = function(event) {
  event.item.removeEventListener("itemClicked", org.apache.royale.utils.Language.closure(this.selectedHandler, this, 'selectedHandler'));
  event.item.removeEventListener("itemRollOver", org.apache.royale.utils.Language.closure(this.rolloverHandler, this, 'rolloverHandler'));
  event.item.removeEventListener("itemRollOut", org.apache.royale.utils.Language.closure(this.rolloutHandler, this, 'rolloutHandler'));
};


/**
 * @protected
 * @param {org.apache.royale.events.MultiSelectionItemClickedEvent} event
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.selectedHandler = function(event) {
  var /** @type {Array} */ selectedIndices = [];
  var /** @type {Array} */ newIndices;
  if (!(event.ctrlKey || event.shiftKey) || !this.listModel.selectedIndices || this.listModel.selectedIndices.length == 0) {
    newIndices = [event.index];
  } else if (event.ctrlKey) {
    newIndices = this.listModel.selectedIndices.concat();
    var /** @type {number} */ locationInSelectionList = (newIndices.indexOf(event.index)) >> 0;
    if (locationInSelectionList < 0) {
      newIndices.push(event.index);
    } else {
      newIndices.splice(locationInSelectionList, 1);
    }
  } else if (event.shiftKey) {
    newIndices = [];
    var /** @type {number} */ min = this.org_apache_royale_html_beads_controllers_ListMultiSelectionMouseController_getMin(this.listModel.selectedIndices);
    var /** @type {number} */ max = this.org_apache_royale_html_beads_controllers_ListMultiSelectionMouseController_getMax(this.listModel.selectedIndices);
    var /** @type {number} */ from = (Math.min(min, event.index)) >> 0;
    var /** @type {number} */ to = (event.index > min ? event.index : min) >> 0;
    while (from <= to) {
      newIndices.push(from++);
    }
  }
  this.listModel.selectedIndices = newIndices;
  org.apache.royale.utils.sendEvent(this.listView.host, "change");
};


/**
 * @private
 * @param {Array} value
 * @return {number}
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.org_apache_royale_html_beads_controllers_ListMultiSelectionMouseController_getMin = function(value) {
  var /** @type {number} */ result = org.apache.royale.utils.Language._int(value[0]);
  for (var /** @type {number} */ i = 0; i < value.length; i++) {
    if (value[i] < result) {
      result = (value[i]) >> 0;
    }
  }
  return result;
};


/**
 * @private
 * @param {Array} value
 * @return {number}
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.org_apache_royale_html_beads_controllers_ListMultiSelectionMouseController_getMax = function(value) {
  var /** @type {number} */ result = org.apache.royale.utils.Language._int(value[0]);
  for (var /** @type {number} */ i = 0; i < value.length; i++) {
    if (value[i] > result) {
      result = (value[i]) >> 0;
    }
  }
  return result;
};


/**
 * @royaleemitcoercion org.apache.royale.core.IIndexedItemRenderer
 * @royaleignorecoercion org.apache.royale.core.IRollOverModel
 * @protected
 * @param {Object} event
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.rolloverHandler = function(event) {
  var /** @type {org.apache.royale.core.IIndexedItemRenderer} */ renderer = org.apache.royale.utils.Language.as(event.currentTarget, org.apache.royale.core.IIndexedItemRenderer);
  if (renderer) {
    this.listModel.rollOverIndex = renderer.index;
  }
};


/**
 * @royaleemitcoercion org.apache.royale.core.IIndexedItemRenderer
 * @royaleignorecoercion org.apache.royale.core.IRollOverModel
 * @protected
 * @param {Object} event
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.rolloutHandler = function(event) {
  var /** @type {org.apache.royale.core.IIndexedItemRenderer} */ renderer = org.apache.royale.utils.Language.as(event.currentTarget, org.apache.royale.core.IIndexedItemRenderer);
  if (renderer) {
    if (org.apache.royale.utils.Language.is(renderer, org.apache.royale.core.IStrand)) {
      var /** @type {Object} */ selectionBead = org.apache.royale.utils.getSelectionRenderBead(renderer);
      if (selectionBead) {
        selectionBead.hovered = false;
        selectionBead.down = false;
      }
    }
    this.listModel.rollOverIndex = -1;
  }
};


org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.set__strand = function(value) {
  this.org_apache_royale_html_beads_controllers_ListMultiSelectionMouseController__strand = value;
  this.listModel = value.getBeadByType(org.apache.royale.core.IMultiSelectionModel);
  this.listView = value.getBeadByType(org.apache.royale.html.beads.IListView);
  this.org_apache_royale_html_beads_controllers_ListMultiSelectionMouseController__strand.addEventListener("itemAdded", org.apache.royale.utils.Language.closure(this.handleItemAdded, this, 'handleItemAdded'));
  this.org_apache_royale_html_beads_controllers_ListMultiSelectionMouseController__strand.addEventListener("itemRemoved", org.apache.royale.utils.Language.closure(this.handleItemRemoved, this, 'handleItemRemoved'));
};


Object.defineProperties(org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype, /** @lends {org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'ListMultiSelectionMouseController', qName: 'org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController', kind: 'class' }], interfaces: [org.apache.royale.core.IBeadController] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController'}
      };
    },
    methods: function () {
      return {
        'ListMultiSelectionMouseController': { type: '', declaredBy: 'org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.controllers.ListMultiSelectionMouseController.prototype.ROYALE_COMPILE_FLAGS = 10;