/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/TreeGridView.as
 * org.apache.royale.html.beads.TreeGridView
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.TreeGridView');

goog.require('org.apache.royale.core.IBeadLayout');
goog.require('org.apache.royale.core.IBeadModel');
goog.require('org.apache.royale.core.IDataGridModel');
goog.require('org.apache.royale.core.IDataGridPresentationModel');
goog.require('org.apache.royale.core.ILayoutChild');
goog.require('org.apache.royale.core.IParent');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.core.ValuesManager');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.html.DataGridButtonBar');
goog.require('org.apache.royale.html.List');
goog.require('org.apache.royale.html.Tree');
goog.require('org.apache.royale.html.TreeGrid');
goog.require('org.apache.royale.html.beads.DataItemRendererFactoryForCollectionView');
goog.require('org.apache.royale.html.beads.GroupView');
goog.require('org.apache.royale.html.beads.TreeGridListArea');
goog.require('org.apache.royale.html.beads.layouts.ButtonBarLayout');
goog.require('org.apache.royale.html.beads.layouts.TreeGridLayout');
goog.require('org.apache.royale.html.beads.models.ButtonBarModel');
goog.require('org.apache.royale.html.beads.models.SingleSelectionCollectionViewModel');
goog.require('org.apache.royale.html.supportClasses.IDataGridColumn');
goog.require('org.apache.royale.html.supportClasses.Viewport');
goog.require('org.apache.royale.utils.sendStrandEvent');
goog.require('org.apache.royale.core.IBeadView');
goog.require('org.apache.royale.html.beads.IDataGridView');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @constructor
 * @extends {org.apache.royale.html.beads.GroupView}
 * @implements {org.apache.royale.core.IBeadView}
 * @implements {org.apache.royale.html.beads.IDataGridView}
 */
org.apache.royale.html.beads.TreeGridView = function() {
  org.apache.royale.html.beads.TreeGridView.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.TreeGridView, org.apache.royale.html.beads.GroupView);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.TreeGridView', org.apache.royale.html.beads.TreeGridView);


/**
 * @private
 * @type {org.apache.royale.html.DataGridButtonBar}
 */
org.apache.royale.html.beads.TreeGridView.prototype.org_apache_royale_html_beads_TreeGridView__header;


/**
 * @private
 * @type {org.apache.royale.core.IUIBase}
 */
org.apache.royale.html.beads.TreeGridView.prototype.org_apache_royale_html_beads_TreeGridView__listArea;


/**
 * @private
 * @type {Array}
 */
org.apache.royale.html.beads.TreeGridView.prototype.org_apache_royale_html_beads_TreeGridView__lists;


/**
 * @export
 */
org.apache.royale.html.beads.TreeGridView.prototype.refreshContent = function() {
  this.finishSetup(null);
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.IBeadModel
 * @royaleignorecoercion org.apache.royale.core.ILayoutChild
 * @royaleignorecoercion org.apache.royale.core.IDataGridModel
 * @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @royaleignorecoercion org.apache.royale.html.supportClasses.IDataGridColumn
 * @royaleignorecoercion org.apache.royale.html.TreeGrid
 * @royaleignorecoercion org.apache.royale.core.IDataGridPresentationModel
 * @protected
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.TreeGridView.prototype.finishSetup = function(event) {
  var /** @type {Object} */ host = this._strand;
  var /** @type {Object} */ presentationModel = host.presentationModel;
  var /** @type {Object} */ sharedModel = host.model;
  sharedModel.addEventListener("dataProviderChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_TreeGridView_handleDataProviderChanged, this, 'org_apache_royale_html_beads_TreeGridView_handleDataProviderChanged'));
  sharedModel.addEventListener("selectedIndexChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_TreeGridView_handleSelectedIndexChanged, this, 'org_apache_royale_html_beads_TreeGridView_handleSelectedIndexChanged'));
  this.org_apache_royale_html_beads_TreeGridView__header = new org.apache.royale.html.DataGridButtonBar();
  this.org_apache_royale_html_beads_TreeGridView__header.percentWidth = 100;
  this.org_apache_royale_html_beads_TreeGridView__header.dataProvider = sharedModel.columns;
  this.org_apache_royale_html_beads_TreeGridView__header.labelField = "label";
  sharedModel.headerModel = this.org_apache_royale_html_beads_TreeGridView__header.model;
  this.org_apache_royale_html_beads_TreeGridView__listArea = new org.apache.royale.html.beads.TreeGridListArea();
  this.org_apache_royale_html_beads_TreeGridView__listArea.percentWidth = 100;
  this.org_apache_royale_html_beads_TreeGridView_createColumns();
  var /** @type {Array} */ buttonWidths = [];
  var /** @type {number} */ marginBorderOffset = 0;
  
  for (var /** @type {number} */ i = 0; i < sharedModel.columns.length; i++) {
    var /** @type {Object} */ dgc = sharedModel.columns[i];
    var /** @type {number} */ colWidth = dgc.columnWidth - marginBorderOffset;
    buttonWidths.push(colWidth);
    var /** @type {org.apache.royale.core.UIBase} */ list = org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_TreeGridView__lists[i], org.apache.royale.core.UIBase);
    if (!isNaN(colWidth)) {
      list.width = Number(colWidth - marginBorderOffset);
    }
  }
  var /** @type {org.apache.royale.html.beads.layouts.ButtonBarLayout} */ bblayout = new org.apache.royale.html.beads.layouts.ButtonBarLayout();
  this.org_apache_royale_html_beads_TreeGridView__header.buttonWidths = buttonWidths;
  this.org_apache_royale_html_beads_TreeGridView__header.widthType = org.apache.royale.html.beads.models.ButtonBarModel.PIXEL_WIDTHS;
  this.org_apache_royale_html_beads_TreeGridView__header.addBead(bblayout);
  this.org_apache_royale_html_beads_TreeGridView__header.addBead(new org.apache.royale.html.supportClasses.Viewport());
  host.addElement(this.org_apache_royale_html_beads_TreeGridView__header);
  host.addElement(this.org_apache_royale_html_beads_TreeGridView__listArea);
  this.org_apache_royale_html_beads_TreeGridView_handleDataProviderChanged(event);
  this.listenOnStrand("widthChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_TreeGridView_handleSizeChanges, this, 'org_apache_royale_html_beads_TreeGridView_handleSizeChanges'));
  this.listenOnStrand("heightChanged", org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_TreeGridView_handleSizeChanges, this, 'org_apache_royale_html_beads_TreeGridView_handleSizeChanges'));
  org.apache.royale.utils.sendStrandEvent(this._strand, "dataGridViewCreated");
  org.apache.royale.utils.sendStrandEvent(this._strand, "layoutNeeded");
};


/**
 * @asprivate
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.TreeGridView.prototype.org_apache_royale_html_beads_TreeGridView_handleSizeChanges = function(event) {
  this.org_apache_royale_html_beads_TreeGridView__header.dispatchEvent(new org.apache.royale.events.Event("layoutChanged"));
  this.org_apache_royale_html_beads_TreeGridView__listArea.dispatchEvent(new org.apache.royale.events.Event("layoutChanged"));
};


/**
 * @asprivate
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.TreeGridView.prototype.org_apache_royale_html_beads_TreeGridView_handleDataProviderChanged = function(event) {
  org.apache.royale.utils.sendStrandEvent(this._strand, "layoutNeeded");
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.IDataGridModel
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.TreeGridView.prototype.org_apache_royale_html_beads_TreeGridView_handleSelectedIndexChanged = function(event) {
  var /** @type {Object} */ sharedModel = this._strand.getBeadByType(org.apache.royale.core.IBeadModel);
  var /** @type {number} */ newIndex = sharedModel.selectedIndex;
  for (var /** @type {number} */ i = 0; i < this.org_apache_royale_html_beads_TreeGridView__lists.length; i++) {
    if (org.apache.royale.utils.Language.is(this.org_apache_royale_html_beads_TreeGridView__lists[i], org.apache.royale.html.List)) {
      org.apache.royale.utils.Language.as(this.org_apache_royale_html_beads_TreeGridView__lists[i], org.apache.royale.html.List).selectedIndex = newIndex;
    }
  }
};


/**
 * @asprivate
 * @royaleignorecoercion org.apache.royale.core.IDataGridModel
 * @private
 * @param {org.apache.royale.events.Event} event
 */
org.apache.royale.html.beads.TreeGridView.prototype.org_apache_royale_html_beads_TreeGridView_handleColumnListChange = function(event) {
  var /** @type {Object} */ sharedModel = this._strand.getBeadByType(org.apache.royale.core.IBeadModel);
  if (org.apache.royale.utils.Language.is(event.target, org.apache.royale.html.List)) {
    var /** @type {org.apache.royale.html.List} */ list = org.apache.royale.utils.Language.as(event.target, org.apache.royale.html.List);
    sharedModel.selectedIndex = list.selectedIndex;
  } else {
    return;
  }
  org.apache.royale.utils.sendStrandEvent(this._strand, 'change');
};


/**
 * @asprivate
 * @royaleignorecoercion Class
 * @royaleignorecoercion org.apache.royale.core.IDataGridModel
 * @royaleignorecoercion org.apache.royale.core.IParent
 * @royaleignorecoercion org.apache.royale.html.supportClasses.IDataGridColumn
 * @royaleignorecoercion org.apache.royale.core.IDataGridPresentationModel
 * @private
 */
org.apache.royale.html.beads.TreeGridView.prototype.org_apache_royale_html_beads_TreeGridView_createColumns = function() {
  var /** @type {org.apache.royale.html.TreeGrid} */ host = org.apache.royale.utils.Language.as(this._strand, org.apache.royale.html.TreeGrid);
  var /** @type {Object} */ presentationModel = host.presentationModel;
  var /** @type {Object} */ sharedModel = host.model;
  this.org_apache_royale_html_beads_TreeGridView__lists = new Array();
  for (var /** @type {number} */ i = 0; i < sharedModel.columns.length; i++) {
    var /** @type {Object} */ columnDef = sharedModel.columns[i];
    var /** @type {string} */ columnClassName = columnDef.className;
    var /** @type {string} */ useClassName = columnClassName ? " " + columnClassName : "";
    var /** @type {org.apache.royale.html.List} */ column = org.apache.royale.utils.Language.as(columnDef.createColumn(), org.apache.royale.html.List);
    if (i == 0)
      column.className = "first" + useClassName;
    else if (i == sharedModel.columns.length - 1)
      column.className = "last" + useClassName;
    else
      column.className = "middle" + useClassName;
    if (!org.apache.royale.utils.Language.is(column, org.apache.royale.html.Tree)) {
      column.model = new org.apache.royale.html.beads.models.SingleSelectionCollectionViewModel();
      column.addBead(new org.apache.royale.html.beads.DataItemRendererFactoryForCollectionView());
    }
    column.id = "treeGridColumn" + String(i);
    column.dataProvider = sharedModel.dataProvider;
    column.labelField = columnDef.dataField;
    column.itemRenderer = columnDef.itemRenderer;
    column.addBead(presentationModel);
    column.addBead(new org.apache.royale.html.supportClasses.Viewport());
    column.addEventListener('change', org.apache.royale.utils.Language.closure(this.org_apache_royale_html_beads_TreeGridView_handleColumnListChange, this, 'org_apache_royale_html_beads_TreeGridView_handleColumnListChange'));
    this.org_apache_royale_html_beads_TreeGridView__listArea.addElement(column);
    this.org_apache_royale_html_beads_TreeGridView__lists.push(column);
  }
  org.apache.royale.utils.sendStrandEvent(this._strand, "layoutNeeded");
};


org.apache.royale.html.beads.TreeGridView.prototype.get__columnLists = function() {
  return this.org_apache_royale_html_beads_TreeGridView__lists;
};


org.apache.royale.html.beads.TreeGridView.prototype.get__listArea = function() {
  return this.org_apache_royale_html_beads_TreeGridView__listArea;
};


org.apache.royale.html.beads.TreeGridView.prototype.get__header = function() {
  return this.org_apache_royale_html_beads_TreeGridView__header;
};


org.apache.royale.html.beads.TreeGridView.prototype.set__strand = function(value) {
  org.apache.royale.html.beads.TreeGridView.superClass_.set__strand.apply(this, [ value] );
  this._strand = value;
  var /** @type {org.apache.royale.core.IBeadLayout} */ layout = this._strand.getBeadByType(org.apache.royale.html.beads.layouts.TreeGridLayout);
  if (layout == null) {
    var /** @type {Object} */ layoutClass =  /** @type {Object|null} */ (org.apache.royale.core.ValuesManager["valuesImpl"].getValue(this._strand, "iBeadLayout"));
    if (layoutClass != null) {
      layout = new layoutClass();
    } else {
      layout = new org.apache.royale.html.beads.layouts.TreeGridLayout();
    }
    this._strand.addBead(layout);
  }
  this.listenOnStrand("beadsAdded", org.apache.royale.utils.Language.closure(this.finishSetup, this, 'finishSetup'));
};


Object.defineProperties(org.apache.royale.html.beads.TreeGridView.prototype, /** @lends {org.apache.royale.html.beads.TreeGridView.prototype} */ {
/**
  * @export
  * @type {Array} */
columnLists: {
get: org.apache.royale.html.beads.TreeGridView.prototype.get__columnLists},
/**
  * @export
  * @type {org.apache.royale.core.IUIBase} */
listArea: {
get: org.apache.royale.html.beads.TreeGridView.prototype.get__listArea},
/**
  * @export
  * @type {org.apache.royale.core.IUIBase} */
header: {
get: org.apache.royale.html.beads.TreeGridView.prototype.get__header},
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.TreeGridView.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.TreeGridView.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'TreeGridView', qName: 'org.apache.royale.html.beads.TreeGridView', kind: 'class' }], interfaces: [org.apache.royale.core.IBeadView, org.apache.royale.html.beads.IDataGridView] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.TreeGridView.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'columnLists': { type: 'Array', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.TreeGridView'},
        'listArea': { type: 'org.apache.royale.core.IUIBase', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.TreeGridView'},
        'header': { type: 'org.apache.royale.core.IUIBase', access: 'readonly', declaredBy: 'org.apache.royale.html.beads.TreeGridView'},
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.TreeGridView'}
      };
    },
    methods: function () {
      return {
        'TreeGridView': { type: '', declaredBy: 'org.apache.royale.html.beads.TreeGridView'},
        'refreshContent': { type: 'void', declaredBy: 'org.apache.royale.html.beads.TreeGridView'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.TreeGridView.prototype.ROYALE_COMPILE_FLAGS = 10;