/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/beads/DataItemRendererFactoryBase.as
 * org.apache.royale.html.beads.DataItemRendererFactoryBase
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.DataItemRendererFactoryBase');

goog.require('org.apache.royale.core.IIndexedItemRenderer');
goog.require('org.apache.royale.core.IIndexedItemRendererInitializer');
goog.require('org.apache.royale.core.IItemRendererOwnerView');
goog.require('org.apache.royale.core.IStrandWithModelView');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.html.beads.IListView');
goog.require('org.apache.royale.html.beads.ItemRendererFactoryBase');
goog.require('org.apache.royale.utils.sendStrandEvent');
goog.require('org.apache.royale.core.IDataProviderItemRendererMapper');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 * @constructor
 * @extends {org.apache.royale.html.beads.ItemRendererFactoryBase}
 * @implements {org.apache.royale.core.IDataProviderItemRendererMapper}
 * @param {Object=} target
 */
org.apache.royale.html.beads.DataItemRendererFactoryBase = function(target) {
  target = typeof target !== 'undefined' ? target : null;
  org.apache.royale.html.beads.DataItemRendererFactoryBase.base(this, 'constructor', target);
};
goog.inherits(org.apache.royale.html.beads.DataItemRendererFactoryBase, org.apache.royale.html.beads.ItemRendererFactoryBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.DataItemRendererFactoryBase', org.apache.royale.html.beads.DataItemRendererFactoryBase);


/**
 * @protected
 * @type {Object}
 */
org.apache.royale.html.beads.DataItemRendererFactoryBase.prototype.dp;


/**
 *  This Factory deletes all renderers, and generates a renderer
 *  for every data provider item.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.8
 *  @royaleignorecoercion Array
 *  @royaleignorecoercion org.apache.royale.core.IStrandWithModelView
 *  @royaleignorecoercion org.apache.royale.html.beads.IListView
 *  @royaleignorecoercion org.apache.royale.core.IIndexedItemRenderer
 *  @royaleignorecoercion org.apache.royale.core.IIndexedItemRendererInitializer
 * @protected
 * @override
 */
org.apache.royale.html.beads.DataItemRendererFactoryBase.prototype.dataProviderChangeHandler = function(event) {
  var /** @type {Object} */ view = this._strand.view;
  var /** @type {org.apache.royale.core.IItemRendererOwnerView} */ dataGroup = view.dataGroup;
  this.removeAllItemRenderers(dataGroup);
  this.dp = this.dataProviderModel.dataProvider;
  if (!this.dp)
    return;
  var /** @type {number} */ n = this.dataProviderLength;
  for (var /** @type {number} */ i = 0; i < n; i++) {
    var /** @type {Object} */ ir = this.itemRendererFactory.createItemRenderer();
    dataGroup.addItemRenderer(ir, false);
    var /** @type {Object} */ data = this.getItemAt(i);
    this.itemRendererInitializer.initializeIndexedItemRenderer(ir, data, i);
    ir.data = data;
  }
  this.dispatchItemCreatedEvent();
};


/**
 * @protected
 */
org.apache.royale.html.beads.DataItemRendererFactoryBase.prototype.dispatchItemCreatedEvent = function() {
  org.apache.royale.utils.sendStrandEvent(this._strand, "itemsCreated");
};


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.DataItemRendererFactoryBase.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'DataItemRendererFactoryBase', qName: 'org.apache.royale.html.beads.DataItemRendererFactoryBase', kind: 'class' }], interfaces: [org.apache.royale.core.IDataProviderItemRendererMapper] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.DataItemRendererFactoryBase.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    methods: function () {
      return {
        'DataItemRendererFactoryBase': { type: '', declaredBy: 'org.apache.royale.html.beads.DataItemRendererFactoryBase', parameters: function () { return [ 'Object', true ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.beads.DataItemRendererFactoryBase.prototype.ROYALE_COMPILE_FLAGS = 10;