/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/Slider.as
 * org.apache.royale.html.Slider
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.Slider');

goog.require('org.apache.royale.core.IRangeModel');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.html.util.addElementToWrapper');
goog.require('org.apache.royale.utils.Language');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @extends {org.apache.royale.core.UIBase}
 */
org.apache.royale.html.Slider = function() {
  org.apache.royale.html.Slider.base(this, 'constructor');
  this.typeNames = "Slider";
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).value = 0;
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).minimum = 0;
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).maximum = 100;
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).stepSize = 1;
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).snapInterval = 1;
};
goog.inherits(org.apache.royale.html.Slider, org.apache.royale.core.UIBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.Slider', org.apache.royale.html.Slider);


/**
 * @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.royale.html.Slider.prototype.createElement = function() {
  org.apache.royale.html.util.addElementToWrapper(this, 'div');
  this.element.style.width = '100px';
  this.element.style.height = '30px';
  return this.element;
};


/**
 * @asprivate
 * @export
 * @param {number} value
 * @return {number}
 */
org.apache.royale.html.Slider.prototype.snap = function(value) {
  var /** @type {number} */ si = this.snapInterval;
  var /** @type {number} */ n = Math.round((value - this.minimum) / si) * si + this.minimum;
  if (value > 0) {
    if (value - n < n + si - value)
      return n;
    return n + si;
  }
  if (value - n > n + si - value)
    return n + si;
  return n;
};


org.apache.royale.html.Slider.prototype.get__value = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).value;
};


org.apache.royale.html.Slider.prototype.set__value = function(newValue) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).value = newValue;
};


org.apache.royale.html.Slider.prototype.get__minimum = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).minimum;
};


org.apache.royale.html.Slider.prototype.set__minimum = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).minimum = value;
};


org.apache.royale.html.Slider.prototype.get__maximum = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).maximum;
};


org.apache.royale.html.Slider.prototype.set__maximum = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).maximum = value;
};


org.apache.royale.html.Slider.prototype.get__snapInterval = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).snapInterval;
};


org.apache.royale.html.Slider.prototype.set__snapInterval = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).snapInterval = value;
};


org.apache.royale.html.Slider.prototype.get__stepSize = function() {
  return org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).stepSize;
};


org.apache.royale.html.Slider.prototype.set__stepSize = function(value) {
  org.apache.royale.utils.Language.as(this.model, org.apache.royale.core.IRangeModel, true).stepSize = value;
};


Object.defineProperties(org.apache.royale.html.Slider.prototype, /** @lends {org.apache.royale.html.Slider.prototype} */ {
/**
  * @export
  * @type {number} */
value: {
get: org.apache.royale.html.Slider.prototype.get__value,
set: org.apache.royale.html.Slider.prototype.set__value},
/**
  * @export
  * @type {number} */
minimum: {
get: org.apache.royale.html.Slider.prototype.get__minimum,
set: org.apache.royale.html.Slider.prototype.set__minimum},
/**
  * @export
  * @type {number} */
maximum: {
get: org.apache.royale.html.Slider.prototype.get__maximum,
set: org.apache.royale.html.Slider.prototype.set__maximum},
/**
  * @export
  * @type {number} */
snapInterval: {
get: org.apache.royale.html.Slider.prototype.get__snapInterval,
set: org.apache.royale.html.Slider.prototype.set__snapInterval},
/**
  * @export
  * @type {number} */
stepSize: {
get: org.apache.royale.html.Slider.prototype.get__stepSize,
set: org.apache.royale.html.Slider.prototype.set__stepSize}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.Slider.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'Slider', qName: 'org.apache.royale.html.Slider', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.Slider.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'value': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.html.Slider', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'valueChange' } ] } ]; }},
        'minimum': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.html.Slider'},
        'maximum': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.html.Slider'},
        'snapInterval': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.html.Slider'},
        'stepSize': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.html.Slider'}
      };
    },
    methods: function () {
      return {
        'Slider': { type: '', declaredBy: 'org.apache.royale.html.Slider'},
        'snap': { type: 'Number', declaredBy: 'org.apache.royale.html.Slider', parameters: function () { return [ 'Number', false ]; }}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.Slider.prototype.ROYALE_COMPILE_FLAGS = 10;