/**
 * Generated by Apache Royale Compiler from org/apache/royale/html/DropDownList.as
 * org.apache.royale.html.DropDownList
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.DropDownList');

goog.require('org.apache.royale.core.ISelectionModel');
goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.html.Button');
goog.require('org.apache.royale.html.beads.models.ArraySelectionModel');
goog.require('org.apache.royale.html.util.addElementToWrapper');
goog.require('org.apache.royale.utils.Language');



/**
 *  Constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 * @constructor
 * @extends {org.apache.royale.html.Button}
 */
org.apache.royale.html.DropDownList = function() {
  org.apache.royale.html.DropDownList.base(this, 'constructor');
  this.model = new org.apache.royale.html.beads.models.ArraySelectionModel();
};
goog.inherits(org.apache.royale.html.DropDownList, org.apache.royale.html.Button);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.DropDownList', org.apache.royale.html.DropDownList);


/**
 * @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @royaleignorecoercion HTMLSelectElement
 * @protected
 * @override
 */
org.apache.royale.html.DropDownList.prototype.createElement = function() {
  org.apache.royale.html.util.addElementToWrapper(this, 'select');
  this.element.size = 1;
  goog.events.listen(this.element, 'change', org.apache.royale.utils.Language.closure(this.changeHandler, this, 'changeHandler'));
  return this.element;
};


/**
 * @royaleignorecoercion HTMLSelectElement
 * @protected
 * @param {Event} event
 */
org.apache.royale.html.DropDownList.prototype.changeHandler = function(event) {
  this.model.selectedIndex = this.element.selectedIndex;
};


org.apache.royale.html.DropDownList.prototype.get__dataProvider = function() {
  return this.model.dataProvider;
};


org.apache.royale.html.DropDownList.prototype.set__dataProvider = function(value) {
  var /** @type {number} */ i = 0;
  var /** @type {number} */ n = 0;
  this.model.dataProvider = value;
  var /** @type {HTMLOptionsCollection} */ dp;
  //var /** @type {number} */ i = 0;
  //var /** @type {number} */ n = 0;
  var /** @type {HTMLOptionElement} */ opt;
  var /** @type {HTMLSelectElement} */ dd = this.element;
  dp = dd.options;
  n = (dp.length) >> 0;
  for (i = 0; i < n; i++) {
    dd.remove(0);
  }
  if (!value)
    return;
  var /** @type {string} */ lf = this.labelField;
  n = (value.length) >> 0;
  for (i = 0; i < n; i++) {
    opt = document.createElement('option');
    var /** @type {string} */ optionText = org.apache.royale.utils.Language.string(lf ? value[i][lf] : value[i]);
    if (!optionText || optionText.indexOf("-") == 0) {
      opt.disabled = true;
      opt.text = "──────────";
    } else {
      opt.text = optionText;
    }
    dd.add(opt, null);
  }
};


org.apache.royale.html.DropDownList.prototype.get__selectedIndex = function() {
  return this.model.selectedIndex;
};


org.apache.royale.html.DropDownList.prototype.set__selectedIndex = function(value) {
  this.model.selectedIndex = value;
  this.element.selectedIndex = this.model.selectedIndex;
};


org.apache.royale.html.DropDownList.prototype.get__selectedItem = function() {
  return this.model.selectedItem;
};


org.apache.royale.html.DropDownList.prototype.set__selectedItem = function(value) {
  this.model.selectedItem = value;
  this.element.selectedIndex = this.model.selectedIndex;
};


org.apache.royale.html.DropDownList.prototype.get__labelField = function() {
  return this.model.labelField;
};


org.apache.royale.html.DropDownList.prototype.set__labelField = function(value) {
  this.model.labelField = value;
};


Object.defineProperties(org.apache.royale.html.DropDownList.prototype, /** @lends {org.apache.royale.html.DropDownList.prototype} */ {
/**
  * @export
  * @type {Object} */
dataProvider: {
get: org.apache.royale.html.DropDownList.prototype.get__dataProvider,
set: org.apache.royale.html.DropDownList.prototype.set__dataProvider},
/**
  * @export
  * @type {number} */
selectedIndex: {
get: org.apache.royale.html.DropDownList.prototype.get__selectedIndex,
set: org.apache.royale.html.DropDownList.prototype.set__selectedIndex},
/**
  * @export
  * @type {Object} */
selectedItem: {
get: org.apache.royale.html.DropDownList.prototype.get__selectedItem,
set: org.apache.royale.html.DropDownList.prototype.set__selectedItem},
/**
  * @export
  * @type {string} */
labelField: {
get: org.apache.royale.html.DropDownList.prototype.get__labelField,
set: org.apache.royale.html.DropDownList.prototype.set__labelField}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.DropDownList.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'DropDownList', qName: 'org.apache.royale.html.DropDownList', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.DropDownList.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    accessors: function () {
      return {
        'dataProvider': { type: 'Object', access: 'readwrite', declaredBy: 'org.apache.royale.html.DropDownList'},
        'selectedIndex': { type: 'int', access: 'readwrite', declaredBy: 'org.apache.royale.html.DropDownList', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'change' } ] } ]; }},
        'selectedItem': { type: 'Object', access: 'readwrite', declaredBy: 'org.apache.royale.html.DropDownList', metadata: function () { return [ { name: 'Bindable', args: [ { key: '', value: 'change' } ] } ]; }},
        'labelField': { type: 'String', access: 'readwrite', declaredBy: 'org.apache.royale.html.DropDownList'}
      };
    },
    methods: function () {
      return {
        'DropDownList': { type: '', declaredBy: 'org.apache.royale.html.DropDownList'}
      };
    }
  };
};
/**
 * @const
 * @type {number}
 */
org.apache.royale.html.DropDownList.prototype.ROYALE_COMPILE_FLAGS = 10;