/**
 * Generated by Apache Royale Compiler from org\apache\royale\html\beads\controllers\MenuBarMouseController.as
 * org.apache.royale.html.beads.controllers.MenuBarMouseController
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.html.beads.controllers.MenuBarMouseController');

goog.require('org.apache.royale.core.IBeadModel');
goog.require('org.apache.royale.core.IFactory');
goog.require('org.apache.royale.core.IMenu');
goog.require('org.apache.royale.core.IMenuBarModel');
goog.require('org.apache.royale.core.IStrand');
goog.require('org.apache.royale.core.IUIBase');
goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.events.Event');
goog.require('org.apache.royale.events.IEventDispatcher');
goog.require('org.apache.royale.events.ItemAddedEvent');
goog.require('org.apache.royale.events.ItemClickedEvent');
goog.require('org.apache.royale.events.ItemRemovedEvent');
goog.require('org.apache.royale.html.beads.controllers.ListSingleSelectionMouseController');
goog.require('org.apache.royale.utils.UIUtils');
goog.require('org.apache.royale.utils.loadBeadFromValuesManager');
goog.require('org.apache.royale.utils.Language');



/**
 * Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @constructor
 * @extends {org.apache.royale.html.beads.controllers.ListSingleSelectionMouseController}
 */
org.apache.royale.html.beads.controllers.MenuBarMouseController = function() {
  org.apache.royale.html.beads.controllers.MenuBarMouseController.base(this, 'constructor');
};
goog.inherits(org.apache.royale.html.beads.controllers.MenuBarMouseController, org.apache.royale.html.beads.controllers.ListSingleSelectionMouseController);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.html.beads.controllers.MenuBarMouseController', org.apache.royale.html.beads.controllers.MenuBarMouseController);


/**
 * @protected
 * @type {org.apache.royale.core.IStrand}
 */
org.apache.royale.html.beads.controllers.MenuBarMouseController.prototype._strand;


/**
 * @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @protected
 * @override
 */
org.apache.royale.html.beads.controllers.MenuBarMouseController.prototype.handleItemAdded = function(event) {
  event.item.addEventListener("itemMouseDown", org.apache.royale.utils.Language.closure(this.selectedHandler, this, 'selectedHandler'));
  event.item.addEventListener("itemRollOver", org.apache.royale.utils.Language.closure(this.rolloverHandler, this, 'rolloverHandler'));
  event.item.addEventListener("itemRollOut", org.apache.royale.utils.Language.closure(this.rolloutHandler, this, 'rolloutHandler'));
};


/**
 * @royaleignorecoercion org.apache.royale.events.IEventDispatcher
 * @protected
 * @override
 */
org.apache.royale.html.beads.controllers.MenuBarMouseController.prototype.handleItemRemoved = function(event) {
  event.item.removeEventListener("itemMouseDown", org.apache.royale.utils.Language.closure(this.selectedHandler, this, 'selectedHandler'));
  event.item.removeEventListener("itemRollOver", org.apache.royale.utils.Language.closure(this.rolloverHandler, this, 'rolloverHandler'));
  event.item.removeEventListener("itemRollOut", org.apache.royale.utils.Language.closure(this.rolloutHandler, this, 'rolloutHandler'));
};


/**
 * Called when an item in the MenuBar is selected; it produces an IMenu below
 * the item selected.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9
 * @protected
 * @override
 */
org.apache.royale.html.beads.controllers.MenuBarMouseController.prototype.selectedHandler = function(event) {
  var /** @type {org.apache.royale.core.UIBase} */ host = org.apache.royale.utils.Language.as(org.apache.royale.utils.UIUtils.findPopUpHost(org.apache.royale.utils.Language.as(this._strand, org.apache.royale.core.IUIBase)), org.apache.royale.core.UIBase);
  host.dispatchEvent(new org.apache.royale.events.Event("hideMenus"));
  var /** @type {org.apache.royale.core.IUIBase} */ component = org.apache.royale.utils.Language.as(event.target, org.apache.royale.core.IUIBase);
  var /** @type {org.apache.royale.core.IFactory} */ menuFactory = org.apache.royale.utils.Language.as(org.apache.royale.utils.loadBeadFromValuesManager(org.apache.royale.core.IFactory, "iMenuFactory", this._strand), org.apache.royale.core.IFactory);
  var /** @type {org.apache.royale.core.IMenu} */ menu = org.apache.royale.utils.Language.as(menuFactory.newInstance(), org.apache.royale.core.IMenu);
  var /** @type {org.apache.royale.core.IMenuBarModel} */ model = org.apache.royale.utils.Language.as(this._strand.getBeadByType(org.apache.royale.core.IBeadModel), org.apache.royale.core.IMenuBarModel);
  menu.dataProvider = event.data[model.submenuField];
  menu.labelField = model.labelField;
  menu.submenuField = model.submenuField;
  menu.parentMenuBar = org.apache.royale.utils.Language.as(this._strand, org.apache.royale.events.IEventDispatcher);
  this.showMenu(menu, component);
};


/**
 * @protected
 * @param {org.apache.royale.core.IMenu} menu
 * @param {org.apache.royale.core.IUIBase} component
 */
org.apache.royale.html.beads.controllers.MenuBarMouseController.prototype.showMenu = function(menu, component) {
  menu.show(component, 0, component.height);
};


org.apache.royale.html.beads.controllers.MenuBarMouseController.prototype.set__strand = function(value) {
  this._strand = value;
  org.apache.royale.html.beads.controllers.MenuBarMouseController.superClass_.set__strand.apply(this, [ value] );
};


Object.defineProperties(org.apache.royale.html.beads.controllers.MenuBarMouseController.prototype, /** @lends {org.apache.royale.html.beads.controllers.MenuBarMouseController.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.IStrand} */
strand: {
set: org.apache.royale.html.beads.controllers.MenuBarMouseController.prototype.set__strand}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.html.beads.controllers.MenuBarMouseController.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'MenuBarMouseController', qName: 'org.apache.royale.html.beads.controllers.MenuBarMouseController', kind: 'class' }] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.html.beads.controllers.MenuBarMouseController.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'strand': { type: 'org.apache.royale.core.IStrand', access: 'writeonly', declaredBy: 'org.apache.royale.html.beads.controllers.MenuBarMouseController'}
      };
    },
    methods: function () {
      return {
        'MenuBarMouseController': { type: '', declaredBy: 'org.apache.royale.html.beads.controllers.MenuBarMouseController'}
      };
    }
  };
};