/**
 * Generated by Apache Royale Compiler from org\apache\royale\core\StyledUIBase.as
 * org.apache.royale.core.StyledUIBase
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.core.StyledUIBase');

goog.require('org.apache.royale.core.UIBase');
goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.html.util.addElementToWrapper');
goog.require('org.apache.royale.utils.ClassSelectorList');
goog.require('org.apache.royale.utils.IClassSelectorListSupport');



/**
 *  Constructor.
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.3
 * @constructor
 * @extends {org.apache.royale.core.UIBase}
 * @implements {org.apache.royale.utils.IClassSelectorListSupport}
 */
org.apache.royale.core.StyledUIBase = function() {
  this.classSelectorList = new org.apache.royale.utils.ClassSelectorList(this);
  org.apache.royale.core.StyledUIBase.base(this, 'constructor');
};
goog.inherits(org.apache.royale.core.StyledUIBase, org.apache.royale.core.UIBase);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.core.StyledUIBase', org.apache.royale.core.StyledUIBase);


/**
 * @private
 * @type {org.apache.royale.core.WrappedHTMLElement}
 */
org.apache.royale.core.StyledUIBase.prototype.org_apache_royale_core_StyledUIBase__positioner;


/**
 * @protected
 * @type {org.apache.royale.utils.ClassSelectorList}
 */
org.apache.royale.core.StyledUIBase.prototype.classSelectorList;


/**
 * @protected
 * @override
 */
org.apache.royale.core.StyledUIBase.prototype.setClassName = function(value) {
  this.classSelectorList.addNames(value);
};


/**
 * Add a class selector to the list.
 * 
 * @asparam name Name of selector to add.
 * 
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.3
 * @export
 * @param {string} name
 */
org.apache.royale.core.StyledUIBase.prototype.addClass = function(name) {
  this.classSelectorList.add(name);
};


/**
 * Removes a class selector from the list.
 * 
 * @asparam name Name of selector to remove.
 *
 * @royaleignorecoercion HTMLElement
 * @royaleignorecoercion DOMTokenList
 * 
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.3
 * @export
 * @param {string} name
 */
org.apache.royale.core.StyledUIBase.prototype.removeClass = function(name) {
  this.classSelectorList.remove(name);
};


/**
 * Add or remove a class selector to/from the list.
 * 
 * @asparam name Name of selector to add or remove.
 * @asparam value True to add, False to remove.
 * 
 * @langversion 3.0
 * @playerversion Flash 10.2
 * @playerversion AIR 2.6
 * @productversion Royale 0.9.3
 * @export
 * @param {string} name
 * @param {boolean} value
 */
org.apache.royale.core.StyledUIBase.prototype.toggleClass = function(name, value) {
  this.classSelectorList.toggle(name, value);
};


/**
 *  Search for the name in the element class list 
 *
 *  @asparam name Name of selector to find.
 *  @asreturn return true if the name is found or false otherwise.
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.9.3
 * @export
 * @param {string} name
 * @return {boolean}
 */
org.apache.royale.core.StyledUIBase.prototype.containsClass = function(name) {
  return this.classSelectorList.contains(name);
  
};


/**
 * @asreturn The actual element to be parented.
 * @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 * @protected
 * @override
 */
org.apache.royale.core.StyledUIBase.prototype.createElement = function() {
  org.apache.royale.html.util.addElementToWrapper(this, 'div');
  this.positioner = this.element;
  return this.element;
};


org.apache.royale.core.StyledUIBase.prototype.get__positioner = function() {
  return this.org_apache_royale_core_StyledUIBase__positioner;
};


org.apache.royale.core.StyledUIBase.prototype.set__positioner = function(value) {
  this.org_apache_royale_core_StyledUIBase__positioner = value;
};


Object.defineProperties(org.apache.royale.core.StyledUIBase.prototype, /** @lends {org.apache.royale.core.StyledUIBase.prototype} */ {
/**
  * @export
  * @type {org.apache.royale.core.WrappedHTMLElement} */
positioner: {
get: org.apache.royale.core.StyledUIBase.prototype.get__positioner,
set: org.apache.royale.core.StyledUIBase.prototype.set__positioner}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.core.StyledUIBase.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'StyledUIBase', qName: 'org.apache.royale.core.StyledUIBase', kind: 'class' }], interfaces: [org.apache.royale.utils.IClassSelectorListSupport] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.core.StyledUIBase.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'positioner': { type: 'org.apache.royale.core.WrappedHTMLElement', access: 'readwrite', declaredBy: 'org.apache.royale.core.StyledUIBase'}
      };
    },
    methods: function () {
      return {
        'StyledUIBase': { type: '', declaredBy: 'org.apache.royale.core.StyledUIBase'},
        'addClass': { type: 'void', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [  { index: 1, type: 'String', optional: false } ]; }},
        'removeClass': { type: 'void', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [  { index: 1, type: 'String', optional: false } ]; }},
        'toggleClass': { type: 'void', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [  { index: 1, type: 'String', optional: false },{ index: 2, type: 'Boolean', optional: false } ]; }},
        'containsClass': { type: 'Boolean', declaredBy: 'org.apache.royale.core.StyledUIBase', parameters: function () { return [  { index: 1, type: 'String', optional: false } ]; }}
      };
    }
  };
};