/**
 * Generated by Apache Royale Compiler from org\apache\royale\svg\Ellipse.as
 * org.apache.royale.svg.Ellipse
 *
 * @fileoverview
 *
 * @suppress {checkTypes|accessControls}
 */

goog.provide('org.apache.royale.svg.Ellipse');

goog.require('org.apache.royale.core.WrappedHTMLElement');
goog.require('org.apache.royale.svg.GraphicShape');
goog.require('org.apache.royale.graphics.IDrawable');
goog.require('org.apache.royale.graphics.IEllipse');



/**
 *  constructor.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.7
 * @constructor
 * @extends {org.apache.royale.svg.GraphicShape}
 * @implements {org.apache.royale.graphics.IEllipse}
 * @implements {org.apache.royale.graphics.IDrawable}
 * @param {number=} cx
 * @param {number=} cy
 * @param {number=} rx
 * @param {number=} ry
 */
org.apache.royale.svg.Ellipse = function(cx, cy, rx, ry) {
  org.apache.royale.svg.Ellipse.base(this, 'constructor');
  cx = typeof cx !== 'undefined' ? cx : 0;
  cy = typeof cy !== 'undefined' ? cy : 0;
  rx = typeof rx !== 'undefined' ? rx : 0;
  ry = typeof ry !== 'undefined' ? ry : 0;
  this.x = cx;
  this.y = cy;
  this.rx = rx;
  this.ry = ry;
};
goog.inherits(org.apache.royale.svg.Ellipse, org.apache.royale.svg.GraphicShape);


/**
 * Prevent renaming of class. Needed for reflection.
 */
goog.exportSymbol('org.apache.royale.svg.Ellipse', org.apache.royale.svg.Ellipse);


/**
 * @private
 * @type {number}
 */
org.apache.royale.svg.Ellipse.prototype.org_apache_royale_svg_Ellipse__rx;


/**
 * @private
 * @type {number}
 */
org.apache.royale.svg.Ellipse.prototype.org_apache_royale_svg_Ellipse__ry;


/**
 * @private
 * @type {org.apache.royale.core.WrappedHTMLElement}
 */
org.apache.royale.svg.Ellipse.prototype.org_apache_royale_svg_Ellipse__ellipse;


/**
 *  Draw the ellipse.
 *  @asparam xp The x position of the top-left corner of the bounding box of the ellipse.
 *  @asparam yp The y position of the top-left corner of the bounding box of the ellipse.
 *
 *  @langversion 3.0
 *  @playerversion Flash 10.2
 *  @playerversion AIR 2.6
 *  @productversion Royale 0.0
 *  @royaleignorecoercion org.apache.royale.core.WrappedHTMLElement
 *  @royaleignorecoercion SVGEllipseElement
 * @export
 * @param {number} xp
 * @param {number} yp
 */
org.apache.royale.svg.Ellipse.prototype.drawEllipse = function(xp, yp) {
  
  var /** @type {string} */ style = this.getStyleStr();
  if (this.org_apache_royale_svg_Ellipse__ellipse == null) {
    this.org_apache_royale_svg_Ellipse__ellipse = document.createElementNS('http://www.w3.org/2000/svg', 'ellipse');
    this.org_apache_royale_svg_Ellipse__ellipse.royale_wrapper = this;
    this.element.appendChild(this.org_apache_royale_svg_Ellipse__ellipse);
  }
  this.org_apache_royale_svg_Ellipse__ellipse.setAttribute('style', style);
  if (this.stroke) {
    this.org_apache_royale_svg_Ellipse__ellipse.setAttribute('cx', this.rx + this.stroke.weight);
    this.org_apache_royale_svg_Ellipse__ellipse.setAttribute('cy', this.ry + this.stroke.weight);
  } else {
    this.org_apache_royale_svg_Ellipse__ellipse.setAttribute('cx', this.rx);
    this.org_apache_royale_svg_Ellipse__ellipse.setAttribute('cy', this.ry);
  }
  this.org_apache_royale_svg_Ellipse__ellipse.setAttribute('rx', this.rx);
  this.org_apache_royale_svg_Ellipse__ellipse.setAttribute('ry', this.ry);
  this.resize(this.x, this.y);
};


/**
 * @protected
 * @override
 */
org.apache.royale.svg.Ellipse.prototype.drawImpl = function() {
  this.drawEllipse(0, 0);
};


/**
 * @export
 */
org.apache.royale.svg.Ellipse.prototype.draw = function() {
  this.drawImpl();
};


org.apache.royale.svg.Ellipse.prototype.get__rx = function() {
  return this.org_apache_royale_svg_Ellipse__rx;
};


org.apache.royale.svg.Ellipse.prototype.set__rx = function(value) {
  this.org_apache_royale_svg_Ellipse__rx = value;
};


org.apache.royale.svg.Ellipse.prototype.get__ry = function() {
  return this.org_apache_royale_svg_Ellipse__ry;
};


org.apache.royale.svg.Ellipse.prototype.set__ry = function(value) {
  this.org_apache_royale_svg_Ellipse__ry = value;
};


org.apache.royale.svg.Ellipse.prototype.get__width = function() {
  return this.org_apache_royale_svg_Ellipse__rx * 2;
};


org.apache.royale.svg.Ellipse.prototype.set__width = function(value) {
  this.org_apache_royale_svg_Ellipse__rx = value / 2;
};


org.apache.royale.svg.Ellipse.prototype.get__height = function() {
  return this.org_apache_royale_svg_Ellipse__ry * 2;
};


org.apache.royale.svg.Ellipse.prototype.set__height = function(value) {
  this.org_apache_royale_svg_Ellipse__ry = value / 2;
};


Object.defineProperties(org.apache.royale.svg.Ellipse.prototype, /** @lends {org.apache.royale.svg.Ellipse.prototype} */ {
/**
  * @export
  * @type {number} */
rx: {
get: org.apache.royale.svg.Ellipse.prototype.get__rx,
set: org.apache.royale.svg.Ellipse.prototype.set__rx},
/**
  * @export
  * @type {number} */
ry: {
get: org.apache.royale.svg.Ellipse.prototype.get__ry,
set: org.apache.royale.svg.Ellipse.prototype.set__ry},
/**
  * @export
  * @type {number} */
width: {
get: org.apache.royale.svg.Ellipse.prototype.get__width,
set: org.apache.royale.svg.Ellipse.prototype.set__width},
/**
  * @export
  * @type {number} */
height: {
get: org.apache.royale.svg.Ellipse.prototype.get__height,
set: org.apache.royale.svg.Ellipse.prototype.set__height}}
);


/**
 * Metadata
 *
 * @type {Object.<string, Array.<Object>>}
 */
org.apache.royale.svg.Ellipse.prototype.ROYALE_CLASS_INFO = { names: [{ name: 'Ellipse', qName: 'org.apache.royale.svg.Ellipse', kind: 'class' }], interfaces: [org.apache.royale.graphics.IEllipse, org.apache.royale.graphics.IDrawable] };



/**
 * Reflection
 *
 * @return {Object.<string, Function>}
 */
org.apache.royale.svg.Ellipse.prototype.ROYALE_REFLECTION_INFO = function () {
  return {
    variables: function () {return {};},
    accessors: function () {
      return {
        'rx': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.svg.Ellipse'},
        'ry': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.svg.Ellipse'},
        'width': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.svg.Ellipse'},
        'height': { type: 'Number', access: 'readwrite', declaredBy: 'org.apache.royale.svg.Ellipse'}
      };
    },
    methods: function () {
      return {
        'Ellipse': { type: '', declaredBy: 'org.apache.royale.svg.Ellipse', parameters: function () { return [  { index: 1, type: 'Number', optional: true },{ index: 2, type: 'Number', optional: true },{ index: 3, type: 'Number', optional: true },{ index: 4, type: 'Number', optional: true } ]; }},
        'drawEllipse': { type: 'void', declaredBy: 'org.apache.royale.svg.Ellipse', parameters: function () { return [  { index: 1, type: 'Number', optional: false },{ index: 2, type: 'Number', optional: false } ]; }},
        'draw': { type: 'void', declaredBy: 'org.apache.royale.svg.Ellipse'}
      };
    }
  };
};