/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.cluster;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class CLusterSendMsgRTCommand
implements SubCommand {
    public static void main(String[] args) {
    }

    @Override
    public String commandName() {
        return "clusterRT";
    }

    @Override
    public String commandDesc() {
        return "List All clusters Message Send RT";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("a", "amount", true, "message amount | default 100");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("s", "size", true, "message size | default 128 Byte");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("c", "cluster", true, "cluster name | default display all cluster");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "print log", true, "print as tlog | default false");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("m", "machine room", true, "machine room name | default noname");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("i", "interval", true, "print interval | default 10 seconds");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        DefaultMQProducer producer = new DefaultMQProducer(rpcHook);
        producer.setProducerGroup(Long.toString(System.currentTimeMillis()));
        try {
            try {
                String machineRoom;
                defaultMQAdminExt.start();
                producer.start();
                ClusterInfo clusterInfoSerializeWrapper = defaultMQAdminExt.examineBrokerClusterInfo();
                HashMap clusterAddr = clusterInfoSerializeWrapper.getClusterAddrTable();
                Set clusterNames = null;
                long amount = !commandLine.hasOption('a') ? 50L : Long.parseLong(commandLine.getOptionValue('a').trim());
                long size = !commandLine.hasOption('s') ? 128L : Long.parseLong(commandLine.getOptionValue('s').trim());
                long interval = !commandLine.hasOption('i') ? 10L : Long.parseLong(commandLine.getOptionValue('i').trim());
                boolean printAsTlog = commandLine.hasOption('p') && Boolean.parseBoolean(commandLine.getOptionValue('p').trim());
                String string = machineRoom = !commandLine.hasOption('m') ? "noname" : commandLine.getOptionValue('m').trim();
                if (commandLine.hasOption('c')) {
                    clusterNames = new TreeSet();
                    clusterNames.add(commandLine.getOptionValue('c').trim());
                } else {
                    clusterNames = clusterAddr.keySet();
                }
                if (!printAsTlog) {
                    System.out.printf("%-24s  %-24s  %-4s  %-8s  %-8s%n", "#Cluster Name", "#Broker Name", "#RT", "#successCount", "#failCount");
                }
                while (true) {
                    for (String clusterName : clusterNames) {
                        Set brokerNames = (Set)clusterAddr.get(clusterName);
                        if (brokerNames == null) {
                            System.out.printf("cluster [%s] not exist", clusterName);
                            break;
                        }
                        for (String brokerName : brokerNames) {
                            Message msg = new Message(brokerName, this.getStringBySize(size).getBytes("UTF-8"));
                            long start = 0L;
                            long end = 0L;
                            long elapsed = 0L;
                            int successCount = 0;
                            int failCount = 0;
                            int i = 0;
                            while ((long)i < amount) {
                                start = System.currentTimeMillis();
                                try {
                                    producer.send(msg);
                                    ++successCount;
                                    end = System.currentTimeMillis();
                                }
                                catch (Exception e) {
                                    ++failCount;
                                    end = System.currentTimeMillis();
                                }
                                if (i != 0) {
                                    elapsed += end - start;
                                }
                                ++i;
                            }
                            double rt = (double)elapsed / (double)(amount - 1L);
                            if (!printAsTlog) {
                                System.out.printf("%-24s  %-24s  %-8s  %-16s  %-16s%n", clusterName, brokerName, String.format("%.2f", rt), successCount, failCount);
                                continue;
                            }
                            System.out.printf("%s", String.format("%s|%s|%s|%s|%s%n", this.getCurTime(), machineRoom, clusterName, brokerName, new BigDecimal(rt).setScale(0, 4)));
                        }
                    }
                    Thread.sleep(interval * 1000L);
                }
            }
            catch (Exception e) {
                throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
            }
        }
        catch (Throwable throwable) {
            defaultMQAdminExt.shutdown();
            producer.shutdown();
            throw throwable;
        }
    }

    public String getStringBySize(long size) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while ((long)i < size) {
            res.append('a');
            ++i;
        }
        return res.toString();
    }

    public String getCurTime() {
        String fromTimeZone = "GMT+8";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        format.setTimeZone(TimeZone.getTimeZone(fromTimeZone));
        String chinaDate = format.format(date);
        return chinaDate;
    }
}

