/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.tools.admin.MQAdminExt;

public class CommandUtil {
    private static final String ERROR_MESSAGE = "Make sure the specified clusterName exists or the name server connected to is correct.";

    public static Map<String, List<String>> fetchMasterAndSlaveDistinguish(MQAdminExt adminExt, String clusterName) throws InterruptedException, RemotingConnectException, RemotingTimeoutException, RemotingSendRequestException, MQBrokerException {
        HashMap<String, List<String>> masterAndSlaveMap = new HashMap<String, List<String>>(4);
        ClusterInfo clusterInfoSerializeWrapper = adminExt.examineBrokerClusterInfo();
        Set brokerNameSet = (Set)clusterInfoSerializeWrapper.getClusterAddrTable().get(clusterName);
        if (brokerNameSet == null) {
            System.out.printf("[error] %s", ERROR_MESSAGE);
            return masterAndSlaveMap;
        }
        for (String brokerName : brokerNameSet) {
            BrokerData brokerData = (BrokerData)clusterInfoSerializeWrapper.getBrokerAddrTable().get(brokerName);
            if (brokerData == null || brokerData.getBrokerAddrs() == null) continue;
            String masterAddr = (String)brokerData.getBrokerAddrs().get(0L);
            masterAndSlaveMap.put(masterAddr, new ArrayList());
            for (Long id : brokerData.getBrokerAddrs().keySet()) {
                if (brokerData.getBrokerAddrs().get(id) == null || id == 0L) continue;
                ((List)masterAndSlaveMap.get(masterAddr)).add(brokerData.getBrokerAddrs().get(id));
            }
        }
        return masterAndSlaveMap;
    }

    public static Set<String> fetchMasterAddrByClusterName(MQAdminExt adminExt, String clusterName) throws InterruptedException, RemotingConnectException, RemotingTimeoutException, RemotingSendRequestException, MQBrokerException {
        HashSet<String> masterSet = new HashSet<String>();
        ClusterInfo clusterInfoSerializeWrapper = adminExt.examineBrokerClusterInfo();
        Set brokerNameSet = (Set)clusterInfoSerializeWrapper.getClusterAddrTable().get(clusterName);
        if (brokerNameSet != null) {
            for (String brokerName : brokerNameSet) {
                String addr;
                BrokerData brokerData = (BrokerData)clusterInfoSerializeWrapper.getBrokerAddrTable().get(brokerName);
                if (brokerData == null || (addr = (String)brokerData.getBrokerAddrs().get(0L)) == null) continue;
                masterSet.add(addr);
            }
        } else {
            System.out.printf("[error] %s", ERROR_MESSAGE);
        }
        return masterSet;
    }

    public static Set<String> fetchMasterAndSlaveAddrByClusterName(MQAdminExt adminExt, String clusterName) throws InterruptedException, RemotingConnectException, RemotingTimeoutException, RemotingSendRequestException, MQBrokerException {
        HashSet<String> brokerAddressSet = new HashSet<String>();
        ClusterInfo clusterInfoSerializeWrapper = adminExt.examineBrokerClusterInfo();
        Set brokerNameSet = (Set)clusterInfoSerializeWrapper.getClusterAddrTable().get(clusterName);
        if (brokerNameSet != null) {
            for (String brokerName : brokerNameSet) {
                BrokerData brokerData = (BrokerData)clusterInfoSerializeWrapper.getBrokerAddrTable().get(brokerName);
                if (brokerData == null) continue;
                Collection addrs = brokerData.getBrokerAddrs().values();
                brokerAddressSet.addAll(addrs);
            }
        } else {
            System.out.printf("[error] %s", ERROR_MESSAGE);
        }
        return brokerAddressSet;
    }

    public static Set<String> fetchBrokerNameByClusterName(MQAdminExt adminExt, String clusterName) throws Exception {
        ClusterInfo clusterInfoSerializeWrapper = adminExt.examineBrokerClusterInfo();
        Set brokerNameSet = (Set)clusterInfoSerializeWrapper.getClusterAddrTable().get(clusterName);
        if (brokerNameSet.isEmpty()) {
            throw new Exception(ERROR_MESSAGE);
        }
        return brokerNameSet;
    }

    public static String fetchBrokerNameByAddr(MQAdminExt adminExt, String addr) throws Exception {
        ClusterInfo clusterInfoSerializeWrapper = adminExt.examineBrokerClusterInfo();
        HashMap brokerAddrTable = clusterInfoSerializeWrapper.getBrokerAddrTable();
        for (Map.Entry entry : brokerAddrTable.entrySet()) {
            HashMap brokerAddrs = ((BrokerData)entry.getValue()).getBrokerAddrs();
            if (!brokerAddrs.containsValue(addr)) continue;
            return (String)entry.getKey();
        }
        throw new Exception(ERROR_MESSAGE);
    }
}

