/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.support;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.MessageSelector;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.client.utils.MessageUtil;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.annotation.SelectorType;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.apache.rocketmq.spring.core.RocketMQPushConsumerLifecycleListener;
import org.apache.rocketmq.spring.core.RocketMQReplyListener;
import org.apache.rocketmq.spring.support.RocketMQListenerContainer;
import org.apache.rocketmq.spring.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;

public class DefaultRocketMQListenerContainer
implements InitializingBean,
RocketMQListenerContainer,
SmartLifecycle,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultRocketMQListenerContainer.class);
    private ApplicationContext applicationContext;
    private String name;
    private long suspendCurrentQueueTimeMillis = 1000L;
    private int delayLevelWhenNextConsume = 0;
    private String nameServer;
    private AccessChannel accessChannel = AccessChannel.LOCAL;
    private String consumerGroup;
    private String topic;
    private int consumeThreadMax = 64;
    private int consumeThreadNumber = 20;
    private String charset = "UTF-8";
    private MessageConverter messageConverter;
    private RocketMQListener rocketMQListener;
    private RocketMQReplyListener rocketMQReplyListener;
    private RocketMQMessageListener rocketMQMessageListener;
    private DefaultMQPushConsumer consumer;
    private Type messageType;
    private MethodParameter methodParameter;
    private boolean running;
    private ConsumeMode consumeMode;
    private SelectorType selectorType;
    private String selectorExpression;
    private MessageModel messageModel;
    private long consumeTimeout;
    private int maxReconsumeTimes;
    private int replyTimeout;
    private String tlsEnable;
    private String namespace;
    private String namespaceV2;
    private long awaitTerminationMillisWhenShutdown;
    private String instanceName;

    public long getSuspendCurrentQueueTimeMillis() {
        return this.suspendCurrentQueueTimeMillis;
    }

    public void setSuspendCurrentQueueTimeMillis(long suspendCurrentQueueTimeMillis) {
        this.suspendCurrentQueueTimeMillis = suspendCurrentQueueTimeMillis;
    }

    public int getDelayLevelWhenNextConsume() {
        return this.delayLevelWhenNextConsume;
    }

    public void setDelayLevelWhenNextConsume(int delayLevelWhenNextConsume) {
        this.delayLevelWhenNextConsume = delayLevelWhenNextConsume;
    }

    public String getNameServer() {
        return this.nameServer;
    }

    public void setNameServer(String nameServer) {
        this.nameServer = nameServer;
    }

    public AccessChannel getAccessChannel() {
        return this.accessChannel;
    }

    public void setAccessChannel(AccessChannel accessChannel) {
        this.accessChannel = accessChannel;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getConsumeThreadMax() {
        return this.consumeThreadMax;
    }

    public int getConsumeThreadNumber() {
        return this.consumeThreadNumber;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public DefaultRocketMQListenerContainer setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
        return this;
    }

    public RocketMQListener getRocketMQListener() {
        return this.rocketMQListener;
    }

    public void setRocketMQListener(RocketMQListener rocketMQListener) {
        this.rocketMQListener = rocketMQListener;
    }

    public RocketMQReplyListener getRocketMQReplyListener() {
        return this.rocketMQReplyListener;
    }

    public void setRocketMQReplyListener(RocketMQReplyListener rocketMQReplyListener) {
        this.rocketMQReplyListener = rocketMQReplyListener;
    }

    public RocketMQMessageListener getRocketMQMessageListener() {
        return this.rocketMQMessageListener;
    }

    public void setRocketMQMessageListener(RocketMQMessageListener anno) {
        this.rocketMQMessageListener = anno;
        this.consumeMode = anno.consumeMode();
        this.consumeThreadMax = anno.consumeThreadMax();
        this.consumeThreadNumber = anno.consumeThreadNumber();
        this.messageModel = anno.messageModel();
        this.selectorType = anno.selectorType();
        this.selectorExpression = anno.selectorExpression();
        this.consumeTimeout = anno.consumeTimeout();
        this.maxReconsumeTimes = anno.maxReconsumeTimes();
        this.replyTimeout = anno.replyTimeout();
        this.tlsEnable = anno.tlsEnable();
        this.namespace = anno.namespace();
        this.namespaceV2 = anno.namespaceV2();
        this.delayLevelWhenNextConsume = anno.delayLevelWhenNextConsume();
        this.suspendCurrentQueueTimeMillis = anno.suspendCurrentQueueTimeMillis();
        this.awaitTerminationMillisWhenShutdown = Math.max(0, anno.awaitTerminationMillisWhenShutdown());
        this.instanceName = anno.instanceName();
    }

    public ConsumeMode getConsumeMode() {
        return this.consumeMode;
    }

    public SelectorType getSelectorType() {
        return this.selectorType;
    }

    public void setSelectorExpression(String selectorExpression) {
        this.selectorExpression = selectorExpression;
    }

    public String getSelectorExpression() {
        return this.selectorExpression;
    }

    public MessageModel getMessageModel() {
        return this.messageModel;
    }

    public String getTlsEnable() {
        return this.tlsEnable;
    }

    public void setTlsEnable(String tlsEnable) {
        this.tlsEnable = tlsEnable;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespaceV2() {
        return this.namespaceV2;
    }

    public void setNamespaceV2(String namespaceV2) {
        this.namespaceV2 = namespaceV2;
    }

    public DefaultMQPushConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(DefaultMQPushConsumer consumer) {
        this.consumer = consumer;
    }

    public long getAwaitTerminationMillisWhenShutdown() {
        return this.awaitTerminationMillisWhenShutdown;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public DefaultRocketMQListenerContainer setAwaitTerminationMillisWhenShutdown(long awaitTerminationMillisWhenShutdown) {
        this.awaitTerminationMillisWhenShutdown = awaitTerminationMillisWhenShutdown;
        return this;
    }

    public void destroy() {
        this.setRunning(false);
        if (Objects.nonNull(this.consumer)) {
            this.consumer.shutdown();
        }
        log.info("container destroyed, {}", (Object)this.toString());
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("container already running. " + this.toString());
        }
        try {
            this.consumer.start();
        }
        catch (MQClientException e) {
            throw new IllegalStateException("Failed to start RocketMQ push consumer", e);
        }
        this.setRunning(true);
        log.info("running container: {}", (Object)this.toString());
    }

    public void stop() {
        if (this.isRunning()) {
            if (Objects.nonNull(this.consumer)) {
                this.consumer.shutdown();
            }
            this.setRunning(false);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void afterPropertiesSet() throws Exception {
        this.initRocketMQPushConsumer();
        this.messageType = this.getMessageType();
        this.methodParameter = this.getMethodParameter();
        log.debug("RocketMQ messageType: {}", (Object)this.messageType);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String toString() {
        return "DefaultRocketMQListenerContainer{consumerGroup='" + this.consumerGroup + '\'' + ", namespace='" + this.namespace + '\'' + ", namespaceV2='" + this.namespaceV2 + '\'' + ", nameServer='" + this.nameServer + '\'' + ", topic='" + this.topic + '\'' + ", consumeMode=" + (Object)((Object)this.consumeMode) + ", selectorType=" + (Object)((Object)this.selectorType) + ", selectorExpression='" + this.selectorExpression + '\'' + ", messageModel=" + (Object)((Object)this.messageModel) + '\'' + ", tlsEnable=" + this.tlsEnable + ", instanceName=" + this.instanceName + '}';
    }

    public void setName(String name) {
        this.name = name;
    }

    public void handleMessage(MessageExt messageExt) throws MQClientException, RemotingException, InterruptedException {
        if (this.rocketMQListener != null) {
            this.rocketMQListener.onMessage(this.doConvertMessage(messageExt));
        } else if (this.rocketMQReplyListener != null) {
            Object replyContent = this.rocketMQReplyListener.onMessage(this.doConvertMessage(messageExt));
            org.springframework.messaging.Message message = MessageBuilder.withPayload(replyContent).build();
            Message replyMessage = MessageUtil.createReplyMessage((Message)messageExt, (byte[])this.convertToBytes(message));
            DefaultMQProducer producer = this.consumer.getDefaultMQPushConsumerImpl().getmQClientFactory().getDefaultMQProducer();
            producer.setSendMsgTimeout(this.replyTimeout);
            producer.send(replyMessage, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    if (sendResult.getSendStatus() != SendStatus.SEND_OK) {
                        log.error("Consumer replies message failed. SendStatus: {}", (Object)sendResult.getSendStatus());
                    } else {
                        log.debug("Consumer replies message success.");
                    }
                }

                public void onException(Throwable e) {
                    log.error("Consumer replies message failed. error: {}", (Object)e.getLocalizedMessage());
                }
            });
        }
    }

    private byte[] convertToBytes(org.springframework.messaging.Message<?> message) {
        byte[] payloads;
        org.springframework.messaging.Message<?> messageWithSerializedPayload = this.doConvert(message.getPayload(), message.getHeaders());
        Object payloadObj = messageWithSerializedPayload.getPayload();
        try {
            if (null == payloadObj) {
                throw new RuntimeException("the message cannot be empty");
            }
            if (payloadObj instanceof String) {
                payloads = ((String)payloadObj).getBytes(Charset.forName(this.charset));
            } else if (payloadObj instanceof byte[]) {
                payloads = (byte[])messageWithSerializedPayload.getPayload();
            } else {
                String jsonObj = (String)this.messageConverter.fromMessage(messageWithSerializedPayload, payloadObj.getClass());
                if (null == jsonObj) {
                    throw new RuntimeException(String.format("empty after conversion [messageConverter:%s,payloadClass:%s,payloadObj:%s]", this.messageConverter.getClass(), payloadObj.getClass(), payloadObj));
                }
                payloads = jsonObj.getBytes(Charset.forName(this.charset));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("convert to bytes failed.", e);
        }
        return payloads;
    }

    private org.springframework.messaging.Message<?> doConvert(Object payload, MessageHeaders headers) {
        org.springframework.messaging.Message message;
        org.springframework.messaging.Message message2 = message = this.messageConverter instanceof SmartMessageConverter ? ((SmartMessageConverter)this.messageConverter).toMessage(payload, headers, null) : this.messageConverter.toMessage(payload, headers);
        if (message == null) {
            String payloadType = payload.getClass().getName();
            Object contentType = headers != null ? headers.get((Object)"contentType") : null;
            throw new MessageConversionException("Unable to convert payload with type='" + payloadType + "', contentType='" + contentType + "', converter=[" + this.messageConverter + "]");
        }
        MessageBuilder builder = MessageBuilder.fromMessage((org.springframework.messaging.Message)message);
        builder.setHeaderIfAbsent("contentType", (Object)MimeTypeUtils.TEXT_PLAIN);
        return builder.build();
    }

    private Object doConvertMessage(MessageExt messageExt) {
        if (Objects.equals(this.messageType, MessageExt.class) || Objects.equals(this.messageType, Message.class)) {
            return messageExt;
        }
        String str = new String(messageExt.getBody(), Charset.forName(this.charset));
        if (Objects.equals(this.messageType, String.class)) {
            return str;
        }
        try {
            if (this.messageType instanceof Class) {
                return this.getMessageConverter().fromMessage(MessageBuilder.withPayload((Object)str).build(), (Class)this.messageType);
            }
            return ((SmartMessageConverter)this.getMessageConverter()).fromMessage(MessageBuilder.withPayload((Object)str).build(), (Class)((ParameterizedType)this.messageType).getRawType(), (Object)this.methodParameter);
        }
        catch (Exception e) {
            log.info("convert failed. str:{}, msgType:{}", (Object)str, (Object)this.messageType);
            throw new RuntimeException("cannot convert message to " + this.messageType, e);
        }
    }

    private MethodParameter getMethodParameter() {
        Class targetClass = this.rocketMQListener != null ? AopProxyUtils.ultimateTargetClass((Object)this.rocketMQListener) : AopProxyUtils.ultimateTargetClass((Object)this.rocketMQReplyListener);
        Type messageType = this.getMessageType();
        Class clazz = null;
        if (messageType instanceof ParameterizedType && this.messageConverter instanceof SmartMessageConverter) {
            clazz = (Class)((ParameterizedType)messageType).getRawType();
        } else if (messageType instanceof Class) {
            clazz = (Class)messageType;
        } else {
            throw new RuntimeException("parameterType:" + messageType + " of onMessage method is not supported");
        }
        try {
            Method method = targetClass.getMethod("onMessage", clazz);
            return new MethodParameter(method, 0);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException("parameterType:" + messageType + " of onMessage method is not supported");
        }
    }

    protected Type getMessageType() {
        Class targetClass = this.rocketMQListener != null ? AopProxyUtils.ultimateTargetClass((Object)this.rocketMQListener) : AopProxyUtils.ultimateTargetClass((Object)this.rocketMQReplyListener);
        Type matchedGenericInterface = null;
        while (Objects.nonNull(targetClass)) {
            Type[] interfaces = targetClass.getGenericInterfaces();
            if (Objects.nonNull(interfaces)) {
                for (Type type : interfaces) {
                    if (!(type instanceof ParameterizedType) || !Objects.equals(((ParameterizedType)type).getRawType(), RocketMQListener.class) && !Objects.equals(((ParameterizedType)type).getRawType(), RocketMQReplyListener.class)) continue;
                    matchedGenericInterface = type;
                    break;
                }
            }
            targetClass = targetClass.getSuperclass();
        }
        if (Objects.isNull(matchedGenericInterface)) {
            return Object.class;
        }
        Type[] actualTypeArguments = ((ParameterizedType)matchedGenericInterface).getActualTypeArguments();
        if (Objects.nonNull(actualTypeArguments) && actualTypeArguments.length > 0) {
            return actualTypeArguments[0];
        }
        return Object.class;
    }

    private void initRocketMQPushConsumer() throws MQClientException {
        if (this.rocketMQListener == null && this.rocketMQReplyListener == null) {
            throw new IllegalArgumentException("Property 'rocketMQListener' or 'rocketMQReplyListener' is required");
        }
        Assert.notNull((Object)this.consumerGroup, (String)"Property 'consumerGroup' is required");
        Assert.notNull((Object)this.nameServer, (String)"Property 'nameServer' is required");
        Assert.notNull((Object)this.topic, (String)"Property 'topic' is required");
        RPCHook rpcHook = RocketMQUtil.getRPCHookByAkSk(this.applicationContext.getEnvironment(), this.rocketMQMessageListener.accessKey(), this.rocketMQMessageListener.secretKey());
        boolean enableMsgTrace = this.rocketMQMessageListener.enableMsgTrace();
        if (Objects.nonNull(rpcHook)) {
            this.consumer = new DefaultMQPushConsumer(this.consumerGroup, rpcHook, (AllocateMessageQueueStrategy)new AllocateMessageQueueAveragely(), enableMsgTrace, this.applicationContext.getEnvironment().resolveRequiredPlaceholders(this.rocketMQMessageListener.customizedTraceTopic()));
            this.consumer.setVipChannelEnabled(false);
        } else {
            log.debug("Access-key or secret-key not configure in " + this + ".");
            this.consumer = new DefaultMQPushConsumer(this.consumerGroup, enableMsgTrace, this.applicationContext.getEnvironment().resolveRequiredPlaceholders(this.rocketMQMessageListener.customizedTraceTopic()));
        }
        this.consumer.setNamespace(this.namespace);
        this.consumer.setNamespaceV2(this.namespaceV2);
        String customizedNameServer = this.applicationContext.getEnvironment().resolveRequiredPlaceholders(this.rocketMQMessageListener.nameServer());
        if (customizedNameServer != null) {
            this.consumer.setNamesrvAddr(customizedNameServer);
        } else {
            this.consumer.setNamesrvAddr(this.nameServer);
        }
        if (this.accessChannel != null) {
            this.consumer.setAccessChannel(this.accessChannel);
        }
        this.consumer.setConsumeThreadMax(this.consumeThreadMax);
        this.consumer.setConsumeThreadMin(this.consumeThreadNumber);
        this.consumer.setConsumeTimeout(this.consumeTimeout);
        this.consumer.setMaxReconsumeTimes(this.maxReconsumeTimes);
        this.consumer.setAwaitTerminationMillisWhenShutdown(this.awaitTerminationMillisWhenShutdown);
        this.consumer.setInstanceName(this.instanceName);
        switch (this.messageModel) {
            case BROADCASTING: {
                this.consumer.setMessageModel(org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel.BROADCASTING);
                break;
            }
            case CLUSTERING: {
                this.consumer.setMessageModel(org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel.CLUSTERING);
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'messageModel' was wrong.");
            }
        }
        switch (this.selectorType) {
            case TAG: {
                this.consumer.subscribe(this.topic, this.selectorExpression);
                break;
            }
            case SQL92: {
                this.consumer.subscribe(this.topic, MessageSelector.bySql((String)this.selectorExpression));
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'selectorType' was wrong.");
            }
        }
        switch (this.consumeMode) {
            case ORDERLY: {
                this.consumer.setMessageListener((MessageListener)new DefaultMessageListenerOrderly());
                break;
            }
            case CONCURRENTLY: {
                this.consumer.setMessageListener((MessageListener)new DefaultMessageListenerConcurrently());
                break;
            }
            default: {
                throw new IllegalArgumentException("Property 'consumeMode' was wrong.");
            }
        }
        this.consumer.setUseTLS(new Boolean(this.tlsEnable).booleanValue());
        if (this.rocketMQListener instanceof RocketMQPushConsumerLifecycleListener) {
            ((RocketMQPushConsumerLifecycleListener)((Object)this.rocketMQListener)).prepareStart(this.consumer);
        } else if (this.rocketMQReplyListener instanceof RocketMQPushConsumerLifecycleListener) {
            ((RocketMQPushConsumerLifecycleListener)((Object)this.rocketMQReplyListener)).prepareStart(this.consumer);
        }
    }

    public class DefaultMessageListenerOrderly
    implements MessageListenerOrderly {
        public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
            for (MessageExt messageExt : msgs) {
                log.debug("received msg: {}", (Object)messageExt);
                try {
                    long now = System.currentTimeMillis();
                    DefaultRocketMQListenerContainer.this.handleMessage(messageExt);
                    long costTime = System.currentTimeMillis() - now;
                    log.debug("consume {} cost: {} ms", (Object)messageExt.getMsgId(), (Object)costTime);
                }
                catch (Exception e) {
                    log.warn("consume message failed. messageId:{}, topic:{}, reconsumeTimes:{}", new Object[]{messageExt.getMsgId(), messageExt.getTopic(), messageExt.getReconsumeTimes(), e});
                    context.setSuspendCurrentQueueTimeMillis(DefaultRocketMQListenerContainer.this.suspendCurrentQueueTimeMillis);
                    return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
                }
            }
            return ConsumeOrderlyStatus.SUCCESS;
        }
    }

    public class DefaultMessageListenerConcurrently
    implements MessageListenerConcurrently {
        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
            for (MessageExt messageExt : msgs) {
                log.debug("received msg: {}", (Object)messageExt);
                try {
                    long now = System.currentTimeMillis();
                    DefaultRocketMQListenerContainer.this.handleMessage(messageExt);
                    long costTime = System.currentTimeMillis() - now;
                    log.debug("consume {} cost: {} ms", (Object)messageExt.getMsgId(), (Object)costTime);
                }
                catch (Exception e) {
                    log.warn("consume message failed. messageId:{}, topic:{}, reconsumeTimes:{}", new Object[]{messageExt.getMsgId(), messageExt.getTopic(), messageExt.getReconsumeTimes(), e});
                    context.setDelayLevelWhenNextConsume(DefaultRocketMQListenerContainer.this.delayLevelWhenNextConsume);
                    return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                }
            }
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
    }
}

