/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.rat.ConfigurationException;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.configuration.Format;
import org.apache.rat.configuration.LicenseReader;
import org.apache.rat.configuration.MatcherReader;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.mp.Family;
import org.apache.rat.mp.FilesReportable;
import org.apache.rat.mp.License;
import org.apache.rat.mp.util.ExclusionHelper;
import org.apache.rat.mp.util.ScmIgnoreParser;
import org.apache.rat.mp.util.ignore.GlobIgnoreMatcher;
import org.apache.rat.mp.util.ignore.IgnoreMatcher;
import org.apache.rat.mp.util.ignore.IgnoringDirectoryScanner;
import org.apache.rat.report.IReportable;
import org.codehaus.plexus.util.DirectoryScanner;

public abstract class AbstractRatMojo
extends AbstractMojo {
    @Parameter(property="rat.basedir", defaultValue="${basedir}", required=true)
    private File basedir;
    @Parameter
    private String[] defaultLicenseFiles;
    @Parameter
    private String[] additionalLicenseFiles;
    @Parameter(property="rat.addDefaultLicenses", defaultValue="true")
    private boolean addDefaultLicenses;
    @Parameter(property="rat.addDefaultLicenseMatchers", defaultValue="true")
    private boolean addDefaultLicenseMatchers;
    @Parameter(required=false)
    private String[] approvedLicenses;
    @Parameter(property="rat.approvedFile")
    private String approvedLicenseFile;
    @Parameter
    private License[] licenses;
    @Parameter
    private Family[] families;
    @Parameter
    private String[] includes;
    @Parameter(property="rat.includesFile")
    private String includesFile;
    @Parameter(property="rat.includesFileCharset", defaultValue="${project.build.sourceEncoding}")
    private String includesFileCharset;
    @Parameter
    private String[] excludes;
    @Parameter(property="rat.excludesFile")
    private String excludesFile;
    @Parameter(property="rat.excludesFileCharset", defaultValue="${project.build.sourceEncoding}")
    private String excludesFileCharset;
    @Parameter(property="rat.useDefaultExcludes", defaultValue="true")
    private boolean useDefaultExcludes;
    @Parameter(property="rat.useMavenDefaultExcludes", defaultValue="true")
    private boolean useMavenDefaultExcludes;
    @Parameter(property="rat.parseSCMIgnoresAsExcludes", defaultValue="true")
    private boolean parseSCMIgnoresAsExcludes;
    @Parameter(property="rat.useEclipseDefaultExcludes", defaultValue="true")
    private boolean useEclipseDefaultExcludes;
    @Parameter(property="rat.useIdeaDefaultExcludes", defaultValue="true")
    private boolean useIdeaDefaultExcludes;
    @Parameter(property="rat.excludeSubprojects", defaultValue="true")
    private boolean excludeSubProjects;
    @Parameter(property="rat.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;

    protected MavenProject getProject() {
        return this.project;
    }

    protected Defaults.Builder getDefaultsBuilder() {
        Defaults.Builder result = Defaults.builder();
        if (this.defaultLicenseFiles != null) {
            for (String defaultLicenseFile : this.defaultLicenseFiles) {
                try {
                    result.add(defaultLicenseFile);
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException(defaultLicenseFile + " is not a valid license file", (Throwable)e);
                }
            }
        }
        return result;
    }

    protected ReportConfiguration getConfiguration() throws MojoExecutionException {
        Log log;
        ReportConfiguration config = new ReportConfiguration();
        if (this.addDefaultLicenses) {
            config.setFrom(this.getDefaultsBuilder().build());
        }
        if (this.additionalLicenseFiles != null) {
            for (String licenseFile : this.additionalLicenseFiles) {
                try {
                    LicenseReader lReader;
                    URL url = new File(licenseFile).toURI().toURL();
                    Format fmt = Format.fromName((String)licenseFile);
                    MatcherReader mReader = fmt.matcherReader();
                    if (mReader != null) {
                        mReader.addMatchers(url);
                    }
                    if ((lReader = fmt.licenseReader()) == null) continue;
                    lReader.addLicenses(url);
                    config.addLicenses((Collection)lReader.readLicenses());
                    config.addApprovedLicenseCategories((Collection)lReader.approvedLicenseId());
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException(licenseFile + " is not a valid license file", (Throwable)e);
                }
            }
        }
        if (this.families != null) {
            log = this.getLog();
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)String.format("%s license families loaded from pom", this.families.length));
            }
            Consumer<ILicenseFamily> logger = log.isDebugEnabled() ? l -> log.debug((CharSequence)String.format("Family: %s", l)) : l -> {};
            Consumer<ILicenseFamily> process = logger.andThen(arg_0 -> ((ReportConfiguration)config).addFamily(arg_0));
            Arrays.stream(this.families).map(Family::build).forEach(process);
        }
        if (this.approvedLicenses != null && this.approvedLicenses.length > 0) {
            Arrays.stream(this.approvedLicenses).forEach(arg_0 -> ((ReportConfiguration)config).addApprovedLicenseCategory(arg_0));
        }
        if (this.licenses != null) {
            log = this.getLog();
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)String.format("%s licenses loaded from pom", this.licenses.length));
            }
            Consumer<ILicense> logger = log.isDebugEnabled() ? l -> log.debug((CharSequence)String.format("License: %s", l)) : l -> {};
            Consumer<ILicense> addApproved = this.approvedLicenses == null || this.approvedLicenses.length == 0 ? l -> config.addApprovedLicenseCategory(l.getLicenseFamily()) : l -> {};
            Consumer<ILicense> process = logger.andThen(arg_0 -> ((ReportConfiguration)config).addLicense(arg_0)).andThen(addApproved);
            SortedSet families = config.getLicenseFamilies(LicenseSetFactory.LicenseFilter.all);
            Arrays.stream(this.licenses).map(x -> x.build(families)).forEach(process);
        }
        config.setReportable(this.getReportable());
        return config;
    }

    protected void logLicenses(Collection<ILicense> licenses) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("The following " + licenses.size() + " licenses are activated:"));
            for (ILicense license : licenses) {
                this.getLog().debug((CharSequence)("* " + license.toString()));
            }
        }
    }

    private IReportable getReportable() throws MojoExecutionException {
        IgnoringDirectoryScanner ds = new IgnoringDirectoryScanner();
        ds.setBasedir(this.basedir);
        this.setExcludes(ds);
        this.setIncludes(ds);
        ds.scan();
        this.whenDebuggingLogExcludedFiles(ds);
        String[] files = ds.getIncludedFiles();
        this.logAboutIncludedFiles(files);
        try {
            return new FilesReportable(this.basedir, files);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private void logAboutIncludedFiles(String[] files) {
        if (files.length == 0) {
            this.getLog().warn((CharSequence)"No resources included.");
        } else {
            this.getLog().debug((CharSequence)(files.length + " resources included"));
            if (this.getLog().isDebugEnabled()) {
                for (String resource : files) {
                    this.getLog().debug((CharSequence)(" - included " + resource));
                }
            }
        }
    }

    private void whenDebuggingLogExcludedFiles(DirectoryScanner ds) {
        if (this.getLog().isDebugEnabled()) {
            String[] excludedFiles = ds.getExcludedFiles();
            if (excludedFiles.length == 0) {
                this.getLog().debug((CharSequence)"No excluded resources.");
            } else {
                this.getLog().debug((CharSequence)("Excluded " + excludedFiles.length + " resources:"));
                for (String resource : excludedFiles) {
                    this.getLog().debug((CharSequence)(" - excluded " + resource));
                }
            }
        }
    }

    private void setIncludes(DirectoryScanner ds) throws MojoExecutionException {
        if (this.includes != null && this.includes.length > 0 || this.includesFile != null) {
            ArrayList<String> includeList = new ArrayList<String>();
            if (this.includes != null) {
                includeList.addAll(Arrays.asList(this.includes));
            }
            if (this.includesFile != null) {
                String charset = this.includesFileCharset == null ? "UTF8" : this.includesFileCharset;
                File f = new File(this.includesFile);
                if (!f.isFile()) {
                    this.getLog().error((CharSequence)("IncludesFile not found: " + f.getAbsolutePath()));
                } else {
                    this.getLog().debug((CharSequence)("Includes loaded from file " + this.includesFile + ", using character set " + charset));
                }
                includeList.addAll(this.getPatternsFromFile(f, charset));
            }
            ds.setIncludes(includeList.toArray(new String[includeList.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getPatternsFromFile(File pFile, String pCharset) throws MojoExecutionException {
        InputStream is = null;
        BufferedInputStream bis = null;
        Reader r = null;
        BufferedReader br = null;
        Throwable th = null;
        ArrayList<String> patterns = new ArrayList<String>();
        try {
            String s;
            is = Files.newInputStream(pFile.toPath(), new OpenOption[0]);
            bis = new BufferedInputStream(is);
            r = new InputStreamReader((InputStream)bis, pCharset);
            br = new BufferedReader(r);
            while ((s = br.readLine()) != null) {
                patterns.add(s);
            }
            br.close();
            br = null;
            r.close();
            r = null;
            bis.close();
            bis = null;
            is.close();
            is = null;
        }
        catch (Throwable t) {
            th = t;
        }
        finally {
            block41: {
                block40: {
                    block39: {
                        block38: {
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (Throwable t) {
                                    if (th != null) break block38;
                                    th = t;
                                }
                            }
                        }
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable t) {
                                if (th != null) break block39;
                                th = t;
                            }
                        }
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Throwable t) {
                            if (th != null) break block40;
                            th = t;
                        }
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable t) {
                        if (th != null) break block41;
                        th = t;
                    }
                }
            }
        }
        if (th != null) {
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new MojoExecutionException(th.getMessage(), th);
        }
        return patterns;
    }

    private void setExcludes(IgnoringDirectoryScanner ds) throws MojoExecutionException {
        List<IgnoreMatcher> ignoreMatchers = this.mergeDefaultExclusions();
        if (this.excludes == null || this.excludes.length == 0) {
            this.getLog().debug((CharSequence)"No excludes explicitly specified.");
        } else {
            this.getLog().debug((CharSequence)(this.excludes.length + " explicit excludes."));
            for (String exclude : this.excludes) {
                this.getLog().debug((CharSequence)("Exclude: " + exclude));
            }
        }
        ArrayList<String> globExcludes = new ArrayList<String>();
        for (IgnoreMatcher ignoreMatcher : ignoreMatchers) {
            if (ignoreMatcher instanceof GlobIgnoreMatcher) {
                globExcludes.addAll(((GlobIgnoreMatcher)ignoreMatcher).getExclusionLines());
                continue;
            }
            ds.addIgnoreMatcher(ignoreMatcher);
        }
        if (this.excludes != null) {
            Collections.addAll(globExcludes, this.excludes);
        }
        if (!globExcludes.isEmpty()) {
            String[] allExcludes = globExcludes.toArray(new String[globExcludes.size()]);
            ds.setExcludes(allExcludes);
        }
    }

    private List<IgnoreMatcher> mergeDefaultExclusions() throws MojoExecutionException {
        ArrayList<IgnoreMatcher> ignoreMatchers = new ArrayList<IgnoreMatcher>();
        GlobIgnoreMatcher basicRules = new GlobIgnoreMatcher();
        basicRules.addRules(ExclusionHelper.addPlexusAndScmDefaults(this.getLog(), this.useDefaultExcludes));
        basicRules.addRules(ExclusionHelper.addMavenDefaults(this.getLog(), this.useMavenDefaultExcludes));
        basicRules.addRules(ExclusionHelper.addEclipseDefaults(this.getLog(), this.useEclipseDefaultExcludes));
        basicRules.addRules(ExclusionHelper.addIdeaDefaults(this.getLog(), this.useIdeaDefaultExcludes));
        if (this.parseSCMIgnoresAsExcludes) {
            this.getLog().debug((CharSequence)"Will parse SCM ignores for exclusions...");
            ignoreMatchers.addAll(ScmIgnoreParser.getExclusionsFromSCM(this.getLog(), this.project.getBasedir()));
            this.getLog().debug((CharSequence)"Finished adding exclusions from SCM ignore files.");
        }
        if (this.excludeSubProjects && this.project != null && this.project.getModules() != null) {
            for (String moduleSubPath : this.project.getModules()) {
                if (new File(this.basedir, moduleSubPath).isDirectory()) {
                    basicRules.addRule(moduleSubPath + "/**/*");
                    continue;
                }
                basicRules.addRule(StringUtils.substringBeforeLast((String)moduleSubPath, (String)"/") + "/**/*");
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Finished creating list of implicit excludes.");
            if (basicRules.getExclusionLines().isEmpty() && ignoreMatchers.isEmpty()) {
                this.getLog().debug((CharSequence)"No excludes implicitly specified.");
            } else {
                if (!basicRules.getExclusionLines().isEmpty()) {
                    this.getLog().debug((CharSequence)(basicRules.getExclusionLines().size() + " implicit excludes."));
                    for (String exclude : basicRules.getExclusionLines()) {
                        this.getLog().debug((CharSequence)("Implicit exclude: " + exclude));
                    }
                }
                for (IgnoreMatcher ignoreMatcher : ignoreMatchers) {
                    if (ignoreMatcher instanceof GlobIgnoreMatcher) {
                        GlobIgnoreMatcher globIgnoreMatcher = (GlobIgnoreMatcher)ignoreMatcher;
                        if (globIgnoreMatcher.getExclusionLines().isEmpty()) continue;
                        this.getLog().debug((CharSequence)(globIgnoreMatcher.getExclusionLines().size() + " implicit excludes from SCM."));
                        for (String exclude : globIgnoreMatcher.getExclusionLines()) {
                            this.getLog().debug((CharSequence)("Implicit exclude: " + exclude));
                        }
                        continue;
                    }
                    this.getLog().debug((CharSequence)("Implicit exclude: \n" + ignoreMatcher));
                }
            }
        }
        if (this.excludesFile != null) {
            File f = new File(this.excludesFile);
            if (!f.isFile()) {
                this.getLog().error((CharSequence)("Excludes file not found: " + f.getAbsolutePath()));
            }
            if (!f.canRead()) {
                this.getLog().error((CharSequence)("Excludes file not readable: " + f.getAbsolutePath()));
            }
            String charset = this.excludesFileCharset == null ? "UTF8" : this.excludesFileCharset;
            this.getLog().debug((CharSequence)("Loading excludes from file " + f + ", using character set " + charset));
            basicRules.addRules(this.getPatternsFromFile(f, charset));
        }
        if (!basicRules.isEmpty()) {
            ignoreMatchers.add(basicRules);
        }
        return ignoreMatchers;
    }
}

