/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp.util.ignore;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.logging.Log;
import org.apache.rat.mp.util.ignore.IgnoreMatcher;

public class GlobIgnoreMatcher
implements IgnoreMatcher {
    final List<String> exclusionLines = new ArrayList<String>();
    private static final List<String> COMMENT_PREFIXES = Arrays.asList("#", "##", "//", "/**", "/*");

    public GlobIgnoreMatcher() {
    }

    public GlobIgnoreMatcher(Log log, File scmIgnore) {
        this.loadFile(log, scmIgnore);
    }

    public void addRule(String rule) {
        if (!this.exclusionLines.contains(rule)) {
            this.exclusionLines.add(rule);
        }
    }

    public void addRules(Collection<String> rules) {
        for (String rule : rules) {
            if (this.exclusionLines.contains(rule)) continue;
            this.exclusionLines.add(rule);
        }
    }

    public void loadFile(Log log, File scmIgnore) {
        if (scmIgnore != null && scmIgnore.exists() && scmIgnore.isFile()) {
            log.debug((CharSequence)("Parsing exclusions from " + scmIgnore));
            try (BufferedReader reader = new BufferedReader(new FileReader(scmIgnore));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (GlobIgnoreMatcher.isComment(line)) continue;
                    this.exclusionLines.add(line);
                    log.debug((CharSequence)("Added " + line));
                }
            }
            catch (IOException e) {
                log.warn((CharSequence)("Cannot parse " + scmIgnore + " for exclusions. Will skip this file."));
                log.debug((CharSequence)("Skip parsing " + scmIgnore + " due to " + e.getMessage()));
            }
        }
    }

    public static boolean isComment(String line) {
        if (line == null || line.length() <= 0) {
            return false;
        }
        String trimLine = line.trim();
        for (String prefix : COMMENT_PREFIXES) {
            if (!trimLine.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public List<String> getExclusionLines() {
        return this.exclusionLines;
    }

    @Override
    public boolean isEmpty() {
        return this.exclusionLines.isEmpty();
    }

    @Override
    public Optional<Boolean> isIgnoredFile(String filename) {
        return Optional.empty();
    }
}

