/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.rat.Defaults;
import org.apache.rat.Report;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.util.HeaderMatcherMultiplexer;
import org.apache.rat.api.RatException;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.mp.FilesReportable;
import org.apache.rat.mp.HeaderMatcherSpecification;
import org.apache.rat.mp.LicenseFamilySpecification;
import org.apache.rat.mp.util.ConfigurationHelper;
import org.apache.rat.mp.util.ExclusionHelper;
import org.apache.rat.mp.util.ScmIgnoreParser;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.claim.ClaimStatistic;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRatMojo
extends AbstractMojo {
    @Parameter(property="rat.basedir", defaultValue="${basedir}", required=true)
    private File basedir;
    @Deprecated
    @Parameter
    private HeaderMatcherSpecification[] licenseMatchers;
    @Parameter
    private IHeaderMatcher[] licenses;
    @Deprecated
    private LicenseFamilySpecification[] licenseFamilyNames;
    @Parameter
    private ILicenseFamily[] licenseFamilies;
    @Parameter(property="rat.addDefaultLicenseMatchers", defaultValue="true")
    private boolean addDefaultLicenseMatchers;
    @Parameter
    private String[] includes;
    @Parameter(property="rat.includesFile")
    private String includesFile;
    @Parameter(property="rat.includesFileCharset", defaultValue="${project.build.sourceEncoding}")
    private String includesFileCharset;
    @Parameter
    private String[] excludes;
    @Parameter(property="rat.excludesFile")
    private String excludesFile;
    @Parameter(property="rat.excludesFileCharset", defaultValue="${project.build.sourceEncoding}")
    private String excludesFileCharset;
    @Parameter(property="rat.useDefaultExcludes", defaultValue="true")
    private boolean useDefaultExcludes;
    @Parameter(property="rat.useMavenDefaultExcludes", defaultValue="true")
    private boolean useMavenDefaultExcludes;
    @Parameter(property="rat.parseSCMIgnoresAsExcludes", defaultValue="true")
    private boolean parseSCMIgnoresAsExcludes;
    @Parameter(property="rat.useEclipseDefaultExcludes", defaultValue="true")
    private boolean useEclipseDefaultExcludes;
    @Parameter(property="rat.useIdeaDefaultExcludes", defaultValue="true")
    private boolean useIdeaDefaultExcludes;
    @Parameter(property="rat.excludeSubprojects", defaultValue="true")
    private boolean excludeSubProjects;
    @Parameter(property="rat.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    protected MavenProject getProject() {
        return this.project;
    }

    private List<IHeaderMatcher> mergeLicenseMatchers() throws MojoFailureException, MojoExecutionException {
        ArrayList<IHeaderMatcher> matchers = new ArrayList<IHeaderMatcher>();
        if (this.licenses != null) {
            matchers.addAll(Arrays.asList(this.licenses));
            this.getLog().info((CharSequence)("Added " + this.licenses.length + " additional default licenses."));
        }
        if (this.licenseMatchers != null) {
            for (HeaderMatcherSpecification spec : this.licenseMatchers) {
                matchers.add(ConfigurationHelper.newInstance(IHeaderMatcher.class, spec.getClassName()));
            }
        }
        if (this.addDefaultLicenseMatchers) {
            this.getLog().info((CharSequence)"Enabled default license matchers.");
            matchers.addAll(Defaults.DEFAULT_MATCHERS);
        }
        this.logLicenseMatchers(matchers);
        return matchers;
    }

    private void logLicenseMatchers(List<IHeaderMatcher> matchers) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"The following license matchers are activated:");
            for (IHeaderMatcher matcher : matchers) {
                this.getLog().debug((CharSequence)("* " + matcher.toString()));
            }
        }
    }

    protected IReportable getResources() throws MojoExecutionException {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.basedir);
        this.setExcludes(ds);
        this.setIncludes(ds);
        ds.scan();
        this.whenDebuggingLogExcludedFiles(ds);
        String[] files = ds.getIncludedFiles();
        this.logAboutIncludedFiles(files);
        try {
            return new FilesReportable(this.basedir, files);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private void logAboutIncludedFiles(String[] files) {
        if (files.length == 0) {
            this.getLog().warn((CharSequence)"No resources included.");
        } else {
            this.getLog().info((CharSequence)(files.length + " resources included (use -debug for more details)"));
            if (this.getLog().isDebugEnabled()) {
                for (String resource : files) {
                    this.getLog().debug((CharSequence)(" - included " + resource));
                }
            }
        }
    }

    private void whenDebuggingLogExcludedFiles(DirectoryScanner ds) {
        if (this.getLog().isDebugEnabled()) {
            String[] excludedFiles = ds.getExcludedFiles();
            if (excludedFiles.length == 0) {
                this.getLog().debug((CharSequence)"No excluded resources.");
            } else {
                this.getLog().debug((CharSequence)("Excluded " + excludedFiles.length + " resources:"));
                for (String resource : excludedFiles) {
                    this.getLog().debug((CharSequence)(" - excluded " + resource));
                }
            }
        }
    }

    private void setIncludes(DirectoryScanner ds) throws MojoExecutionException {
        if (this.includes != null && this.includes.length > 0 || this.includesFile != null) {
            ArrayList<String> includeList = new ArrayList<String>();
            if (this.includes != null) {
                includeList.addAll(Arrays.asList(this.includes));
            }
            if (this.includesFile != null) {
                String charset = this.includesFileCharset == null ? "UTF8" : this.includesFileCharset;
                File f = new File(this.includesFile);
                if (!f.isFile()) {
                    this.getLog().error((CharSequence)("IncludesFile not found: " + f.getAbsolutePath()));
                } else {
                    this.getLog().info((CharSequence)("Includes loaded from file " + this.includesFile + ", using character set " + charset));
                }
                includeList.addAll(this.getPatternsFromFile(f, charset));
            }
            ds.setIncludes(includeList.toArray(new String[includeList.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<String> getPatternsFromFile(File pFile, String pCharset) throws MojoExecutionException {
        ArrayList<String> patterns;
        Throwable th;
        block47: {
            Throwable t222222;
            BufferedReader br;
            Reader r;
            BufferedInputStream bis;
            FileInputStream is;
            block39: {
                block38: {
                    block37: {
                        String s;
                        is = null;
                        bis = null;
                        r = null;
                        br = null;
                        th = null;
                        patterns = new ArrayList<String>();
                        is = new FileInputStream(pFile);
                        bis = new BufferedInputStream(is);
                        r = new InputStreamReader((InputStream)bis, pCharset);
                        br = new BufferedReader(r);
                        while ((s = br.readLine()) != null) {
                            patterns.add(s);
                        }
                        br.close();
                        br = null;
                        r.close();
                        r = null;
                        bis.close();
                        bis = null;
                        ((InputStream)is).close();
                        is = null;
                        Object var11_11 = null;
                        if (br == null) break block37;
                        try {
                            br.close();
                        }
                        catch (Throwable t222222) {
                            if (th != null) break block37;
                            th = t222222;
                        }
                    }
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable t222222) {
                            if (th != null) break block38;
                            th = t222222;
                        }
                    }
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Throwable t222222) {
                        if (th != null) break block39;
                        th = t222222;
                    }
                }
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable t222222) {
                    if (th == null) {
                        th = t222222;
                    }
                }
            }
            break block47;
            {
                catch (Throwable t3) {
                    Throwable t222222;
                    block42: {
                        block41: {
                            block40: {
                                th = t3;
                                Object var11_12 = null;
                                if (br != null) {
                                    try {
                                        br.close();
                                    }
                                    catch (Throwable t222222) {
                                        if (th != null) break block40;
                                        th = t222222;
                                    }
                                }
                            }
                            if (r != null) {
                                try {
                                    r.close();
                                }
                                catch (Throwable t222222) {
                                    if (th != null) break block41;
                                    th = t222222;
                                }
                            }
                        }
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (Throwable t222222) {
                                if (th != null) break block42;
                                th = t222222;
                            }
                        }
                    }
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable t222222) {
                            if (th == null) {
                                th = t222222;
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block46: {
                    Throwable t222222;
                    block45: {
                        block44: {
                            block43: {
                                Object var11_13 = null;
                                if (br != null) {
                                    try {
                                        br.close();
                                    }
                                    catch (Throwable t222222) {
                                        if (th != null) break block43;
                                        th = t222222;
                                    }
                                }
                            }
                            if (r != null) {
                                try {
                                    r.close();
                                }
                                catch (Throwable t222222) {
                                    if (th != null) break block44;
                                    th = t222222;
                                }
                            }
                        }
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (Throwable t222222) {
                                if (th != null) break block45;
                                th = t222222;
                            }
                        }
                    }
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable t222222) {
                            if (th != null) break block46;
                            th = t222222;
                        }
                    }
                }
                throw throwable;
            }
        }
        if (th != null) {
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new MojoExecutionException(th.getMessage(), th);
        }
        return patterns;
    }

    private void setExcludes(DirectoryScanner ds) throws MojoExecutionException {
        List<String> excludeList = this.mergeDefaultExclusions();
        if (this.excludes == null || this.excludes.length == 0) {
            this.getLog().info((CharSequence)"No excludes explicitly specified.");
        } else {
            this.getLog().info((CharSequence)(this.excludes.length + " explicit excludes (use -debug for more details)."));
            for (String exclude : this.excludes) {
                this.getLog().debug((CharSequence)("Exclude: " + exclude));
            }
        }
        if (this.excludes != null) {
            Collections.addAll(excludeList, this.excludes);
        }
        if (!excludeList.isEmpty()) {
            String[] allExcludes = excludeList.toArray(new String[excludeList.size()]);
            ds.setExcludes(allExcludes);
        }
    }

    private List<String> mergeDefaultExclusions() throws MojoExecutionException {
        HashSet<String> results = new HashSet<String>();
        ExclusionHelper.addPlexusAndScmDefaults(this.getLog(), this.useDefaultExcludes, results);
        ExclusionHelper.addMavenDefaults(this.getLog(), this.useMavenDefaultExcludes, results);
        ExclusionHelper.addEclipseDefaults(this.getLog(), this.useEclipseDefaultExcludes, results);
        ExclusionHelper.addIdeaDefaults(this.getLog(), this.useIdeaDefaultExcludes, results);
        if (this.parseSCMIgnoresAsExcludes) {
            this.getLog().info((CharSequence)"Will parse SCM ignores for exclusions...");
            results.addAll(ScmIgnoreParser.getExclusionsFromSCM(this.getLog(), this.project.getBasedir()));
            this.getLog().info((CharSequence)"Finished adding exclusions from SCM ignore files.");
        }
        if (this.excludeSubProjects && this.project != null && this.project.getModules() != null) {
            for (Object o : this.project.getModules()) {
                String moduleSubPath = (String)o;
                results.add(moduleSubPath + "/**/*");
            }
        }
        this.getLog().debug((CharSequence)"Finished creating list of implicit excludes.");
        if (results.isEmpty()) {
            this.getLog().info((CharSequence)"No excludes implicitly specified.");
        } else {
            this.getLog().info((CharSequence)(results.size() + " implicit excludes (use -debug for more details)."));
            for (String exclude : results) {
                this.getLog().debug((CharSequence)("Implicit exclude: " + exclude));
            }
        }
        if (this.excludesFile != null) {
            File f = new File(this.excludesFile);
            if (!f.isFile()) {
                this.getLog().error((CharSequence)("Excludes file not found: " + f.getAbsolutePath()));
            }
            if (!f.canRead()) {
                this.getLog().error((CharSequence)("Excludes file not readable: " + f.getAbsolutePath()));
            }
            String charset = this.excludesFileCharset == null ? "UTF8" : this.excludesFileCharset;
            this.getLog().info((CharSequence)("Loading excludes from file " + f + ", using character set " + charset));
            results.addAll(this.getPatternsFromFile(f, charset));
        }
        return new ArrayList<String>(results);
    }

    protected String createReport(InputStream styleSheet) throws MojoExecutionException, MojoFailureException {
        String string;
        StringWriter sw = new StringWriter();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(sw);
            this.createReport(new PrintWriter(sw), styleSheet);
            String result = sw.toString();
            pw.close();
            pw = null;
            sw.close();
            sw = null;
            string = result;
            Object var7_7 = null;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                IOUtils.closeQuietly((Writer)pw);
                IOUtils.closeQuietly((Writer)sw);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)pw);
        IOUtils.closeQuietly((Writer)sw);
        return string;
    }

    protected ClaimStatistic createReport(Writer out, InputStream style) throws MojoExecutionException, MojoFailureException {
        ReportConfiguration configuration = this.getConfiguration();
        try {
            if (style != null) {
                return Report.report((Writer)out, (IReportable)this.getResources(), (InputStream)style, (ReportConfiguration)configuration);
            }
            return Report.report((IReportable)this.getResources(), (Writer)out, (ReportConfiguration)configuration);
        }
        catch (TransformerConfigurationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (RatException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected ReportConfiguration getConfiguration() throws MojoFailureException, MojoExecutionException {
        ReportConfiguration configuration = new ReportConfiguration();
        configuration.setHeaderMatcher((IHeaderMatcher)new HeaderMatcherMultiplexer(this.mergeLicenseMatchers()));
        configuration.setApprovedLicenseNames(this.mergeApprovedLicenseNames());
        configuration.setApproveDefaultLicenses(this.addDefaultLicenseMatchers);
        return configuration;
    }

    private List<ILicenseFamily> mergeApprovedLicenseNames() throws MojoExecutionException, MojoFailureException {
        ArrayList<ILicenseFamily> list = new ArrayList<ILicenseFamily>();
        if (this.licenseFamilies != null) {
            this.getLog().info((CharSequence)("Added " + this.licenseFamilies.length + " custom approved licenses."));
            list.addAll(Arrays.asList(this.licenseFamilies));
        }
        if (this.licenseFamilyNames != null) {
            for (LicenseFamilySpecification spec : this.licenseFamilyNames) {
                list.add(ConfigurationHelper.newInstance(ILicenseFamily.class, spec.getClassName()));
            }
        }
        return list;
    }
}

