/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.rat.Defaults;
import org.apache.rat.mp.AbstractRatMojo;
import org.codehaus.doxia.sink.Sink;

@Mojo(name="rat", requiresDependencyResolution=ResolutionScope.TEST)
public class RatReportMojo
extends AbstractRatMojo
implements MavenReport {
    @Component
    private Renderer siteRenderer;
    @Component
    private ArtifactFactory factory;
    @Component
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;

    private File getSkinArtifactFile() throws MojoFailureException, MojoExecutionException {
        Artifact artifact;
        Skin skin = Skin.getDefaultSkin();
        String version = skin.getVersion();
        try {
            if (version == null) {
                version = "RELEASE";
            }
            VersionRange versionSpec = VersionRange.createFromVersionSpec((String)version);
            artifact = this.factory.createDependencyArtifact(skin.getGroupId(), skin.getArtifactId(), versionSpec, "jar", null, null);
            this.resolver.resolve(artifact, this.getProject().getRemoteArtifactRepositories(), this.localRepository);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoFailureException("The skin version '" + version + "' is not valid: " + e.getMessage());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to find skin", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoFailureException("The skin does not exist: " + e.getMessage());
        }
        return artifact.getFile();
    }

    private String createReport() throws MojoExecutionException, MojoFailureException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(sw);
            this.createReport(new PrintWriter(sw), Defaults.getDefaultStyleSheet());
            String result = sw.toString();
            pw.close();
            pw = null;
            sw.close();
            sw = null;
            String string = result;
            return string;
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Throwable t) {}
            }
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        DecorationModel model = new DecorationModel();
        model.setBody(new Body());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("outputEncoding", "UTF-8");
        Locale locale = Locale.getDefault();
        try {
            SiteRenderingContext siteContext = this.siteRenderer.createContextForSkin(this.getSkinArtifactFile(), attributes, model, this.getName(locale), locale);
            RenderingContext context = new RenderingContext(this.outputDirectory, this.getOutputName() + ".html");
            SiteRendererSink sink = new SiteRendererSink(context);
            this.generate((Sink)sink, locale);
            if (!this.outputDirectory.mkdirs() && !this.outputDirectory.isDirectory()) {
                throw new IOException("Could not created output directory " + this.outputDirectory);
            }
            FileWriter writer = new FileWriter(new File(this.outputDirectory, this.getOutputName() + ".html"));
            this.siteRenderer.generateDocument((Writer)writer, sink, siteContext);
            this.siteRenderer.copyResources(siteContext, new File(this.getProject().getBasedir(), "src/site/resources"), this.outputDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (RendererException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public boolean canGenerateReport() {
        return true;
    }

    private String getRatVersion() {
        for (Artifact a : this.getProject().getDependencyArtifacts()) {
            if (!"rat-lib".equals(a.getArtifactId())) continue;
            return a.getVersion();
        }
        return null;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        ResourceBundle bundle = this.getBundle(locale);
        String title = bundle.getString("report.rat.title");
        sink.head();
        sink.title();
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(title);
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(bundle.getString("report.rat.link") + " ");
        sink.link(bundle.getString("report.rat.url"));
        sink.text(bundle.getString("report.rat.fullName"));
        sink.link_();
        String ratVersion = this.getRatVersion();
        if (ratVersion != null) {
            sink.text(" " + ratVersion);
        }
        sink.text(".");
        sink.paragraph_();
        sink.paragraph();
        sink.verbatim(true);
        try {
            sink.text(this.createReport());
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        catch (MojoFailureException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        sink.verbatim_();
        sink.paragraph_();
        sink.section1_();
        sink.body_();
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("org/apache/rat/mp/rat-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.rat.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.rat.name");
    }

    public String getOutputName() {
        return "rat-report";
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isExternalReport() {
        return false;
    }

    public void setReportOutputDirectory(File pOutputDirectory) {
        this.outputDirectory = pOutputDirectory;
    }
}

