/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.authorization.hadoop.utils.RangerCredentialProvider;
import org.apache.ranger.authorization.utils.StringUtil;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;

public class RangerRESTClient {
    private static final Log LOG = LogFactory.getLog(RangerRESTClient.class);
    public static final String RANGER_PROP_POLICYMGR_URL = "ranger.service.store.rest.url";
    public static final String RANGER_PROP_POLICYMGR_SSLCONFIG_FILENAME = "ranger.service.store.rest.ssl.config.file";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE = "xasecure.policymgr.clientssl.keystore";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE = "xasecure.policymgr.clientssl.keystore.type";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL = "xasecure.policymgr.clientssl.keystore.credential.file";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL_ALIAS = "sslKeyStore";
    public static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE_DEFAULT = "jks";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE = "xasecure.policymgr.clientssl.truststore";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE = "xasecure.policymgr.clientssl.truststore.type";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL = "xasecure.policymgr.clientssl.truststore.credential.file";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL_ALIAS = "sslTrustStore";
    public static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE_DEFAULT = "jks";
    public static final String RANGER_SSL_KEYMANAGER_ALGO_TYPE = KeyManagerFactory.getDefaultAlgorithm();
    public static final String RANGER_SSL_TRUSTMANAGER_ALGO_TYPE = TrustManagerFactory.getDefaultAlgorithm();
    public static final String RANGER_SSL_CONTEXT_ALGO_TYPE = "TLS";
    private String mUrl;
    private String mSslConfigFileName;
    private String mUsername;
    private String mPassword;
    private boolean mIsSSL;
    private String mKeyStoreURL;
    private String mKeyStoreAlias;
    private String mKeyStoreFile;
    private String mKeyStoreType;
    private String mTrustStoreURL;
    private String mTrustStoreAlias;
    private String mTrustStoreFile;
    private String mTrustStoreType;
    private Gson gsonBuilder;
    private volatile Client client;
    private int mRestClientConnTimeOutMs;
    private int mRestClientReadTimeOutMs;

    public RangerRESTClient() {
        this(RangerConfiguration.getInstance().get(RANGER_PROP_POLICYMGR_URL), RangerConfiguration.getInstance().get(RANGER_PROP_POLICYMGR_SSLCONFIG_FILENAME));
    }

    public RangerRESTClient(String url, String sslConfigFileName) {
        this.mUrl = url;
        this.mSslConfigFileName = sslConfigFileName;
        this.init();
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int getRestClientConnTimeOutMs() {
        return this.mRestClientConnTimeOutMs;
    }

    public void setRestClientConnTimeOutMs(int mRestClientConnTimeOutMs) {
        this.mRestClientConnTimeOutMs = mRestClientConnTimeOutMs;
    }

    public int getRestClientReadTimeOutMs() {
        return this.mRestClientReadTimeOutMs;
    }

    public void setRestClientReadTimeOutMs(int mRestClientReadTimeOutMs) {
        this.mRestClientReadTimeOutMs = mRestClientReadTimeOutMs;
    }

    public void setBasicAuthInfo(String username, String password) {
        this.mUsername = username;
        this.mPassword = password;
    }

    public WebResource getResource(String relativeUrl) {
        WebResource ret = this.getClient().resource(this.getUrl() + relativeUrl);
        return ret;
    }

    public String toJson(Object obj) {
        return this.gsonBuilder.toJson(obj);
    }

    public <T> T fromJson(String json, Class<T> cls) {
        return (T)this.gsonBuilder.fromJson(json, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getClient() {
        Client result = this.client;
        if (result == null) {
            RangerRESTClient rangerRESTClient = this;
            synchronized (rangerRESTClient) {
                result = this.client;
                if (result == null) {
                    this.client = result = this.buildClient();
                }
            }
        }
        return result;
    }

    private Client buildClient() {
        Client client = null;
        if (this.mIsSSL) {
            KeyManager[] kmList = this.getKeyManagers();
            TrustManager[] tmList = this.getTrustManagers();
            SSLContext sslContext = this.getSSLContext(kmList, tmList);
            DefaultClientConfig config = new DefaultClientConfig();
            config.getClasses().add(JacksonJsonProvider.class);
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return session.getPeerHost().equals(urlHostName);
                }
            };
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hv, sslContext));
            client = Client.create((ClientConfig)config);
        }
        if (client == null) {
            DefaultClientConfig config = new DefaultClientConfig();
            config.getClasses().add(JacksonJsonProvider.class);
            client = Client.create((ClientConfig)config);
        }
        if (!StringUtils.isEmpty((String)this.mUsername) && !StringUtils.isEmpty((String)this.mPassword)) {
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.mUsername, this.mPassword));
        }
        client.setConnectTimeout(Integer.valueOf(this.mRestClientConnTimeOutMs));
        client.setReadTimeout(Integer.valueOf(this.mRestClientReadTimeOutMs));
        return client;
    }

    public void resetClient() {
        this.client = null;
    }

    private void init() {
        try {
            this.gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
        }
        catch (Throwable excp) {
            LOG.fatal((Object)"RangerRESTClient.init(): failed to create GsonBuilder object", excp);
        }
        this.mIsSSL = StringUtil.containsIgnoreCase(this.mUrl, "https");
        if (this.mIsSSL) {
            InputStream in = null;
            try {
                Configuration conf = new Configuration();
                in = this.getFileInputStream(this.mSslConfigFileName);
                if (in != null) {
                    conf.addResource(in);
                }
                this.mKeyStoreURL = conf.get(RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL);
                this.mKeyStoreAlias = RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL_ALIAS;
                this.mKeyStoreType = conf.get(RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE, "jks");
                this.mKeyStoreFile = conf.get(RANGER_POLICYMGR_CLIENT_KEY_FILE);
                this.mTrustStoreURL = conf.get(RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL);
                this.mTrustStoreAlias = RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL_ALIAS;
                this.mTrustStoreType = conf.get(RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE, "jks");
                this.mTrustStoreFile = conf.get(RANGER_POLICYMGR_TRUSTSTORE_FILE);
                this.close(in, this.mSslConfigFileName);
            }
            catch (IOException ioe) {
                try {
                    LOG.error((Object)("Unable to load SSL Config FileName: [" + this.mSslConfigFileName + "]"), (Throwable)ioe);
                    this.close(in, this.mSslConfigFileName);
                }
                catch (Throwable throwable) {
                    this.close(in, this.mSslConfigFileName);
                    throw throwable;
                }
            }
        }
    }

    private KeyManager[] getKeyManagers() {
        KeyManager[] kmList;
        block12: {
            kmList = null;
            String keyStoreFilepwd = this.getCredential(this.mKeyStoreURL, this.mKeyStoreAlias);
            if (!StringUtil.isEmpty(this.mKeyStoreFile) && !StringUtil.isEmpty(keyStoreFilepwd)) {
                InputStream in = null;
                try {
                    in = this.getFileInputStream(this.mKeyStoreFile);
                    if (in != null) {
                        KeyStore keyStore = KeyStore.getInstance(this.mKeyStoreType);
                        keyStore.load(in, keyStoreFilepwd.toCharArray());
                        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(RANGER_SSL_KEYMANAGER_ALGO_TYPE);
                        keyManagerFactory.init(keyStore, keyStoreFilepwd.toCharArray());
                        kmList = keyManagerFactory.getKeyManagers();
                        break block12;
                    }
                    LOG.error((Object)("Unable to obtain keystore from file [" + this.mKeyStoreFile + "]"));
                    throw new IllegalStateException("Unable to find keystore file :" + this.mKeyStoreFile);
                }
                catch (KeyStoreException e) {
                    LOG.error((Object)("Unable to obtain from KeyStore :" + e.getMessage()), (Throwable)e);
                    throw new IllegalStateException("Unable to init keystore:" + e.getMessage(), e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.error((Object)"SSL algorithm is NOT available in the environment", (Throwable)e);
                    throw new IllegalStateException("SSL algorithm is NOT available in the environment :" + e.getMessage(), e);
                }
                catch (CertificateException e) {
                    LOG.error((Object)"Unable to obtain the requested certification ", (Throwable)e);
                    throw new IllegalStateException("Unable to obtain the requested certification :" + e.getMessage(), e);
                }
                catch (FileNotFoundException e) {
                    LOG.error((Object)"Unable to find the necessary SSL Keystore Files", (Throwable)e);
                    throw new IllegalStateException("Unable to find keystore file :" + this.mKeyStoreFile + ", error :" + e.getMessage(), e);
                }
                catch (IOException e) {
                    LOG.error((Object)"Unable to read the necessary SSL Keystore Files", (Throwable)e);
                    throw new IllegalStateException("Unable to read keystore file :" + this.mKeyStoreFile + ", error :" + e.getMessage(), e);
                }
                catch (UnrecoverableKeyException e) {
                    LOG.error((Object)"Unable to recover the key from keystore", (Throwable)e);
                    throw new IllegalStateException("Unable to recover the key from keystore :" + this.mKeyStoreFile + ", error :" + e.getMessage(), e);
                }
                finally {
                    this.close(in, this.mKeyStoreFile);
                }
            }
        }
        return kmList;
    }

    private TrustManager[] getTrustManagers() {
        TrustManager[] tmList;
        block11: {
            tmList = null;
            String trustStoreFilepwd = this.getCredential(this.mTrustStoreURL, this.mTrustStoreAlias);
            if (!StringUtil.isEmpty(this.mTrustStoreFile) && !StringUtil.isEmpty(trustStoreFilepwd)) {
                InputStream in = null;
                try {
                    in = this.getFileInputStream(this.mTrustStoreFile);
                    if (in != null) {
                        KeyStore trustStore = KeyStore.getInstance(this.mTrustStoreType);
                        trustStore.load(in, trustStoreFilepwd.toCharArray());
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(RANGER_SSL_TRUSTMANAGER_ALGO_TYPE);
                        trustManagerFactory.init(trustStore);
                        tmList = trustManagerFactory.getTrustManagers();
                        break block11;
                    }
                    LOG.error((Object)("Unable to obtain truststore from file [" + this.mTrustStoreFile + "]"));
                    throw new IllegalStateException("Unable to find truststore file :" + this.mTrustStoreFile);
                }
                catch (KeyStoreException e) {
                    LOG.error((Object)"Unable to obtain from KeyStore", (Throwable)e);
                    throw new IllegalStateException("Unable to init keystore:" + e.getMessage(), e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.error((Object)("SSL algorithm is NOT available in the environment :" + e.getMessage()), (Throwable)e);
                    throw new IllegalStateException("SSL algorithm is NOT available in the environment :" + e.getMessage(), e);
                }
                catch (CertificateException e) {
                    LOG.error((Object)("Unable to obtain the requested certification :" + e.getMessage()), (Throwable)e);
                    throw new IllegalStateException("Unable to obtain the requested certification :" + e.getMessage(), e);
                }
                catch (FileNotFoundException e) {
                    LOG.error((Object)("Unable to find the necessary SSL TrustStore File:" + this.mTrustStoreFile), (Throwable)e);
                    throw new IllegalStateException("Unable to find trust store file :" + this.mTrustStoreFile + ", error :" + e.getMessage(), e);
                }
                catch (IOException e) {
                    LOG.error((Object)("Unable to read the necessary SSL TrustStore Files :" + this.mTrustStoreFile), (Throwable)e);
                    throw new IllegalStateException("Unable to read the trust store file :" + this.mTrustStoreFile + ", error :" + e.getMessage(), e);
                }
                finally {
                    this.close(in, this.mTrustStoreFile);
                }
            }
        }
        return tmList;
    }

    private SSLContext getSSLContext(KeyManager[] kmList, TrustManager[] tmList) {
        Validate.notNull((Object)tmList, (String)"TrustManager is not specified");
        try {
            SSLContext sslContext = SSLContext.getInstance(RANGER_SSL_CONTEXT_ALGO_TYPE);
            sslContext.init(kmList, tmList, new SecureRandom());
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)"SSL algorithm is not available in the environment", (Throwable)e);
            throw new IllegalStateException("SSL algorithm is not available in the environment: " + e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            LOG.error((Object)"Unable to initials the SSLContext", (Throwable)e);
            throw new IllegalStateException("Unable to initials the SSLContex: " + e.getMessage(), e);
        }
    }

    private String getCredential(String url, String alias) {
        return RangerCredentialProvider.getInstance().getCredentialString(url, alias);
    }

    private InputStream getFileInputStream(String fileName) throws IOException {
        InputStream in = null;
        if (!StringUtil.isEmpty(fileName)) {
            File f = new File(fileName);
            in = f.exists() ? new FileInputStream(f) : ClassLoader.getSystemResourceAsStream(fileName);
        }
        return in;
    }

    private void close(InputStream str, String filename) {
        if (str != null) {
            try {
                str.close();
            }
            catch (IOException excp) {
                LOG.error((Object)("Error while closing file: [" + filename + "]"), (Throwable)excp);
            }
        }
    }
}

