/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GrantRevokeRoleRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String grantor;
    private Set<String> grantorGroups;
    private Set<String> targetRoles;
    private Set<String> users;
    private Set<String> groups;
    private Set<String> roles;
    private Boolean grantOption = Boolean.FALSE;
    private String clientIPAddress;
    private String clientType;
    private String requestData;
    private String sessionId;
    private String clusterName;

    public GrantRevokeRoleRequest() {
        this(null, null, null, null, null, null, null, null, null, null, null);
    }

    public GrantRevokeRoleRequest(String grantor, Set<String> grantorGroups, Set<String> targetRoles, Set<String> users, Set<String> groups, Set<String> roles, Boolean grantOption, String clientIPAddress, String clientType, String requestData, String sessionId) {
        this.setGrantor(grantor);
        this.setGrantorGroups(grantorGroups);
        this.setTargetRoles(targetRoles);
        this.setUsers(users);
        this.setGroups(groups);
        this.setRoles(roles);
        this.setGrantOption(grantOption);
        this.setClientIPAddress(clientIPAddress);
        this.setClientType(clientType);
        this.setRequestData(requestData);
        this.setSessionId(sessionId);
        this.setClusterName(this.clusterName);
    }

    public String getGrantor() {
        return this.grantor;
    }

    public void setGrantor(String grantor) {
        this.grantor = grantor;
    }

    public Set<String> getGrantorGroups() {
        return this.grantorGroups;
    }

    public void setGrantorGroups(Set<String> grantorGroups) {
        this.grantorGroups = grantorGroups;
    }

    public Set<String> getTargetRoles() {
        return this.targetRoles;
    }

    public void setTargetRoles(Set<String> targetRoles) {
        this.targetRoles = targetRoles == null ? new HashSet() : targetRoles;
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public void setUsers(Set<String> users) {
        this.users = users == null ? new HashSet() : users;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles == null ? new HashSet() : roles;
    }

    public Boolean getGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(Boolean grantOption) {
        this.grantOption = grantOption == null ? Boolean.FALSE : grantOption;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setClientIPAddress(String clientIPAddress) {
        this.clientIPAddress = clientIPAddress;
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getRequestData() {
        return this.requestData;
    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("GrantRevokeRoleRequest={");
        sb.append("grantor={").append(this.grantor).append("} ");
        sb.append("targetRoles={");
        if (this.targetRoles != null) {
            for (String targetRole : this.targetRoles) {
                sb.append(targetRole).append(" ");
            }
        }
        sb.append("} ");
        sb.append("users={");
        if (this.users != null) {
            for (String user : this.users) {
                sb.append(user).append(" ");
            }
        }
        sb.append("} ");
        sb.append("groups={");
        if (this.roles != null) {
            for (String group : this.groups) {
                sb.append(group).append(" ");
            }
        }
        sb.append("} ");
        sb.append("roles={");
        if (this.roles != null) {
            for (String role : this.roles) {
                sb.append(role).append(" ");
            }
        }
        sb.append("} ");
        sb.append("grantOption={").append(this.grantOption).append("} ");
        sb.append("clientIPAddress={").append(this.clientIPAddress).append("} ");
        sb.append("clientType={").append(this.clientType).append("} ");
        sb.append("requestData={").append(this.requestData).append("} ");
        sb.append("sessionId={").append(this.sessionId).append("} ");
        sb.append("clusterName={").append(this.clusterName).append("} ");
        sb.append("}");
        return sb;
    }
}

