/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.ServicePolicies;

public interface RangerPolicyEngine {
    public static final String GROUP_PUBLIC = "public";
    public static final String ANY_ACCESS = "_any";
    public static final String ADMIN_ACCESS = "_admin";
    public static final String AUDIT_ALL = "audit-all";
    public static final String AUDIT_NONE = "audit-none";
    public static final String AUDIT_DEFAULT = "audit-default";
    public static final String USER_CURRENT = "{USER}";
    public static final String RESOURCE_OWNER = "{OWNER}";

    public void setUseForwardedIPAddress(boolean var1);

    public void setTrustedProxyAddresses(String[] var1);

    public boolean getUseForwardedIPAddress();

    public String[] getTrustedProxyAddresses();

    public RangerServiceDef getServiceDef();

    public long getPolicyVersion();

    public void preProcess(RangerAccessRequest var1);

    public void preProcess(Collection<RangerAccessRequest> var1);

    public RangerAccessResult evaluatePolicies(RangerAccessRequest var1, int var2, RangerAccessResultProcessor var3);

    public Collection<RangerAccessResult> evaluatePolicies(Collection<RangerAccessRequest> var1, int var2, RangerAccessResultProcessor var3);

    public RangerResourceACLs getResourceACLs(RangerAccessRequest var1);

    public String getMatchedZoneName(GrantRevokeRequest var1);

    public boolean preCleanup();

    public void cleanup();

    public void reorderPolicyEvaluators();

    public boolean isAccessAllowed(RangerAccessResource var1, String var2, Set<String> var3, String var4);

    public boolean isAccessAllowed(Map<String, RangerPolicy.RangerPolicyResource> var1, String var2, Set<String> var3, String var4);

    public boolean isAccessAllowed(RangerPolicy var1, String var2, Set<String> var3, String var4);

    public boolean isAccessAllowed(RangerPolicy var1, String var2, Set<String> var3, Set<String> var4, String var5);

    public List<RangerPolicy> getExactMatchPolicies(RangerAccessResource var1, Map<String, Object> var2);

    public List<RangerPolicy> getExactMatchPolicies(RangerPolicy var1, Map<String, Object> var2);

    public List<RangerPolicy> getMatchingPolicies(RangerAccessResource var1);

    public List<RangerPolicy> getMatchingPolicies(RangerAccessRequest var1);

    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest var1);

    public List<RangerPolicy> getAllowedPolicies(String var1, Set<String> var2, String var3);

    public RangerPolicyEngine cloneWithDelta(ServicePolicies var1);

    public Set<String> getRolesFromUserAndGroups(String var1, Set<String> var2);
}

