/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;

public class RangerAccessRequestReadOnly
implements RangerAccessRequest {
    private final RangerAccessRequest source;
    private final RangerAccessResource resource;
    private final Set<String> userGroups;
    private final List<String> forwardedAddresses;
    private final Map<String, Object> context;

    RangerAccessRequestReadOnly(RangerAccessRequest source) {
        this.source = source;
        this.resource = source.getResource().getReadOnlyCopy();
        this.userGroups = Collections.unmodifiableSet(source.getUserGroups());
        this.context = Collections.unmodifiableMap(source.getContext());
        this.forwardedAddresses = Collections.unmodifiableList(source.getForwardedAddresses());
    }

    @Override
    public RangerAccessResource getResource() {
        return this.resource;
    }

    @Override
    public String getAccessType() {
        return this.source.getAccessType();
    }

    @Override
    public boolean isAccessTypeAny() {
        return this.source.isAccessTypeAny();
    }

    @Override
    public boolean isAccessTypeDelegatedAdmin() {
        return this.source.isAccessTypeDelegatedAdmin();
    }

    @Override
    public String getUser() {
        return this.source.getUser();
    }

    @Override
    public Set<String> getUserGroups() {
        return this.userGroups;
    }

    @Override
    public Date getAccessTime() {
        return this.source.getAccessTime();
    }

    @Override
    public String getClientIPAddress() {
        return this.source.getClientIPAddress();
    }

    @Override
    public String getRemoteIPAddress() {
        return this.source.getRemoteIPAddress();
    }

    @Override
    public List<String> getForwardedAddresses() {
        return this.forwardedAddresses;
    }

    @Override
    public String getClientType() {
        return this.source.getClientType();
    }

    @Override
    public String getAction() {
        return this.source.getAction();
    }

    @Override
    public String getRequestData() {
        return this.source.getRequestData();
    }

    @Override
    public String getSessionId() {
        return this.source.getSessionId();
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public RangerAccessRequest getReadOnlyCopy() {
        return this;
    }

    @Override
    public RangerAccessRequest.ResourceMatchingScope getResourceMatchingScope() {
        return this.source.getResourceMatchingScope();
    }

    @Override
    public String getClusterName() {
        return this.source.getClusterName();
    }

    @Override
    public String getClusterType() {
        return this.source.getClusterType();
    }
}

