/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.geo;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.geo.RangeChecker;

public class RangerGeolocationData
implements Comparable<RangerGeolocationData>,
RangeChecker<Long> {
    private static final Log LOG = LogFactory.getLog(RangerGeolocationData.class);
    private static final Character IPSegmentsSeparator = Character.valueOf('.');
    private final long fromIPAddress;
    private final long toIPAddress;
    private final String[] locationData;
    private int hash;

    public static RangerGeolocationData create(String[] fields, int index, boolean useDotFormat) {
        RangerGeolocationData data = null;
        if (fields.length > 2) {
            String startAddress = fields[0];
            String endAddress = fields[1];
            if (RangerGeolocationData.validateAsIP(startAddress, useDotFormat) && RangerGeolocationData.validateAsIP(endAddress, useDotFormat)) {
                if (!useDotFormat) {
                    startAddress = RangerGeolocationData.unsignedIntToIPAddress(Long.valueOf(startAddress));
                    endAddress = RangerGeolocationData.unsignedIntToIPAddress(Long.valueOf(endAddress));
                }
                long startIP = RangerGeolocationData.ipAddressToLong(startAddress);
                long endIP = RangerGeolocationData.ipAddressToLong(endAddress);
                if (endIP - startIP >= 0L) {
                    String[] locationData = new String[fields.length - 2];
                    for (int i = 2; i < fields.length; ++i) {
                        locationData[i - 2] = fields[i];
                    }
                    data = new RangerGeolocationData(startIP, endIP, locationData);
                }
            }
        } else {
            LOG.error((Object)("GeolocationMetadata.createMetadata() - Not enough fields specified, need {start, end, location} at " + index));
        }
        return data;
    }

    private RangerGeolocationData(long fromIPAddress, long toIPAddress, String[] locationData) {
        this.fromIPAddress = fromIPAddress;
        this.toIPAddress = toIPAddress;
        this.locationData = locationData;
    }

    public String[] getLocationData() {
        return this.locationData;
    }

    @Override
    public int compareTo(RangerGeolocationData other) {
        int ret;
        int n = ret = other == null ? 1 : 0;
        if (ret == 0 && (ret = Long.compare(this.fromIPAddress, other.fromIPAddress)) == 0 && (ret = Long.compare(this.toIPAddress, other.toIPAddress)) == 0) {
            ret = Integer.compare(this.locationData.length, other.locationData.length);
            for (int i = 0; ret == 0 && i < this.locationData.length; ++i) {
                ret = RangerGeolocationData.stringCompareTo(this.locationData[i], other.locationData[i]);
            }
        }
        return ret;
    }

    public boolean equals(Object other) {
        boolean ret = false;
        if (other != null && other instanceof RangerGeolocationData) {
            ret = this == other || this.compareTo((RangerGeolocationData)other) == 0;
        }
        return ret;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.fromIPAddress, this.toIPAddress, this.locationData);
        }
        return this.hash;
    }

    @Override
    public int compareToRange(Long ip) {
        int ret = Long.compare(this.fromIPAddress, ip);
        if (ret < 0 && (ret = Long.compare(this.toIPAddress, ip)) > 0) {
            ret = 0;
        }
        return ret;
    }

    public static long ipAddressToLong(String ipAddress) {
        long ret = 0L;
        try {
            byte[] bytes = InetAddress.getByName(ipAddress).getAddress();
            if (bytes != null && bytes.length <= 4) {
                for (int i = 0; i < bytes.length; ++i) {
                    int val = bytes[i] < 0 ? 256 + bytes[i] : bytes[i];
                    ret += (long)(val << 8 * (3 - i));
                }
            }
        }
        catch (UnknownHostException exception) {
            LOG.error((Object)("RangerGeolocationData.ipAddressToLong() - Invalid IP address " + ipAddress));
        }
        return ret;
    }

    public static String unsignedIntToIPAddress(long val) {
        if (val <= 0L) {
            return "";
        }
        long remaining = val;
        Object[] segments = new String[4];
        for (int i = 3; i >= 0; --i) {
            long segment = remaining % 256L;
            remaining /= 256L;
            segments[i] = String.valueOf(segment);
        }
        return StringUtils.join((Object[])segments, (char)IPSegmentsSeparator.charValue());
    }

    public static boolean validateAsIP(String ipAddress, boolean ipInDotNotation) {
        if (!ipInDotNotation) {
            return StringUtils.isNumeric((String)ipAddress);
        }
        boolean ret = false;
        try {
            InetAddress.getByName(ipAddress).getAddress();
            ret = true;
        }
        catch (UnknownHostException exception) {
            LOG.error((Object)("RangerGeolocationData.validateAsIP() - Invalid address " + ipAddress));
        }
        return ret;
    }

    private static int stringCompareTo(String str1, String str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    private StringBuilder toString(StringBuilder sb) {
        sb.append("{").append("from=").append(RangerGeolocationData.unsignedIntToIPAddress(this.fromIPAddress)).append(", to=").append(RangerGeolocationData.unsignedIntToIPAddress(this.toIPAddress)).append(", location={");
        for (String data : this.locationData) {
            sb.append(data).append(", ");
        }
        sb.append("}");
        sb.append("}");
        return sb;
    }
}

