/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.JsonUtilsV2;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerRESTUtils;

public class RangerDefaultAuditHandler
implements RangerAccessResultProcessor {
    protected static final String RangerModuleName = RangerConfiguration.getInstance().get("xasecure.auditlog.xasecureAcl.name", "ranger-acl");
    private static final Log LOG = LogFactory.getLog(RangerDefaultAuditHandler.class);
    static long sequenceNumber;
    private static String UUID;
    private static AtomicInteger counter;
    RangerRESTUtils restUtils = new RangerRESTUtils();

    @Override
    public void processResult(RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultAuditHandler.processResult(" + result + ")"));
        }
        AuthzAuditEvent event = this.getAuthzEvents(result);
        this.logAuthzAudit(event);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultAuditHandler.processResult(" + result + ")"));
        }
    }

    @Override
    public void processResults(Collection<RangerAccessResult> results) {
        Collection<AuthzAuditEvent> events;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultAuditHandler.processResults(" + results + ")"));
        }
        if ((events = this.getAuthzEvents(results)) != null) {
            this.logAuthzAudits(events);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultAuditHandler.processResults(" + results + ")"));
        }
    }

    public AuthzAuditEvent getAuthzEvents(RangerAccessResult result) {
        RangerAccessRequest request;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultAuditHandler.getAuthzEvents(" + result + ")"));
        }
        AuthzAuditEvent ret = null;
        RangerAccessRequest rangerAccessRequest = request = result != null ? result.getAccessRequest() : null;
        if (request != null && result != null && result.getIsAudited()) {
            RangerAccessResource resource = request.getResource();
            String resourceType = resource == null ? null : resource.getLeafName();
            String resourcePath = resource == null ? null : resource.getAsString();
            ret = this.createAuthzAuditEvent();
            ret.setRepositoryName(result.getServiceName());
            ret.setRepositoryType(result.getServiceType());
            ret.setResourceType(resourceType);
            ret.setResourcePath(resourcePath);
            ret.setRequestData(request.getRequestData());
            ret.setEventTime(request.getAccessTime() != null ? request.getAccessTime() : new Date());
            ret.setUser(request.getUser());
            ret.setAction(request.getAccessType());
            ret.setAccessResult((short)(result.getIsAllowed() ? 1 : 0));
            ret.setPolicyId(result.getPolicyId());
            ret.setAccessType(request.getAction());
            ret.setClientIP(request.getClientIPAddress());
            ret.setClientType(request.getClientType());
            ret.setSessionId(request.getSessionId());
            ret.setAclEnforcer(RangerModuleName);
            Set<String> tags = this.getTags(request);
            if (tags != null) {
                ret.setTags(tags);
            }
            ret.setAdditionalInfo(this.getAdditionalInfo(request));
            ret.setClusterName(request.getClusterName());
            ret.setZoneName(result.getZoneName());
            ret.setAgentHostname(this.restUtils.getAgentHostname());
            ret.setPolicyVersion(result.getPolicyVersion());
            this.populateDefaults(ret);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultAuditHandler.getAuthzEvents(" + result + "): " + ret));
        }
        return ret;
    }

    public Collection<AuthzAuditEvent> getAuthzEvents(Collection<RangerAccessResult> results) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultAuditHandler.getAuthzEvents(" + results + ")"));
        }
        ArrayList<AuthzAuditEvent> ret = null;
        if (results != null) {
            for (RangerAccessResult result : results) {
                AuthzAuditEvent event = this.getAuthzEvents(result);
                if (event == null) continue;
                if (ret == null) {
                    ret = new ArrayList<AuthzAuditEvent>();
                }
                ret.add(event);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultAuditHandler.getAuthzEvents(" + results + "): " + ret));
        }
        return ret;
    }

    public void logAuthzAudit(AuthzAuditEvent auditEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultAuditHandler.logAuthzAudit(" + auditEvent + ")"));
        }
        if (auditEvent != null) {
            this.populateDefaults(auditEvent);
            AuditHandler auditProvider = RangerBasePlugin.getAuditProvider(auditEvent.getRepositoryName());
            if (auditProvider == null || !auditProvider.log((AuditEventBase)auditEvent)) {
                MiscUtil.logErrorMessageByInterval((Log)LOG, (String)("fail to log audit event " + auditEvent));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultAuditHandler.logAuthzAudit(" + auditEvent + ")"));
        }
    }

    private void populateDefaults(AuthzAuditEvent auditEvent) {
        if (auditEvent.getAclEnforcer() == null || auditEvent.getAclEnforcer().isEmpty()) {
            auditEvent.setAclEnforcer("ranger-acl");
        }
        if (auditEvent.getAgentHostname() == null || auditEvent.getAgentHostname().isEmpty()) {
            auditEvent.setAgentHostname(MiscUtil.getHostname());
        }
        if (auditEvent.getLogType() == null || auditEvent.getLogType().isEmpty()) {
            auditEvent.setLogType("RangerAudit");
        }
        if (auditEvent.getEventId() == null || auditEvent.getEventId().isEmpty()) {
            auditEvent.setEventId(this.generateNextAuditEventId());
        }
        if (auditEvent.getAgentId() == null) {
            auditEvent.setAgentId(MiscUtil.getApplicationType());
        }
        auditEvent.setSeqNum(sequenceNumber++);
    }

    public void logAuthzAudits(Collection<AuthzAuditEvent> auditEvents) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultAuditHandler.logAuthzAudits(" + auditEvents + ")"));
        }
        if (auditEvents != null) {
            for (AuthzAuditEvent auditEvent : auditEvents) {
                this.logAuthzAudit(auditEvent);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultAuditHandler.logAuthzAudits(" + auditEvents + ")"));
        }
    }

    public AuthzAuditEvent createAuthzAuditEvent() {
        return new AuthzAuditEvent();
    }

    protected final Set<String> getTags(RangerAccessRequest request) {
        HashSet<String> ret = null;
        Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        if (CollectionUtils.isNotEmpty(tags)) {
            ret = new HashSet<String>();
            for (RangerTagForEval tag : tags) {
                ret.add(this.writeObjectAsString(tag));
            }
        }
        return ret;
    }

    public String getAdditionalInfo(RangerAccessRequest request) {
        if (StringUtils.isBlank((String)request.getRemoteIPAddress()) && CollectionUtils.isEmpty(request.getForwardedAddresses())) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\"remote-ip-address\":").append(request.getRemoteIPAddress()).append(", \"forwarded-ip-addresses\":[").append(StringUtils.join(request.getForwardedAddresses(), (String)", ")).append("]");
        return sb.toString();
    }

    private String generateNextAuditEventId() {
        int nextId = counter.getAndIncrement();
        if (nextId == Integer.MAX_VALUE) {
            UUID = MiscUtil.generateUniqueId();
            counter = new AtomicInteger(0);
        }
        return UUID + "-" + Integer.toString(nextId);
    }

    private String writeObjectAsString(Serializable obj) {
        String jsonStr = "";
        try {
            jsonStr = JsonUtilsV2.objToJson(obj);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot create JSON string for object:[" + obj + "]"), (Throwable)e);
        }
        return jsonStr;
    }

    static {
        UUID = MiscUtil.generateUniqueId();
        counter = new AtomicInteger(0);
    }
}

