/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.classloader;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPluginClassLoaderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPluginClassLoaderUtil.class);
    private static volatile RangerPluginClassLoaderUtil config = null;
    private static String rangerPluginLibDir = "ranger-%-plugin-impl";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RangerPluginClassLoaderUtil getInstance() {
        RangerPluginClassLoaderUtil result = config;
        if (result != null) return result;
        Class<RangerPluginClassLoaderUtil> clazz = RangerPluginClassLoaderUtil.class;
        synchronized (RangerPluginClassLoaderUtil.class) {
            result = config;
            if (result != null) return result;
            config = result = new RangerPluginClassLoaderUtil();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public URL[] getPluginFilesForServiceTypeAndPluginclass(String serviceType, Class<?> pluginClass) throws Exception {
        URL[] ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPluginClassLoaderUtil.getPluginFilesForServiceTypeAndPluginclass(" + serviceType + ")" + " Pluging Class :" + pluginClass.getName());
        }
        String[] libDirs = new String[]{this.getPluginImplLibPath(serviceType, pluginClass)};
        ret = this.getPluginFiles(libDirs);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPluginClassLoaderUtil.getPluginFilesForServiceTypeAndPluginclass(" + serviceType + ")" + " Pluging Class :" + pluginClass.getName());
        }
        return ret;
    }

    private URL[] getPluginFiles(String[] libDirs) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPluginClassLoaderUtil.getPluginFiles()");
        }
        ArrayList<URL> ret = new ArrayList<URL>();
        for (String libDir : libDirs) {
            this.getFilesInDirectory(libDir, ret);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPluginClassLoaderUtil.getPluginFilesForServiceType(): " + ret.size() + " files");
        }
        return ret.toArray(new URL[0]);
    }

    /*
     * Unable to fully structure code
     */
    private void getFilesInDirectory(String dirPath, List<URL> files) {
        if (RangerPluginClassLoaderUtil.LOG.isDebugEnabled()) {
            RangerPluginClassLoaderUtil.LOG.debug("==> RangerPluginClassLoaderUtil.getPluginFiles()");
        }
        if (dirPath != null) {
            try {
                dirFiles = new File(dirPath).listFiles();
                if (dirFiles == null) ** GOTO lbl24
                for (File dirFile : dirFiles) {
                    try {
                        if (!dirFile.canRead()) {
                            RangerPluginClassLoaderUtil.LOG.error("getFilesInDirectory('" + dirPath + "'): " + dirFile.getAbsolutePath() + " is not readable!");
                        }
                        jarPath = dirFile.toURI().toURL();
                        RangerPluginClassLoaderUtil.LOG.info("getFilesInDirectory('" + dirPath + "'): adding " + dirFile.getAbsolutePath());
                        files.add(jarPath);
                    }
                    catch (Exception excp) {
                        RangerPluginClassLoaderUtil.LOG.warn("getFilesInDirectory('" + dirPath + "'): failed to get URI for file " + dirFile.getAbsolutePath(), (Throwable)excp);
                    }
                }
            }
            catch (Exception excp) {
                RangerPluginClassLoaderUtil.LOG.warn("getFilesInDirectory('" + dirPath + "'): error", (Throwable)excp);
            }
        } else {
            RangerPluginClassLoaderUtil.LOG.warn("getFilesInDirectory('" + dirPath + "'): could not find directory in path " + dirPath);
        }
lbl24:
        // 4 sources

        if (RangerPluginClassLoaderUtil.LOG.isDebugEnabled()) {
            RangerPluginClassLoaderUtil.LOG.debug("<== RangerPluginClassLoaderUtil.getFilesInDirectory(" + dirPath + ")");
        }
    }

    private String getPluginImplLibPath(String serviceType, Class<?> pluginClass) throws Exception {
        String ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPluginClassLoaderUtil.getPluginImplLibPath for Class (" + pluginClass.getName() + ")");
        }
        URI uri = pluginClass.getProtectionDomain().getCodeSource().getLocation().toURI();
        Path path = Paths.get(URI.create(uri.toString()));
        ret = path.getParent().toString() + File.separatorChar + rangerPluginLibDir.replaceAll("%", serviceType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPluginClassLoaderUtil.getPluginImplLibPath for Class (" + pluginClass.getName() + " PATH :" + ret + ")");
        }
        return ret;
    }
}

