/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQSession_0_8;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.BasicMessageConsumer;
import org.apache.qpid.client.RejectBehaviour;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.MessageFactoryRegistry;
import org.apache.qpid.client.message.UnprocessedMessage_0_8;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicCancelBody;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.apache.qpid.jms.ConnectionURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicMessageConsumer_0_8
extends BasicMessageConsumer<UnprocessedMessage_0_8> {
    private final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private AMQSession_0_8.DestinationCache<AMQTopic> _topicDestinationCache;
    private AMQSession_0_8.DestinationCache<AMQQueue> _queueDestinationCache;
    private final RejectBehaviour _rejectBehaviour;

    protected BasicMessageConsumer_0_8(int channelId, AMQConnection connection, AMQDestination destination, String messageSelector, boolean noLocal, MessageFactoryRegistry messageFactory, AMQSession_0_8 session, Map<String, Object> rawSelector, int prefetchHigh, int prefetchLow, boolean exclusive, int acknowledgeMode, boolean browseOnly, boolean autoClose) throws JMSException {
        super(channelId, connection, destination, messageSelector, noLocal, messageFactory, session, rawSelector, prefetchHigh, prefetchLow, exclusive, acknowledgeMode, browseOnly, autoClose);
        Map<String, Object> consumerArguments = this.getArguments();
        if (this.isAutoClose()) {
            consumerArguments.put(AMQPFilterTypes.AUTO_CLOSE.getValue(), Boolean.TRUE);
        }
        if (this.isBrowseOnly()) {
            consumerArguments.put(AMQPFilterTypes.NO_CONSUME.getValue(), Boolean.TRUE);
        }
        this._topicDestinationCache = session.getTopicDestinationCache();
        this._queueDestinationCache = session.getQueueDestinationCache();
        if (session.isResolved(destination) && 2 == destination.getAddressType()) {
            boolean namedQueue;
            boolean bl = namedQueue = destination.getLink() != null && destination.getLink().getName() != null;
            if (!namedQueue) {
                this.setDestination(destination.copyDestination());
                this.getDestination().setQueueName(null);
            }
        }
        if (destination.getRejectBehaviour() != null) {
            this._rejectBehaviour = destination.getRejectBehaviour();
        } else {
            ConnectionURL connectionURL = connection.getConnectionURL();
            String rejectBehaviour = connectionURL.getOption("rejectbehaviour");
            if (rejectBehaviour != null) {
                this._rejectBehaviour = RejectBehaviour.valueOf(rejectBehaviour.toUpperCase());
            } else {
                rejectBehaviour = System.getProperty("qpid.reject.behaviour", RejectBehaviour.NORMAL.toString());
                this._rejectBehaviour = RejectBehaviour.valueOf(rejectBehaviour.toUpperCase());
            }
        }
    }

    @Override
    public AMQSession_0_8 getSession() {
        return (AMQSession_0_8)super.getSession();
    }

    @Override
    void sendCancel() throws QpidException, FailoverException {
        BasicCancelBody body = this.getSession().getMethodRegistry().createBasicCancelBody(new AMQShortString(String.valueOf(this.getConsumerTag())), false);
        AMQFrame cancelFrame = body.generateFrame(this.getChannelId());
        this.getConnection().getProtocolHandler().syncWrite(cancelFrame, BasicCancelOkBody.class);
        this.postSubscription();
        this.getSession().sync();
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("CancelOk'd for consumer:" + this.debugIdentity());
        }
    }

    void postSubscription() throws QpidException {
        AMQDestination dest = this.getDestination();
        if (dest != null && dest.getDestSyntax() == AMQDestination.DestSyntax.ADDR) {
            if (dest.getDelete() == AMQDestination.AddressOption.ALWAYS || dest.getDelete() == AMQDestination.AddressOption.RECEIVER) {
                this.getSession().handleNodeDelete(dest);
            }
            this.getSession().handleLinkDelete(dest);
            if (!this.isDurableSubscriber()) {
                this.getSession().deleteSubscriptionQueue(dest);
            }
        }
    }

    @Override
    public AbstractJMSMessage createJMSMessageFromUnprocessedMessage(AMQMessageDelegateFactory delegateFactory, UnprocessedMessage_0_8 messageFrame) throws Exception {
        return this.getMessageFactory().createMessage(messageFrame.getDeliveryTag(), messageFrame.isRedelivered(), messageFrame.getExchange() == null ? "" : AMQShortString.toString((AMQShortString)messageFrame.getExchange()), AMQShortString.toString((AMQShortString)messageFrame.getRoutingKey()), messageFrame.getContentHeader(), messageFrame.getBodies(), this._queueDestinationCache, this._topicDestinationCache, this.getAddressType());
    }

    @Override
    Message receiveBrowse() throws JMSException {
        return this.receive();
    }

    public RejectBehaviour getRejectBehaviour() {
        return this._rejectBehaviour;
    }

    @Override
    public Message receive(long l) throws JMSException {
        boolean manageCredit = this.getSession().isManagingCredit();
        boolean creditModified = false;
        try {
            if (manageCredit) {
                creditModified = this.getSession().ensureCreditForReceive();
            }
            Message message = super.receive(l);
            if (creditModified && message == null) {
                this.getSession().reduceCreditAfterAcknowledge();
            }
            if (manageCredit && this.getSession().getAcknowledgeMode() != 1 && this.getSession().getAcknowledgeMode() != 3 && message != null) {
                this.getSession().updateCurrentPrefetch(1);
            }
            return message;
        }
        catch (QpidException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("BasicMessageConsumer.receive failed."), e);
        }
    }

    @Override
    public Message receiveNoWait() throws JMSException {
        boolean manageCredit = this.getSession().isManagingCredit();
        boolean creditModified = false;
        try {
            if (manageCredit && (creditModified = this.getSession().ensureCreditForReceive())) {
                this.getSession().sync();
            }
            Message message = super.receiveNoWait();
            if (creditModified && message == null) {
                this.getSession().reduceCreditAfterAcknowledge();
            }
            if (manageCredit && this.getSession().getAcknowledgeMode() != 1 && this.getSession().getAcknowledgeMode() != 3 && message != null) {
                this.getSession().updateCurrentPrefetch(1);
            }
            return message;
        }
        catch (QpidException e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("BasicMessageConsumer.receiveNoWait failed"), e);
        }
    }

    @Override
    void postDeliver(AbstractJMSMessage msg) {
        this.getSession().reduceCreditInPostDeliver();
        super.postDeliver(msg);
    }
}

