/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.crypto.spec.SecretKeySpec;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.qpid.QpidException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQSession_0_10;
import org.apache.qpid.client.BasicMessageProducer;
import org.apache.qpid.client.message.AMQMessageDelegate_0_10;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.MessageEncryptionHelper;
import org.apache.qpid.client.messaging.address.Link;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageAcceptMode;
import org.apache.qpid.transport.MessageAcquireMode;
import org.apache.qpid.transport.MessageDeliveryMode;
import org.apache.qpid.transport.MessageDeliveryPriority;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.codec.BBEncoder;
import org.apache.qpid.util.BytesDataOutput;
import org.apache.qpid.util.GZIPUtils;
import org.apache.qpid.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicMessageProducer_0_10
extends BasicMessageProducer {
    private static final Logger _logger = LoggerFactory.getLogger(BasicMessageProducer_0_10.class);
    private byte[] userIDBytes = Strings.toUTF8((String)this.getUserID());

    BasicMessageProducer_0_10(AMQConnection connection, AMQDestination destination, boolean transacted, int channelId, AMQSession session, long producerId, Boolean immediate, Boolean mandatory) throws QpidException {
        super(_logger, connection, destination, transacted, channelId, session, producerId, immediate, mandatory);
    }

    @Override
    void declareDestination(AMQDestination destination) throws QpidException {
        if (destination.getDestSyntax() == AMQDestination.DestSyntax.BURL) {
            if (this.getSession().isDeclareExchanges()) {
                String name = destination.getExchangeName();
                ((AMQSession_0_10)this.getSession()).getQpidSession().exchangeDeclare(name, destination.getExchangeClass(), null, null, new Option[]{name.startsWith("amq.") ? Option.PASSIVE : Option.NONE, destination.isExchangeDurable() ? Option.DURABLE : Option.NONE, destination.isExchangeAutoDelete() ? Option.AUTO_DELETE : Option.NONE});
            }
        } else {
            this.getSession().resolveAddress(destination, false, false);
            this.getSession().handleLinkCreation(destination);
            this.getSession().sync();
        }
    }

    @Override
    void sendMessage(AMQDestination destination, Message origMessage, AbstractJMSMessage message, UUID messageId, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate) throws JMSException {
        byte[] compressed;
        boolean encrypt;
        String exchangeName;
        message.prepareForSending();
        AMQMessageDelegate_0_10 delegate = (AMQMessageDelegate_0_10)message.getDelegate();
        DeliveryProperties deliveryProp = delegate.getDeliveryProperties();
        MessageProperties messageProps = delegate.getMessageProperties();
        if (this.getConnection().isPopulateUserId()) {
            messageProps.setUserId(this.userIDBytes);
        }
        if (messageId != null) {
            messageProps.setMessageId(messageId);
        } else if (messageProps.hasMessageId()) {
            messageProps.clearMessageId();
        }
        long currentTime = 0L;
        if (timeToLive > 0L || !this.isDisableTimestamps()) {
            currentTime = System.currentTimeMillis();
        }
        if (timeToLive > 0L) {
            deliveryProp.setTtl(timeToLive);
            message.setJMSExpiration(currentTime + timeToLive);
        }
        if (!this.isDisableTimestamps()) {
            deliveryProp.setTimestamp(currentTime);
            message.setJMSTimestamp(currentTime);
        }
        if (!deliveryProp.hasDeliveryMode() || deliveryProp.getDeliveryMode().getValue() != deliveryMode) {
            MessageDeliveryMode mode;
            switch (deliveryMode) {
                case 2: {
                    mode = MessageDeliveryMode.PERSISTENT;
                    break;
                }
                case 1: {
                    mode = MessageDeliveryMode.NON_PERSISTENT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal delivery mode: " + deliveryMode);
                }
            }
            deliveryProp.setDeliveryMode(mode);
            message.setJMSDeliveryMode(deliveryMode);
        }
        if (!deliveryProp.hasPriority() || deliveryProp.getPriority().getValue() != priority) {
            deliveryProp.setPriority(MessageDeliveryPriority.get((short)((short)priority)));
            message.setJMSPriority(priority);
        }
        String string = exchangeName = destination.getExchangeName() == null ? "" : destination.getExchangeName();
        if (deliveryProp.getExchange() == null || !deliveryProp.getExchange().equals(exchangeName)) {
            deliveryProp.setExchange(exchangeName);
        }
        String routingKey = destination.getRoutingKey();
        if (deliveryProp.getRoutingKey() == null || !deliveryProp.getRoutingKey().equals(routingKey)) {
            deliveryProp.setRoutingKey(routingKey);
        }
        if (destination.getDestSyntax() == AMQDestination.DestSyntax.ADDR && (destination.getSubject() != null || messageProps.getApplicationHeaders() != null && messageProps.getApplicationHeaders().get("qpid.subject") != null)) {
            HashMap<String, String> appProps = messageProps.getApplicationHeaders();
            if (appProps == null) {
                appProps = new HashMap<String, String>();
                messageProps.setApplicationHeaders(appProps);
            }
            if (appProps.get("qpid.subject") == null) {
                appProps.put("qpid.subject", destination.getSubject());
            }
            if (destination.getAddressType() == 2) {
                deliveryProp.setRoutingKey((String)messageProps.getApplicationHeaders().get("qpid.subject"));
            }
        }
        ByteBuffer data = message.getData();
        boolean bl = encrypt = message.getBooleanProperty("x-qpid-encrypt") || destination.sendEncrypted();
        if (encrypt) {
            MessageEncryptionHelper encryptionHelper = this.getSession().getMessageEncryptionHelper();
            try {
                String recipientString;
                MessageProperties origMessageProps = messageProps;
                DeliveryProperties origDeliveryProps = deliveryProp;
                messageProps = new MessageProperties(messageProps);
                deliveryProp = new DeliveryProperties(deliveryProp);
                SecretKeySpec secretKey = encryptionHelper.createSecretKey();
                Map origApplicationHeaders = origMessageProps.getApplicationHeaders();
                if (origApplicationHeaders != null) {
                    origApplicationHeaders.remove("x-qpid-encrypt");
                }
                if ((recipientString = message.getStringProperty("x-qpid-encrypt-recipients")) == null) {
                    recipientString = destination.getEncryptedRecipients();
                }
                if (origApplicationHeaders != null) {
                    origApplicationHeaders.remove("x-qpid-encrypt-recipients");
                }
                String unencryptedProperties = message.getStringProperty("x-qpid-unencrypted-properties");
                if (origApplicationHeaders != null) {
                    origApplicationHeaders.remove("x-qpid-unencrypted-properties");
                }
                BBEncoder encoder = new BBEncoder(1024);
                encoder.writeStruct32((Struct)origDeliveryProps);
                encoder.writeStruct32((Struct)origMessageProps);
                ByteBuffer buf = encoder.buffer();
                int headerLength = buf.remaining();
                byte[] unencryptedBytes = new byte[headerLength + (data == null ? 0 : data.remaining())];
                BytesDataOutput output = new BytesDataOutput(unencryptedBytes);
                output.write(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
                if (data != null) {
                    data.get(unencryptedBytes, headerLength, data.remaining());
                }
                byte[] ivbytes = encryptionHelper.getInitialisationVector();
                byte[] encryptedBytes = encryptionHelper.encrypt(secretKey, unencryptedBytes, ivbytes);
                data = ByteBuffer.wrap(encryptedBytes);
                if (recipientString == null) {
                    throw new JMSException("When sending an encrypted message, recipients must be supplied");
                }
                String[] recipients = recipientString.split(";");
                ArrayList<List<Object>> encryptedKeys = new ArrayList<List<Object>>();
                for (MessageEncryptionHelper.KeyTransportRecipientInfo info : encryptionHelper.getKeyTransportRecipientInfo(Arrays.asList(recipients), secretKey)) {
                    encryptedKeys.add(info.asList());
                }
                LinkedHashMap<String, Object> newHeaders = messageProps.getApplicationHeaders();
                if (newHeaders != null) {
                    newHeaders.clear();
                } else {
                    newHeaders = new LinkedHashMap<String, Object>();
                    messageProps.setApplicationHeaders(newHeaders);
                }
                if (unencryptedProperties != null) {
                    List<String> unencryptedPropertyNames = Arrays.asList(unencryptedProperties.split(" *; *"));
                    for (String propertyName : unencryptedPropertyNames) {
                        if (!origApplicationHeaders.containsKey(propertyName)) continue;
                        newHeaders.put(propertyName, origApplicationHeaders.get(propertyName));
                    }
                }
                newHeaders.put("x-qpid-encrypted-keys", encryptedKeys);
                newHeaders.put("x-qpid-encryption-algorithm", encryptionHelper.getMessageEncryptionCipherName());
                newHeaders.put("x-qpid-key-init-vector", ivbytes);
                messageProps.setContentType("application/qpid-0-10-encrypted");
            }
            catch (IOException | GeneralSecurityException e) {
                throw JMSExceptionHelper.chainJMSException(new JMSException("Unexpected Exception while encrypting message"), e);
            }
        } else if (data != null && data.remaining() > this.getConnection().getMessageCompressionThresholdSize() && this.getConnection().getDelegate().isMessageCompressionSupported() && this.getConnection().isMessageCompressionDesired() && messageProps.getContentEncoding() == null && (compressed = GZIPUtils.compressBufferToArray((ByteBuffer)data)) != null) {
            messageProps.setContentEncoding("gzip");
            data = ByteBuffer.wrap(compressed);
        }
        messageProps.setContentLength(data == null ? 0L : (long)data.remaining());
        try {
            Session ssn = ((AMQSession_0_10)this.getSession()).getQpidSession();
            boolean sync = false;
            sync = this.getPublishMode() == BasicMessageProducer.PublishMode.SYNC_PUBLISH_ALL || this.getPublishMode() == BasicMessageProducer.PublishMode.SYNC_PUBLISH_PERSISTENT && deliveryMode == 2;
            boolean unreliable = destination.getDestSyntax() == AMQDestination.DestSyntax.ADDR && destination.getLink().getReliability() == Link.Reliability.UNRELIABLE;
            ByteBuffer buffer = data == null ? ByteBuffer.allocate(0) : data.slice();
            ssn.messageTransfer(destination.getExchangeName() == null ? "" : destination.getExchangeName(), MessageAcceptMode.NONE, MessageAcquireMode.PRE_ACQUIRED, new Header(deliveryProp, messageProps), buffer, new Option[]{sync ? Option.SYNC : Option.NONE, unreliable ? Option.UNRELIABLE : Option.NONE});
            if (sync) {
                ssn.sync();
                ((AMQSession_0_10)this.getSession()).getCurrentException();
            }
        }
        catch (Exception e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Exception when sending message:" + e.getMessage()), e);
        }
    }

    @Override
    public boolean isBound(AMQDestination destination) throws JMSException {
        return this.getSession().isQueueBound(destination);
    }

    @Override
    public void close() throws JMSException {
        super.close();
    }
}

