/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.qpid.client.SSLConfiguration;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.client.transport.ITransportConnection;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.protocol.ProtocolEngine;
import org.apache.qpid.ssl.SSLContextFactory;
import org.apache.qpid.transport.NetworkDriver;
import org.apache.qpid.transport.network.mina.MINANetworkDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketTransportConnection
implements ITransportConnection {
    private static final Logger _logger = LoggerFactory.getLogger(SocketTransportConnection.class);
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private SocketConnectorFactory _socketConnectorFactory;

    public SocketTransportConnection(SocketConnectorFactory socketConnectorFactory) {
        this._socketConnectorFactory = socketConnectorFactory;
    }

    public void connect(AMQProtocolHandler protocolHandler, BrokerDetails brokerDetail) throws IOException {
        InetSocketAddress address;
        ByteBuffer.setUseDirectBuffers((boolean)Boolean.getBoolean("amqj.enableDirectBuffers"));
        if (!Boolean.getBoolean("amqj.enablePooledAllocator")) {
            _logger.info("Using SimpleByteBufferAllocator");
            ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        }
        IoConnector ioConnector = this._socketConnectorFactory.newSocketConnector();
        if (brokerDetail.getTransport().equals("socket")) {
            address = null;
        } else {
            address = new InetSocketAddress(brokerDetail.getHost(), brokerDetail.getPort());
            _logger.info("Attempting connection to " + address);
        }
        SSLConfiguration sslConfig = protocolHandler.getConnection().getSSLConfiguration();
        SSLContextFactory sslFactory = null;
        if (sslConfig != null) {
            sslFactory = new SSLContextFactory(sslConfig.getKeystorePath(), sslConfig.getKeystorePassword(), sslConfig.getCertType());
        }
        MINANetworkDriver driver = new MINANetworkDriver(ioConnector);
        driver.open(brokerDetail.getPort(), address.getAddress(), (ProtocolEngine)protocolHandler, null, sslFactory);
        protocolHandler.setNetworkDriver((NetworkDriver)driver);
    }

    static interface SocketConnectorFactory {
        public IoConnector newSocketConnector();
    }
}

