/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.transport.util.Functions;

public abstract class AbstractBytesMessage
extends AbstractJMSMessage {
    private static final int DEFAULT_BUFFER_INITIAL_SIZE = 1024;

    AbstractBytesMessage(AMQMessageDelegateFactory delegateFactory) {
        this(delegateFactory, null);
    }

    AbstractBytesMessage(AMQMessageDelegateFactory delegateFactory, ByteBuffer data) {
        super(delegateFactory, data);
        this.setContentType(this.getMimeType());
        if (this._data == null) {
            this.allocateInitialBuffer();
        }
    }

    protected void allocateInitialBuffer() {
        this._data = ByteBuffer.allocate((int)1024);
        this._data.setAutoExpand(true);
    }

    AbstractBytesMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        super(delegate, data);
        this.setContentType(this.getMimeType());
    }

    public void clearBodyImpl() throws JMSException {
        this.allocateInitialBuffer();
    }

    public String toBodyString() throws JMSException {
        try {
            if (this._data != null) {
                return Functions.str((java.nio.ByteBuffer)this._data.buf(), (int)100, (int)0);
            }
            return "";
        }
        catch (Exception e) {
            JMSException jmse = new JMSException(e.toString());
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    protected void checkAvailable(int len) throws MessageEOFException {
        if (this._data.remaining() < len) {
            throw new MessageEOFException("Unable to read " + len + " bytes");
        }
    }
}

