/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.message;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.message.AMQMessageDelegate;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.JMSMapMessage;
import org.apache.qpid.transport.codec.BBDecoder;
import org.apache.qpid.transport.codec.BBEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQPEncodedMapMessage
extends JMSMapMessage {
    public static final String MIME_TYPE = "amqp/map";

    public AMQPEncodedMapMessage(AMQMessageDelegateFactory delegateFactory) throws JMSException {
        this(delegateFactory, null);
    }

    AMQPEncodedMapMessage(AMQMessageDelegateFactory delegateFactory, ByteBuffer data) throws JMSException {
        super(delegateFactory, data);
    }

    AMQPEncodedMapMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        super(delegate, data);
    }

    @Override
    protected String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public void setObject(String propName, Object value) throws JMSException {
        this.checkWritable();
        this.checkPropertyName(propName);
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Character || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[] || value instanceof List || value instanceof Map || value instanceof UUID || value == null)) {
            throw new MessageFormatException("Cannot set property " + propName + " to value " + value + "of type " + value.getClass().getName() + ".");
        }
        this._map.put(propName, value);
    }

    @Override
    public ByteBuffer getData() {
        this.writeMapToData();
        return this._data;
    }

    @Override
    protected void populateMapFromData() throws JMSException {
        if (this._data != null) {
            this._data.rewind();
            BBDecoder decoder = new BBDecoder();
            decoder.init(this._data.buf());
            this._map = decoder.readMap();
        } else {
            this._map.clear();
        }
    }

    @Override
    protected void writeMapToData() {
        BBEncoder encoder = new BBEncoder(1024);
        encoder.writeMap(this._map);
        this._data = ByteBuffer.wrap((java.nio.ByteBuffer)encoder.segment());
    }

    Map<String, Object> getMap() {
        return this._map;
    }

    void setMap(Map<String, Object> map) {
        this._map = map;
    }
}

