/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.apache.qpid.client.XASessionImpl;
import org.apache.qpid.dtx.XidImpl;
import org.apache.qpid.transport.DtxXaStatus;
import org.apache.qpid.transport.ExecutionErrorCode;
import org.apache.qpid.transport.Future;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.RecoverResult;
import org.apache.qpid.transport.SessionException;
import org.apache.qpid.transport.XaResult;
import org.apache.qpid.transport.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAResourceImpl
implements XAResource {
    private static final Logger _logger = LoggerFactory.getLogger(XAResourceImpl.class);
    private XASessionImpl _xaSession = null;
    private javax.transaction.xa.Xid _xid;
    private int _timeout;

    protected XAResourceImpl(XASessionImpl xaSession) {
        this._xaSession = xaSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(javax.transaction.xa.Xid xid, boolean b) throws XAException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("commit tx branch with xid:  ", (Object)xid);
        }
        Future future = this._xaSession.getQpidSession().dtxCommit(this.convertXid(xid), new Option[]{b ? Option.ONE_PHASE : Option.NONE});
        XaResult result = null;
        try {
            result = (XaResult)future.get();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        finally {
            this._xid = null;
        }
        this.checkStatus(result.getStatus());
    }

    public void end(javax.transaction.xa.Xid xid, int flag) throws XAException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("end tx branch with xid: ", (Object)xid);
        }
        switch (flag) {
            case 0x4000000: {
                break;
            }
            case 0x20000000: {
                break;
            }
            case 0x2000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        this._xaSession.flushAcknowledgments();
        Future future = this._xaSession.getQpidSession().dtxEnd(this.convertXid(xid), new Option[]{flag == 0x20000000 ? Option.FAIL : Option.NONE, flag == 0x2000000 ? Option.SUSPEND : Option.NONE});
        XaResult result = null;
        try {
            result = (XaResult)future.get();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        this.checkStatus(result.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(javax.transaction.xa.Xid xid) throws XAException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("forget tx branch with xid: ", (Object)xid);
        }
        this._xaSession.getQpidSession().dtxForget(this.convertXid(xid), new Option[0]);
        try {
            this._xaSession.getQpidSession().sync();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        finally {
            this._xid = null;
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this._timeout;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return false;
    }

    public int prepare(javax.transaction.xa.Xid xid) throws XAException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("prepare ", (Object)xid);
        }
        Future future = this._xaSession.getQpidSession().dtxPrepare(this.convertXid(xid), new Option[0]);
        XaResult result = null;
        try {
            result = (XaResult)future.get();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        DtxXaStatus status = result.getStatus();
        int outcome = 0;
        switch (status) {
            case XA_OK: {
                break;
            }
            case XA_RDONLY: {
                outcome = 3;
                break;
            }
            default: {
                this.checkStatus(status);
            }
        }
        return outcome;
    }

    public javax.transaction.xa.Xid[] recover(int flag) throws XAException {
        Future future = this._xaSession.getQpidSession().dtxRecover(new Option[0]);
        RecoverResult res = null;
        try {
            res = (RecoverResult)future.get();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        javax.transaction.xa.Xid[] result = new javax.transaction.xa.Xid[res.getInDoubt().size()];
        int i = 0;
        for (Object obj : res.getInDoubt()) {
            Xid xid = (Xid)obj;
            result[i] = new XidImpl(xid.getBranchId(), (int)xid.getFormat(), xid.getGlobalId());
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(javax.transaction.xa.Xid xid) throws XAException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("rollback tx branch with xid: ", (Object)xid);
        }
        Future future = this._xaSession.getQpidSession().dtxRollback(this.convertXid(xid), new Option[0]);
        XaResult result = null;
        try {
            result = (XaResult)future.get();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        finally {
            this._xid = null;
        }
        this.checkStatus(result.getStatus());
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        this._timeout = timeout;
        if (timeout != this._timeout && this._xid != null) {
            this.setDtxTimeout(this._timeout);
        }
        return true;
    }

    private void setDtxTimeout(int timeout) throws XAException {
        this._xaSession.getQpidSession().dtxSetTimeout(XidImpl.convert((javax.transaction.xa.Xid)this._xid), (long)timeout, new Option[0]);
    }

    public void start(javax.transaction.xa.Xid xid, int flag) throws XAException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("start tx branch with xid: ", (Object)xid);
        }
        switch (flag) {
            case 0: {
                break;
            }
            case 0x200000: {
                break;
            }
            case 0x8000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        Future future = this._xaSession.getQpidSession().dtxStart(this.convertXid(xid), new Option[]{flag == 0x200000 ? Option.JOIN : Option.NONE, flag == 0x8000000 ? Option.RESUME : Option.NONE});
        XaResult result = null;
        try {
            result = (XaResult)future.get();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        this.checkStatus(result.getStatus());
        this._xid = xid;
        if (this._timeout > 0) {
            this.setDtxTimeout(this._timeout);
        }
    }

    private void checkStatus(DtxXaStatus status) throws XAException {
        switch (status) {
            case XA_OK: {
                break;
            }
            case XA_RBROLLBACK: {
                throw new XAException(100);
            }
            case XA_RBTIMEOUT: {
                throw new XAException(106);
            }
            case XA_HEURHAZ: {
                throw new XAException(8);
            }
            case XA_HEURCOM: {
                throw new XAException(7);
            }
            case XA_HEURRB: {
                throw new XAException(6);
            }
            case XA_HEURMIX: {
                throw new XAException(5);
            }
            case XA_RDONLY: {
                throw new XAException(3);
            }
            default: {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("got unexpected status value: ", (Object)status);
                }
                throw new XAException(-3);
            }
        }
    }

    private void convertExecutionErrorToXAErr(ExecutionErrorCode error) throws XAException {
        switch (error) {
            case NOT_ALLOWED: {
                throw new XAException(-8);
            }
            case NOT_FOUND: {
                try {
                    throw new XAException(-4);
                }
                catch (XAException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            case ILLEGAL_STATE: {
                throw new XAException(-6);
            }
            case NOT_IMPLEMENTED: {
                throw new XAException(-3);
            }
            case COMMAND_INVALID: {
                throw new XAException(-5);
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Got unexpected error: " + error);
        }
        throw new XAException(-3);
    }

    private Xid convertXid(javax.transaction.xa.Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        return XidImpl.convert((javax.transaction.xa.Xid)xid);
    }
}

