/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionRolledBackException;
import org.apache.qpid.AMQChannelClosedException;
import org.apache.qpid.AMQDisconnectedException;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQInvalidArgumentException;
import org.apache.qpid.AMQInvalidRoutingKeyException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQQueueBrowser;
import org.apache.qpid.client.AMQTemporaryQueue;
import org.apache.qpid.client.AMQTemporaryTopic;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.BasicMessageConsumer;
import org.apache.qpid.client.BasicMessageProducer;
import org.apache.qpid.client.Closeable;
import org.apache.qpid.client.JMSAMQException;
import org.apache.qpid.client.QueueReceiverAdaptor;
import org.apache.qpid.client.QueueSenderAdapter;
import org.apache.qpid.client.TemporaryDestination;
import org.apache.qpid.client.TopicPublisherAdapter;
import org.apache.qpid.client.TopicSubscriberAdaptor;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.failover.FailoverNoopSupport;
import org.apache.qpid.client.failover.FailoverProtectedOperation;
import org.apache.qpid.client.failover.FailoverRetrySupport;
import org.apache.qpid.client.message.AMQMessageDelegateFactory;
import org.apache.qpid.client.message.AMQPEncodedMapMessage;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.message.CloseConsumerMessage;
import org.apache.qpid.client.message.JMSBytesMessage;
import org.apache.qpid.client.message.JMSMapMessage;
import org.apache.qpid.client.message.JMSObjectMessage;
import org.apache.qpid.client.message.JMSStreamMessage;
import org.apache.qpid.client.message.JMSTextMessage;
import org.apache.qpid.client.message.MessageFactoryRegistry;
import org.apache.qpid.client.message.UnprocessedMessage;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.client.util.FlowControllingBlockingQueue;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.FieldTableFactory;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.jms.Session;
import org.apache.qpid.thread.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AMQSession<C extends BasicMessageConsumer, P extends BasicMessageProducer>
extends Closeable
implements Session,
QueueSession,
TopicSession {
    final AMQSession<C, P> _thisSession = this;
    private static final Logger _logger = LoggerFactory.getLogger(AMQSession.class);
    protected final boolean DEFAULT_IMMEDIATE = Boolean.parseBoolean(System.getProperty("qpid.default_immediate", "false"));
    protected final boolean DEFAULT_MANDATORY = Boolean.parseBoolean(System.getProperty("qpid.default_mandatory", "true"));
    protected final boolean DEFAULT_WAIT_ON_SEND = Boolean.parseBoolean(System.getProperty("qpid.default_wait_on_send", "false"));
    protected final long FLOW_CONTROL_WAIT_PERIOD = Long.getLong("qpid.flow_control_wait_notify_period", 5000L);
    public static final long DEFAULT_FLOW_CONTROL_WAIT_FAILURE = 120000L;
    protected final long FLOW_CONTROL_WAIT_FAILURE = Long.getLong("qpid.flow_control_wait_failure", 120000L);
    protected final boolean DECLARE_QUEUES = Boolean.parseBoolean(System.getProperty("qpid.declare_queues", "true"));
    protected final boolean DECLARE_EXCHANGES = Boolean.parseBoolean(System.getProperty("qpid.declare_exchanges", "true"));
    protected final boolean USE_AMQP_ENCODED_MAP_MESSAGE;
    public static final String STRICT_AMQP = "STRICT_AMQP";
    public static final String STRICT_AMQP_DEFAULT = "false";
    public static final String STRICT_AMQP_FATAL = "STRICT_AMQP_FATAL";
    public static final String STRICT_AMQP_FATAL_DEFAULT = "true";
    public static final String IMMEDIATE_PREFETCH = "IMMEDIATE_PREFETCH";
    public static final String IMMEDIATE_PREFETCH_DEFAULT = "false";
    protected AMQConnection _connection;
    protected boolean _transacted;
    protected final int _acknowledgeMode;
    protected int _channelId;
    private int _ticket;
    private int _prefetchHighMark;
    private int _prefetchLowMark;
    private MessageListener _messageListener = null;
    private AtomicBoolean _startedAtLeastOnce = new AtomicBoolean(false);
    protected final ConcurrentHashMap<String, TopicSubscriberAdaptor<C>> _subscriptions = new ConcurrentHashMap();
    protected final ConcurrentHashMap<C, String> _reverseSubscriptionMap = new ConcurrentHashMap();
    protected final Lock _subscriberDetails = new ReentrantLock(true);
    protected final Lock _subscriberAccess = new ReentrantLock(true);
    protected final FlowControllingBlockingQueue _queue;
    private final AtomicLong _highestDeliveryTag = new AtomicLong(-1L);
    private final AtomicLong _rollbackMark = new AtomicLong(-1L);
    protected ConcurrentLinkedQueue<Long> _unacknowledgedMessageTags = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<Long> _deliveredMessageTags = new ConcurrentLinkedQueue();
    protected Dispatcher _dispatcher;
    protected Thread _dispatcherThread;
    protected MessageFactoryRegistry _messageFactoryRegistry;
    private Map<Long, MessageProducer> _producers = new ConcurrentHashMap<Long, MessageProducer>();
    private int _nextTag = 1;
    protected final IdToConsumerMap<C> _consumers = new IdToConsumerMap();
    private CopyOnWriteArrayList<C> _removedConsumers = new CopyOnWriteArrayList();
    private ConcurrentHashMap<Destination, AtomicInteger> _destinationConsumerCount = new ConcurrentHashMap();
    private long _nextProducerId;
    private boolean _inRecovery;
    private boolean _connectionStopped;
    private boolean _hasMessageListeners;
    private boolean _suspended;
    private final Object _suspensionLock = new Object();
    protected final AtomicBoolean _firstDispatcher = new AtomicBoolean(true);
    protected final boolean _immediatePrefetch;
    protected final boolean _strictAMQP;
    protected final boolean _strictAMQPFATAL;
    private final Object _messageDeliveryLock = new Object();
    private boolean _dirty;
    private boolean _failedOverDirty;
    private FlowControlIndicator _flowControl = new FlowControlIndicator();
    private static final Logger _dispatcherLogger = LoggerFactory.getLogger((String)"org.apache.qpid.client.AMQSession.Dispatcher");

    protected AMQSession(AMQConnection con, int channelId, boolean transacted, int acknowledgeMode, MessageFactoryRegistry messageFactoryRegistry, int defaultPrefetchHighMark, int defaultPrefetchLowMark) {
        this.USE_AMQP_ENCODED_MAP_MESSAGE = con == null ? true : !con.isUseLegacyMapMessageFormat();
        this._strictAMQP = Boolean.parseBoolean(System.getProperties().getProperty(STRICT_AMQP, "false"));
        this._strictAMQPFATAL = Boolean.parseBoolean(System.getProperties().getProperty(STRICT_AMQP_FATAL, STRICT_AMQP_FATAL_DEFAULT));
        this._immediatePrefetch = this._strictAMQP || Boolean.parseBoolean(System.getProperties().getProperty(IMMEDIATE_PREFETCH, "false"));
        this._connection = con;
        this._transacted = transacted;
        this._acknowledgeMode = transacted ? 0 : acknowledgeMode;
        this._channelId = channelId;
        this._messageFactoryRegistry = messageFactoryRegistry;
        this._prefetchHighMark = defaultPrefetchHighMark;
        this._prefetchLowMark = defaultPrefetchLowMark;
        this._queue = this._acknowledgeMode == 257 ? new FlowControllingBlockingQueue(this._prefetchHighMark, this._prefetchLowMark, new FlowControllingBlockingQueue.ThresholdListener(){
            private final AtomicBoolean _suspendState = new AtomicBoolean();

            public void aboveThreshold(int currentValue) {
                if (!(AMQSession.this._thisSession.isClosed() || AMQSession.this._thisSession.isClosing() || this._suspendState.getAndSet(true))) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Above threshold(" + AMQSession.this._prefetchHighMark + ") so suspending channel. Current value is " + currentValue);
                    }
                    try {
                        Threading.getThreadFactory().createThread((Runnable)new SuspenderRunner(this._suspendState)).start();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create thread", e);
                    }
                }
            }

            public void underThreshold(int currentValue) {
                if (!AMQSession.this._thisSession.isClosed() && !AMQSession.this._thisSession.isClosing() && this._suspendState.getAndSet(false)) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Below threshold(" + AMQSession.this._prefetchLowMark + ") so unsuspending channel. Current value is " + currentValue);
                    }
                    try {
                        Threading.getThreadFactory().createThread((Runnable)new SuspenderRunner(this._suspendState)).start();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create thread", e);
                    }
                }
            }
        }) : new FlowControllingBlockingQueue(this._prefetchHighMark, null);
        if (_logger.isInfoEnabled()) {
            _logger.info("Created session:" + this);
        }
    }

    AMQSession(AMQConnection con, int channelId, boolean transacted, int acknowledgeMode, int defaultPrefetchHigh, int defaultPrefetchLow) {
        this(con, channelId, transacted, acknowledgeMode, MessageFactoryRegistry.newDefaultRegistry(), defaultPrefetchHigh, defaultPrefetchLow);
    }

    @Override
    public void close() throws JMSException {
        this.close(-1L);
    }

    public abstract AMQException getLastException();

    @Override
    public void checkNotClosed() throws JMSException {
        try {
            super.checkNotClosed();
        }
        catch (javax.jms.IllegalStateException ise) {
            AMQException ex = this.getLastException();
            if (ex != null) {
                javax.jms.IllegalStateException ssnClosed = new javax.jms.IllegalStateException("Session has been closed", ex.getErrorCode().toString());
                ssnClosed.setLinkedException((Exception)((Object)ex));
                ssnClosed.initCause((Throwable)ex);
                throw ssnClosed;
            }
            throw ise;
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkNotClosed();
        JMSBytesMessage msg = new JMSBytesMessage(this.getMessageDelegateFactory());
        msg.setAMQSession(this);
        return msg;
    }

    public void acknowledge() throws javax.jms.IllegalStateException {
        Long tag;
        if (this.isClosed()) {
            throw new javax.jms.IllegalStateException("Session is already closed");
        }
        if (this.hasFailedOver()) {
            throw new javax.jms.IllegalStateException("has failed over");
        }
        while ((tag = this._unacknowledgedMessageTags.poll()) != null) {
            this.acknowledgeMessage(tag, false);
        }
    }

    public abstract void acknowledgeMessage(long var1, boolean var3);

    public MethodRegistry getMethodRegistry() {
        MethodRegistry methodRegistry = this.getProtocolHandler().getMethodRegistry();
        return methodRegistry;
    }

    public void bindQueue(AMQShortString queueName, AMQShortString routingKey, FieldTable arguments, AMQShortString exchangeName, AMQDestination destination) throws AMQException {
        this.bindQueue(queueName, routingKey, arguments, exchangeName, destination, false);
    }

    public void bindQueue(final AMQShortString queueName, final AMQShortString routingKey, final FieldTable arguments, final AMQShortString exchangeName, final AMQDestination destination, final boolean nowait) throws AMQException {
        new FailoverNoopSupport<Object, AMQException>(new FailoverProtectedOperation<Object, AMQException>(){

            @Override
            public Object execute() throws AMQException, FailoverException {
                AMQSession.this.sendQueueBind(queueName, routingKey, arguments, exchangeName, destination, nowait);
                return null;
            }
        }, this._connection).execute();
    }

    public void addBindingKey(C consumer, AMQDestination amqd, String routingKey) throws AMQException {
        if (((BasicMessageConsumer)consumer).getQueuename() != null) {
            this.bindQueue(((BasicMessageConsumer)consumer).getQueuename(), new AMQShortString(routingKey), new FieldTable(), amqd.getExchangeName(), amqd);
        }
    }

    public abstract void sendQueueBind(AMQShortString var1, AMQShortString var2, FieldTable var3, AMQShortString var4, AMQDestination var5, boolean var6) throws AMQException, FailoverException;

    public void close(long timeout) throws JMSException {
        this.close(timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(long timeout, boolean sendClose) throws JMSException {
        if (_logger.isInfoEnabled()) {
            _logger.info("Closing session: " + this);
        }
        if (!this._closed.getAndSet(true)) {
            this._closing.set(true);
            Object object = this.getFailoverMutex();
            synchronized (object) {
                Object object2 = this._messageDeliveryLock;
                synchronized (object2) {
                    this.closeProducersAndConsumers(null);
                    try {
                        if ((!this._connection.isClosed() || this._connection.isClosing()) && sendClose) {
                            this.sendClose(timeout);
                        }
                    }
                    catch (AMQException e) {
                        JMSException jmse = new JMSException("Error closing session: " + (Object)((Object)e));
                        jmse.setLinkedException((Exception)((Object)e));
                        jmse.initCause((Throwable)e);
                        throw jmse;
                    }
                    catch (FailoverException e) {
                        _logger.debug("Got FailoverException during channel close, ignored as channel already marked as closed.");
                    }
                    finally {
                        this._connection.deregisterSession(this._channelId);
                    }
                }
            }
        }
    }

    public abstract void sendClose(long var1) throws AMQException, FailoverException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed(Throwable e) throws JMSException {
        if (e instanceof AMQDisconnectedException && this._dispatcher != null) {
            this._dispatcherThread.interrupt();
        }
        this._closing.set(e == null);
        if (!this._closed.getAndSet(true)) {
            Object object = this._messageDeliveryLock;
            synchronized (object) {
                AMQException amqe = e instanceof AMQException ? (AMQException)e : new AMQException("Closing session forcibly", e);
                this._connection.deregisterSession(this._channelId);
                this.closeProducersAndConsumers(amqe);
            }
        }
    }

    public void commit() throws JMSException {
        this.checkTransacted();
        try {
            Long tag;
            if (this._failedOverDirty) {
                this.rollback();
                throw new TransactionRolledBackException("Connection failover has occured since last send. Forced rollback");
            }
            while ((tag = this._deliveredMessageTags.poll()) != null) {
                this.acknowledgeMessage(tag, false);
            }
            this.sendCommit();
            this.markClean();
        }
        catch (AMQException e) {
            throw new JMSAMQException("Failed to commit: " + e.getMessage() + ":" + e.getCause(), (Exception)((Object)e));
        }
        catch (FailoverException e) {
            throw new JMSAMQException("Fail-over interrupted commit. Status of the commit is uncertain.", e);
        }
    }

    public abstract void sendCommit() throws AMQException, FailoverException;

    public void confirmConsumerCancelled(int consumerTag) {
        C consumer = this._consumers.get(consumerTag);
        if (consumer != null) {
            if (!((BasicMessageConsumer)consumer).isNoConsume()) {
                if (this._dispatcher != null) {
                    _logger.info("Dispatcher is not null");
                } else {
                    _logger.info("Dispatcher is null so created stopped dispatcher");
                    this.startDispatcherIfNecessary(true);
                }
                this._dispatcher.rejectPending(consumer);
            } else if (((BasicMessageConsumer)consumer).isAutoClose()) {
                if (((Closeable)consumer).isClosed()) {
                    if (_logger.isInfoEnabled()) {
                        _logger.info("Closing consumer:" + ((BasicMessageConsumer)consumer).debugIdentity());
                    }
                    this.deregisterConsumer(consumer);
                } else {
                    this._queue.add(new CloseConsumerMessage((BasicMessageConsumer)consumer));
                }
            }
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.isStrictAMQP()) {
            throw new UnsupportedOperationException();
        }
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (this.isStrictAMQP()) {
            throw new UnsupportedOperationException();
        }
        this.checkNotClosed();
        this.checkValidQueue(queue);
        return new AMQQueueBrowser(this, (AMQQueue)queue, messageSelector);
    }

    public MessageConsumer createBrowserConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, this._prefetchHighMark, this._prefetchLowMark, noLocal, false, messageSelector, null, true, true);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, this._prefetchHighMark, this._prefetchLowMark, false, destination instanceof Topic, null, null, destination instanceof AMQDestination && ((AMQDestination)destination).isBrowseOnly(), false);
    }

    public C createExclusiveConsumer(Destination destination) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, this._prefetchHighMark, this._prefetchLowMark, false, true, null, null, destination instanceof AMQDestination && ((AMQDestination)destination).isBrowseOnly(), false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, this._prefetchHighMark, this._prefetchLowMark, false, destination instanceof Topic, messageSelector, null, destination instanceof AMQDestination && ((AMQDestination)destination).isBrowseOnly(), false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, this._prefetchHighMark, this._prefetchLowMark, noLocal, destination instanceof Topic, messageSelector, null, destination instanceof AMQDestination && ((AMQDestination)destination).isBrowseOnly(), false);
    }

    public MessageConsumer createExclusiveConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, this._prefetchHighMark, this._prefetchLowMark, noLocal, true, messageSelector, null, false, false);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, int prefetch, boolean noLocal, boolean exclusive, String selector) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, prefetch, prefetch / 2, noLocal, exclusive, selector, null, destination instanceof AMQDestination && ((AMQDestination)destination).isBrowseOnly(), false);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, int prefetchHigh, int prefetchLow, boolean noLocal, boolean exclusive, String selector) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, prefetchHigh, prefetchLow, noLocal, exclusive, selector, null, destination instanceof AMQDestination && ((AMQDestination)destination).isBrowseOnly(), false);
    }

    public MessageConsumer createConsumer(Destination destination, int prefetch, boolean noLocal, boolean exclusive, String selector, FieldTable rawSelector) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, prefetch, prefetch / 2, noLocal, exclusive, selector, rawSelector, destination instanceof AMQDestination && ((AMQDestination)destination).isBrowseOnly(), false);
    }

    public MessageConsumer createConsumer(Destination destination, int prefetchHigh, int prefetchLow, boolean noLocal, boolean exclusive, String selector, FieldTable rawSelector) throws JMSException {
        this.checkValidDestination(destination);
        return this.createConsumerImpl(destination, prefetchHigh, prefetchLow, noLocal, exclusive, selector, rawSelector, destination instanceof AMQDestination && ((AMQDestination)destination).isBrowseOnly(), false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        this.checkNotClosed();
        Topic origTopic = this.checkValidTopic(topic, true);
        AMQTopic dest = AMQTopic.createDurableTopic(origTopic, name, this._connection);
        if (dest.getDestSyntax() == AMQDestination.DestSyntax.ADDR && !dest.isAddressResolved()) {
            try {
                this.handleAddressBasedDestination(dest, false, true);
                if (dest.getAddressType() != 2) {
                    throw new JMSException("Durable subscribers can only be created for Topics");
                }
                dest.getSourceNode().setDurable(true);
            }
            catch (AMQException e) {
                JMSException ex = new JMSException("Error when verifying destination");
                ex.initCause((Throwable)e);
                ex.setLinkedException((Exception)((Object)e));
                throw ex;
            }
        }
        String messageSelector = selector == null || selector.trim().length() == 0 ? null : selector;
        this._subscriberDetails.lock();
        try {
            TopicSubscriberAdaptor<Object> subscriber = this._subscriptions.get(name);
            if (subscriber == null) {
                AMQShortString topicName = dest.getRoutingKey();
                if (this._strictAMQP) {
                    if (this._strictAMQPFATAL) {
                        throw new UnsupportedOperationException("JMS Durable not currently supported by AMQP.");
                    }
                    _logger.warn("Unable to determine if subscription already exists for '" + topicName + "' for creation durableSubscriber. Requesting queue deletion regardless.");
                    this.deleteQueue(dest.getAMQQueueName());
                } else {
                    HashMap<String, Object> args = new HashMap<String, Object>();
                    args.put(AMQPFilterTypes.JMS_SELECTOR.getValue().toString(), messageSelector == null ? "" : messageSelector);
                    boolean isQueueBound = this.isQueueBound(dest.getExchangeName(), dest.getAMQQueueName());
                    boolean isQueueBoundForTopicAndSelector = this.isQueueBound(dest.getExchangeName().asString(), dest.getAMQQueueName().asString(), topicName.asString(), args);
                    if (isQueueBound && !isQueueBoundForTopicAndSelector) {
                        this.deleteQueue(dest.getAMQQueueName());
                    }
                }
            } else {
                if (subscriber.getTopic().equals(topic) && (messageSelector == null && subscriber.getMessageSelector() == null || messageSelector != null && messageSelector.equals(subscriber.getMessageSelector()))) {
                    throw new javax.jms.IllegalStateException("Already subscribed to topic " + topic + " with subscription name " + name + (messageSelector != null ? " and selector " + messageSelector : ""));
                }
                this.unsubscribe(name, true);
            }
            this._subscriberAccess.lock();
            try {
                BasicMessageConsumer consumer = (BasicMessageConsumer)this.createConsumer(dest, messageSelector, noLocal);
                subscriber = new TopicSubscriberAdaptor<BasicMessageConsumer>(dest, consumer);
                this._subscriptions.put(name, subscriber);
                this._reverseSubscriptionMap.put(subscriber.getMessageConsumer(), name);
            }
            finally {
                this._subscriberAccess.unlock();
            }
            TopicSubscriberAdaptor<Object> topicSubscriberAdaptor = subscriber;
            return topicSubscriberAdaptor;
        }
        finally {
            this._subscriberDetails.unlock();
        }
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkNotClosed();
        if (this.USE_AMQP_ENCODED_MAP_MESSAGE) {
            AMQPEncodedMapMessage msg = new AMQPEncodedMapMessage(this.getMessageDelegateFactory());
            msg.setAMQSession(this);
            return msg;
        }
        JMSMapMessage msg = new JMSMapMessage(this.getMessageDelegateFactory());
        msg.setAMQSession(this);
        return msg;
    }

    public Message createMessage() throws JMSException {
        return this.createBytesMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkNotClosed();
        JMSObjectMessage msg = new JMSObjectMessage(this.getMessageDelegateFactory());
        msg.setAMQSession(this);
        return msg;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        ObjectMessage msg = this.createObjectMessage();
        msg.setObject(object);
        return msg;
    }

    public P createProducer(Destination destination) throws JMSException {
        return this.createProducerImpl(destination, this.DEFAULT_MANDATORY, this.DEFAULT_IMMEDIATE);
    }

    public P createProducer(Destination destination, boolean immediate) throws JMSException {
        return this.createProducerImpl(destination, this.DEFAULT_MANDATORY, immediate);
    }

    public P createProducer(Destination destination, boolean mandatory, boolean immediate) throws JMSException {
        return this.createProducerImpl(destination, mandatory, immediate);
    }

    public P createProducer(Destination destination, boolean mandatory, boolean immediate, boolean waitUntilSent) throws JMSException {
        return this.createProducerImpl(destination, mandatory, immediate, waitUntilSent);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkNotClosed();
        return new TopicPublisherAdapter((BasicMessageProducer)this.createProducer((Destination)topic, false, false), topic);
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.checkNotClosed();
        try {
            if (queueName.indexOf(47) == -1 && queueName.indexOf(59) == -1) {
                AMQDestination.DestSyntax syntax = AMQDestination.getDestType(queueName);
                if (syntax == AMQDestination.DestSyntax.BURL) {
                    return new AMQQueue(this.getDefaultQueueExchangeName(), new AMQShortString(AMQDestination.stripSyntaxPrefix(queueName)));
                }
                AMQQueue queue = new AMQQueue(queueName);
                return queue;
            }
            return new AMQQueue(queueName);
        }
        catch (URISyntaxException urlse) {
            _logger.error("", (Throwable)urlse);
            JMSException jmse = new JMSException(urlse.getReason());
            jmse.setLinkedException((Exception)urlse);
            jmse.initCause((Throwable)urlse);
            throw jmse;
        }
    }

    public void createQueue(AMQShortString name, boolean autoDelete, boolean durable, boolean exclusive) throws AMQException {
        this.createQueue(name, autoDelete, durable, exclusive, null);
    }

    public void createQueue(final AMQShortString name, final boolean autoDelete, final boolean durable, final boolean exclusive, final Map<String, Object> arguments) throws AMQException {
        new FailoverRetrySupport<Object, AMQException>(new FailoverProtectedOperation<Object, AMQException>(){

            @Override
            public Object execute() throws AMQException, FailoverException {
                AMQSession.this.sendCreateQueue(name, autoDelete, durable, exclusive, arguments);
                return null;
            }
        }, this._connection).execute();
    }

    public abstract void sendCreateQueue(AMQShortString var1, boolean var2, boolean var3, boolean var4, Map<String, Object> var5) throws AMQException, FailoverException;

    public QueueReceiver createQueueReceiver(Destination destination) throws JMSException {
        this.checkValidDestination(destination);
        Queue dest = this.validateQueue(destination);
        BasicMessageConsumer consumer = (BasicMessageConsumer)this.createConsumer((Destination)dest);
        return new QueueReceiverAdaptor(dest, consumer);
    }

    public QueueReceiver createQueueReceiver(Destination destination, String messageSelector) throws JMSException {
        this.checkValidDestination(destination);
        Queue dest = this.validateQueue(destination);
        BasicMessageConsumer consumer = (BasicMessageConsumer)this.createConsumer((Destination)dest, messageSelector);
        return new QueueReceiverAdaptor(dest, consumer);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkNotClosed();
        Queue dest = this.validateQueue((Destination)queue);
        BasicMessageConsumer consumer = (BasicMessageConsumer)this.createConsumer((Destination)dest);
        return new QueueReceiverAdaptor(dest, consumer);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.checkNotClosed();
        Queue dest = this.validateQueue((Destination)queue);
        BasicMessageConsumer consumer = (BasicMessageConsumer)this.createConsumer((Destination)dest, messageSelector);
        return new QueueReceiverAdaptor(dest, consumer);
    }

    private Queue validateQueue(Destination dest) throws InvalidDestinationException {
        if (dest instanceof AMQDestination && dest instanceof Queue) {
            return (Queue)dest;
        }
        throw new InvalidDestinationException("The destination object used is not from this provider or of type javax.jms.Queue");
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkNotClosed();
        return new QueueSenderAdapter((BasicMessageProducer)this.createProducer((Destination)queue), queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamMessage createStreamMessage() throws JMSException {
        Object object = this.getFailoverMutex();
        synchronized (object) {
            this.checkNotClosed();
            JMSStreamMessage msg = new JMSStreamMessage(this.getMessageDelegateFactory());
            msg.setAMQSession(this);
            return msg;
        }
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkNotClosed();
        Topic dest = this.checkValidTopic(topic);
        return new TopicSubscriberAdaptor<C>(dest, this.createExclusiveConsumer((Destination)dest));
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkNotClosed();
        Topic dest = this.checkValidTopic(topic);
        return new TopicSubscriberAdaptor<BasicMessageConsumer>(dest, (BasicMessageConsumer)this.createExclusiveConsumer((Destination)dest, messageSelector, noLocal));
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkNotClosed();
        try {
            AMQTemporaryQueue result = new AMQTemporaryQueue(this);
            result.setQueueName(result.getRoutingKey());
            this.createQueue(result.getAMQQueueName(), result.isAutoDelete(), result.isDurable(), result.isExclusive());
            this.bindQueue(result.getAMQQueueName(), result.getRoutingKey(), new FieldTable(), result.getExchangeName(), result);
            return result;
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Cannot create temporary queue");
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkNotClosed();
        return new AMQTemporaryTopic(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextMessage createTextMessage() throws JMSException {
        Object object = this.getFailoverMutex();
        synchronized (object) {
            this.checkNotClosed();
            JMSTextMessage msg = new JMSTextMessage(this.getMessageDelegateFactory());
            msg.setAMQSession(this);
            return msg;
        }
    }

    protected Object getFailoverMutex() {
        return this._connection.getFailoverMutex();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        TextMessage msg = this.createTextMessage();
        msg.setText(text);
        return msg;
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.checkNotClosed();
        try {
            if (topicName.indexOf(47) == -1 && topicName.indexOf(59) == -1) {
                AMQDestination.DestSyntax syntax = AMQDestination.getDestType(topicName);
                topicName = AMQDestination.stripSyntaxPrefix(topicName);
                if (syntax == AMQDestination.DestSyntax.BURL) {
                    return new AMQTopic(this.getDefaultTopicExchangeName(), new AMQShortString(topicName));
                }
                return new AMQTopic("ADDR:" + this.getDefaultTopicExchangeName() + "/" + topicName);
            }
            return new AMQTopic(topicName);
        }
        catch (URISyntaxException urlse) {
            _logger.error("", (Throwable)urlse);
            JMSException jmse = new JMSException(urlse.getReason());
            jmse.setLinkedException((Exception)urlse);
            jmse.initCause((Throwable)urlse);
            throw jmse;
        }
    }

    public void declareExchange(AMQShortString name, AMQShortString type, boolean nowait) throws AMQException {
        this.declareExchange(name, type, this.getProtocolHandler(), nowait);
    }

    public abstract void sync() throws AMQException;

    public int getAcknowledgeMode() throws JMSException {
        this.checkNotClosed();
        return this._acknowledgeMode;
    }

    public AMQConnection getAMQConnection() {
        return this._connection;
    }

    public int getChannelId() {
        return this._channelId;
    }

    @Override
    public int getDefaultPrefetch() {
        return this._prefetchHighMark;
    }

    @Override
    public int getDefaultPrefetchHigh() {
        return this._prefetchHighMark;
    }

    @Override
    public int getDefaultPrefetchLow() {
        return this._prefetchLowMark;
    }

    @Override
    public AMQShortString getDefaultQueueExchangeName() {
        return this._connection.getDefaultQueueExchangeName();
    }

    @Override
    public AMQShortString getDefaultTopicExchangeName() {
        return this._connection.getDefaultTopicExchangeName();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this._messageListener;
    }

    @Override
    public AMQShortString getTemporaryQueueExchangeName() {
        return this._connection.getTemporaryQueueExchangeName();
    }

    @Override
    public AMQShortString getTemporaryTopicExchangeName() {
        return this._connection.getTemporaryTopicExchangeName();
    }

    public int getTicket() {
        return this._ticket;
    }

    public boolean getTransacted() throws JMSException {
        this.checkNotClosed();
        return this._transacted;
    }

    public boolean hasConsumer(Destination destination) {
        AtomicInteger counter = this._destinationConsumerCount.get(destination);
        return counter != null && counter.get() != 0;
    }

    public boolean isStrictAMQP() {
        return this._strictAMQP;
    }

    public boolean isSuspended() {
        return this._suspended;
    }

    protected void addUnacknowledgedMessage(long id) {
        this._unacknowledgedMessageTags.add(id);
    }

    protected void addDeliveredMessage(long id) {
        this._deliveredMessageTags.add(id);
    }

    public void messageReceived(UnprocessedMessage message) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Message[" + message.toString() + "] received in session");
        }
        this._highestDeliveryTag.set(message.getDeliveryTag());
        this._queue.add(message);
    }

    public void declareAndBind(AMQDestination amqd) throws AMQException {
        AMQProtocolHandler protocolHandler = this.getProtocolHandler();
        this.declareExchange(amqd, protocolHandler, false);
        AMQShortString queueName = this.declareQueue(amqd, protocolHandler, false);
        this.bindQueue(queueName, amqd.getRoutingKey(), new FieldTable(), amqd.getExchangeName(), amqd);
    }

    public void recover() throws JMSException {
        this.checkNotClosed();
        this.checkNotTransacted();
        this.flushAcknowledgments();
        this._inRecovery = true;
        try {
            boolean isSuspended = this.isSuspended();
            if (!isSuspended) {
                this.suspendChannel(true);
            }
            this.syncDispatchQueue();
            if (this._dispatcher != null) {
                this._dispatcher.recover();
            }
            this.sendRecover();
            this.markClean();
            this._inRecovery = false;
            if (!isSuspended) {
                this.suspendChannel(false);
            }
        }
        catch (AMQException e) {
            throw new JMSAMQException("Recover failed: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (FailoverException e) {
            throw new JMSAMQException("Recovery was interrupted by fail-over. Recovery status is not known.", e);
        }
    }

    protected abstract void sendRecover() throws AMQException, FailoverException;

    protected abstract void flushAcknowledgments();

    public void rejectMessage(UnprocessedMessage message, boolean requeue) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Rejecting Unacked message:" + message.getDeliveryTag());
        }
        this.rejectMessage(message.getDeliveryTag(), requeue);
    }

    public void rejectMessage(AbstractJMSMessage message, boolean requeue) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Rejecting Abstract message:" + message.getDeliveryTag());
        }
        this.rejectMessage(message.getDeliveryTag(), requeue);
    }

    public abstract void rejectMessage(long var1, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        Object object = this._suspensionLock;
        synchronized (object) {
            this.checkTransacted();
            try {
                boolean isSuspended = this.isSuspended();
                if (!isSuspended) {
                    this.suspendChannel(true);
                }
                this._rollbackMark.set(this._highestDeliveryTag.get());
                this.syncDispatchQueue();
                this._dispatcher.rollback();
                this.releaseForRollback();
                this.sendRollback();
                this.markClean();
                if (!isSuspended) {
                    this.suspendChannel(false);
                }
            }
            catch (AMQException e) {
                throw new JMSAMQException("Failed to rollback: " + (Object)((Object)e), (Exception)((Object)e));
            }
            catch (FailoverException e) {
                throw new JMSAMQException("Fail-over interrupted rollback. Status of the rollback is uncertain.", e);
            }
        }
    }

    public abstract void releaseForRollback();

    public abstract void sendRollback() throws AMQException, FailoverException;

    public void run() {
        throw new UnsupportedOperationException();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
    }

    public void unsubscribe(String name) throws JMSException {
        this.unsubscribe(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribe(String name, boolean safe) throws JMSException {
        TopicSubscriberAdaptor<C> subscriber;
        this._subscriberDetails.lock();
        try {
            this.checkNotClosed();
            subscriber = this._subscriptions.get(name);
            if (subscriber != null) {
                this._subscriptions.remove(name);
                this._reverseSubscriptionMap.remove(subscriber.getMessageConsumer());
            }
        }
        finally {
            this._subscriberDetails.unlock();
        }
        if (subscriber != null) {
            subscriber.close();
            this.deleteQueue(AMQTopic.getDurableTopicQueueName(name, this._connection));
        } else if (this._strictAMQP) {
            if (this._strictAMQPFATAL) {
                throw new UnsupportedOperationException("JMS Durable not currently supported by AMQP.");
            }
            _logger.warn("Unable to determine if subscription already exists for '" + name + "' for unsubscribe." + " Requesting queue deletion regardless.");
            this.deleteQueue(AMQTopic.getDurableTopicQueueName(name, this._connection));
        } else if (this.isQueueBound(this.getDefaultTopicExchangeName(), AMQTopic.getDurableTopicQueueName(name, this._connection))) {
            this.deleteQueue(AMQTopic.getDurableTopicQueueName(name, this._connection));
        } else if (!safe) {
            throw new InvalidDestinationException("Unknown subscription name: " + name);
        }
    }

    protected C createConsumerImpl(final Destination destination, final int prefetchHigh, final int prefetchLow, final boolean noLocal, final boolean exclusive, String selector, final FieldTable rawSelector, final boolean noConsume, final boolean autoClose) throws JMSException {
        String messageSelector;
        this.checkTemporaryDestination(destination);
        if (this._strictAMQP && selector != null && !selector.equals("")) {
            if (this._strictAMQPFATAL) {
                throw new UnsupportedOperationException("Selectors not currently supported by AMQP.");
            }
            messageSelector = null;
        } else {
            messageSelector = selector;
        }
        return (C)((BasicMessageConsumer)new FailoverRetrySupport(new FailoverProtectedOperation<C, JMSException>(){

            @Override
            public C execute() throws JMSException, FailoverException {
                AMQSession.this.checkNotClosed();
                AMQDestination amqd = (AMQDestination)destination;
                FieldTable ft = FieldTableFactory.newFieldTable();
                if (rawSelector != null) {
                    ft.addAll(rawSelector);
                }
                ft.put(AMQPFilterTypes.JMS_SELECTOR.getValue(), (Object)(messageSelector == null ? "" : messageSelector));
                Object consumer = AMQSession.this.createMessageConsumer(amqd, prefetchHigh, prefetchLow, noLocal, exclusive, messageSelector, ft, noConsume, autoClose);
                if (AMQSession.this._messageListener != null) {
                    ((BasicMessageConsumer)consumer).setMessageListener(AMQSession.this._messageListener);
                }
                try {
                    AMQSession.this.registerConsumer(consumer, false);
                }
                catch (AMQInvalidArgumentException ise) {
                    InvalidSelectorException jmse = new InvalidSelectorException(ise.getMessage());
                    jmse.setLinkedException((Exception)((Object)ise));
                    jmse.initCause((Throwable)ise);
                    throw jmse;
                }
                catch (AMQInvalidRoutingKeyException e) {
                    InvalidDestinationException jmse = new InvalidDestinationException("Invalid routing key:" + amqd.getRoutingKey().toString());
                    jmse.setLinkedException((Exception)((Object)e));
                    jmse.initCause((Throwable)e);
                    throw jmse;
                }
                catch (AMQException e) {
                    if (e instanceof AMQChannelClosedException) {
                        AMQSession.this.close(-1L, false);
                    }
                    JMSException ex = new JMSException("Error registering consumer: " + (Object)((Object)e));
                    ex.setLinkedException((Exception)((Object)e));
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                return consumer;
            }
        }, this._connection).execute());
    }

    public abstract C createMessageConsumer(AMQDestination var1, int var2, int var3, boolean var4, boolean var5, String var6, FieldTable var7, boolean var8, boolean var9) throws JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterConsumer(C consumer) {
        if (this._consumers.remove(((BasicMessageConsumer)consumer).getConsumerTag()) != null) {
            AMQDestination dest;
            this._subscriberAccess.lock();
            try {
                String subscriptionName = this._reverseSubscriptionMap.remove(consumer);
                if (subscriptionName != null) {
                    this._subscriptions.remove(subscriptionName);
                }
            }
            finally {
                this._subscriberAccess.unlock();
            }
            AMQDestination aMQDestination = dest = ((BasicMessageConsumer)consumer).getDestination();
            synchronized (aMQDestination) {
                if (this._destinationConsumerCount.get(dest) != null && this._destinationConsumerCount.get(dest).decrementAndGet() == 0) {
                    this._destinationConsumerCount.remove(dest);
                }
            }
            if (this._transacted) {
                this._removedConsumers.add(consumer);
            }
        }
    }

    void deregisterProducer(long producerId) {
        this._producers.remove(new Long(producerId));
    }

    boolean isInRecovery() {
        return this._inRecovery;
    }

    boolean isQueueBound(AMQShortString exchangeName, AMQShortString queueName) throws JMSException {
        return this.isQueueBound(exchangeName, queueName, null);
    }

    public abstract boolean isQueueBound(AMQShortString var1, AMQShortString var2, AMQShortString var3) throws JMSException;

    public abstract boolean isQueueBound(AMQDestination var1) throws JMSException;

    public abstract boolean isQueueBound(String var1, String var2, String var3, Map<String, Object> var4) throws JMSException;

    void markClosed() {
        this._closed.set(true);
        this._connection.deregisterSession(this._channelId);
        this.markClosedProducersAndConsumers();
    }

    void failoverPrep() {
        this.syncDispatchQueue();
    }

    void syncDispatchQueue() {
        if (Thread.currentThread() == this._dispatcherThread) {
            while (!this._closed.get() && !this._queue.isEmpty()) {
                Dispatchable disp;
                try {
                    disp = (Dispatchable)this._queue.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (disp == null) {
                    _logger.debug("_queue became empty during sync.");
                    break;
                }
                disp.dispatch(this);
            }
        } else {
            this.startDispatcherIfNecessary();
            final CountDownLatch signal = new CountDownLatch(1);
            this._queue.add(new Dispatchable(){

                public void dispatch(AMQSession ssn) {
                    signal.countDown();
                }
            });
            try {
                signal.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void resubscribe() throws AMQException {
        if (this._dirty) {
            this._failedOverDirty = true;
        }
        this._rollbackMark.set(-1L);
        this.resubscribeProducers();
        this.resubscribeConsumers();
    }

    void setHasMessageListeners() {
        this._hasMessageListeners = true;
    }

    void setInRecovery(boolean inRecovery) {
        this._inRecovery = inRecovery;
    }

    boolean isStarted() {
        return this._startedAtLeastOnce.get();
    }

    void start() throws AMQException {
        if (this._startedAtLeastOnce.getAndSet(true)) {
            this.suspendChannel(false);
        }
        if (this.hasMessageListeners()) {
            this.startDispatcherIfNecessary();
        }
    }

    void startDispatcherIfNecessary() {
        if (Thread.currentThread() == this._dispatcherThread) {
            return;
        }
        if (!this._immediatePrefetch && this.isSuspended() && this._startedAtLeastOnce.get() && this._firstDispatcher.getAndSet(false)) {
            try {
                this.suspendChannel(false);
            }
            catch (AMQException e) {
                _logger.info("Unsuspending channel threw an exception:" + (Object)((Object)e));
            }
        }
        this.startDispatcherIfNecessary(false);
    }

    synchronized void startDispatcherIfNecessary(boolean initiallyStopped) {
        if (this._dispatcher == null) {
            this._dispatcher = new Dispatcher();
            try {
                this._dispatcherThread = Threading.getThreadFactory().createThread((Runnable)this._dispatcher);
            }
            catch (Exception e) {
                throw new Error("Error creating Dispatcher thread", e);
            }
            this._dispatcherThread.setName("Dispatcher-Channel-" + this._channelId);
            this._dispatcherThread.setDaemon(true);
            this._dispatcher.setConnectionStopped(initiallyStopped);
            this._dispatcherThread.start();
            if (_dispatcherLogger.isInfoEnabled()) {
                _dispatcherLogger.info(this._dispatcherThread.getName() + " created");
            }
        } else {
            this._dispatcher.setConnectionStopped(initiallyStopped);
        }
    }

    void stop() throws AMQException {
        this.suspendChannel(true);
        if (this._dispatcher != null) {
            this._dispatcher.setConnectionStopped(true);
        }
    }

    private void checkNotTransacted() throws JMSException {
        if (this.getTransacted()) {
            throw new javax.jms.IllegalStateException("Session is transacted");
        }
    }

    private void checkTemporaryDestination(Destination destination) throws JMSException {
        if (destination instanceof TemporaryDestination) {
            _logger.debug("destination is temporary");
            TemporaryDestination tempDest = (TemporaryDestination)destination;
            if (tempDest.getSession() != this) {
                _logger.debug("destination is on different session");
                throw new JMSException("Cannot consume from a temporary destination created on another session");
            }
            if (tempDest.isDeleted()) {
                _logger.debug("destination is deleted");
                throw new JMSException("Cannot consume from a deleted destination");
            }
        }
    }

    protected void checkTransacted() throws JMSException {
        if (!this.getTransacted()) {
            throw new javax.jms.IllegalStateException("Session is not transacted");
        }
    }

    private void checkValidDestination(Destination destination) throws InvalidDestinationException {
        if (destination == null) {
            throw new InvalidDestinationException("Invalid Queue");
        }
    }

    private void checkValidQueue(Queue queue) throws InvalidDestinationException {
        if (queue == null) {
            throw new InvalidDestinationException("Invalid Queue");
        }
    }

    protected Topic checkValidTopic(Topic topic, boolean durable) throws JMSException {
        if (topic == null) {
            throw new InvalidDestinationException("Invalid Topic");
        }
        if (topic instanceof TemporaryDestination && ((TemporaryDestination)topic).getSession() != this) {
            throw new InvalidDestinationException("Cannot create a subscription on a temporary topic created in another session");
        }
        if (topic instanceof TemporaryDestination && durable) {
            throw new InvalidDestinationException("Cannot create a durable subscription with a temporary topic: " + topic);
        }
        if (!(topic instanceof AMQDestination) || !(topic instanceof Topic)) {
            throw new InvalidDestinationException("Cannot create a subscription on topic created for another JMS Provider, class of topic provided is: " + topic.getClass().getName());
        }
        return topic;
    }

    protected Topic checkValidTopic(Topic topic) throws JMSException {
        return this.checkValidTopic(topic, false);
    }

    private void closeConsumers(Throwable error) throws JMSException {
        ArrayList<C> clonedConsumers = new ArrayList<C>(this._consumers.values());
        for (BasicMessageConsumer con : clonedConsumers) {
            if (error != null) {
                con.notifyError(error);
                continue;
            }
            con.close(false);
        }
        if (this._dispatcher != null) {
            this._dispatcher.close();
            this._dispatcher = null;
        }
    }

    private void closeProducers() throws JMSException {
        ArrayList<MessageProducer> clonedProducers = new ArrayList<MessageProducer>(this._producers.values());
        for (BasicMessageProducer basicMessageProducer : clonedProducers) {
            basicMessageProducer.close();
        }
    }

    private void closeProducersAndConsumers(AMQException amqe) throws JMSException {
        JMSException jmse;
        block5: {
            jmse = null;
            try {
                this.closeProducers();
            }
            catch (JMSException e) {
                _logger.error("Error closing session: " + (Object)((Object)e), (Throwable)e);
                jmse = e;
            }
            try {
                this.closeConsumers(amqe);
            }
            catch (JMSException e) {
                _logger.error("Error closing session: " + (Object)((Object)e), (Throwable)e);
                if (jmse != null) break block5;
                jmse = e;
            }
        }
        if (jmse != null) {
            throw jmse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeFromQueue(C consumer, AMQShortString queueName, AMQProtocolHandler protocolHandler, boolean nowait, String messageSelector) throws AMQException, FailoverException {
        int tagId = this._nextTag++;
        ((BasicMessageConsumer)consumer).setConsumerTag(tagId);
        this._consumers.put(tagId, consumer);
        AMQDestination aMQDestination = ((BasicMessageConsumer)consumer).getDestination();
        synchronized (aMQDestination) {
            this._destinationConsumerCount.putIfAbsent(((BasicMessageConsumer)consumer).getDestination(), new AtomicInteger());
            this._destinationConsumerCount.get(((BasicMessageConsumer)consumer).getDestination()).incrementAndGet();
        }
        try {
            this.sendConsume(consumer, queueName, protocolHandler, nowait, messageSelector, tagId);
        }
        catch (AMQException e) {
            this._consumers.remove(tagId);
            throw e;
        }
    }

    public abstract void sendConsume(C var1, AMQShortString var2, AMQProtocolHandler var3, boolean var4, String var5, int var6) throws AMQException, FailoverException;

    private P createProducerImpl(Destination destination, boolean mandatory, boolean immediate) throws JMSException {
        return this.createProducerImpl(destination, mandatory, immediate, this.DEFAULT_WAIT_ON_SEND);
    }

    private P createProducerImpl(final Destination destination, final boolean mandatory, final boolean immediate, final boolean waitUntilSent) throws JMSException {
        return (P)((BasicMessageProducer)new FailoverRetrySupport(new FailoverProtectedOperation<P, JMSException>(){

            @Override
            public P execute() throws JMSException, FailoverException {
                AMQSession.this.checkNotClosed();
                long producerId = AMQSession.this.getNextProducerId();
                Object producer = AMQSession.this.createMessageProducer(destination, mandatory, immediate, waitUntilSent, producerId);
                AMQSession.this.registerProducer(producerId, producer);
                return producer;
            }
        }, this._connection).execute());
    }

    public abstract P createMessageProducer(Destination var1, boolean var2, boolean var3, boolean var4, long var5) throws JMSException;

    private void declareExchange(AMQDestination amqd, AMQProtocolHandler protocolHandler, boolean nowait) throws AMQException {
        this.declareExchange(amqd.getExchangeName(), amqd.getExchangeClass(), protocolHandler, nowait);
    }

    public long getQueueDepth(final AMQDestination amqd) throws AMQException {
        return new FailoverNoopSupport<Long, AMQException>(new FailoverProtectedOperation<Long, AMQException>(){

            @Override
            public Long execute() throws AMQException, FailoverException {
                return AMQSession.this.requestQueueDepth(amqd);
            }
        }, this._connection).execute();
    }

    protected abstract Long requestQueueDepth(AMQDestination var1) throws AMQException, FailoverException;

    private void declareExchange(final AMQShortString name, final AMQShortString type, final AMQProtocolHandler protocolHandler, final boolean nowait) throws AMQException {
        new FailoverNoopSupport<Object, AMQException>(new FailoverProtectedOperation<Object, AMQException>(){

            @Override
            public Object execute() throws AMQException, FailoverException {
                AMQSession.this.sendExchangeDeclare(name, type, protocolHandler, nowait);
                return null;
            }
        }, this._connection).execute();
    }

    public abstract void sendExchangeDeclare(AMQShortString var1, AMQShortString var2, AMQProtocolHandler var3, boolean var4) throws AMQException, FailoverException;

    protected AMQShortString declareQueue(AMQDestination amqd, AMQProtocolHandler protocolHandler, boolean noLocal) throws AMQException {
        return this.declareQueue(amqd, protocolHandler, noLocal, false);
    }

    protected AMQShortString declareQueue(final AMQDestination amqd, final AMQProtocolHandler protocolHandler, boolean noLocal, final boolean nowait) throws AMQException {
        return new FailoverNoopSupport<AMQShortString, AMQException>(new FailoverProtectedOperation<AMQShortString, AMQException>(){

            @Override
            public AMQShortString execute() throws AMQException, FailoverException {
                if (amqd.isNameRequired()) {
                    amqd.setQueueName(protocolHandler.generateQueueName());
                }
                AMQSession.this.sendQueueDeclare(amqd, protocolHandler, nowait);
                return amqd.getAMQQueueName();
            }
        }, this._connection).execute();
    }

    public abstract void sendQueueDeclare(AMQDestination var1, AMQProtocolHandler var2, boolean var3) throws AMQException, FailoverException;

    protected void deleteQueue(final AMQShortString queueName) throws JMSException {
        try {
            new FailoverRetrySupport<Object, AMQException>(new FailoverProtectedOperation<Object, AMQException>(){

                @Override
                public Object execute() throws AMQException, FailoverException {
                    AMQSession.this.sendQueueDelete(queueName);
                    return null;
                }
            }, this._connection).execute();
        }
        catch (AMQException e) {
            throw new JMSAMQException("The queue deletion failed: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public abstract void sendQueueDelete(AMQShortString var1) throws AMQException, FailoverException;

    private long getNextProducerId() {
        return ++this._nextProducerId;
    }

    protected AMQProtocolHandler getProtocolHandler() {
        return this._connection.getProtocolHandler();
    }

    public byte getProtocolMajorVersion() {
        return this.getProtocolHandler().getProtocolMajorVersion();
    }

    public byte getProtocolMinorVersion() {
        return this.getProtocolHandler().getProtocolMinorVersion();
    }

    protected boolean hasMessageListeners() {
        return this._hasMessageListeners;
    }

    private void markClosedConsumers() throws JMSException {
        if (this._dispatcher != null) {
            this._dispatcher.close();
            this._dispatcher = null;
        }
        ArrayList<C> clonedConsumers = new ArrayList<C>(this._consumers.values());
        for (BasicMessageConsumer con : clonedConsumers) {
            con.markClosed();
        }
    }

    private void markClosedProducersAndConsumers() {
        try {
            this.closeProducers();
        }
        catch (JMSException e) {
            _logger.error("Error closing session: " + (Object)((Object)e), (Throwable)e);
        }
        try {
            this.markClosedConsumers();
        }
        catch (JMSException e) {
            _logger.error("Error closing session: " + (Object)((Object)e), (Throwable)e);
        }
    }

    private void registerConsumer(C consumer, boolean nowait) throws AMQException {
        AMQDestination amqd = ((BasicMessageConsumer)consumer).getDestination();
        AMQProtocolHandler protocolHandler = this.getProtocolHandler();
        if (amqd.getDestSyntax() == AMQDestination.DestSyntax.ADDR) {
            this.handleAddressBasedDestination(amqd, true, nowait);
        } else {
            if (this.DECLARE_EXCHANGES) {
                this.declareExchange(amqd, protocolHandler, nowait);
            }
            if (this.DECLARE_QUEUES || amqd.isNameRequired()) {
                this.declareQueue(amqd, protocolHandler, ((BasicMessageConsumer)consumer).isNoLocal(), nowait);
            }
            this.bindQueue(amqd.getAMQQueueName(), amqd.getRoutingKey(), ((BasicMessageConsumer)consumer).getArguments(), amqd.getExchangeName(), amqd, nowait);
        }
        AMQShortString queueName = amqd.getAMQQueueName();
        ((BasicMessageConsumer)consumer).setQueuename(queueName);
        if (!this._immediatePrefetch) {
            if (this._dispatcher == null && !this.isSuspended()) {
                try {
                    this.suspendChannel(true);
                    _logger.info("Prefetching delayed existing messages will not flow until requested via receive*() or setML().");
                }
                catch (AMQException e) {
                    _logger.info("Suspending channel threw an exception:" + (Object)((Object)e));
                }
            }
        } else {
            _logger.info("Immediately prefetching existing messages to new consumer.");
        }
        try {
            this.consumeFromQueue(consumer, queueName, protocolHandler, nowait, ((BasicMessageConsumer)consumer)._messageSelector);
        }
        catch (FailoverException e) {
            throw new AMQException(null, "Fail-over exception interrupted basic consume.", (Throwable)e);
        }
    }

    public abstract void handleAddressBasedDestination(AMQDestination var1, boolean var2, boolean var3) throws AMQException;

    private void registerProducer(long producerId, MessageProducer producer) {
        this._producers.put(new Long(producerId), producer);
    }

    private void rejectAllMessages(boolean requeue) {
        this.rejectMessagesForConsumerTag(0, requeue, true);
    }

    private void rejectMessagesForConsumerTag(int consumerTag, boolean requeue, boolean rejectAllConsumers) {
        Iterator messages = this._queue.iterator();
        if (_logger.isInfoEnabled()) {
            _logger.info("Rejecting messages from _queue for Consumer tag(" + consumerTag + ") (PDispatchQ) requeue:" + requeue);
            if (messages.hasNext()) {
                _logger.info("Checking all messages in _queue for Consumer tag(" + consumerTag + ")");
            } else {
                _logger.info("No messages in _queue to reject");
            }
        }
        while (messages.hasNext()) {
            UnprocessedMessage message = (UnprocessedMessage)messages.next();
            if (!rejectAllConsumers && message.getConsumerTag() != consumerTag) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug("Removing message(" + System.identityHashCode(message) + ") from _queue DT:" + message.getDeliveryTag());
            }
            messages.remove();
            this.rejectMessage(message, requeue);
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug("Rejected the message(" + message.toString() + ") for consumer :" + consumerTag);
        }
    }

    private void resubscribeConsumers() throws AMQException {
        ArrayList<C> consumers = new ArrayList<C>(this._consumers.values());
        this._consumers.clear();
        for (BasicMessageConsumer consumer : consumers) {
            consumer.failedOverPre();
            this.registerConsumer(consumer, true);
            consumer.failedOverPost();
        }
    }

    private void resubscribeProducers() throws AMQException {
        ArrayList<MessageProducer> producers = new ArrayList<MessageProducer>(this._producers.values());
        _logger.info(MessageFormat.format("Resubscribing producers = {0} producers.size={1}", producers, producers.size()));
        for (BasicMessageProducer basicMessageProducer : producers) {
            basicMessageProducer.resubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspendChannel(boolean suspend) throws AMQException {
        Object object = this._suspensionLock;
        synchronized (object) {
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Setting channel flow : " + (suspend ? "suspended" : "unsuspended"));
                }
                this._suspended = suspend;
                this.sendSuspendChannel(suspend);
            }
            catch (FailoverException e) {
                throw new AMQException(null, "Fail-over interrupted suspend/unsuspend channel.", (Throwable)e);
            }
        }
    }

    public abstract void sendSuspendChannel(boolean var1) throws AMQException, FailoverException;

    Object getMessageDeliveryLock() {
        return this._messageDeliveryLock;
    }

    public boolean prefetch() {
        return this.getAMQConnection().getMaxPrefetch() > 0L;
    }

    public void markDirty() {
        this._dirty = true;
    }

    public void markClean() {
        this._dirty = false;
        this._failedOverDirty = false;
    }

    public boolean hasFailedOver() {
        return this._failedOverDirty;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setTicket(int ticket) {
        this._ticket = ticket;
    }

    public void setFlowControl(boolean active) {
        this._flowControl.setFlowControl(active);
        _logger.warn("Broker enforced flow control " + (active ? "no longer in effect" : "has been enforced"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFlowControl() throws InterruptedException, JMSException {
        long expiryTime = 0L;
        FlowControlIndicator flowControlIndicator = this._flowControl;
        synchronized (flowControlIndicator) {
            while (!this._flowControl.getFlowControl() && (expiryTime == 0L ? System.currentTimeMillis() + this.FLOW_CONTROL_WAIT_FAILURE : expiryTime) >= System.currentTimeMillis()) {
                this._flowControl.wait(this.FLOW_CONTROL_WAIT_PERIOD);
                _logger.warn("Message send delayed by " + (System.currentTimeMillis() + this.FLOW_CONTROL_WAIT_FAILURE - expiryTime) / 1000L + "s due to broker enforced flow control");
            }
            if (!this._flowControl.getFlowControl()) {
                _logger.error("Message send failed due to timeout waiting on broker enforced flow control");
                throw new JMSException("Unable to send message for " + this.FLOW_CONTROL_WAIT_FAILURE / 1000L + " seconds due to broker enforced flow control");
            }
        }
    }

    public void dispatch(UnprocessedMessage message) {
        if (this._dispatcher == null) {
            throw new IllegalStateException("dispatcher is not started");
        }
        this._dispatcher.dispatchMessage(message);
    }

    protected abstract boolean tagLE(long var1, long var3);

    protected abstract boolean updateRollbackMark(long var1, long var3);

    public abstract AMQMessageDelegateFactory getMessageDelegateFactory();

    @Override
    public boolean isClosed() {
        return this._closed.get() || this._connection.isClosed();
    }

    @Override
    public boolean isClosing() {
        return this._closing.get() || this._connection.isClosing();
    }

    public boolean isDeclareExchanges() {
        return this.DECLARE_EXCHANGES;
    }

    private class SuspenderRunner
    implements Runnable {
        private AtomicBoolean _suspend;

        public SuspenderRunner(AtomicBoolean suspend) {
            this._suspend = suspend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block6: {
                try {
                    Object object = AMQSession.this._suspensionLock;
                    synchronized (object) {
                        if (!AMQSession.this._thisSession.isClosed() && !AMQSession.this._thisSession.isClosing()) {
                            AMQSession.this.suspendChannel(this._suspend.get());
                        }
                    }
                }
                catch (AMQException e) {
                    _logger.warn("Unable to " + (this._suspend.get() ? "suspend" : "unsuspend") + " session " + AMQSession.this._thisSession + " due to: " + (Object)((Object)e));
                    if (!_logger.isDebugEnabled()) break block6;
                    _logger.debug("Is the _queue empty?" + AMQSession.this._queue.isEmpty());
                    _logger.debug("Is the dispatcher closed?" + (AMQSession.this._dispatcher == null ? "it's Null" : AMQSession.this._dispatcher._closed));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Dispatcher
    implements Runnable {
        private final AtomicBoolean _closed = new AtomicBoolean(false);
        private final Object _lock = new Object();
        private String dispatcherID = "" + System.identityHashCode(this);

        public void close() {
            this._closed.set(true);
            AMQSession.this._dispatcherThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rejectPending(C consumer) {
            Object object = this._lock;
            synchronized (object) {
                boolean stopped = AMQSession.this._dispatcher.connectionStopped();
                if (!stopped) {
                    AMQSession.this._dispatcher.setConnectionStopped(true);
                }
                ((BasicMessageConsumer)consumer).rollbackPendingMessages();
                AMQSession.this.rejectMessagesForConsumerTag(((BasicMessageConsumer)consumer).getConsumerTag(), true, false);
                ((BasicMessageConsumer)consumer).markClosed();
                AMQSession.this._dispatcher.setConnectionStopped(stopped);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() {
            Object object = this._lock;
            synchronized (object) {
                boolean isStopped = this.connectionStopped();
                if (!isStopped) {
                    this.setConnectionStopped(true);
                }
                AMQSession.this._rollbackMark.set(AMQSession.this._highestDeliveryTag.get());
                _dispatcherLogger.debug("Session Pre Dispatch Queue cleared");
                for (BasicMessageConsumer consumer : AMQSession.this._consumers.values()) {
                    if (!consumer.isNoConsume()) {
                        consumer.rollback();
                        continue;
                    }
                    consumer.clearReceiveQueue();
                }
                for (int i = 0; i < AMQSession.this._removedConsumers.size(); ++i) {
                    ((BasicMessageConsumer)AMQSession.this._removedConsumers.get(i)).rollback();
                    AMQSession.this._removedConsumers.remove(i);
                }
                this.setConnectionStopped(isStopped);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recover() {
            Object object = this._lock;
            synchronized (object) {
                boolean isStopped = this.connectionStopped();
                if (!isStopped) {
                    this.setConnectionStopped(true);
                }
                _dispatcherLogger.debug("Session clearing the consumer queues");
                for (BasicMessageConsumer consumer : AMQSession.this._consumers.values()) {
                    List<Long> tags = consumer.drainReceiverQueueAndRetrieveDeliveryTags();
                    AMQSession.this._unacknowledgedMessageTags.addAll(tags);
                }
                this.setConnectionStopped(isStopped);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (_dispatcherLogger.isInfoEnabled()) {
                _dispatcherLogger.info(AMQSession.this._dispatcherThread.getName() + " started");
            }
            Object object = this._lock;
            synchronized (object) {
                while (!this._closed.get() && this.connectionStopped()) {
                    try {
                        this._lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                Dispatchable disp;
                while (!this._closed.get() && (disp = (Dispatchable)AMQSession.this._queue.take()) != null) {
                    disp.dispatch(AMQSession.this);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (_dispatcherLogger.isInfoEnabled()) {
                _dispatcherLogger.info(AMQSession.this._dispatcherThread.getName() + " thread terminating for channel " + AMQSession.this._channelId + ":" + AMQSession.this._thisSession);
            }
        }

        final boolean connectionStopped() {
            return AMQSession.this._connectionStopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setConnectionStopped(boolean connectionStopped) {
            boolean currently;
            Object object = this._lock;
            synchronized (object) {
                currently = AMQSession.this._connectionStopped;
                AMQSession.this._connectionStopped = connectionStopped;
                this._lock.notify();
                if (_dispatcherLogger.isDebugEnabled()) {
                    _dispatcherLogger.debug("Set Dispatcher Connection " + (connectionStopped ? "Stopped" : "Started") + ": Currently " + (currently ? "Stopped" : "Started"));
                }
            }
            return currently;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchMessage(UnprocessedMessage message) {
            long deliveryTag = message.getDeliveryTag();
            Object object = this._lock;
            synchronized (object) {
                try {
                    while (this.connectionStopped()) {
                        this._lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!(message instanceof CloseConsumerMessage) && AMQSession.this.tagLE(deliveryTag, AMQSession.this._rollbackMark.get())) {
                    AMQSession.this.rejectMessage(message, true);
                } else if (AMQSession.this.isInRecovery()) {
                    AMQSession.this._unacknowledgedMessageTags.add(deliveryTag);
                } else {
                    Object object2 = AMQSession.this._messageDeliveryLock;
                    synchronized (object2) {
                        this.notifyConsumer(message);
                    }
                }
            }
            long current = AMQSession.this._rollbackMark.get();
            if (AMQSession.this.updateRollbackMark(current, deliveryTag)) {
                AMQSession.this._rollbackMark.compareAndSet(current, deliveryTag);
            }
        }

        private void notifyConsumer(UnprocessedMessage message) {
            Object consumer = AMQSession.this._consumers.get(message.getConsumerTag());
            if (consumer == null || ((Closeable)consumer).isClosed()) {
                if (_dispatcherLogger.isInfoEnabled()) {
                    if (consumer == null) {
                        _dispatcherLogger.info("Dispatcher(" + this.dispatcherID + ")Received a message(" + System.identityHashCode(message) + ")" + "[" + message.getDeliveryTag() + "] from queue " + message.getConsumerTag() + " )without a handler - rejecting(requeue)...");
                    } else {
                        if (((BasicMessageConsumer)consumer).isNoConsume()) {
                            _dispatcherLogger.info("Received a message(" + System.identityHashCode(message) + ")" + "[" + message.getDeliveryTag() + "] from queue " + " consumer(" + message.getConsumerTag() + ") is closed and a browser so dropping...");
                            return;
                        }
                        _dispatcherLogger.info("Received a message(" + System.identityHashCode(message) + ")" + "[" + message.getDeliveryTag() + "] from queue " + " consumer(" + message.getConsumerTag() + ") is closed rejecting(requeue)...");
                    }
                }
                if (!this._closed.get()) {
                    AMQSession.this.rejectMessage(message, true);
                }
            } else {
                ((BasicMessageConsumer)consumer).notifyMessage((UnprocessedMessage)message);
            }
        }
    }

    public static interface Dispatchable {
        public void dispatch(AMQSession var1);
    }

    private static final class FlowControlIndicator {
        private volatile boolean _flowControl = true;

        private FlowControlIndicator() {
        }

        public synchronized void setFlowControl(boolean flowControl) {
            this._flowControl = flowControl;
            this.notify();
        }

        public boolean getFlowControl() {
            return this._flowControl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IdToConsumerMap<C extends BasicMessageConsumer> {
        private final BasicMessageConsumer[] _fastAccessConsumers = new BasicMessageConsumer[16];
        private final ConcurrentHashMap<Integer, C> _slowAccessConsumers = new ConcurrentHashMap();

        public C get(int id) {
            if ((id & 0xFFFFFFF0) == 0) {
                return (C)this._fastAccessConsumers[id];
            }
            return (C)((BasicMessageConsumer)this._slowAccessConsumers.get(id));
        }

        public C put(int id, C consumer) {
            BasicMessageConsumer oldVal;
            if ((id & 0xFFFFFFF0) == 0) {
                oldVal = this._fastAccessConsumers[id];
                this._fastAccessConsumers[id] = consumer;
            } else {
                oldVal = (BasicMessageConsumer)this._slowAccessConsumers.put(id, consumer);
            }
            return (C)oldVal;
        }

        public C remove(int id) {
            BasicMessageConsumer consumer;
            if ((id & 0xFFFFFFF0) == 0) {
                consumer = this._fastAccessConsumers[id];
                this._fastAccessConsumers[id] = null;
            } else {
                consumer = (BasicMessageConsumer)this._slowAccessConsumers.remove(id);
            }
            return (C)consumer;
        }

        public Collection<C> values() {
            ArrayList<BasicMessageConsumer<Object>> values = new ArrayList<BasicMessageConsumer<Object>>();
            for (int i = 0; i < 16; ++i) {
                if (this._fastAccessConsumers[i] == null) continue;
                values.add(this._fastAccessConsumers[i]);
            }
            values.addAll(this._slowAccessConsumers.values());
            return values;
        }

        public void clear() {
            this._slowAccessConsumers.clear();
            for (int i = 0; i < 16; ++i) {
                this._fastAccessConsumers[i] = null;
            }
        }
    }
}

