/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.validation;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.qpid.server.query.engine.exception.QueryValidationException;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;
import org.apache.qpid.server.query.engine.parsing.query.ProjectionExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;

public class SelectExpressionValidator {
    public <T, R> void validate(SelectExpression<T, R> selectExpression) {
        boolean hasHaving;
        Objects.requireNonNull(selectExpression, "Select expression must be not null");
        boolean hasAccessors = selectExpression.getProjections().stream().anyMatch(AbstractExpressionNode::isAccessor);
        boolean hasAggregations = selectExpression.getProjections().stream().anyMatch(AbstractExpressionNode::containsAggregation);
        boolean hasGrouping = !selectExpression.getGroupBy().isEmpty();
        boolean bl = hasHaving = selectExpression.getHaving() != null;
        if (selectExpression.getFrom() == null) {
            if (selectExpression.getProjections().isEmpty()) {
                throw QueryValidationException.of("Missing expression", new Object[0]);
            }
            if (hasAccessors) {
                throw QueryValidationException.of("Keyword 'FROM' not found where expected", new Object[0]);
            }
        }
        if (hasAggregations) {
            List projectionAliases = selectExpression.getProjections().stream().filter(item -> !item.containsAggregation()).map(ProjectionExpression::getAlias).collect(Collectors.toList());
            List groupByAliases = selectExpression.getGroupBy().stream().map(ProjectionExpression::getAlias).collect(Collectors.toList());
            projectionAliases.removeAll(groupByAliases);
            if (!projectionAliases.isEmpty()) {
                throw QueryValidationException.of("Not a single-group group function: projections %s should be included in GROUP BY clause", projectionAliases);
            }
        }
        if (hasHaving && !hasAggregations && !hasGrouping) {
            throw QueryValidationException.of("HAVING clause is allowed when using aggregation", new Object[0]);
        }
    }
}

