/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.util;

import java.util.Objects;
import org.apache.qpid.server.security.access.util.PrefixTree;

abstract class AbstractTreeBranch
implements PrefixTree {
    private static final String NO_PREFIX = "Tree root does not have a prefix";
    private static final String EMPTY_INPUT_PREFIX = "The input prefix can not be empty";
    private static final String EMPTY_INPUT_STRING = "The input string can not be empty";
    final String _prefix;
    final int _length;

    abstract AbstractTreeBranch mergeString(String var1);

    abstract AbstractTreeBranch mergeWildCard(String var1);

    abstract boolean contains(String var1);

    AbstractTreeBranch(String prefix) {
        this._prefix = Objects.requireNonNull(prefix, "The prefix can not be null!");
        this._length = this._prefix.length();
    }

    AbstractTreeBranch() {
        this._prefix = "";
        this._length = 0;
    }

    @Override
    public String prefix() {
        return this._prefix;
    }

    @Override
    public char firstPrefixCharacter() {
        if (this._prefix.isEmpty()) {
            throw new UnsupportedOperationException(NO_PREFIX);
        }
        return this._prefix.charAt(0);
    }

    @Override
    public PrefixTree mergeWithFinalValue(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException(EMPTY_INPUT_STRING);
        }
        return this.mergeString(str);
    }

    @Override
    public PrefixTree mergeWithPrefix(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            throw new IllegalArgumentException(EMPTY_INPUT_PREFIX);
        }
        return this.mergeWildCard(prefix);
    }

    @Override
    public boolean match(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        return this.contains(str);
    }
}

