/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.validation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.apache.qpid.server.model.RestContentHeader"})
public class ContentHeaderAnnotationValidator
extends AbstractProcessor {
    public static final String CONTENT_HEADER_CLASS_NAME = "org.apache.qpid.server.model.RestContentHeader";
    public static final String CONTENT_CLASS_NAME = "org.apache.qpid.server.model.CustomRestHeaders";
    private static final Set<TypeKind> VALID_PRIMITIVE_TYPES = new HashSet<TypeKind>(Arrays.asList(TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT));

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement annotationElement = elementUtils.getTypeElement(CONTENT_HEADER_CLASS_NAME);
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationElement)) {
            ExecutableElement methodElement = (ExecutableElement)element;
            this.checkClassExtendsContent(annotationElement, methodElement);
            this.checkMethodHasNoArgs(annotationElement, methodElement);
            this.checkMethodReturnsString(annotationElement, methodElement);
        }
        return false;
    }

    private void checkMethodReturnsString(TypeElement annotationElement, ExecutableElement methodElement) {
        TypeMirror returnType = methodElement.getReturnType();
        if (!this.isValidType(returnType)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to methods with primitive, boxed primitive, enum, or String type return type but annotated Method " + String.valueOf(methodElement.getSimpleName()) + " returns " + returnType.toString(), methodElement);
        }
    }

    private boolean isValidType(TypeMirror type) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        Elements elementUtils = this.processingEnv.getElementUtils();
        Element typeElement = typeUtils.asElement(type);
        if (VALID_PRIMITIVE_TYPES.contains((Object)type.getKind())) {
            return true;
        }
        for (TypeKind primitive : VALID_PRIMITIVE_TYPES) {
            if (!typeUtils.isSameType(type, typeUtils.boxedClass(typeUtils.getPrimitiveType(primitive)).asType())) continue;
            return true;
        }
        if (typeElement != null && typeElement.getKind() == ElementKind.ENUM) {
            return true;
        }
        return typeUtils.isSameType(type, elementUtils.getTypeElement("java.lang.String").asType());
    }

    private void checkMethodHasNoArgs(TypeElement annotationElement, ExecutableElement methodElement) {
        if (!methodElement.getParameters().isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to methods without arguments which does not apply to " + String.valueOf(methodElement.getSimpleName()), methodElement);
        }
    }

    private void checkClassExtendsContent(TypeElement annotationElement, Element e) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeMirror contentType = this.getErasure(CONTENT_CLASS_NAME);
        TypeElement parent = (TypeElement)e.getEnclosingElement();
        if (!typeUtils.isAssignable(typeUtils.erasure(parent.asType()), contentType)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + String.valueOf(annotationElement.getSimpleName()) + " can only be applied to methods within a class implementing " + contentType.toString() + " which does not apply to " + parent.asType().toString(), e);
        }
    }

    private TypeMirror getErasure(String className) {
        return ContentHeaderAnnotationValidator.getErasure(this.processingEnv, className);
    }

    private static TypeMirror getErasure(ProcessingEnvironment processingEnv, String className) {
        Types typeUtils = processingEnv.getTypeUtils();
        Elements elementUtils = processingEnv.getElementUtils();
        return typeUtils.erasure(elementUtils.getTypeElement(className).asType());
    }
}

