/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.structuredeventlog.log4j2;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.pulsar.structuredeventlog.Event;
import org.apache.pulsar.structuredeventlog.EventResources;
import org.apache.pulsar.structuredeventlog.EventResourcesImpl;

class Log4j2Event
implements Event {
    private static final Logger stringLogger = LogManager.getLogger();
    private final Clock clock;
    private String traceId = null;
    private String parentId = null;
    private List<Object> attributes = null;
    private Level level = Level.INFO;
    private Throwable throwable = null;
    private Instant startTime = null;
    private final EventResourcesImpl resources;

    Log4j2Event(Clock clock, EventResourcesImpl parentResources) {
        this.clock = clock;
        this.resources = new EventResourcesImpl(parentResources);
    }

    @Override
    public Event newChildEvent() {
        return new Log4j2Event(this.clock, this.resources).traceId(this.traceId);
    }

    @Override
    public Event traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Override
    public Event parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @Override
    public Event timed() {
        this.startTime = this.clock.instant();
        return this;
    }

    @Override
    public Event sampled(Object samplingKey, int duration, TimeUnit unit) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Event resources(EventResources other) {
        if (other instanceof EventResourcesImpl) {
            this.resources.copyFrom((EventResourcesImpl)other);
        }
        return this;
    }

    @Override
    public Event resource(String key, Object value) {
        this.resources.resource(key, value);
        return this;
    }

    @Override
    public Event resource(String key, Supplier<String> value) {
        this.resources.resource(key, value);
        return this;
    }

    @Override
    public Event attr(String key, Object value) {
        this.getAttributes().add(key);
        this.getAttributes().add(value);
        return this;
    }

    @Override
    public Event attr(String key, Supplier<String> value) {
        this.attr(key, (Object)value);
        return this;
    }

    @Override
    public Event exception(Throwable t) {
        this.throwable = t;
        return this;
    }

    @Override
    public Event atError() {
        this.level = Level.ERROR;
        return this;
    }

    @Override
    public Event atInfo() {
        this.level = Level.INFO;
        return this;
    }

    @Override
    public Event atWarn() {
        this.level = Level.WARN;
        return this;
    }

    @Override
    public void log(Enum<?> event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void log(String event) {
        this.logInternal(stringLogger, event);
    }

    private void logInternal(Logger logger, String msg) {
        StringMapMessage event = new StringMapMessage();
        event.with("msg", msg);
        if (this.traceId != null) {
            event.with("traceId", this.traceId);
        }
        if (this.parentId != null) {
            event.with("parentId", this.parentId);
        }
        this.resources.forEach((arg_0, arg_1) -> ((StringMapMessage)event).with(arg_0, arg_1));
        if (this.attributes != null) {
            EventResourcesImpl.forEach(this.attributes, (arg_0, arg_1) -> ((StringMapMessage)event).with(arg_0, arg_1));
        }
        if (this.startTime != null) {
            event.with("startTimestamp", this.startTime.toString());
            event.with("durationMs", String.valueOf(Duration.between(this.startTime, this.clock.instant()).toMillis()));
        }
        switch (this.level.ordinal()) {
            case 2: {
                if (this.throwable != null) {
                    logger.error((Message)event, this.throwable);
                    break;
                }
                logger.error((Message)event);
                break;
            }
            case 1: {
                if (this.throwable != null) {
                    logger.warn((Message)event, this.throwable);
                    break;
                }
                logger.warn((Message)event);
                break;
            }
            default: {
                if (this.throwable != null) {
                    logger.info((Message)event, this.throwable);
                    break;
                }
                logger.info((Message)event);
            }
        }
    }

    @Override
    public void stash() {
        throw new UnsupportedOperationException("TODO");
    }

    private List<Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Object>();
        }
        return this.attributes;
    }

    static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

