/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.internal.api;

import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.reactive.client.api.MessageResult;
import org.apache.pulsar.reactive.client.api.MessageSpec;
import org.apache.pulsar.reactive.client.api.MessageSpecBuilder;
import org.apache.pulsar.reactive.client.api.ReactiveMessageConsumer;
import org.apache.pulsar.reactive.client.api.ReactiveMessagePipelineBuilder;
import org.apache.pulsar.reactive.client.internal.api.DefaultMessageResult;
import org.apache.pulsar.reactive.client.internal.api.DefaultMessageSpecBuilder;
import org.apache.pulsar.reactive.client.internal.api.DefaultReactiveMessagePipelineBuilder;
import org.apache.pulsar.reactive.client.internal.api.EmptyMessageResult;
import org.apache.pulsar.reactive.client.internal.api.ValueOnlyMessageSpec;

public final class ApiImplementationFactory {
    private ApiImplementationFactory() {
    }

    public static <T> MessageResult<T> acknowledge(MessageId messageId, T value) {
        return new DefaultMessageResult<T>(messageId, true, value);
    }

    public static <T> MessageResult<T> negativeAcknowledge(MessageId messageId, T value) {
        return new DefaultMessageResult<T>(messageId, false, value);
    }

    public static MessageResult<Void> acknowledge(MessageId messageId) {
        return new EmptyMessageResult(messageId, true);
    }

    public static MessageResult<Void> negativeAcknowledge(MessageId messageId) {
        return new EmptyMessageResult(messageId, false);
    }

    public static <T> MessageSpecBuilder<T> createMessageSpecBuilder(T value) {
        return new DefaultMessageSpecBuilder<T>().value(value);
    }

    public static <T> MessageSpec<T> createValueOnlyMessageSpec(T value) {
        return new ValueOnlyMessageSpec<T>(value);
    }

    public static <T> ReactiveMessagePipelineBuilder<T> createReactiveMessageHandlerPipelineBuilder(ReactiveMessageConsumer<T> messageConsumer) {
        return new DefaultReactiveMessagePipelineBuilder<T>(messageConsumer);
    }
}

