/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.pulsar.tests.HeapDumpUtil;
import org.apache.pulsar.tests.HeapHistogramUtil;
import org.apache.pulsar.tests.ThreadDumpUtil;
import org.testng.IExecutionListener;

public class TraceTestResourceCleanupListener
implements IExecutionListener {
    private static final TraceTestResourceCleanupMode MODE = TraceTestResourceCleanupMode.valueOf(System.getenv().getOrDefault("TRACE_TEST_RESOURCE_CLEANUP", "off").toUpperCase());
    private static final File DUMP_DIR = new File(System.getenv().getOrDefault("TRACE_TEST_RESOURCE_CLEANUP_DIR", "target/trace-test-resource-cleanup"));
    private static final long WAIT_BEFORE_DUMP_MILLIS = Long.parseLong(System.getenv().getOrDefault("TRACE_TEST_RESOURCE_CLEANUP_DELAY", "5000"));

    static void createDumps() {
        if (!DUMP_DIR.isDirectory()) {
            DUMP_DIR.mkdirs();
        }
        try {
            Thread.sleep(WAIT_BEFORE_DUMP_MILLIS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String datetimePart = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss.SSS").format(ZonedDateTime.now());
        try {
            String threadDump = ThreadDumpUtil.buildThreadDiagnosticString();
            File threaddumpFile = new File(DUMP_DIR, "threaddump" + datetimePart + ".txt");
            Files.asCharSink((File)threaddumpFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)threadDump);
        }
        catch (Throwable t) {
            System.err.println("Error dumping threads");
            t.printStackTrace(System.err);
        }
        try {
            String heapHistogram = HeapHistogramUtil.buildHeapHistogram();
            File heapHistogramFile = new File(DUMP_DIR, "heaphistogram" + datetimePart + ".txt");
            Files.asCharSink((File)heapHistogramFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)heapHistogram);
        }
        catch (Throwable t) {
            System.err.println("Error dumping heap histogram");
            t.printStackTrace(System.err);
        }
        if (MODE == TraceTestResourceCleanupMode.FULL) {
            try {
                File heapdumpFile = new File(DUMP_DIR, "heapdump" + datetimePart + ".hprof");
                HeapDumpUtil.dumpHeap(heapdumpFile, true);
            }
            catch (Throwable t) {
                System.err.println("Error dumping heap");
                t.printStackTrace(System.err);
            }
        }
    }

    static {
        if (MODE != TraceTestResourceCleanupMode.OFF) {
            Runtime.getRuntime().addShutdownHook(new Thread(TraceTestResourceCleanupListener::createDumps));
        }
    }

    static enum TraceTestResourceCleanupMode {
        OFF,
        ON,
        FULL;

    }
}

